/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.ConstraintDouble;
import graphtools.PermutationGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideTools;
import rnadesign.rnamodel.RnaModelException;
import tools3d.CoordinateSystem;
import tools3d.GeometryTools;
import tools3d.Vector3D;
import tools3d.objects3d.MultiConstraintLink;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleMultiLink;

public class JunctionMultiConstraintLink
extends SimpleMultiLink
implements MultiConstraintLink {
    private ConstraintDouble constraint;
    private ConstraintDouble bridgableConstraint;
    private List<Integer> symIds = new ArrayList<Integer>();
    private List<Integer> symIds2 = new ArrayList<Integer>();
    private PermutationGenerator permGen;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static final String ATOM_3_NAME = "P";
    private static final String ATOM_3_NAME_PREC = "O5*";
    private static final String ATOM_5_NAME = "O3*";
    private static final String ATOM_5_NAME_PREC = "C3*";
    private Vector3D[] threePrimePositions;
    private Vector3D[] fivePrimePositions;

    public JunctionMultiConstraintLink(List<Nucleotide3D> fivePrimeResidues, List<Nucleotide3D> threePrimeResidues, ConstraintDouble constraint, ConstraintDouble _bridgableConstraint) throws RnaModelException {
        assert (fivePrimeResidues.size() == threePrimeResidues.size());
        assert (fivePrimeResidues.size() > 0);
        for (int i = 0; i < fivePrimeResidues.size(); ++i) {
            if (!this.isProperNucleotide(fivePrimeResidues.get(i))) {
                Nucleotide3D nuc = fivePrimeResidues.get(i);
                System.out.println("O3* : " + nuc.getIndexOfChild(ATOM_5_NAME));
                System.out.println("P : " + nuc.getIndexOfChild(ATOM_3_NAME));
                throw new RnaModelException("5' nucleotide has missing atoms: " + fivePrimeResidues.get(i).toString());
            }
            if (!this.isProperNucleotide(threePrimeResidues.get(i))) {
                Nucleotide3D nuc = threePrimeResidues.get(i);
                System.out.println("O3* : " + nuc.getIndexOfChild(ATOM_5_NAME) + " " + ATOM_3_NAME + " : " + nuc.getIndexOfChild(ATOM_3_NAME));
                throw new RnaModelException("3' nucleotide has missing atoms: " + threePrimeResidues.get(i).toString());
            }
            this.addObj(fivePrimeResidues.get(i));
            this.addObj(threePrimeResidues.get(i));
            this.symIds.add(0);
        }
        this.constraint = constraint;
        this.bridgableConstraint = _bridgableConstraint;
        this.permGen = new PermutationGenerator(fivePrimeResidues.size());
        this.initPositions(fivePrimeResidues, threePrimeResidues);
        assert (this.validate());
        log.info("Successfully created JunctionMultiConstraintLink: " + this.toString());
        log.info("Created junction multi constraint link with " + fivePrimeResidues.size() + " branches and constraints: " + constraint.getMin() + " " + constraint.getMax());
        if (this.bridgableConstraint != null) {
            log.info("" + this.bridgableConstraint.getMin() + " " + this.bridgableConstraint.getMax());
        }
    }

    private void initPositions(List<Nucleotide3D> fivePrimeResidues, List<Nucleotide3D> threePrimeResidues) {
        assert (fivePrimeResidues.size() == threePrimeResidues.size());
        this.fivePrimePositions = new Vector3D[fivePrimeResidues.size()];
        this.threePrimePositions = new Vector3D[threePrimeResidues.size()];
        for (int i = 0; i < fivePrimeResidues.size(); ++i) {
            this.fivePrimePositions[i] = fivePrimeResidues.get(i).getChild(ATOM_5_NAME).getPosition();
            this.threePrimePositions[i] = threePrimeResidues.get(i).getChild(ATOM_3_NAME).getPosition();
        }
    }

    public int getBranchCount() {
        return this.size() / 2;
    }

    public int[] findBestPermutation(List<CoordinateSystem> csList) {
        this.permGen.reset();
        double bestDiff = 1.0E30;
        double newDiff = 0.0;
        int[] bestPerm = new int[this.permGen.size()];
        double bridgeTerm = 0.0;
        if (this.bridgableConstraint != null) {
            try {
                bridgeTerm = this.getBridgable3(csList);
            }
            catch (RnaModelException rne) {
                throw new RuntimeException(rne.getMessage());
            }
        }
        do {
            if (!((newDiff = bridgeTerm + this.getDiff(this.permGen.get(), csList)) < bestDiff)) continue;
            bestDiff = newDiff;
            int[] tmpAry = this.permGen.get();
            for (int i = 0; i < tmpAry.length; ++i) {
                bestPerm[i] = tmpAry[i];
            }
        } while (this.permGen.inc());
        return bestPerm;
    }

    public int[] findBestPermutation() {
        this.permGen.reset();
        double bestDiff = 1.0E30;
        double newDiff = 0.0;
        int[] bestPerm = new int[this.permGen.size()];
        double bridgeTerm = 0.0;
        if (this.bridgableConstraint != null) {
            try {
                bridgeTerm = this.getBridgable3();
            }
            catch (RnaModelException rne) {
                throw new RuntimeException(rne.getMessage());
            }
        }
        do {
            if (!((newDiff = bridgeTerm + this.getDiff(this.permGen.get())) < bestDiff)) continue;
            bestDiff = newDiff;
            int[] tmpAry = this.permGen.get();
            for (int i = 0; i < tmpAry.length; ++i) {
                bestPerm[i] = tmpAry[i];
            }
        } while (this.permGen.inc());
        return bestPerm;
    }

    public double getDiff(List<CoordinateSystem> csList) {
        this.permGen.reset();
        double bestDiff = 1.0E30;
        double newDiff = 0.0;
        double bridgeTerm = 0.0;
        if (this.bridgableConstraint != null) {
            try {
                bridgeTerm = this.getBridgable3(csList);
            }
            catch (RnaModelException rne) {
                throw new RuntimeException(rne.getMessage());
            }
        }
        do {
            if (!((newDiff = bridgeTerm + this.getDiff(this.permGen.get(), csList)) < bestDiff)) continue;
            bestDiff = newDiff;
        } while (this.permGen.inc());
        return bestDiff;
    }

    private double getDiff(int[] perm) {
        double result = 0.0;
        for (int i = 0; i < perm.length; ++i) {
            int id1 = perm[perm.length - 1];
            if (i > 0) {
                id1 = perm[i - 1];
            }
            int id2 = perm[i];
            assert (id1 != id2);
            double dist = this.fivePrimePositions[id1].distance(this.threePrimePositions[id2]);
            result += this.constraint.getDiff(dist);
        }
        return result;
    }

    private double getDiff(int[] perm, List<CoordinateSystem> csList) {
        assert (perm.length == csList.size());
        double result = 0.0;
        for (int i = 0; i < perm.length; ++i) {
            int id1 = perm[perm.length - 1];
            if (i > 0) {
                id1 = perm[i - 1];
            }
            int id2 = perm[i];
            assert (id1 != id2);
            assert (id1 < csList.size());
            CoordinateSystem cs1 = csList.get(id1);
            CoordinateSystem cs2 = csList.get(id2);
            double dist = cs1.activeTransform(this.fivePrimePositions[id1]).distance(cs2.activeTransform(this.threePrimePositions[id2]));
            result += this.constraint.getDiff(dist);
        }
        return result;
    }

    private double getBridgable3(List<CoordinateSystem> csList) throws RnaModelException {
        assert (this.getBranchCount() == csList.size());
        double result = 0.0;
        for (int i = 0; i < this.getBranchCount(); ++i) {
            CoordinateSystem cs1 = csList.get(i);
            for (int j = i + 1; j < this.getBranchCount(); ++j) {
                CoordinateSystem cs2 = csList.get(j);
                result += this.isBridgable2((Nucleotide3D)this.getFivePrimeObject(i), (Nucleotide3D)this.getThreePrimeObject(j), cs1, cs2);
                result += this.isBridgable2((Nucleotide3D)this.getFivePrimeObject(j), (Nucleotide3D)this.getThreePrimeObject(i), cs2, cs1);
            }
        }
        return result;
    }

    private double getBridgable3() throws RnaModelException {
        double result = 0.0;
        for (int i = 0; i < this.getBranchCount(); ++i) {
            for (int j = i + 1; j < this.getBranchCount(); ++j) {
                result += this.isBridgable2((Nucleotide3D)this.getFivePrimeObject(i), (Nucleotide3D)this.getThreePrimeObject(j));
                result += this.isBridgable2((Nucleotide3D)this.getFivePrimeObject(j), (Nucleotide3D)this.getThreePrimeObject(i));
            }
        }
        return result;
    }

    private double getBridgable(int[] perm) throws RnaModelException {
        assert (false);
        double result = 0.0;
        for (int i = 0; i < perm.length; ++i) {
            int id1 = perm[perm.length - 1];
            if (i > 0) {
                id1 = perm[i - 1];
            }
            int id2 = perm[i];
            assert (id1 != id2);
            result += this.isBridgable2((Nucleotide3D)this.getFivePrimeObject(id1), (Nucleotide3D)this.getThreePrimeObject(id2));
        }
        return result;
    }

    Vector3D extrapolatePosition(Vector3D origPos, Vector3D precPos, double length) {
        if (origPos == precPos) {
            return origPos;
        }
        Vector3D dv = origPos.minus(precPos);
        if (length > 0.0) {
            dv.normalize();
            dv.scale(length);
        }
        return origPos.plus(dv);
    }

    private double isBridgable(Nucleotide3D fivePrimeRes, Nucleotide3D threePrimeRes, CoordinateSystem cs1, CoordinateSystem cs2) {
        double d;
        Vector3D pos;
        int i;
        assert (false);
        Vector3D lineStart = cs1.activeTransform(this.extrapolatePosition(fivePrimeRes.getChild(ATOM_5_NAME).getPosition(), fivePrimeRes.getChild(ATOM_5_NAME_PREC).getPosition(), 2.0));
        Vector3D lineEnd = cs2.activeTransform(this.extrapolatePosition(threePrimeRes.getChild(ATOM_3_NAME).getPosition(), threePrimeRes.getChild(ATOM_3_NAME_PREC).getPosition(), 2.0));
        Vector3D directionAndLength = lineEnd.minus(lineStart);
        double result = 0.0;
        for (i = 0; i < fivePrimeRes.size(); ++i) {
            if (fivePrimeRes.getChild(i).getName().equals(ATOM_5_NAME)) continue;
            pos = cs1.activeTransform(fivePrimeRes.getChild(i).getPosition());
            d = GeometryTools.distanceToLineSegment(pos, lineStart, directionAndLength);
            result += this.bridgableConstraint.getDiff(d);
        }
        for (i = 0; i < threePrimeRes.size(); ++i) {
            if (threePrimeRes.getChild(i).getName().equals(ATOM_3_NAME)) continue;
            pos = cs2.activeTransform(threePrimeRes.getChild(i).getPosition());
            d = GeometryTools.distanceToLineSegment(pos, lineStart, directionAndLength);
            result += this.bridgableConstraint.getDiff(d);
        }
        return result;
    }

    private double isBridgable2(Nucleotide3D fivePrimeRes, Nucleotide3D threePrimeRes, CoordinateSystem cs1, CoordinateSystem cs2) throws RnaModelException {
        Vector3D planeNormal = NucleotideTools.computeBasePlaneNormal(fivePrimeRes);
        assert (planeNormal.length() > 0.99 && planeNormal.length() < 1.01);
        planeNormal = cs1.activeTransform(planeNormal).minus(cs1.getPosition());
        assert (planeNormal.length() > 0.99 && planeNormal.length() < 1.01);
        Vector3D planeOffset = cs1.activeTransform(NucleotideTools.getGlycosylicBondAtom(fivePrimeRes).getPosition());
        double result = 0.0;
        for (int i = 0; i < threePrimeRes.size(); ++i) {
            Vector3D pos = cs2.activeTransform(threePrimeRes.getChild(i).getPosition());
            double d = GeometryTools.planeDistance(planeNormal, planeOffset, pos);
            if (!(d < 0.0)) continue;
            result -= d;
        }
        Vector3D planeNormal2 = NucleotideTools.computeBasePlaneNormal(threePrimeRes);
        assert (planeNormal2.length() > 0.99 && planeNormal2.length() < 1.01);
        planeNormal2 = cs2.activeTransform(planeNormal2).minus(cs2.getPosition());
        assert (planeNormal2.length() > 0.99 && planeNormal2.length() < 1.01);
        Vector3D planeOffset2 = cs2.activeTransform(NucleotideTools.getGlycosylicBondAtom(threePrimeRes).getPosition());
        planeNormal2.scale(-1.0);
        assert (planeNormal2.length() < 1.01);
        assert (planeNormal2.length() > 0.99);
        for (int i = 0; i < fivePrimeRes.size(); ++i) {
            Vector3D pos = cs1.activeTransform(fivePrimeRes.getChild(i).getPosition());
            double d = GeometryTools.planeDistance(planeNormal2, planeOffset2, pos);
            if (!(d < 0.0)) continue;
            result -= d;
        }
        return result;
    }

    private double isBridgable2(Nucleotide3D fivePrimeRes, Nucleotide3D threePrimeRes) throws RnaModelException {
        Vector3D planeNormal = NucleotideTools.computeBasePlaneNormal(fivePrimeRes);
        Vector3D planeOffset = NucleotideTools.getGlycosylicBondAtom(fivePrimeRes).getPosition();
        double result = 0.0;
        for (int i = 0; i < threePrimeRes.size(); ++i) {
            Vector3D pos = threePrimeRes.getChild(i).getPosition();
            double d = GeometryTools.planeDistance(planeNormal, planeOffset, pos);
            if (!(d < 0.0)) continue;
            result -= d;
        }
        Vector3D planeNormal2 = NucleotideTools.computeBasePlaneNormal(threePrimeRes);
        Vector3D planeOffset2 = NucleotideTools.getGlycosylicBondAtom(threePrimeRes).getPosition();
        planeNormal2.scale(-1.0);
        for (int i = 0; i < fivePrimeRes.size(); ++i) {
            Vector3D pos = fivePrimeRes.getChild(i).getPosition();
            double d = GeometryTools.planeDistance(planeNormal2, planeOffset2, pos);
            if (!(d < 0.0)) continue;
            result -= d;
        }
        return result;
    }

    private double isBridgable(Nucleotide3D fivePrimeRes, Nucleotide3D threePrimeRes) {
        double d;
        Vector3D pos;
        int i;
        assert (false);
        Vector3D lineStart = fivePrimeRes.getChild(ATOM_5_NAME).getPosition();
        Vector3D lineEnd = threePrimeRes.getChild(ATOM_3_NAME).getPosition();
        Vector3D directionAndLength = lineEnd.minus(lineStart);
        double result = 0.0;
        for (i = 0; i < fivePrimeRes.size(); ++i) {
            pos = fivePrimeRes.getChild(i).getPosition();
            d = GeometryTools.distanceToLineSegment(pos, lineStart, directionAndLength);
            result += this.bridgableConstraint.getDiff(d);
        }
        for (i = 0; i < threePrimeRes.size(); ++i) {
            pos = threePrimeRes.getChild(i).getPosition();
            d = GeometryTools.distanceToLineSegment(pos, lineStart, directionAndLength);
            result += this.bridgableConstraint.getDiff(d);
        }
        return result;
    }

    public int getFivePrimeIndex(int n) {
        return n * 2;
    }

    public int getThreePrimeIndex(int n) {
        return n * 2 + 1;
    }

    public Object3D getFivePrimeObject(int n) {
        return this.getObj(this.getFivePrimeIndex(n));
    }

    public Object3D getThreePrimeObject(int n) {
        return this.getObj(this.getThreePrimeIndex(n));
    }

    @Override
    public ConstraintDouble getConstraint() {
        return this.constraint;
    }

    @Override
    public int getSymId(int index) {
        return this.symIds.get(index);
    }

    @Override
    public int getSymId1() {
        return this.symIds.get(0);
    }

    @Override
    public int getSymId2() {
        return this.symIds.get(1);
    }

    public boolean isProperNucleotide(Nucleotide3D nuc) {
        return nuc.getIndexOfChild(ATOM_5_NAME) >= 0 && nuc.getIndexOfChild(ATOM_3_NAME) >= 0;
    }

    @Override
    public void setSymId(int index, int _symId1) {
        while (this.symIds.size() <= index) {
            this.symIds.add(-1);
        }
        this.symIds.set(index, _symId1);
    }

    @Override
    public void setSymId1(int _symId1) {
        this.setSymId(0, _symId1);
    }

    @Override
    public void setSymId2(int _symId2) {
        this.setSymId(1, _symId2);
    }

    public String toPrettyString() {
        return this.toString();
    }

    @Override
    public String toString() {
        int i;
        String result = "(JunctionMultiConstraintLink " + this.getName();
        for (i = 0; i < this.size(); ++i) {
            result = result + " " + this.getObj(i).getFullName();
        }
        for (i = 0; i < this.symIds.size(); ++i) {
            result = result + " " + this.symIds.get(i);
        }
        result = result + " " + this.getConstraint().toString() + " )";
        return result;
    }

    public boolean validate() {
        return this.getBranchCount() > 0 && this.symIds.size() == this.getBranchCount() && this.getBranchCount() == this.threePrimePositions.length && this.getBranchCount() == this.fivePrimePositions.length;
    }
}

