/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.NucleotideTools;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaModelException;
import sequence.LetterSymbol;
import sequence.Residue;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleObject3D;

public class Nucleotide3D
extends SimpleObject3D
implements Residue3D {
    private int assignedNumber;
    private String assignedName = "";
    public static final String CLASS_NAME = "Nucleotide3D";
    private LetterSymbol symbol;
    private static Logger log = Logger.getLogger("NanoTiler.debug");

    public Nucleotide3D() {
        this.assignedNumber = 0;
    }

    public Nucleotide3D(LetterSymbol symbol, Vector3D position) {
        super(position);
        this.symbol = symbol;
        this.assignedNumber = 0;
    }

    public Object clone() {
        assert (false);
        return new Nucleotide3D(this.symbol, this.getRelativePosition());
    }

    @Override
    public Object cloneDeepThis() {
        Nucleotide3D obj = new Nucleotide3D();
        obj.assignedNumber = this.assignedNumber;
        obj.copyDeepThisCore(this);
        obj.symbol = (LetterSymbol)this.symbol.clone();
        return obj;
    }

    @Override
    public int getAssignedNumber() {
        return this.assignedNumber;
    }

    @Override
    public String getAssignedName() {
        return this.assignedName;
    }

    @Override
    public int getAtomCount() {
        return this.size();
    }

    @Override
    public Atom3D getAtom(int n) {
        if (!(this.getChild(n) instanceof Atom3D)) {
            log.warning("Child " + n + " of nucleotide " + this.getFullName() + " is not of class Atom3D: " + this.getChild(n));
            return null;
        }
        return (Atom3D)this.getChild(n);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public int getCovalentBondOrder(Atom3D atom1, Atom3D atom2) {
        try {
            boolean flag = NucleotideTools.isCovalentlyBonded(this, atom1.getName(), atom2.getName());
            return flag ? 1 : 0;
        }
        catch (RnaModelException rne) {
            log.info("RnaModelException: " + rne.getMessage());
            return 0;
        }
    }

    @Override
    public List<Atom3D> getCovalentlyBondedAtoms(Atom3D atom) {
        ArrayList<Atom3D> resultAtoms = new ArrayList<Atom3D>();
        Nucleotide3D res = (Nucleotide3D)atom.getParent();
        for (int j = 0; j < res.size(); ++j) {
            Atom3D atomOther = (Atom3D)this.getChild(j);
            if (atom == atomOther || this.getCovalentBondOrder(atom, atomOther) <= 0) continue;
            resultAtoms.add(atomOther);
        }
        return resultAtoms;
    }

    @Override
    public Object getParentObject() {
        return this.getParent();
    }

    @Override
    public LetterSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isKnownResidue() {
        char c = this.getName().charAt(0);
        return c != 'X' && c != 'N';
    }

    @Override
    public void insertChild(Object3D child) {
        if (!(child instanceof Atom3D)) {
            log.warning("Adding class other than Atom3D to object of class Nucleotide3D: " + this.getFullName() + " " + ((Object)child).toString());
        }
        super.insertChild(child);
    }

    @Override
    public boolean isSameSequence(Residue other) {
        if (other instanceof Nucleotide3D) {
            Nucleotide3D otherNuc = (Nucleotide3D)other;
            assert (this.getParent() != null);
            assert (otherNuc.getParent() != null);
            assert (this.getParent() instanceof BioPolymer);
            assert (otherNuc.getParent() instanceof BioPolymer);
            return this.getParent() == otherNuc.getParent();
        }
        return false;
    }

    @Override
    public void setSymbol(LetterSymbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public int getPos() {
        return this.getSiblingId();
    }

    public void mutateResidue(Residue residue, int position) {
        assert (false);
        throw new RuntimeException("Internal error: mutation of Nucleotide3D currently not supported!");
    }

    @Override
    public void read(InputStream is) {
    }

    @Override
    public void setParentObject(Object obj) {
        if (obj instanceof Object3D) {
            super.setParent((Object3D)obj);
        }
        throw new RuntimeException("Parent of Nucleotide3D class must be an Object3D");
    }

    @Override
    public void setPos(int pos) {
        log.warning("setPos ignored in Nucleotide3D");
    }

    @Override
    public void setAssignedName(String name) {
        this.assignedName = name;
    }

    @Override
    public void setAssignedNumber(int number) {
        this.assignedNumber = number;
    }

    private int findDigitPos(String name) {
        boolean digitPos = false;
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isDigit(name.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int getResidueNumberInName() {
        String name = this.getName();
        int digitPos = this.findDigitPos(name);
        if (digitPos < 0) {
            return -1;
        }
        String s = name.substring(digitPos, name.length());
        return Integer.parseInt(s);
    }

    @Override
    public int getResidueNumberInPdb() {
        String prop = this.getProperty("pdb_residue_id");
        if (prop == null) {
            return this.getPos() + 1;
        }
        return Integer.parseInt(prop);
    }

    public void setResidueNumberInName(int number) {
        String name = this.getName();
        int digitPos = this.findDigitPos(name);
        String prefix = name.substring(0, digitPos);
        this.setName(prefix + number);
    }

    @Override
    public String toString() {
        String s = new String();
        s = "(" + this.getClassName() + " " + this.symbol + " " + this.toStringBody() + " )";
        return s;
    }
}

