/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.testng.annotations.Test;
import tools3d.Point;
import tools3d.Vector3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DFactory;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.RotationInfo;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class PointSetReader3
implements Object3DFactory {
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public RotationInfo readPoints2(InputStream is) throws Object3DIOException {
        DataInputStream dis = new DataInputStream(is);
        Object3D root = this.readAnyObject3D(is);
        LinkSet links = this.readLinks(is, root);
        PointSetReader3.readWord(dis);
        int numPlace = Integer.parseInt(PointSetReader3.readWord(dis));
        for (int i = 0; i < numPlace; ++i) {
            root.getChild(Integer.parseInt(PointSetReader3.readWord(dis)) - 1).setProperty("place", "true");
        }
        PointSetReader3.readWord(dis);
        int numRotate = Integer.parseInt(PointSetReader3.readWord(dis));
        for (int i = 0; i < numRotate; ++i) {
            int id1 = Integer.parseInt(PointSetReader3.readWord(dis)) - 1;
            int id2 = Integer.parseInt(PointSetReader3.readWord(dis)) - 1;
            Object3D child1 = root.getChild(id1);
            Object3D child2 = root.getChild(id2);
            Vector3D axis = PointSetReader3.readVector3D(dis);
            if (child2.getProperty("place") == "true") continue;
            child2.setProperty("rotateFrom", "" + id1);
            assert (child2.getProperty("rotateFrom").equals("" + id1));
            child2.setProperty("axisX", "" + axis.getX());
            assert (child2.getProperty("axisX").equals("" + axis.getX()));
            child2.setProperty("axisY", "" + axis.getY());
            assert (child2.getProperty("axisY").equals("" + axis.getY()));
            child2.setProperty("axisZ", "" + axis.getZ());
            assert (child2.getProperty("axisZ").equals("" + axis.getZ()));
            child2.setProperty("angle", "" + this.getAngle(axis, child1.getPosition(), child2.getPosition()));
            assert (child2.getProperty("angle").equals("" + this.getAngle(axis, child1.getPosition(), child2.getPosition())));
        }
        return new RotationInfo(root, links);
    }

    private double getAngle(Vector3D axisOrig, Vector3D child1Orig, Vector3D child2Orig) {
        Vector3D axis = new Vector3D(axisOrig);
        Vector3D child1 = new Vector3D(child1Orig);
        Vector3D child2 = new Vector3D(child2Orig);
        if (!axis.isOrigin()) {
            child1 = child1.minus(axis);
            child2 = child2.minus(axis);
            axis = axis.minus(axis);
        }
        assert (axis.isOrigin());
        assert (child1.length() > 0.0);
        assert (child2.length() > 0.0);
        double angle = child1.angle(child2);
        assert (angle > 0.0);
        return angle;
    }

    @Override
    public Object3D readAnyObject3D(InputStream is) throws Object3DIOException {
        DataInputStream dis = new DataInputStream(is);
        SimpleObject3D root = new SimpleObject3D();
        PointSetReader3.readWord(dis);
        int numPoints = Integer.parseInt(PointSetReader3.readWord(dis));
        log.info("Reading " + numPoints + " points.");
        for (int i = 0; i < numPoints; ++i) {
            Vector3D position = PointSetReader3.readVector3DIndex(dis);
            log.fine("Coordinates of point " + (i + 1) + ": " + position);
            SimpleObject3D child = new SimpleObject3D();
            child.setPosition(position);
            child.setName("p" + i);
            root.insertChild(child);
        }
        return root;
    }

    @Test
    public void testReadAnyObject3D() {
    }

    @Override
    public Object3DLinkSetBundle readBundle(InputStream is) throws Object3DIOException {
        assert (false);
        return new SimpleObject3DLinkSetBundle();
    }

    public LinkSet readLinks(InputStream is, Object3D root) throws Object3DIOException {
        DataInputStream dis = new DataInputStream(is);
        SimpleLinkSet links = new SimpleLinkSet();
        root.setName("PointSet3Import");
        PointSetReader3.readWord(dis);
        int numLinks = Integer.parseInt(PointSetReader3.readWord(dis));
        for (int i = 0; i < numLinks; ++i) {
            int id1 = Integer.parseInt(PointSetReader3.readWord(dis)) - 1;
            int id2 = Integer.parseInt(PointSetReader3.readWord(dis)) - 1;
            links.add(new SimpleLink(root.getChild(id1), root.getChild(id2)));
        }
        return links;
    }

    public static Vector3D readVector3DIndex(DataInputStream dis) throws Object3DIOException {
        int index = Integer.parseInt(PointSetReader3.readWord(dis));
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        String word = PointSetReader3.readWord(dis);
        try {
            x = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse x coordinate for Vector3D " + word);
        }
        word = PointSetReader3.readWord(dis);
        try {
            y = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse y coordinate for Vector3D " + word);
        }
        word = PointSetReader3.readWord(dis);
        try {
            z = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse z coordinate for Vector3D " + word);
        }
        return new Vector3D(x, y, z, index);
    }

    public static Vector3D readVector3D(DataInputStream dis) throws Object3DIOException {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        String word = PointSetReader3.readWord(dis);
        try {
            x = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse x coordinate for Vector3D " + word);
        }
        word = PointSetReader3.readWord(dis);
        try {
            y = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse y coordinate for Vector3D " + word);
        }
        word = PointSetReader3.readWord(dis);
        try {
            z = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse z coordinate for Vector3D " + word);
        }
        return new Vector3D(x, y, z);
    }

    public static Point readPoint(DataInputStream dis) throws Object3DIOException {
        String name = PointSetReader3.readWord(dis);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        String word = PointSetReader3.readWord(dis);
        try {
            x = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse x coordinate for Point " + word);
        }
        word = PointSetReader3.readWord(dis);
        try {
            y = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse y coordinate for Point " + word);
        }
        word = PointSetReader3.readWord(dis);
        try {
            z = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse z coordinate for Point " + word);
        }
        Point point = new Point(name, x, y, z);
        return point;
    }

    @Test
    public void testReadPoint() {
    }

    public static String readWord(DataInputStream dis) {
        String s = new String("");
        char c = ' ';
        do {
            try {
                c = (char)dis.readByte();
            }
            catch (IOException e) {
                break;
            }
        } while (Character.isWhitespace(c));
        if (Character.isWhitespace(c)) {
            log.fine("found word: " + s);
            return s;
        }
        s = s + c;
        try {
            while (!Character.isWhitespace(c = (char)dis.readByte())) {
                s = s + c;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        log.fine("found word: " + s);
        return s;
    }
}

