/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import rnadesign.rnamodel.AbstractPdbReader;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.SimpleRnaStrand;
import sequence.DnaTools;
import sequence.SimpleLetterSymbol;
import sequence.UnknownSymbolException;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DFactory;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class RnaPdbReader
extends AbstractPdbReader
implements Object3DFactory {
    public static final char BAD_RESIDUE_CHAR = 'X';
    public static final int PRECISION = 3;
    public static final int NO_TRANSLATION = 0;
    public static final int AMBER_TO_STANDARD = 1;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static char defaultStrandName = (char)65;
    private int translationMode = 0;
    public boolean debugMode = false;
    public boolean dnaMode = false;

    @Override
    public Object3DLinkSetBundle readBundle(InputStream is) throws Object3DIOException {
        DataInputStream dis = new DataInputStream(is);
        if (this.debugMode) {
            log.fine("starting RnaPdbReader.readBundle!");
        }
        Object3D obj = this.readAnyObject3D(is);
        SimpleLinkSet links = new SimpleLinkSet();
        this.addBackboneLinks(obj, links);
        this.addCovalentLinks(obj, links);
        if (this.debugMode) {
            log.fine("Finished RnaPdbReader.readBundle: PDB file with " + obj.size() + " strands read: Position: " + obj.getPosition());
        }
        return new SimpleObject3DLinkSetBundle(obj, links);
    }

    @Override
    public Object3D readAnyObject3D(InputStream is) throws Object3DIOException {
        if (this.debugMode) {
            log.fine("Starting RnaPdbReader.readAnyObject3D!");
        }
        DataInputStream dis = new DataInputStream(is);
        SimpleObject3D root = new SimpleObject3D();
        SimpleObject3DSet atomSet = new SimpleObject3DSet();
        root.setName("PdbImport");
        char currentStrandName = '_';
        int currentResidueId = -9999;
        int currentAtomId = -9999;
        int lineCounter = 0;
        SimpleRnaStrand currentStrand = null;
        Nucleotide3D currentResidue = null;
        int strandCounter = 0;
        boolean strandEndFlag = false;
        try {
            String line;
            do {
                line = dis.readLine();
                ++lineCounter;
                if (this.debugMode) {
                    log.fine("Read line " + lineCounter + ": " + line);
                }
                if (line == null) {
                    if (this.debugMode) {
                        log.fine("Quitting loop because end of file reached! Line number: " + lineCounter);
                    }
                    break;
                }
                if (this.isTer(line) || this.isEndMdl(line)) {
                    if (this.debugMode) {
                        log.fine("TER or ENDMDL keyword found!");
                    }
                    strandEndFlag = true;
                    continue;
                }
                if (RnaPdbReader.isAtom(line)) {
                    double minDist;
                    int residueId = this.getResidueId(line);
                    String residueName = this.getResidueName(line);
                    if (!this.isLegalResidueName(residueName)) {
                        System.out.println("# Residue name is not legal: " + residueName);
                        continue;
                    }
                    String atomName = this.getAtomName(line);
                    char strandName = this.getStrandName(line);
                    char versionChar = this.getVersionChar(line);
                    if (versionChar != ' ' && versionChar != 'A') {
                        log.fine("Warning: ignoring alternative coordinate version: " + line);
                        continue;
                    }
                    Atom3D atom = this.generateAtomFromPdb(line);
                    if (this.debugMode) {
                        log.fine("Read atom: " + atom.getName() + " with position: " + atom.getPosition());
                    }
                    if (atomSet.size() > 0 && (minDist = RnaPdbReader.findMinimumDistance(atom, atomSet)) < 0.7) {
                        log.fine("Warning: ignoring atom " + line);
                        continue;
                    }
                    if (currentStrand == null || strandEndFlag || strandName != ' ' && strandName != currentStrandName || residueId < currentResidueId) {
                        strandEndFlag = false;
                        if (strandName == ' ') {
                            strandName = this.getDefaultStrandName(strandCounter);
                        }
                        ++strandCounter;
                        currentStrand = this.dnaMode ? new SimpleRnaStrand(DnaTools.DNA_ALPHABET) : new SimpleRnaStrand(DnaTools.RNA_ALPHABET);
                        currentStrand.setName("" + strandName);
                        currentStrand.setProperty("pdb_chain_char", "" + strandName);
                        currentStrandName = strandName;
                        root.insertChild(currentStrand);
                    }
                    if (currentResidue == null || currentResidueId != residueId) {
                        try {
                            char c = this.getResidueCharacter(residueName);
                            SimpleLetterSymbol symbol = this.dnaMode ? new SimpleLetterSymbol(c, DnaTools.DNA_ALPHABET) : new SimpleLetterSymbol(c, DnaTools.RNA_ALPHABET);
                            currentResidue = new Nucleotide3D(symbol, atom.getPosition());
                            currentResidue.setAssignedNumber(currentResidueId);
                            currentResidue.setAssignedName(residueName);
                            String resName = "" + c + residueId;
                            currentResidue.setName(resName);
                            currentStrand.insertChild(currentResidue);
                            currentResidueId = residueId;
                        }
                        catch (UnknownSymbolException e) {
                            log.fine("Warning: could not interpret nucleotide symbol from line: " + line);
                        }
                    }
                    if (this.debugMode) {
                        log.fine("Inserting atom into strand " + strandCounter + " " + currentStrandName + " residue " + currentResidue.getName() + " " + currentResidue.getPos() + " : " + atom);
                    }
                    currentResidue.insertChild(atom);
                    Vector3D newAtomPos = currentResidue.getChild(currentResidue.size() - 1).getPosition();
                    if (!(atom.getPosition().distance(newAtomPos) >= 0.001)) continue;
                    log.fine("Error!!! root: " + root.getPosition() + " strand " + currentStrand.getPosition() + " residue " + currentResidue.getPosition() + " atom: " + atom.getPosition() + " new atom pos: " + newAtomPos);
                    assert (atom.getPosition().distance(newAtomPos) < 0.001);
                    continue;
                }
                if (!this.debugMode) continue;
                log.fine("Line is not ATOM : " + line);
            } while (line != null);
        }
        catch (IOException exp) {
            // empty catch block
        }
        Object3DTools.balanceTree(root);
        if (this.debugMode) {
            log.fine("Finished RnaPdbReader.readAnyObject3D");
        }
        return root;
    }
}

