/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.Randomizer;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaFolder;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaStrand;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;

public class RnaUnfolder
implements RnaFolder {
    private int stepMax = 100;
    public static final double RESIDUE_DIST_CUTOFF = 30.0;
    public static final double ATOM_DIST_COLLISION = 0.9;
    private static Random rnd = Randomizer.getInstance();
    private static final double ANGLE_STEP = 0.17453292519943295;
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    private int countCollisions(Object3DSet strandSet) {
        int collisionCounter = 0;
        for (int i = 0; i < strandSet.size(); ++i) {
            RnaStrand strandI = (RnaStrand)strandSet.get(i);
            for (int k = 0; k < strandI.getResidueCount(); ++k) {
                Nucleotide3D res1 = (Nucleotide3D)strandI.getResidue3D(k);
                for (int j = i; j < strandSet.size(); ++j) {
                    RnaStrand strandJ = (RnaStrand)strandSet.get(j);
                    for (int m = 0; m < strandJ.getResidueCount(); ++m) {
                        Nucleotide3D res2;
                        if (j == i && m <= k || res1.distance(res2 = (Nucleotide3D)strandJ.getResidue3D(m)) > 30.0) continue;
                        for (int p = 0; p < res1.getAtomCount(); ++p) {
                            Atom3D atom1 = res1.getAtom(p);
                            for (int q = 0; q < res2.getAtomCount(); ++q) {
                                Atom3D atom2 = res2.getAtom(q);
                                if (!(atom1.distance(atom2) < 0.9)) continue;
                                ++collisionCounter;
                            }
                        }
                    }
                }
            }
        }
        return collisionCounter;
    }

    public boolean mutationStep(Object3DSet strandSet, int initialCollisions) {
        int strandId = rnd.nextInt(strandSet.size());
        RnaStrand strand = (RnaStrand)strandSet.get(strandId);
        boolean result = true;
        int resId = rnd.nextInt(strand.size());
        int angleId = rnd.nextInt(5);
        while (angleId == 3) {
            angleId = rnd.nextInt(5);
        }
        double angle = 0.17453292519943295 * rnd.nextGaussian();
        try {
            strand.rotateAroundBackboneAngle(resId, angleId, angle);
        }
        catch (RnaModelException rne) {
            log.info("Could not rotate!");
        }
        int collisions = this.countCollisions(strandSet);
        if (!result || collisions > initialCollisions) {
            try {
                strand.rotateAroundBackboneAngle(resId, angleId, -angle);
            }
            catch (RnaModelException rne) {
                log.warning("Could not rotate back!");
            }
            result = false;
        }
        assert (this.countCollisions(strandSet) == initialCollisions);
        return result;
    }

    @Override
    public Properties fold(Object3D obj) {
        Properties properties = new Properties();
        Object3DSet strandSet = Object3DTools.collectByClassName(obj, "RnaStrand");
        int initialCollisionCount = this.countCollisions(strandSet);
        int acceptCount = 0;
        for (int i = 0; i < this.stepMax; ++i) {
            boolean accepted = this.mutationStep(strandSet, initialCollisionCount);
            if (!accepted) continue;
            ++acceptCount;
        }
        properties.setProperty("number_steps", "" + this.stepMax);
        properties.setProperty("number_accept", "" + acceptCount);
        return properties;
    }
}

