/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.AlgorithmFailureException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnamodel.ConnectivityGenerator;
import rnadesign.rnamodel.DBElementDescriptor;
import rnadesign.rnamodel.GrowConnectivity;
import rnadesign.rnamodel.SignatureTranslatorCanonizer;
import rnadesign.rnamodel.SmallConnectivityIterator;
import tools3d.Vector3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class SimpleConnectivityGenerator
implements ConnectivityGenerator {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    List<DBElementDescriptor> buildingBlocks;
    List<List<Vector3D>> buildingBlocksHelixDirections;
    List<List<Integer>> buildingBlockIndices;
    List<Object3D> vertices;
    LinkSet links;
    String topology = null;
    int[] vertexOrders;
    int numGenerations = 5;
    int helixLengthVariation = 4;
    int buildingBlockCountMax = 10;
    int connectionCountMax = 10;

    public SimpleConnectivityGenerator(List<Object3D> vertices, LinkSet links, List<DBElementDescriptor> buildingBlocks, List<List<Integer>> buildingBlockIndices, int numGenerations) {
        assert (vertices != null && vertices.size() > 0);
        assert (links != null && links.size() > 0);
        assert (buildingBlocks != null && buildingBlockIndices != null);
        assert (buildingBlockIndices.size() == vertices.size());
        assert (buildingBlocks.size() > 0);
        this.vertices = vertices;
        this.links = links;
        this.buildingBlocks = buildingBlocks;
        this.buildingBlockIndices = buildingBlockIndices;
        this.numGenerations = numGenerations;
        this.initVertexOrders();
    }

    public SimpleConnectivityGenerator(Object3D root, LinkSet linksOrig, List<DBElementDescriptor> buildingBlocks, List<List<Integer>> buildingBlockIndices, int numGenerations) {
        log.warning("Constructor method not save because order of elements below root not determined.");
        this.numGenerations = numGenerations;
        this.links = new SimpleLinkSet();
        for (int i = 0; i < linksOrig.size(); ++i) {
            this.links.add(linksOrig.get(i));
        }
        this.links.removeBadLinks(root);
        this.vertices = new ArrayList<Object3D>();
        SimpleObject3DSet oset = new SimpleObject3DSet(root);
        for (int i = 0; i < oset.size(); ++i) {
            if (this.links.getLinkOrder(oset.get(i)) <= 0) continue;
            this.vertices.add(oset.get(i));
        }
        this.buildingBlocks = buildingBlocks;
        this.buildingBlockIndices = buildingBlockIndices;
        assert (this.vertices != null);
        assert (this.links != null);
        assert (buildingBlocks != null && buildingBlockIndices != null);
        assert (buildingBlockIndices.size() == this.vertices.size());
        assert (buildingBlocks.size() > 0);
        this.initVertexOrders();
        this.initTopology();
    }

    @Override
    public void setTopology(String s) {
        this.topology = s;
    }

    @Override
    public String getTopology() {
        return this.topology;
    }

    @Override
    public int getBuildingBlockCountMax() {
        return this.buildingBlockCountMax;
    }

    @Override
    public int getConnectionCountMax() {
        return this.connectionCountMax;
    }

    @Override
    public int getVertexOrder(int n) {
        assert (this.vertexOrders != null && this.vertexOrders.length == this.vertices.size());
        assert (n >= 0 && n < this.vertexOrders.length);
        return this.vertexOrders[n];
    }

    @Override
    public int getHelixLengthVariation() {
        return this.helixLengthVariation;
    }

    @Override
    public int getNumGenerations() {
        return this.numGenerations;
    }

    @Override
    public void setNumGenerations(int n) {
        this.numGenerations = n;
    }

    private void initTopology() {
        if (this.vertices == null || this.vertices.size() < 1) {
            log.info("No target topology set!");
            this.setTopology("");
            return;
        }
        SignatureTranslatorCanonizer canonizer = new SignatureTranslatorCanonizer();
        SimpleObject3D root = new SimpleObject3D("root");
        for (Object3D vertex : this.vertices) {
            root.insertChild(vertex);
        }
        SimpleObject3DLinkSetBundle bundle = new SimpleObject3DLinkSetBundle(root, this.links);
        try {
            String topo = canonizer.generateCanonizedRepresentation(bundle);
            log.info("Setting target topology to " + topo);
            this.setTopology(topo);
        }
        catch (AlgorithmFailureException afe) {
            log.severe("Error canonizing graph : " + bundle);
        }
        log.info("Set graph topology to " + this.getTopology());
    }

    private void initVertexOrders() {
        this.vertexOrders = new int[this.vertices.size()];
        for (int i = 0; i < this.vertexOrders.length; ++i) {
            this.vertexOrders[i] = this.links.getLinkOrder(this.vertices.get(i));
        }
    }

    @Override
    public void setHelixLengthVariation(int n) {
        this.helixLengthVariation = n;
    }

    @Override
    public Iterator<GrowConnectivity> iterator() {
        SmallConnectivityIterator iter = new SmallConnectivityIterator(this);
        assert (iter.validate());
        return iter;
    }

    @Override
    public List<DBElementDescriptor> getBuildingBlocks() {
        return this.buildingBlocks;
    }

    @Override
    public List<List<Vector3D>> getBuildingBlocksHelixDirections() {
        return this.buildingBlocksHelixDirections;
    }

    @Override
    public List<List<Integer>> getBuildingBlockIndices() {
        return this.buildingBlockIndices;
    }

    @Override
    public List<Object3D> getVertices() {
        return this.vertices;
    }

    @Override
    public LinkSet getLinks() {
        return this.links;
    }

    @Override
    public void setBuildingBlockCountMax(int n) {
        this.buildingBlockCountMax = n;
    }

    @Override
    public void setConnectionCountMax(int n) {
        this.connectionCountMax = n;
    }
}

