/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnamodel.AbstractBiopolymer;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.MoleculeTools;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.NucleotideTools;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaStrand;
import sequence.Alphabet;
import sequence.DnaTools;
import sequence.Residue;
import sequence.Sequence;
import tools3d.Matrix3DTools;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleObject3DSet;

public class SimpleRnaStrand
extends AbstractBiopolymer
implements RnaStrand {
    public static final char DEFAULT_CHAIN_CHARACTER = 'A';
    private Alphabet alphabet = DnaTools.AMBIGUOUS_RNA_ALPHABET;
    private double weight = 1.0;
    public static final String CLASS_NAME = "RnaStrand";
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private char chainCharacter = (char)65;

    public SimpleRnaStrand() {
        this.setName("unnamed");
    }

    public SimpleRnaStrand(Alphabet alphabet) {
        this.alphabet = alphabet;
    }

    @Override
    public void addResidue(Residue residue) {
        if (!(residue instanceof Nucleotide3D)) {
            assert (false);
            throw new RuntimeException("SimpleRnaStrand.addResidue: added residue must be of type Nucleotid3D");
        }
        this.insertChild((Nucleotide3D)residue);
    }

    @Override
    public Atom3D getAtom(int n) {
        assert (false);
        this.log.severe("getAtom method not yet implemented!");
        return null;
    }

    @Override
    public int getAtomCount() {
        int sum = 0;
        int resCount = this.getResidueCount();
        for (int i = 0; i < resCount; ++i) {
            sum += this.getResidue3D(i).getAtomCount();
        }
        return sum;
    }

    @Override
    public int getCovalentBondOrder(Atom3D atom1, Atom3D atom2) throws RnaModelException {
        Nucleotide3D res1 = (Nucleotide3D)atom1.getParent();
        Nucleotide3D res2 = (Nucleotide3D)atom2.getParent();
        assert (res1.getParent() == this);
        assert (res2.getParent() == this);
        if (res1 == res2) {
            boolean flag = NucleotideTools.isCovalentlyBonded(res1, atom1.getName(), atom2.getName());
            if (!flag) {
                return 0;
            }
            return 1;
        }
        int posDiff = res2.getPos() - res1.getPos();
        assert (posDiff != 0);
        if (Math.abs(posDiff) > 1) {
            return 0;
        }
        if (posDiff == 1 && (atom1.getName().equals("O3*") || atom1.getName().equals("O3'")) && atom2.getName().equals("P")) {
            return 1;
        }
        if (posDiff == -1 && (atom2.getName().equals("O3*") || atom2.getName().equals("O3'")) && atom1.getName().equals("P")) {
            return 1;
        }
        return 0;
    }

    public Object3DSet collectRotationSet(Atom3D atom1, Atom3D atom2) throws RnaModelException {
        Nucleotide3D res1 = (Nucleotide3D)atom1.getParent();
        Nucleotide3D res2 = (Nucleotide3D)atom2.getParent();
        assert (res1.getParent() == this);
        assert (res2.getParent() == this);
        Object3DSet result = new SimpleObject3DSet();
        if (res1 == res2) {
            result = MoleculeTools.collectRotationSet(res1, atom1, atom2);
            for (int i = res1.getPos() + 1; i < this.getResidueCount(); ++i) {
                result.merge(Object3DTools.collectByClassName(this.getResidue3D(i), "Atom3D"));
            }
        } else {
            this.log.severe("Sorry, no backbone torsion angle rotations are currently only allowed for atoms of same residue!");
            assert (false);
        }
        return result;
    }

    @Override
    public List<Atom3D> getCovalentlyBondedAtoms(Atom3D atom) {
        int posEnd;
        ArrayList<Atom3D> resultAtoms = new ArrayList<Atom3D>();
        Nucleotide3D res = (Nucleotide3D)atom.getParent();
        int pos = res.getPos();
        int posStart = pos - 1;
        if (posStart < 0) {
            posStart = 0;
        }
        if ((posEnd = pos + 1) >= this.getResidueCount()) {
            posEnd = this.getResidueCount() - 1;
        }
        for (int i = posStart; i <= posEnd; ++i) {
            Nucleotide3D resOther = (Nucleotide3D)this.getChild(i);
            for (int j = 0; j < resOther.size(); ++j) {
                Atom3D atomOther = (Atom3D)resOther.getChild(j);
                try {
                    if (atom == atomOther || this.getCovalentBondOrder(atom, atomOther) <= 0) continue;
                    resultAtoms.add(atomOther);
                    continue;
                }
                catch (RnaModelException rne) {
                    this.log.fine("RNA model exception in getCovelentlyBondedAtoms " + atom.getName());
                }
            }
        }
        assert (resultAtoms.size() < 6);
        return resultAtoms;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public int findHighestNameIndex() {
        int resCount = this.getResidueCount();
        int highest = 0;
        for (int i = 0; i < resCount; ++i) {
            try {
                int newNum = Integer.parseInt(this.getChild(i).getName().substring(1));
                if (newNum <= highest) continue;
                highest = newNum;
                continue;
            }
            catch (NumberFormatException e) {
                this.log.fine("Ignoring name " + this.getChild(i).getName() + " for finding highest residue index.");
            }
        }
        return highest;
    }

    @Override
    public void append(BioPolymer other) {
        assert (other instanceof NucleotideStrand);
        this.log.fine("starting SimpleRnaStrand.append");
        NucleotideStrand strand = (NucleotideStrand)other;
        int currIndex = this.findHighestNameIndex() + 1;
        for (int i = 0; i < strand.getResidueCount(); ++i) {
            Residue3D newRes = strand.getResidue3D(i);
            String newName = newRes.getName();
            newName = "" + newName.charAt(0) + currIndex;
            newRes.setName(newName);
            assert (newRes.size() > 0);
            this.insertChild(newRes);
            ++currIndex;
        }
        this.log.fine("finished SimpleRnaStrand.append");
    }

    @Override
    public void appendAndDelete(BioPolymer other) {
        assert (other instanceof NucleotideStrand);
        this.log.fine("starting SimpleRnaStrand.append");
        NucleotideStrand strand = (NucleotideStrand)other;
        int currIndex = this.findHighestNameIndex() + 1;
        for (int i = 0; i < strand.getResidueCount(); ++i) {
            Residue3D newRes = strand.getResidue3D(i);
            String newName = newRes.getName();
            newName = "" + newName.charAt(0) + currIndex;
            newRes.setName(newName);
            assert (newRes.size() > 0);
            this.insertChild(newRes);
            ++currIndex;
        }
        if (other.getParent() != null) {
            other.getParent().removeChild(other);
        }
        this.log.fine("finished SimpleRnaStrand.append");
    }

    @Override
    public void prepend(BioPolymer other) {
        int i;
        assert (other instanceof NucleotideStrand);
        this.log.fine("started SimpleRnaStrand.prepend");
        NucleotideStrand strand = (NucleotideStrand)other;
        int currIndex = strand.findHighestNameIndex() + 1;
        for (i = 0; i < this.getResidueCount(); ++i) {
            String newName = this.getResidue3D(i).getName();
            newName = "" + newName.charAt(0) + currIndex;
            assert (this.getResidue3D(i).size() > 0);
            this.getResidue3D(i).setName(newName);
            ++currIndex;
        }
        for (i = strand.getResidueCount() - 1; i >= 0; --i) {
            this.insertChild(strand.getResidue3D(i), 0);
        }
        this.log.fine("finished SimpleRnaStrand.prepend");
    }

    @Override
    public void prependAndDelete(BioPolymer other) {
        int i;
        assert (other instanceof NucleotideStrand);
        this.log.fine("started SimpleRnaStrand.prepend");
        NucleotideStrand strand = (NucleotideStrand)other;
        int currIndex = strand.findHighestNameIndex() + 1;
        for (i = 0; i < this.getResidueCount(); ++i) {
            String newName = this.getResidue3D(i).getName();
            newName = "" + newName.charAt(0) + currIndex;
            assert (this.getResidue3D(i).size() > 0);
            this.getResidue3D(i).setName(newName);
            ++currIndex;
        }
        for (i = strand.getResidueCount() - 1; i >= 0; --i) {
            this.insertChild(strand.getResidue3D(i), 0);
        }
        if (other.getParent() != null) {
            other.getParent().removeChild(other);
        }
        this.log.fine("finished SimpleRnaStrand.prepend");
    }

    @Override
    public Object cloneDeepThis() {
        SimpleRnaStrand obj = new SimpleRnaStrand();
        obj.copyDeepThisCore(this);
        obj.chainCharacter = this.chainCharacter;
        obj.alphabet = this.alphabet;
        obj.weight = this.weight;
        return obj;
    }

    @Override
    public Object cloneDeep(int startPos, int stopPos) {
        SimpleRnaStrand strand = (SimpleRnaStrand)this.cloneDeepThis();
        for (int i = startPos; i < stopPos; ++i) {
            strand.insertChild((Object3D)this.getChild(i).cloneDeep());
        }
        return strand;
    }

    public char getChainCharacter() {
        return this.chainCharacter;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public Vector3D getResiduePosition(int n) throws IndexOutOfBoundsException {
        if (n < this.getResidueCount()) {
            Residue3D residue = this.getResidue3D(n);
            return residue.getPosition();
        }
        Vector3D pos = new Vector3D();
        pos.copy(this.getPosition());
        int nn = this.size();
        int nHalf = nn / 2;
        double z = pos.getZ() + (double)(n - nHalf) * 5.0;
        pos.setZ(z);
        return Matrix3DTools.rotate(pos, this.getRotationAxis(), this.getRotationAngle());
    }

    @Override
    public void clear() {
        super.clear();
        this.chainCharacter = (char)65;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Override
    public Object getParentObject() {
        return this.getParent();
    }

    @Override
    public int getResidueCount() {
        return this.size();
    }

    @Override
    public Residue3D getResidue3D(int n) {
        return (Nucleotide3D)this.getChild(n);
    }

    @Override
    public Residue getResidue(int n) {
        return this.getResidue3D(n);
    }

    @Override
    public Residue3D getResidueByAssignedNumber(int n) {
        int resCount = this.getResidueCount();
        for (int i = 0; i < resCount; ++i) {
            Residue3D residue = this.getResidue3D(i);
            if (residue.getAssignedNumber() != n) continue;
            return residue;
        }
        return null;
    }

    @Override
    public Residue3D getResidueByPdbId(int n) {
        String ns = new Integer(n).toString();
        int resCount = this.getResidueCount();
        for (int i = 0; i < resCount; ++i) {
            Residue3D residue = this.getResidue3D(i);
            if (!ns.equals(residue.getProperty("pdb_residue_id"))) continue;
            return residue;
        }
        return null;
    }

    @Override
    public String getShapeName() {
        return CLASS_NAME;
    }

    @Override
    public void insertChild(Object3D child) {
        assert (child instanceof Nucleotide3D);
        super.insertChild(child);
    }

    public boolean isProbablyEqual(Sequence seq) {
        if (seq instanceof Object3D) {
            return this.isProbablyEqual((Object3D)((Object)seq));
        }
        return false;
    }

    @Override
    public boolean isProbablyEqual(Object3D obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClassName().equals(this.getClassName()) || !obj.getName().equals(this.getName())) {
            return false;
        }
        double dist = this.distance(obj);
        if (dist > 0.001) {
            return false;
        }
        if (this.size() != obj.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.isProbablyEqual(this.getChild(i), obj.getChild(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isProbablyEqual(Object3D obj1, Object3D obj2) {
        if (obj1 instanceof Residue3D && obj2 instanceof Residue3D) {
            Residue3D res1 = (Residue3D)obj1;
            Residue3D res2 = (Residue3D)obj2;
            if (!res1.getSymbol().equals(res2.getSymbol())) {
                return false;
            }
            if (res1.size() != res2.size()) {
                return false;
            }
            return res1.distance(res2) < 0.001;
        }
        return obj1.isProbablyEqual(obj2);
    }

    @Override
    public void rotateAroundBackboneAngle(int residue, int angleId, double angle) throws RnaModelException {
        String atomName1 = NucleotideTools.getBackboneAngleAtomName1(angleId);
        String atomName2 = NucleotideTools.getBackboneAngleAtomName2(angleId);
        Atom3D atom1 = (Atom3D)this.getResidue3D(residue).getChild(atomName1);
        Atom3D atom2 = (Atom3D)this.getResidue3D(residue).getChild(atomName2);
        if (atom1 == null || atom2 == null) {
            throw new RnaModelException("Could not find atoms with names " + atomName1 + " " + atomName2 + " for residue " + (residue + 1));
        }
        int bondOrder = this.getCovalentBondOrder(atom1, atom2);
        if (bondOrder == 0) {
            this.log.info("Trying to rotate around two atoms that are not bonded: " + atom1 + " " + atom2);
            return;
        }
        Object3DSet rotationSet = this.collectRotationSet(atom1, atom2);
        Object3DTools.rotateSet(rotationSet, atom2.getPosition().minus(atom1.getPosition()), atom2.getPosition(), angle);
    }

    public void setChainCharacter(char chainChar) {
        this.chainCharacter = chainChar;
    }

    @Override
    public void setParent(Object obj) {
        if (obj instanceof Object3D) {
            super.setParent((Object3D)obj);
        }
        assert (false);
        throw new RuntimeException("Internal error: only object3d objects can be added here.");
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public BioPolymer split(int position, String newName) {
        int oldLength = this.getResidueCount();
        String oldSequence = this.sequenceString();
        SimpleRnaStrand newStrand = new SimpleRnaStrand(this.getAlphabet());
        newStrand.setName(newName);
        this.split(position, newStrand);
        assert (this.getResidueCount() + newStrand.getResidueCount() == oldLength);
        assert (oldSequence.equals(this.sequenceString() + newStrand.sequenceString()));
        return newStrand;
    }

    @Override
    public String toString() {
        String result = "(RnaStrand " + this.toStringBody() + this.sequenceString();
        result = result + " )";
        return result;
    }
}

