/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.awt.geom.NoninvertibleTransformException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.BranchDescriptorTools;
import rnadesign.rnamodel.DBElementDescriptor;
import rnadesign.rnamodel.GeneralRnaReader;
import rnadesign.rnamodel.JunctionHashGenerator;
import rnadesign.rnamodel.JunctionSimilarity;
import rnadesign.rnamodel.RnaConstants;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunction3DLispWriter;
import rnadesign.rnamodel.StrandJunctionDB;
import tools3d.CoordinateSystem;
import tools3d.Matrix4D;
import tools3d.Matrix4DTools;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3DFactory;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DWriter;
import tools3d.objects3d.SimpleLinkSet;

public class SimpleStrandJunctionDB
implements StrandJunctionDB {
    public static final String NEWLINE = System.getProperty("line.separator");
    private StrandJunction3D[][] strandJunctions;
    private List<HashMap<String, Set<Integer>>> hashes;
    private List<List<List<Matrix4D>>> junctionTransformations;
    private LinkSet[][] strandJunctionLinkSets;
    private JunctionHashGenerator hashGenerator = new JunctionHashGenerator();
    private Object3DFactory reader = new GeneralRnaReader();
    private Object3DWriter writer = new StrandJunction3DLispWriter();
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private String name = "junctionDB";

    public SimpleStrandJunctionDB() {
        assert (false);
    }

    public SimpleStrandJunctionDB(int numOrders) {
        this.strandJunctions = new StrandJunction3D[numOrders][0];
        this.strandJunctionLinkSets = new SimpleLinkSet[numOrders][0];
        this.hashes = new ArrayList<HashMap<String, Set<Integer>>>();
        this.junctionTransformations = new ArrayList<List<List<Matrix4D>>>();
        for (int i = 0; i < numOrders; ++i) {
            this.hashes.add(new HashMap());
            this.junctionTransformations.add(new ArrayList());
        }
    }

    public void clear() {
        this.strandJunctions = null;
        this.strandJunctionLinkSets = null;
    }

    @Override
    public synchronized void addJunction(StrandJunction3D junction, LinkSet links) {
        int order = junction.getBranchCount();
        if (order >= this.size()) {
            log.info("Warning: not adding junction because of too high order: " + order + " >= " + this.size());
            return;
        }
        StrandJunction3D[] sofarJunctions = this.getJunctions(order);
        StrandJunction3D[] tmpJunctions = new StrandJunction3D[sofarJunctions.length + 1];
        for (int i = 0; i < sofarJunctions.length; ++i) {
            tmpJunctions[i] = sofarJunctions[i];
        }
        tmpJunctions[tmpJunctions.length - 1] = junction;
        this.strandJunctions[order] = tmpJunctions;
        ArrayList<BranchDescriptor3D> branches = new ArrayList<BranchDescriptor3D>();
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            branches.add(junction.getBranch(i));
        }
        try {
            assert (branches != null);
            assert (branches.size() > 1);
            List<String> junctionHashes = this.hashGenerator.generateCompleteHashes(branches);
            for (String s : junctionHashes) {
                Set<Integer> l = this.hashes.get(order).get(s);
                if (l == null) {
                    l = new HashSet<Integer>();
                    this.hashes.get(order).put(s, l);
                }
                l.add(tmpJunctions.length - 1);
                List<Matrix4D> normTrafos = this.hashGenerator.generateCompleteNormalizedTransformations(junction);
            }
            log.fine("Adding links into Junction DB not yet implemented!");
        }
        catch (NoninvertibleTransformException niv) {
            System.out.println(niv.getMessage());
            System.exit(1);
        }
    }

    @Override
    public StrandJunction3D[] getJunctions(int order) {
        if (this.strandJunctions == null || order < 0 || order >= this.strandJunctions.length) {
            return new StrandJunction3D[0];
        }
        return this.strandJunctions[order];
    }

    @Override
    public String getName() {
        return this.name;
    }

    public LinkSet[] getStrandJunctionLinkSets(int order) {
        if (this.strandJunctionLinkSets == null || order < 0 || order >= this.strandJunctionLinkSets.length) {
            return new LinkSet[0];
        }
        return this.strandJunctionLinkSets[order];
    }

    @Override
    public StrandJunction3D getJunction(int order, int n) {
        if (this.strandJunctions == null || order < 0 || order >= this.strandJunctions.length || n >= this.strandJunctions[order].length) {
            return null;
        }
        return this.strandJunctions[order][n];
    }

    @Override
    public int[] getSuperposableJunctions(int order, int n, double rmsLimit) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        StrandJunction3D jnc = this.getJunction(order, n);
        StrandJunction3D[] otherJunctions = this.getJunctions(order);
        JunctionSimilarity similarityGenerator = new JunctionSimilarity();
        for (int i = 0; i < otherJunctions.length; ++i) {
            double rms;
            String rmsString;
            Properties superposProperties;
            if (i == n || (superposProperties = similarityGenerator.similarity(jnc, otherJunctions[i])) == null || (rmsString = superposProperties.getProperty("drms")) == null || !((rms = Double.parseDouble(rmsString)) <= rmsLimit)) continue;
            result.add(new Integer(i));
        }
        int[] finalResult = new int[result.size()];
        for (int i = 0; i < finalResult.length; ++i) {
            finalResult[i] = (Integer)result.get(i);
        }
        return finalResult;
    }

    @Override
    public Set<Integer> findSimilarJunctions(List<BranchDescriptor3D> branches) {
        System.out.println(this.hashesToString());
        ArrayList<CoordinateSystem> transforms = new ArrayList<CoordinateSystem>();
        CoordinateSystem3D cs = new CoordinateSystem3D(new Vector3D(0.0, 0.0, 0.0), new Vector3D(1.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0));
        for (int i = 0; i < branches.size(); ++i) {
            transforms.add(cs);
        }
        return this.findSimilarJunctions(branches, transforms);
    }

    @Override
    public Set<Integer> findSimilarJunctions(List<BranchDescriptor3D> branches, List<CoordinateSystem> activeTransforms) {
        assert (branches.size() == activeTransforms.size());
        int order = branches.size();
        System.out.println(this.hashesToString());
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            List<String> junctionHashes = this.hashGenerator.generateCompleteHashes(branches, activeTransforms);
            for (int i = 0; i < junctionHashes.size(); ++i) {
                Set<Integer> set = this.hashes.get(order).get(junctionHashes.get(i));
                Iterator<Integer> it = set.iterator();
                while (it.hasNext()) {
                    System.out.print("" + it.next());
                }
                System.out.println("");
                result.addAll(set);
            }
        }
        catch (NoninvertibleTransformException nit) {
            log.warning("Could not generate hash codes for junction!");
        }
        return result;
    }

    @Override
    public Map<Integer, Double> findAndScoreSimilarJunctions(List<BranchDescriptor3D> branches) {
        int order = branches.size();
        System.out.println(this.hashesToString());
        HashMap<Integer, Double> result = new HashMap<Integer, Double>();
        try {
            List<Matrix4D> normTrafos = this.hashGenerator.generateCompleteNormalizedTransformations(branches);
            List<String> junctionHashes = this.hashGenerator.generateCompleteHashes(branches);
            for (int i = 0; i < junctionHashes.size(); ++i) {
                Set<Integer> set = this.hashes.get(order).get(junctionHashes.get(i));
                for (int id : set) {
                    StrandJunction3D junc = this.getJunction(order, id);
                    List<Matrix4D> currTrafos = this.hashGenerator.generateCompleteNormalizedTransformations(junc);
                    double score = this.hashGenerator.scoreNormalizedTransformations(normTrafos, currTrafos);
                    result.put(id, score);
                }
            }
        }
        catch (NoninvertibleTransformException nit) {
            log.warning("Could not generate hash codes for junction!");
        }
        return result;
    }

    @Override
    public Map<Integer, Double> findAndScoreSimilarJunctions(List<BranchDescriptor3D> branches, List<CoordinateSystem> activeTransforms) {
        assert (branches.size() == activeTransforms.size());
        int order = branches.size();
        System.out.println(this.hashesToString());
        HashMap<Integer, Double> result = new HashMap<Integer, Double>();
        try {
            List<Matrix4D> normTrafos = this.hashGenerator.generateCompleteNormalizedTransformations(branches, activeTransforms);
            List<String> junctionHashes = this.hashGenerator.generateCompleteHashes(branches, activeTransforms);
            for (int i = 0; i < junctionHashes.size(); ++i) {
                Set<Integer> set = this.hashes.get(order).get(junctionHashes.get(i));
                if (set != null) {
                    Iterator<Integer> it = set.iterator();
                    assert (it != null);
                    while (it.hasNext()) {
                        int id = it.next();
                        StrandJunction3D junc = this.getJunction(order, id);
                        List<Matrix4D> currTrafos = this.hashGenerator.generateCompleteNormalizedTransformations(junc);
                        double score = this.hashGenerator.scoreNormalizedTransformations(normTrafos, currTrafos);
                        result.put(id, score);
                    }
                    continue;
                }
                System.out.println("No similar junctions found for hash " + (i + 1) + " : " + junctionHashes.get(i));
            }
        }
        catch (NoninvertibleTransformException nit) {
            log.warning("Could not generate hash codes for junction!");
        }
        return result;
    }

    @Override
    public List<Double> scoreAllJunctions(List<BranchDescriptor3D> branches, List<CoordinateSystem> activeTransforms) {
        assert (branches.size() == activeTransforms.size());
        int order = branches.size();
        ArrayList<Double> result = new ArrayList<Double>();
        try {
            List<Matrix4D> normTrafos = this.hashGenerator.generateCompleteNormalizedTransformations(branches, activeTransforms);
            for (int id = 0; id < this.size(order); ++id) {
                StrandJunction3D junc = this.getJunction(order, id);
                List<Matrix4D> currTrafos = this.hashGenerator.generateCompleteNormalizedTransformations(junc);
                double score = this.hashGenerator.scoreNormalizedTransformations(normTrafos, currTrafos);
                result.add(score);
            }
        }
        catch (NoninvertibleTransformException nit) {
            log.warning("Could not generate hash codes for junction!");
        }
        return result;
    }

    @Override
    public List<Double> scoreAllJunctions(List<BranchDescriptor3D> branches) {
        int order = branches.size();
        System.out.println(this.hashesToString());
        ArrayList<Double> result = new ArrayList<Double>();
        try {
            List<Matrix4D> normTrafos = this.hashGenerator.generateCompleteNormalizedTransformations(branches);
            for (int id = 0; id < this.size(order); ++id) {
                StrandJunction3D junc = this.getJunction(order, id);
                List<Matrix4D> currTrafos = this.hashGenerator.generateCompleteNormalizedTransformations(junc);
                double score = this.hashGenerator.scoreNormalizedTransformations(normTrafos, currTrafos);
                result.add(score);
            }
        }
        catch (NoninvertibleTransformException nit) {
            log.warning("Could not generate hash codes for junction!");
        }
        return result;
    }

    @Override
    public LinkSet getJunctionLinkSet(int order, int n) {
        if (this.strandJunctionLinkSets == null || order < 0 || order >= this.strandJunctionLinkSets.length || n >= this.strandJunctionLinkSets[order].length) {
            return null;
        }
        return this.strandJunctionLinkSets[order][n];
    }

    @Override
    public int getJunctionCount() {
        log.fine("SimpleStrandJunctionDB: Called getJunctionCount");
        try {
            int sum = 0;
            log.fine("Size: " + this.size());
            log.fine("strandJunctions: " + this.strandJunctions);
            log.fine("strandJunctions.length: " + this.strandJunctions.length);
            for (int i = 0; i < this.size(); ++i) {
                log.fine("Size(i): " + this.size(i));
                log.fine("Sum: " + (sum += this.size(i)));
            }
            return sum;
        }
        catch (NullPointerException e) {
            log.info("Junction DB does not contain junctions yet.");
            return 0;
        }
    }

    @Override
    public boolean isValid() {
        return this.strandJunctions != null && this.strandJunctions.length > 0;
    }

    public static Properties scoreJunctionLoopFit(BranchDescriptor3D bScaff1, BranchDescriptor3D bScaff2, BranchDescriptor3D bLoop1, BranchDescriptor3D bLoop2, int n1, int n2, double rotationWeight) {
        Matrix4D targetTrafo = BranchDescriptorTools.computeBranchDescriptorFlippedTransformation(bScaff1, bScaff2);
        log.fine("Trying to bridge: " + bScaff1.getFullName() + " " + bScaff2.getFullName() + " " + targetTrafo);
        log.fine("Trying to bridge from scaff1: " + bScaff1.getCoordinateSystem() + " " + bScaff1.getCoordinateSystem().generateMatrix4D());
        log.fine("Trying to bridge from scaff2: " + bScaff2.getCoordinateSystem() + " " + bScaff2.getCoordinateSystem().generateMatrix4D());
        log.fine("Trying to bridge from loop1: " + bLoop1.getCoordinateSystem() + " " + bLoop1.getCoordinateSystem().generateMatrix4D());
        log.fine("Trying to bridge from loop2: " + bLoop2.getCoordinateSystem() + " " + bLoop2.getCoordinateSystem().generateMatrix4D());
        Matrix4D bLoop1Flip = BranchDescriptorTools.computeBranchDescriptorInvertedTransformation(bLoop1.getCoordinateSystem().generateMatrix4D(), 0);
        Matrix4D trans = bLoop1Flip.inverse().multiply(bLoop2.getCoordinateSystem().generateMatrix4D());
        Matrix4D trans2 = RnaConstants.HELIX_MATRIX4D.pow(n1 + 1).multiply(trans).multiply(RnaConstants.HELIX_MATRIX4D.pow(n2 + 1));
        log.fine("Found bridge: " + bScaff1.getFullName() + " " + bScaff2.getFullName() + " " + trans + "\ntwo empty bp shifts:\n" + trans2);
        double score = Matrix4DTools.scoreFit(targetTrafo, trans2, rotationWeight);
        return Matrix4DTools.generateMatrix4DFitResult(score, n1, n2);
    }

    Properties scoreJunctionLoopFit(StrandJunction3D junction, int b1, int b2, int n1Min, int n1Max, int n2Min, int n2Max, Matrix4D targetTrafo) {
        BranchDescriptor3D branch1 = junction.getBranch(b1);
        BranchDescriptor3D branch2 = junction.getBranch(b2);
        Matrix4D queryTrafo = BranchDescriptorTools.computeBranchDescriptorFlippedTransformation(branch2, branch1).inverse();
        log.fine("Starting to rank loop fittings for brand descriptors " + junction.getBranch(b1).getFullName() + " " + " and " + junction.getBranch(b2).getFullName());
        log.fine("cs1: " + branch1.getCoordinateSystem().toString());
        log.fine("cs2: " + branch2.getCoordinateSystem().toString());
        log.fine("query transformation: " + queryTrafo);
        Properties result = Matrix4DTools.scoreFit(targetTrafo, queryTrafo, RnaConstants.HELIX_MATRIX4D, RnaConstants.HELIX_MATRIX4D, n1Min + 1, n1Max + 1, n2Min + 1, n2Max + 1);
        assert (result != null);
        result.setProperty("branch_id1", "" + b1);
        result.setProperty("branch_id2", "" + b2);
        return result;
    }

    @Override
    public List<Properties> rankLoopFits(BranchDescriptor3D b1, BranchDescriptor3D b2, int n1Min, int n1Max, int n2Min, int n2Max) {
        Matrix4D targetTrafo = BranchDescriptorTools.computeBranchDescriptorFlippedTransformation(b1, b2);
        log.fine("Starting to rank loop fittings for brand descriptors " + b1.getFullName() + " " + " and " + b2.getFullName());
        log.fine("cs1: " + b1.getCoordinateSystem().toString());
        Matrix4D mh2a = b2.getCoordinateSystem().generateMatrix4D();
        Matrix4D mh2b = BranchDescriptorTools.computeBranchDescriptorInvertedTransformation(mh2a, 1);
        Matrix4D mh2c = BranchDescriptorTools.computeBranchDescriptorInvertedTransformation(mh2b, 1);
        assert (mh2a.minus(mh2c).norm() < 0.1);
        log.fine("cs2: " + b2.getCoordinateSystem().toString() + " ; flipped: " + mh2b + " " + new CoordinateSystem3D(mh2b).toString());
        log.fine("target transformation: " + targetTrafo);
        ArrayList<Properties> result = new ArrayList<Properties>();
        int order = 2;
        int bId1 = 0;
        int bId2 = 1;
        double bestScore = 1.0E30;
        int bestId = 0;
        for (int i = 0; i < this.size(order); ++i) {
            StrandJunction3D junction = this.getJunction(order, i);
            Properties properties = this.scoreJunctionLoopFit(junction, bId1, bId2, n1Min, n1Max, n2Min, n2Max, targetTrafo);
            properties.setProperty("junction_id", "" + i);
            properties.setProperty("junction_order", "" + order);
            properties.setProperty("junction_direction", "forward");
            properties.setProperty("junction_type", junction.getClassName());
            double score = Double.parseDouble(properties.getProperty("score"));
            result.add(properties);
            if (score < bestScore) {
                bestId = result.size() - 1;
                bestScore = score;
            }
            Properties properties2 = this.scoreJunctionLoopFit(junction, bId2, bId1, n1Min, n1Max, n2Min, n2Max, targetTrafo);
            properties2.setProperty("junction_id", "" + i);
            properties2.setProperty("junction_order", "" + order);
            properties2.setProperty("junction_type", junction.getClassName());
            properties2.setProperty("junction_direction", "backward");
            result.add(properties2);
            score = Double.parseDouble(properties2.getProperty("score"));
            if (!(score < bestScore)) continue;
            bestId = result.size() - 1;
            bestScore = score;
        }
        if (bestId != 0) {
            log.fine("Swapping! 0 and " + bestId);
            Properties tmpProperties = (Properties)result.get(0);
            result.set(0, (Properties)result.get(bestId));
            result.set(bestId, tmpProperties);
        }
        return result;
    }

    private void readDimension(InputStream is, int n) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        String line = dis.readLine();
        line = line.trim();
        int numEntries = Integer.parseInt(line);
        this.strandJunctions[n] = new StrandJunction3D[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            try {
                this.strandJunctions[n][i] = (StrandJunction3D)this.reader.readAnyObject3D(dis);
                continue;
            }
            catch (Object3DIOException e) {
                this.clear();
                throw new IOException("StrandJunction3D parsing error: entry " + (i + 1) + " of dimension " + n + " ; " + e.getMessage());
            }
        }
    }

    @Override
    public void read(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        String line = dis.readLine();
        line = line.trim();
        int numDim = Integer.parseInt(line);
        this.strandJunctions = new StrandJunction3D[numDim][0];
        for (int dim = 0; dim < numDim; ++dim) {
            this.readDimension(dis, dim);
        }
    }

    @Override
    public List<StrandJunction3D> retrieveJunctions(DBElementDescriptor dbe) {
        StrandJunction3D[] jnc = this.getJunctions(dbe.getOrder());
        ArrayList<StrandJunction3D> result = new ArrayList<StrandJunction3D>();
        if (jnc != null) {
            if (dbe.getId() >= 0 && dbe.getId() < jnc.length) {
                result.add(jnc[dbe.getId()]);
            } else {
                for (StrandJunction3D jc : jnc) {
                    result.add(jc);
                }
            }
        }
        return result;
    }

    @Override
    public List<StrandJunction3D> retrieveAllJunctions() {
        ArrayList<StrandJunction3D> result = new ArrayList<StrandJunction3D>();
        for (int order = 0; order < this.strandJunctions.length; ++order) {
            for (int id = 0; id < this.strandJunctions[order].length; ++id) {
                result.add(this.strandJunctions[order][id]);
            }
        }
        if (result.size() != this.getJunctionCount()) {
            log.severe("Internal error in method retrieve all junctions: " + result.size() + " " + this.getJunctionCount());
        }
        return result;
    }

    @Override
    public int size() {
        if (this.strandJunctions == null) {
            return 0;
        }
        return this.strandJunctions.length;
    }

    @Override
    public int size(int n) {
        if (this.strandJunctions == null || n >= this.strandJunctions.length) {
            return 0;
        }
        return this.strandJunctions[n].length;
    }

    @Override
    public String infoString() {
        if (!this.isValid()) {
            return "No junctions defined in database!";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 2; i < this.strandJunctions.length; ++i) {
            buf.append("Junctions of order " + i + ": " + this.size(i) + NEWLINE);
        }
        return buf.toString();
    }

    public String hashesToString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.hashes.size(); ++i) {
            if (this.size(i) <= 0) continue;
            buf.append("# junctions of order " + i + ":" + NEWLINE);
            buf.append(this.hashes.get(i).toString() + NEWLINE);
        }
        return buf.toString();
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("" + this.size() + NEWLINE);
        for (int i = 0; i < this.size(); ++i) {
            buf.append("" + this.strandJunctions[i].length + NEWLINE);
            for (int j = 0; j < this.strandJunctions[i].length; ++j) {
                buf.append(this.writer.writeString(this.strandJunctions[i][j]));
            }
        }
        return buf.toString();
    }
}

