/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnamodel.AtomTools;
import rnadesign.rnamodel.BridgeFinder;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideDBTools;
import rnadesign.rnamodel.NucleotideTools;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaStrand;
import tools3d.MCSuperpose;
import tools3d.SuperpositionResult;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class SingleStrandBridgeFinder
implements BridgeFinder {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final double SOLUTION_MAX_FACTOR = 5.0;
    private List<Object3DLinkSetBundle> bundleList;
    int minBridge = 1;
    int maxBridge = 10;
    double rms = 2.0;
    double angleWeight = 1.0;
    double angleBendLimit = Math.toRadians(180.0);
    double angleBendLimitDist = 50.0;
    double collisionDistance = 1.0;
    int solutionMax = 10;
    boolean shortestMode = false;

    public SingleStrandBridgeFinder(List<Object3DLinkSetBundle> bundleList) {
        this.bundleList = bundleList;
    }

    public SingleStrandBridgeFinder() {
        this.bundleList = new ArrayList<Object3DLinkSetBundle>();
    }

    @Override
    public List<Object3DLinkSetBundle> findBridge(Object3D obj1, Object3D obj2) {
        assert (obj1 != null || obj2 != null);
        ArrayList<Object3DLinkSetBundle> result = new ArrayList<Object3DLinkSetBundle>();
        for (Object3DLinkSetBundle bundle : this.bundleList) {
            List<Object3DLinkSetBundle> tmpResult = null;
            if (obj1 != null && obj2 != null) {
                tmpResult = this.findBridgeInBundle(obj1, obj2, bundle);
            } else if (obj1 != null) {
                tmpResult = this.findBridgeHeadInBundle(obj1, bundle, this.maxBridge);
            } else {
                assert (obj2 != null);
                tmpResult = this.findBridgeHeadInBundle(obj2, bundle, this.maxBridge);
            }
            if (tmpResult == null) continue;
            result.addAll(tmpResult);
        }
        return result;
    }

    public List<Object3DLinkSetBundle> findBridgeHeadInBundle(Object3D obj1, Object3DLinkSetBundle bundle, int len) {
        log.fine("Started single strand bridge head finder: " + obj1.getFullName() + " using length " + len);
        if (!(obj1 instanceof Nucleotide3D)) {
            log.warning("Single strand bridge search only defined between nucleotides: " + obj1.getFullName());
            return null;
        }
        if (obj1.getParent() == null) {
            log.warning("Residue must be child node of nucleotide strand!");
            return null;
        }
        Nucleotide3D nuc1 = (Nucleotide3D)obj1;
        boolean appendAtEnd = true;
        if (nuc1.getSiblingId() == 0) {
            appendAtEnd = false;
        } else if (nuc1.getSiblingId() != nuc1.getParent().size() - 1) {
            log.warning("Nucleotide must be first or last residue of strand in order to be bridge head use for extension.");
            return null;
        }
        ArrayList<Object3DLinkSetBundle> result = new ArrayList<Object3DLinkSetBundle>();
        Object3D dbObj = bundle.getObject3D();
        Object3DSet strands = Object3DTools.collectByClassName(dbObj, "RnaStrand");
        for (int i = 0; i < strands.size(); ++i) {
            List<Object3DLinkSetBundle> tmpResult = this.findSingleStrandBridgeHead(nuc1, (RnaStrand)strands.get(i), len, appendAtEnd);
            result.addAll(tmpResult);
        }
        return result;
    }

    public List<Object3DLinkSetBundle> findBridgeInBundle(Object3D obj1, Object3D obj2, Object3DLinkSetBundle bundle) {
        log.info("Started single strand bridge finder: " + obj1.getFullName() + " " + obj2.getFullName() + " distance: " + obj1.distance(obj2));
        if (!(obj1 instanceof Nucleotide3D)) {
            log.warning("Single strand bridge search only defined between nucleotides: " + obj1.getFullName() + " " + obj2.getFullName());
            return null;
        }
        if (!(obj2 instanceof Nucleotide3D)) {
            log.warning("Single strand bridge search only defined between nucleotides: " + obj1.getFullName() + " " + obj2.getFullName());
            return null;
        }
        Nucleotide3D nuc1 = (Nucleotide3D)obj1;
        Nucleotide3D nuc2 = (Nucleotide3D)obj2;
        ArrayList<Object3DLinkSetBundle> result = new ArrayList<Object3DLinkSetBundle>();
        if (!this.validate(nuc1, nuc2)) {
            log.info("Nucleotides " + nuc1.getFullName() + " " + nuc2.getFullName() + " not bridgeable!");
            return result;
        }
        Object3D dbObj = bundle.getObject3D();
        Object3DSet strands = Object3DTools.collectByClassName(dbObj, "RnaStrand");
        for (int i = 0; i < strands.size(); ++i) {
            List<Object3DLinkSetBundle> tmpResult = this.findSingleStrandBridge(nuc1, nuc2, (RnaStrand)strands.get(i));
            result.addAll(tmpResult);
        }
        return result;
    }

    @Override
    public double getRms() {
        return this.rms;
    }

    @Override
    public void setRms(double rms) {
        this.rms = rms;
    }

    public List<Object3DLinkSetBundle> findSingleStrandBridge(Nucleotide3D obj1, Nucleotide3D obj2, RnaStrand strand) {
        ArrayList<Object3DLinkSetBundle> result = new ArrayList<Object3DLinkSetBundle>();
        for (int bridgeLength = this.minBridge; bridgeLength <= this.maxBridge; ++bridgeLength) {
            if (bridgeLength == 0) continue;
            log.info("Searching for bridge of length " + bridgeLength);
            List<Object3DLinkSetBundle> tmpResult = this.findSingleStrandBridge(obj1, obj2, strand, bridgeLength);
            if (tmpResult == null || tmpResult.size() <= 0) continue;
            result.addAll(tmpResult);
            if (this.shortestMode) break;
        }
        return result;
    }

    public List<Object3DLinkSetBundle> findSingleStrandBridge(Nucleotide3D obj1, Nucleotide3D obj2, RnaStrand strand, int bridgeLength) {
        ArrayList<Object3DLinkSetBundle> result = new ArrayList<Object3DLinkSetBundle>();
        Object3D root = Object3DTools.findRoot(obj1);
        Object3D root2 = Object3DTools.findRoot(obj2);
        for (int i = 0; i < strand.getResidueCount(); ++i) {
            int startPos = i;
            int stopPos = i + bridgeLength + 1;
            if (stopPos >= strand.getResidueCount()) break;
            Nucleotide3D otherStart = (Nucleotide3D)strand.getResidue3D(startPos);
            Nucleotide3D otherStop = (Nucleotide3D)strand.getResidue3D(stopPos);
            try {
                SuperpositionResult supResult = this.scoreSuperposition(obj1, obj2, otherStart, otherStop);
                if (supResult == null || !(supResult.getRms() < this.rms)) continue;
                Object3D bridgePart = (Object3D)strand.cloneDeep(startPos + 1, stopPos);
                supResult.applyTransformation(bridgePart);
                int collCount = 0;
                if (this.collisionDistance > 0.0) {
                    collCount = AtomTools.countExternalCollisions(bridgePart, root, this.collisionDistance);
                    if (root != root2) {
                        collCount += AtomTools.countExternalCollisions(bridgePart, root2, this.collisionDistance);
                    }
                }
                if (collCount != 0) continue;
                bridgePart.setZBufValue(supResult.getRms());
                result.add(new SimpleObject3DLinkSetBundle(bridgePart, new SimpleLinkSet()));
                continue;
            }
            catch (RnaModelException rne) {
                log.warning("Could not superpose " + obj1.getFullName() + " " + obj2.getFullName() + " with " + otherStart.getFullName() + " " + otherStop.getFullName());
            }
        }
        return result;
    }

    private List<Object3DLinkSetBundle> findSingleStrandBridgeHead(Nucleotide3D obj1, RnaStrand strand, int bridgeLength, boolean appendAtEnd) {
        ArrayList<Object3DLinkSetBundle> result = new ArrayList<Object3DLinkSetBundle>();
        Object3D root = Object3DTools.findRoot(obj1);
        for (int i = 0; i < strand.getResidueCount(); ++i) {
            int startPos = i;
            int stopPos = i + bridgeLength + 1;
            if (stopPos >= strand.getResidueCount()) break;
            Nucleotide3D otherStart = (Nucleotide3D)strand.getResidue3D(startPos);
            Nucleotide3D otherStop = (Nucleotide3D)strand.getResidue3D(stopPos);
            try {
                SuperpositionResult supResult = null;
                supResult = appendAtEnd ? this.scoreHeadSuperposition(obj1, otherStart) : this.scoreHeadSuperposition(obj1, otherStop);
                if (supResult == null || !(supResult.getRms() < this.rms)) continue;
                Object3D bridgePart = (Object3D)strand.cloneDeep(startPos + 1, stopPos);
                supResult.applyTransformation(bridgePart);
                int collCount = 0;
                if (this.collisionDistance > 0.0) {
                    collCount = AtomTools.countExternalCollisions(bridgePart, root, this.collisionDistance);
                }
                if (collCount != 0) continue;
                bridgePart.setZBufValue(supResult.getRms());
                log.info("Adding bridge head fragment with rms " + supResult.getRms());
                result.add(new SimpleObject3DLinkSetBundle(bridgePart, new SimpleLinkSet()));
                if (!((double)result.size() >= 5.0 * (double)this.solutionMax)) continue;
                log.info("Found " + result.size() + " solutions. Quitting bridge head search.");
                break;
            }
            catch (RnaModelException rne) {
                log.warning("Could not superpose " + obj1.getFullName() + " with " + otherStart.getFullName());
            }
        }
        return result;
    }

    public SuperpositionResult scoreSuperposition(Nucleotide3D oldRes1, Nucleotide3D oldRes2, Nucleotide3D newRes1, Nucleotide3D newRes2) throws RnaModelException {
        int i;
        Object3DSet oldTripod1 = NucleotideDBTools.extractAtomTripodBp(oldRes1);
        Object3DSet oldTripod2 = NucleotideDBTools.extractAtomTripodBp(oldRes2);
        Object3DSet newTripod1 = NucleotideDBTools.extractAtomTripodBp(newRes1);
        Object3DSet newTripod2 = NucleotideDBTools.extractAtomTripodBp(newRes2);
        Vector3D[] oldCoord1 = Object3DSetTools.getCoordinates(oldTripod1);
        Vector3D[] newCoord1 = Object3DSetTools.getCoordinates(newTripod1);
        Vector3D[] oldCoord2 = Object3DSetTools.getCoordinates(oldTripod2);
        Vector3D[] newCoord2 = Object3DSetTools.getCoordinates(newTripod2);
        Vector3D[] oldCoord = new Vector3D[oldCoord1.length + oldCoord2.length];
        Vector3D[] newCoord = new Vector3D[newCoord1.length + newCoord2.length];
        for (i = 0; i < newCoord1.length; ++i) {
            newCoord[i] = newCoord1[i];
            oldCoord[i] = oldCoord1[i];
        }
        for (i = 0; i < newCoord2.length; ++i) {
            newCoord[i + newCoord1.length] = newCoord2[i];
            oldCoord[i + oldCoord1.length] = oldCoord2[i];
        }
        if (Vector3DTools.computeDrms(newCoord, oldCoord) > this.rms) {
            return null;
        }
        MCSuperpose superposer = new MCSuperpose();
        SuperpositionResult supResult = superposer.superpose(oldCoord, newCoord);
        return supResult;
    }

    public SuperpositionResult scoreHeadSuperposition(Nucleotide3D oldRes1, Nucleotide3D newRes1) throws RnaModelException {
        Object3DSet oldTripod1 = NucleotideDBTools.extractAtomTripodBp(oldRes1);
        Object3DSet newTripod1 = NucleotideDBTools.extractAtomTripodBp(newRes1);
        Vector3D[] oldCoord1 = Object3DSetTools.getCoordinates(oldTripod1);
        Vector3D[] newCoord1 = Object3DSetTools.getCoordinates(newTripod1);
        if (Vector3DTools.computeDrms(newCoord1, oldCoord1) > this.rms) {
            return null;
        }
        MCSuperpose superposer = new MCSuperpose();
        SuperpositionResult supResult = superposer.superpose(oldCoord1, newCoord1);
        return supResult;
    }

    @Override
    public void setAngleWeight(double x) {
        this.angleWeight = x;
    }

    @Override
    public int getLenMin() {
        return this.minBridge;
    }

    @Override
    public int getLenMax() {
        return this.maxBridge;
    }

    @Override
    public void setLenMin(int n) {
        this.minBridge = n;
    }

    @Override
    public void setLenMax(int n) {
        this.maxBridge = n;
    }

    @Override
    public void setSolutionMax(int n) {
        this.solutionMax = n;
    }

    public boolean validate(Nucleotide3D n1, Nucleotide3D n2) {
        boolean result = false;
        try {
            double angle = NucleotideTools.getBackboneAngle(n1, n2);
            double dist = n1.getChild("C1*").distance(n2.getChild("C1*"));
            if (angle < this.angleBendLimit && dist < this.angleBendLimitDist) {
                result = true;
                log.info("Single-Strand-Bridge validation result for nucleotides with distance and angle: " + dist + " " + Math.toDegrees(angle) + " : " + result + " " + n1.getFullName() + " " + n2.getFullName());
            } else {
                log.fine("Problematic single-Strand-Bridge validation result for nucleotides with distance and angle: " + dist + " " + Math.toDegrees(angle) + " : " + result + " " + n1.getFullName() + " " + n2.getFullName());
            }
        }
        catch (RnaModelException rme) {
            log.info("Model exception while trying to validate bridge anchor residues: " + rme.getMessage());
            return false;
        }
        return result;
    }
}

