/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import graphtools.PermutationGenerator;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.rnamodel.NucleotideStrand;
import sequence.SequenceTools;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DSimilarity;
import tools3d.objects3d.Object3DTools;

public class StrandSimilarity
implements Object3DSimilarity {
    Logger log = Logger.getLogger("NanoTiler_debug");
    double sequenceIdentityLimitFraction = 1.0;

    private Vector3D[] generatePositions(Object3DSet strandSet, int[] permutation) {
        ArrayList<Vector3D> result = new ArrayList<Vector3D>();
        for (int i = 0; i < strandSet.size(); ++i) {
            NucleotideStrand strand = (NucleotideStrand)strandSet.get(permutation[i]);
            for (int j = 0; j < strand.getResidueCount(); ++j) {
                result.add(strand.getResidue3D(j).getChild("C4*").getPosition());
            }
        }
        Vector3D[] finalResult = new Vector3D[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            finalResult[i] = (Vector3D)result.get(i);
        }
        return finalResult;
    }

    private Vector3D[] generatePositions(Object3DSet j) {
        int[] perm = new int[j.size()];
        for (int i = 0; i < perm.length; ++i) {
            perm[i] = i;
        }
        return this.generatePositions(j, perm);
    }

    private double computeSequenceIdentifyFraction(Object3DSet strandSet1, Object3DSet strandSet2, int[] perm) {
        assert (perm != null);
        int countId = 0;
        int countTot = 0;
        for (int i = 0; i < perm.length; ++i) {
            NucleotideStrand strand1 = (NucleotideStrand)strandSet1.get(i);
            NucleotideStrand strand2 = (NucleotideStrand)strandSet2.get(perm[i]);
            if (strand1.size() != strand2.size()) {
                return -1.0;
            }
            int numIdent = SequenceTools.countIdentical(strand1, strand2);
            countId += numIdent;
            countTot += strand1.size();
        }
        return (double)countId / (double)countTot;
    }

    @Override
    public Properties similarity(Object3D obj1, Object3D obj2) {
        Properties properties = new Properties();
        properties.setProperty("superposable", "false");
        Object3DSet strandSet1 = Object3DTools.collectByClassName(obj1, "RnaStrand");
        Object3DSet strandSet2 = Object3DTools.collectByClassName(obj2, "RnaStrand");
        int numStrands = strandSet1.size();
        if (strandSet2.size() != numStrands) {
            return properties;
        }
        PermutationGenerator permGen = new PermutationGenerator(numStrands);
        Vector3D[] vSet1 = this.generatePositions(strandSet1);
        double bestDrms = 999999.9;
        int[] bestPerm = null;
        while (permGen.hasMore()) {
            Vector3D[] vSet2;
            double drms;
            int[] perm = permGen.getNext();
            double seqIdentityFraction = this.computeSequenceIdentifyFraction(strandSet1, strandSet2, perm);
            if (seqIdentityFraction < this.sequenceIdentityLimitFraction || !((drms = Vector3DTools.computeDrms(vSet1, vSet2 = this.generatePositions(strandSet2, perm))) < bestDrms)) continue;
            bestDrms = drms;
            bestPerm = perm;
        }
        if (bestPerm != null) {
            properties.setProperty("drms", "" + bestDrms);
            properties.setProperty("superposable", "true");
        } else {
            this.log.info("Junctions seem to be not superposable!");
        }
        return properties;
    }
}

