/*
 * Decompiled with CFR 0.152.
 */
package rnasecondary;

import generaltools.ResultWorker;
import generaltools.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.SimpleQueueManager;
import launchtools.SimpleRunCommand;
import rnasecondary.InteractionSet;
import rnasecondary.RnaInteractionType;
import rnasecondary.SimpleInteraction;
import rnasecondary.SimpleInteractionSet;
import rnasecondary.SimpleSecondaryStructure;
import sequence.Alphabet;
import sequence.DnaTools;
import sequence.Residue;
import sequence.Sequence;
import sequence.UnevenAlignment;

public class MatchFoldAllSecondaryStructurePredictor
extends ResultWorker {
    public static final double YIELD_MAX = 1.0;
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private Level debugLogLevel = Level.FINE;
    private static String scriptName = "matchconc.pl";
    private UnevenAlignment ali;
    private double gcEnergy = -1.0;
    private double auEnergy = -0.8;
    private Alphabet alphabet = DnaTools.AMBIGUOUS_RNA_ALPHABET;
    private Sequence[] sequences;
    private int stemLengthMin = 3;
    private int stopOffset = 3;
    private double yield = 1.0;
    private static int launchCount = 0;
    private static final int LAUNCH_MESSAGE_INTERVAL = 1000;

    public MatchFoldAllSecondaryStructurePredictor(UnevenAlignment ali) {
        assert (ali != null);
        this.ali = ali;
        this.sequences = this.getSequences(ali);
    }

    private Sequence[] getSequences(UnevenAlignment ali) {
        Sequence[] sequences = new Sequence[ali.getSequenceCount()];
        for (int i = 0; i < ali.getSequenceCount(); ++i) {
            sequences[i] = ali.getSequence(i);
        }
        return sequences;
    }

    private void writeSequences(OutputStream os, Sequence[] sequences) throws IOException {
        PrintStream ps = new PrintStream(os);
        for (int i = 0; i < sequences.length; ++i) {
            ps.println(">s" + (i + 1));
            ps.println(sequences[i].sequenceString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] launchFolding(Sequence[] sequences) throws IOException {
        ++launchCount;
        File tmpInputFile = File.createTempFile("nanotiler_matchold", ".seq");
        tmpInputFile.deleteOnExit();
        String inputFileName = tmpInputFile.getAbsolutePath();
        FileOutputStream fos = new FileOutputStream(tmpInputFile);
        this.writeSequences(fos, sequences);
        fos.close();
        File tmpOutputFile = File.createTempFile("nanotiler_rnafold", ".sec");
        String outputFileName = tmpOutputFile.getAbsolutePath();
        if (tmpOutputFile.exists()) {
            tmpOutputFile.delete();
        }
        tmpInputFile.deleteOnExit();
        File tempFile = new File(scriptName);
        String[] commandWords = new String[]{scriptName, inputFileName, outputFileName};
        SimpleRunCommand command = new SimpleRunCommand(commandWords);
        if (launchCount % 1000 == 1) {
            System.out.println("Issuing command: " + scriptName + " " + inputFileName + " " + outputFileName);
        }
        SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
        Job job = queueManager.createJob(command);
        queueManager.submit(job);
        String[] resultLines = null;
        String[] resultLines2 = null;
        FileInputStream resultFile = null;
        FileInputStream resultFile2 = null;
        try {
            resultFile = new FileInputStream(outputFileName + ".ct");
            resultFile2 = new FileInputStream(outputFileName + ".out");
            resultLines = StringTools.readAllLines(resultFile);
            resultLines2 = StringTools.readAllLines(resultFile2);
            this.yield = this.parseYield(resultLines2);
        }
        catch (IOException ioe) {
            this.log.warning("IO Error when scraping result file: " + ioe.getMessage());
            assert (false);
            throw ioe;
        }
        catch (NumberFormatException nfe) {
            this.log.warning("Could not scrape yield from matchconc.pl result: " + nfe.getMessage());
            assert (false);
        }
        finally {
            if (resultFile != null) {
                resultFile.close();
                File file = new File(outputFileName + ".ct");
                file.delete();
            }
            if (resultFile2 != null) {
                resultFile2.close();
                File file2 = new File(outputFileName + ".out");
                file2.delete();
            }
            if (tmpInputFile != null) {
                tmpInputFile.delete();
            }
        }
        if (resultLines == null) {
            assert (false);
            this.log.warning("matchfold results were null!");
        }
        return resultLines;
    }

    double parseYield(String[] lines) throws NumberFormatException {
        assert (lines.length > 0);
        double result = 0.0;
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].startsWith("# Start concentration")) continue;
            String[] words = lines[i].split(" ");
            assert (words.length == 10);
            result = Double.parseDouble(words[9]);
        }
        return result;
    }

    InteractionSet parseMatchfold(String[] lines) throws ParseException, NumberFormatException {
        if (lines.length < 2) {
            for (int i = 0; i < lines.length; ++i) {
                System.out.println(lines[i]);
            }
            throw new ParseException("Expected at least 2 lines in matchfold output!", 0);
        }
        SimpleInteractionSet result = new SimpleInteractionSet();
        String totSequence = lines[0];
        int numEntries = Integer.parseInt(lines[1]);
        for (int ii = 0; ii < numEntries; ++ii) {
            int i = ii + 2;
            String line = lines[i].trim();
            String[] words = line.split("\t");
            if (words.length != 2 && words.length != 3) {
                throw new ParseException("Expected 2 or 3 words in base pair decription.", i);
            }
            int currId = 0;
            int otherId = 0;
            try {
                currId = Integer.parseInt(words[0]) - 1;
                otherId = Integer.parseInt(words[1]) - 1;
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Parsing (number format) error in line: " + i + " " + nfe.getMessage(), i);
            }
            if (currId == otherId) {
                throw new ParseException("Two identical indices detected.", i);
            }
            if (currId >= otherId || otherId < 0) continue;
            int pc2 = 0;
            int seq1Id = 0;
            int seq1Pos = 0;
            int seq2Id = 0;
            int seq2Pos = 0;
            boolean found = false;
            for (int j = 0; j < this.sequences.length; ++j) {
                for (int k = 0; k < this.sequences[j].size(); ++k) {
                    if (pc2 == currId) {
                        seq1Id = j;
                        seq1Pos = k;
                        found = true;
                        break;
                    }
                    ++pc2;
                }
                if (found) break;
            }
            found = false;
            int pc3 = 0;
            for (int j = 0; j < this.sequences.length; ++j) {
                for (int k = 0; k < this.sequences[j].size(); ++k) {
                    if (pc3 == otherId) {
                        seq2Id = j;
                        seq2Pos = k;
                        found = true;
                        break;
                    }
                    ++pc3;
                }
                if (found) break;
            }
            Residue res1 = this.sequences[seq1Id].getResidue(seq1Pos);
            Residue res2 = this.sequences[seq2Id].getResidue(seq2Pos);
            assert (res1 != res2);
            RnaInteractionType interactionType = new RnaInteractionType(1);
            result.add(new SimpleInteraction(res1, res2, interactionType));
        }
        return result;
    }

    @Override
    protected void runInternal() {
        String[] launchResult = null;
        try {
            launchResult = this.launchFolding(this.sequences);
            InteractionSet interactionSet = this.parseMatchfold(launchResult);
            SimpleSecondaryStructure newResult = new SimpleSecondaryStructure(this.ali, interactionSet);
            newResult.setEnergy(1.0 - this.yield);
            this.setResult(newResult);
            this.setValid(true);
        }
        catch (IOException ioe) {
            this.setException(ioe);
            this.setValid(false);
        }
        catch (ParseException pe) {
            this.setException(pe);
            this.setValid(false);
        }
        catch (NumberFormatException nfe) {
            this.setException(nfe);
            this.setValid(false);
        }
        if (!this.validate()) {
            System.out.println("Non-valid MatchFoldScore for Weird matchfold output: ");
            for (String line : launchResult) {
                System.out.println(line);
            }
            if (this.getException() != null) {
                System.out.println("Excepion: " + this.getException().getMessage());
            }
        }
    }
}

