/*
 * Decompiled with CFR 0.152.
 */
package rnasecondary;

import generaltools.MalformedInputException;
import java.io.InputStream;
import rnasecondary.InteractionType;

public class RnaInteractionType
implements InteractionType {
    public static final int NO_INTERACTION = -1;
    public static final int UNKNOWN_SUBTYPE = 0;
    public static final int WATSON_CRICK = 1;
    public static final int WOBBLE = 2;
    public static final int NON_STANDARD = 3;
    public static final int HOOGSTEEN = 4;
    public static final int TERTIARY = 5;
    public static final int BACKBONE = 6;
    private static final String[] subTypeNames = new String[]{"Unknown", "WatsonCrick", "Wobble", "NonStandard", "Hoogsteen", "Tertiary", "Backbone"};
    private static final String typeName = "RnaInteraction";
    private int subTypeId = 0;

    public RnaInteractionType() {
    }

    public RnaInteractionType(int subTypeId) {
        this.subTypeId = subTypeId;
    }

    @Override
    public Object clone() {
        RnaInteractionType iType = new RnaInteractionType();
        iType.subTypeId = this.subTypeId;
        return iType;
    }

    public boolean equals(Object other) {
        if (other instanceof RnaInteractionType) {
            int otherId = ((RnaInteractionType)other).getSubTypeId();
            return otherId == this.subTypeId;
        }
        return false;
    }

    @Override
    public String getClassName() {
        return "RnaInteractionType";
    }

    @Override
    public String getTypeName() {
        return typeName;
    }

    @Override
    public String getSubTypeName() {
        return subTypeNames[this.subTypeId];
    }

    @Override
    public int getSubTypeId() {
        return this.subTypeId;
    }

    @Override
    public void read(InputStream is) throws MalformedInputException {
    }

    @Override
    public void setSubTypeId(int n) {
        this.subTypeId = n;
    }

    @Override
    public String toString() {
        String result = "(" + this.getTypeName() + " " + this.getSubTypeId() + " " + this.getSubTypeName() + " )";
        return result;
    }
}

