/*
 * Decompiled with CFR 0.152.
 */
package rnasecondary;

import generaltools.StringTools;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import numerictools.IntervalInt;
import org.testng.annotations.Test;
import rnasecondary.InteractionSet;
import rnasecondary.MutableSecondaryStructure;
import rnasecondary.RnaInteractionType;
import rnasecondary.SecondaryStructureParser;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import rnasecondary.SimpleInteraction;
import rnasecondary.SimpleInteractionSet;
import rnasecondary.SimpleMutableSecondaryStructure;
import sequence.DnaTools;
import sequence.DuplicateNameException;
import sequence.Sequence;
import sequence.SimpleMutableSequence;
import sequence.SimpleUnevenAlignment;
import sequence.UnknownSymbolException;

public class SecondaryStructureParserWithWeights
implements SecondaryStructureParser {
    private boolean fastaMode = false;
    public Level debugLogLevel = Level.FINE;
    private Logger log = Logger.getLogger("mcsopt");

    public SecondaryStructureParserWithWeights() {
        this.log.finest("starting SecondaryStructureParserWithWeights");
    }

    public SecondaryStructureParserWithWeights(boolean fastaMode) {
        this.log.finest("starting SecondaryStructureParserWithWeights");
        this.fastaMode = fastaMode;
    }

    private int findInnerInteraction(String s, int n) {
        if (s.charAt(n) != '(') {
            return -1;
        }
        for (int i = n + 1; i < s.length(); ++i) {
            if (s.charAt(i) == ')') {
                return i;
            }
            if (s.charAt(i) != '(') continue;
            return -1;
        }
        return -1;
    }

    private IntervalInt findInnerInteraction(String s) {
        for (int i = 0; i < s.length(); ++i) {
            int j = this.findInnerInteraction(s, i);
            if (j < 0) continue;
            return new IntervalInt(i, j);
        }
        return null;
    }

    void addInteractions(String structure, Sequence seq, InteractionSet interactions) {
        int foundInteractions;
        int numInteractions = StringTools.countChar(structure, '(');
        StringBuffer buf = new StringBuffer(structure);
        for (foundInteractions = 0; foundInteractions < numInteractions; ++foundInteractions) {
            IntervalInt intervall = this.findInnerInteraction(buf.toString());
            if (intervall == null) {
                this.log.log(this.debugLogLevel, "Could not find inner interactions in: " + structure);
                break;
            }
            int j = intervall.getLower();
            int k = intervall.getUpper();
            interactions.add(new SimpleInteraction(seq.getResidue(j), seq.getResidue(k), new RnaInteractionType(1)));
            buf.setCharAt(j, '.');
            buf.setCharAt(k, '.');
        }
        for (int i = 0; i < structure.length(); ++i) {
            if (structure.charAt(i) != '?') continue;
            this.log.log(this.debugLogLevel, "Setting residue " + (i + 1) + " to ignore status!");
            seq.getResidue(i).setProperty("seqstatus", "ignore");
        }
        assert (foundInteractions == numInteractions);
    }

    @Override
    public MutableSecondaryStructure parse(String filename) throws IOException, ParseException {
        FileInputStream fis = new FileInputStream(filename);
        String[] lines = StringTools.readAllLines(fis);
        return this.parse(lines);
    }

    @Override
    public MutableSecondaryStructure parse(String[] lines) throws ParseException {
        try {
            int i;
            SimpleUnevenAlignment sequences = new SimpleUnevenAlignment();
            SimpleInteractionSet interactions = new SimpleInteractionSet();
            ArrayList<String> structures = new ArrayList<String>();
            ArrayList<List<Double>> weights = new ArrayList<List<Double>>();
            this.log.log(this.debugLogLevel, "Parsing input");
            String name = null;
            int step = 0;
            double weight = 1.0;
            String startPattern = "~STRAND";
            if (this.fastaMode) {
                startPattern = ">";
            }
            for (i = 0; i < lines.length; ++i) {
                Matcher m;
                Pattern p;
                String line = lines[i];
                this.log.log(this.debugLogLevel, "Parsing line " + (i + 1) + " : " + line);
                if (step == 0) {
                    if (line.startsWith(startPattern)) {
                        if (!this.fastaMode) {
                            String[] words = line.split(" ");
                            if (words.length < 2 || words.length > 3) {
                                throw new ParseException("Error parsing ~STRAND line " + line, i + 1);
                            }
                            name = words[1];
                            if (words.length > 2) {
                                try {
                                    weight = Double.parseDouble(words[2]);
                                }
                                catch (NumberFormatException nfe) {
                                    throw new ParseException("Error parsing weight in ~STRAND line " + line, i + 1);
                                }
                            } else {
                                weight = 1.0;
                            }
                        } else {
                            line = line.trim();
                            name = line.substring(1, line.length());
                        }
                        this.log.log(this.debugLogLevel, "Parsed name and weight: " + name + " " + weight);
                        ++step;
                        continue;
                    }
                    this.log.info("Expecting ~STRAND. Ignoring line " + line);
                    continue;
                }
                if (step == 1) {
                    p = null;
                    p = !this.fastaMode ? Pattern.compile("SEQUENCE *= *([AaCcGgNnTtUuWwSs]+)") : Pattern.compile("([AaCcGgNnTtUu]+)");
                    Matcher m2 = p.matcher(line);
                    if (m2.matches()) {
                        String seqData = m2.group(1);
                        ArrayList<Integer> lowCharIndices = new ArrayList<Integer>();
                        for (int ii = 0; ii < seqData.length(); ++ii) {
                            if (!Character.isLowerCase(seqData.charAt(ii))) continue;
                            lowCharIndices.add(ii);
                        }
                        this.log.log(this.debugLogLevel, "Using alphabet: " + DnaTools.AMBIGUOUS_RNA_ALPHABET);
                        SimpleMutableSequence sequence = new SimpleMutableSequence(seqData.toUpperCase(), name, DnaTools.AMBIGUOUS_RNA_ALPHABET);
                        if (weight != 1.0) {
                            sequence.setWeight(weight);
                        }
                        for (int ii = 0; ii < lowCharIndices.size(); ++ii) {
                            int idx = (Integer)lowCharIndices.get(ii);
                            sequence.getResidue(idx).setProperty("sequence_status", "fragment");
                        }
                        this.log.log(this.debugLogLevel, "Adding sequence " + ((Object)sequence).toString());
                        sequences.addSequence(sequence);
                        ++step;
                        continue;
                    }
                    this.log.info("Expecting SEQUENCE. Ignoring line : " + line);
                    continue;
                }
                if (step == 2) {
                    p = null;
                    String pat = "([A-Za-z\\?\\.\\(\\)\\-\\+\\[\\]\\^\\`\\_\\\\]+)";
                    p = !this.fastaMode ? Pattern.compile("STRUCTURE *= *" + pat) : Pattern.compile(pat);
                    assert (p != null);
                    assert (line != null);
                    m = p.matcher(line);
                    if (m.matches()) {
                        structures.add(m.group(1));
                        this.log.log(this.debugLogLevel, "Adding structure " + m.group(1));
                        ++step;
                        continue;
                    }
                    this.log.info("Expecting STRUCTURE keyword. Ignoring line : " + line);
                    continue;
                }
                if (step != 3) continue;
                String pat = "([0-9\\+]+)";
                Pattern p2 = Pattern.compile("WEIGHTS *= *" + pat);
                m = p2.matcher(line);
                if (m.matches()) {
                    String weightString = m.group(1);
                    this.log.info("Found weight string " + weightString);
                    this.log.log(this.debugLogLevel, "Adding structure " + m.group(1));
                    ArrayList<Double> weightList = new ArrayList<Double>();
                    for (int k = 0; k < weightString.length(); ++k) {
                        String c = weightString.substring(k, k + 1);
                        assert (c.length() == 1);
                        double resWeight = 1.0;
                        if (!c.equals("+")) {
                            try {
                                resWeight = Double.parseDouble(c) / 10.0;
                            }
                            catch (NumberFormatException nfe) {
                                throw new ParseException(nfe.getMessage(), i);
                            }
                        }
                        weightList.add(resWeight);
                    }
                    weights.add(weightList);
                    step = 0;
                    continue;
                }
                this.log.info("Expecting WEIGHTS keyword. Ignoring line : " + line);
            }
            for (i = 0; i < structures.size(); ++i) {
                String structure = (String)structures.get(i);
                this.log.fine("Adding intra-sequence interactions for structure: " + structure);
                this.addInteractions(structure, sequences.getSequence(i), interactions);
            }
            for (i = 0; i < structures.size(); ++i) {
                for (int j = i + 1; j < structures.size(); ++j) {
                    String s1 = (String)structures.get(i);
                    String s2 = (String)structures.get(j);
                    StringBuffer sofarChars = new StringBuffer();
                    for (int k = 0; k < s1.length(); ++k) {
                        char c1 = s1.charAt(k);
                        if (c1 == '(' || c1 == ')' || c1 == '.' || c1 == '-' || sofarChars.indexOf("" + c1) >= 0) continue;
                        this.addInteractions(s1, s2, sequences.getSequence(i), sequences.getSequence(j), interactions, c1);
                        sofarChars.append("" + c1);
                    }
                }
            }
            SimpleMutableSecondaryStructure mutStruct = new SimpleMutableSecondaryStructure(sequences, interactions, weights);
            assert (mutStruct.weightsSanityCheck());
            return mutStruct;
        }
        catch (DuplicateNameException e1) {
            System.out.println("DuplicateNameException: " + e1.getMessage());
        }
        catch (UnknownSymbolException e2) {
            System.out.println("UnknownSymbolException: " + e2.getMessage());
        }
        return null;
    }

    private void addInteractions(String s1, String s2, Sequence seq1, Sequence seq2, InteractionSet interactions, char c) {
        int i;
        assert (s1.length() == seq1.size());
        assert (s2.length() == seq2.size());
        this.log.fine("Starting interaction search: " + c);
        int p1 = 0;
        RnaInteractionType interactionType = new RnaInteractionType(1);
        for (int i2 = 0; i2 < s1.length(); ++i2) {
            if (s1.charAt(i2) != c) continue;
            p1 = i2;
            break;
        }
        int p2 = s2.length() - 1;
        for (i = s2.length() - 1; i >= 0; --i) {
            if (s2.charAt(i) != c) continue;
            p2 = i;
            break;
        }
        for (i = 0; i < s1.length(); ++i) {
            int pp1 = p1 + i;
            int pp2 = p2 - i;
            if (pp1 >= s1.length() || pp2 < 0 || s1.charAt(pp1) != c || s2.charAt(pp2) != c) break;
            interactions.add(new SimpleInteraction(seq1.getResidue(pp1), seq2.getResidue(pp2), interactionType));
        }
    }

    private void parseSequences(String[] lines) {
    }

    private void parseInteractions(String[] lines) {
    }

    @Test(groups={"new"})
    public void testParse() {
        ResourceBundle rb = ResourceBundle.getBundle("SecondaryStructureDesignTest");
        String fileNames = rb.getString("testSecondaryStructureParserWithWeights");
        String[] tokens = fileNames.split(",");
        SecondaryStructureParserWithWeights parser = new SecondaryStructureParserWithWeights();
        for (int i = 0; i < tokens.length; ++i) {
            MutableSecondaryStructure structure;
            block13: {
                structure = null;
                String fileName = tokens[i];
                if (fileName.length() < 2) continue;
                System.out.println("Reading file: " + fileName);
                try {
                    structure = parser.parse(tokens[i]);
                    boolean foundZero = false;
                    boolean foundNonZero = false;
                    for (int k = 0; k < structure.getSequenceCount(); ++k) {
                        List<Double> weights = structure.getWeights(k);
                        for (int j = 0; j < weights.size(); ++j) {
                            System.out.println("Sequence " + (k + 1) + " residue " + (j + 1) + " weight: " + weights.get(j));
                            if (weights.get(j) == 0.0) {
                                foundZero = true;
                                continue;
                            }
                            foundNonZero = true;
                        }
                    }
                    if (!foundZero) {
                        this.log.severe("Did not find any residue that have zero weights.");
                        assert (foundZero);
                    }
                    if (!foundNonZero) {
                        this.log.severe("Did not find any residue that have non-zero weights.");
                        assert (foundZero);
                    }
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                    assert (false);
                }
                catch (ParseException pe) {
                    System.out.println(pe.getMessage());
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError();
                }
            }
            assert (structure != null);
            SecondaryStructureScriptFormatWriter writer = new SecondaryStructureScriptFormatWriter();
            System.out.println("Read secondary structure: " + writer.writeString(structure));
        }
    }
}

