/*
 * Decompiled with CFR 0.152.
 */
package rnasecondary;

import generaltools.MalformedInputException;
import java.io.InputStream;
import java.util.logging.Logger;
import rnasecondary.Interaction;
import rnasecondary.InteractionType;
import rnasecondary.PackageConventionTools;
import sequence.Residue;
import sequence.Sequence;

public class SimpleInteraction
implements Interaction {
    private InteractionType interactionType;
    private Residue residue1;
    private Residue residue2;
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public SimpleInteraction() {
    }

    public SimpleInteraction(Residue r1, Residue r2, InteractionType interactionType) {
        assert (r1 != null);
        assert (r2 != null);
        this.residue1 = r1;
        this.residue2 = r2;
        this.interactionType = interactionType;
    }

    @Override
    public Object clone() {
        SimpleInteraction interaction = new SimpleInteraction();
        interaction.interactionType = (InteractionType)this.interactionType.clone();
        interaction.residue1 = this.residue1;
        interaction.residue2 = this.residue2;
        return interaction;
    }

    @Override
    public int compareTo(Interaction other) {
        int p2b;
        int p2;
        if (!this.residue1.isSameSequence(other.getResidue1())) {
            log.finest("Careful, bad comparison in SimpleInteraction.compareTo");
            return 0;
        }
        int p1 = this.residue1.getPos();
        if (p1 < (p2 = other.getResidue1().getPos())) {
            return -1;
        }
        if (p2 > p1) {
            return 1;
        }
        int p1b = this.residue2.getPos();
        if (p1b > (p2b = other.getResidue2().getPos())) {
            return -1;
        }
        if (p2b < p1b) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getClassName() {
        return "Interaction";
    }

    @Override
    public InteractionType getInteractionType() {
        return this.interactionType;
    }

    @Override
    public Residue getResidue1() {
        return this.residue1;
    }

    @Override
    public Residue getResidue2() {
        return this.residue2;
    }

    @Override
    public Sequence getSequence1() {
        return (Sequence)this.residue1.getParentObject();
    }

    @Override
    public Sequence getSequence2() {
        return (Sequence)this.residue2.getParentObject();
    }

    @Override
    public boolean isIntraSequence() {
        return this.isValid() && this.getResidue1().isSameSequence(this.getResidue2());
    }

    @Override
    public boolean isOverlapping(Interaction other) {
        return this.getResidue1() == other.getResidue1() || this.getResidue1() == other.getResidue2() || this.getResidue2() == other.getResidue1() || this.getResidue2() == other.getResidue2();
    }

    @Override
    public boolean isValid() {
        return this.residue1 != null && this.residue2 != null && this.interactionType != null;
    }

    @Override
    public void read(InputStream is) throws MalformedInputException {
        PackageConventionTools.readHeader(is, this.getClassName());
        this.interactionType.read(is);
        this.residue1.read(is);
        this.residue2.read(is);
        PackageConventionTools.readFooter(is, this.getClassName());
    }

    @Override
    public void setResidue1(Residue r) {
        this.residue1 = r;
    }

    @Override
    public void setResidue2(Residue r) {
        this.residue2 = r;
    }

    @Override
    public void setInteractionType(InteractionType intType) {
        this.interactionType = intType;
    }

    @Override
    public String toString() {
        String result = "(Interaction ";
        result = this.getInteractionType() != null ? result + this.getInteractionType().toString() + " " : result + "invalidtype ";
        result = this.residue1 != null ? result + this.residue1.infoString() + " " : result + "invalidresidue1 ";
        result = this.residue2 != null ? result + this.residue2.infoString() + " " : result + "invalidresidue2 ";
        result = result + " )";
        return result;
    }
}

