/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.Randomizer;
import java.util.Properties;
import java.util.Random;
import rnasecondary.RnaSecondaryTools;
import rnasecondary.SecondaryStructure;
import secondarystructuredesign.SecondaryStructureScorer;

public class DefaultSecondaryStructureScorer
implements SecondaryStructureScorer {
    private double mismatchPenalty = 10.0;
    private double matchPenalty = 5.0;
    private double sameResiduePenalty = 0.2;
    private double gcContent = 0.6;
    private Random rand = Randomizer.getInstance();

    private boolean isComplementary(char c1, char c2) {
        return RnaSecondaryTools.isRnaComplement(c1, c2);
    }

    private boolean isWatsonCrick(char c1, char c2) {
        return RnaSecondaryTools.isWatsonCrick(c1, c2);
    }

    private double scoreStructureSequence(StringBuffer bseq, int[][] interactions) {
        assert (interactions.length == bseq.length());
        double score = 0.0;
        for (int i = 0; i < interactions.length; ++i) {
            if (i >= 2 && bseq.charAt(i) == bseq.charAt(i - 1) && bseq.charAt(i) == bseq.charAt(i - 2)) {
                score += this.sameResiduePenalty;
            }
            for (int j = i + 1; j < interactions.length; ++j) {
                if (interactions[i][j] == 1) {
                    if (this.isWatsonCrick(bseq.charAt(i), bseq.charAt(j))) continue;
                    score += this.mismatchPenalty;
                    continue;
                }
                if (interactions[i][j] != -1 || !this.isWatsonCrick(bseq.charAt(i), bseq.charAt(j)) || i <= 0 || j + 1 >= bseq.length() || !this.isWatsonCrick(bseq.charAt(i - 1), bseq.charAt(j + 1)) || j <= 0 || i + 1 >= bseq.length() || !this.isWatsonCrick(bseq.charAt(i + 1), bseq.charAt(j - 1)) || i <= 1 || j + 2 >= bseq.length() || !this.isWatsonCrick(bseq.charAt(i - 2), bseq.charAt(j + 2)) || j <= 1 || i + 2 >= bseq.length() || !this.isWatsonCrick(bseq.charAt(i + 2), bseq.charAt(j - 2))) continue;
                score += this.matchPenalty;
            }
        }
        return score;
    }

    private double scoreStructureSequencePair(StringBuffer bseq1, StringBuffer bseq2, int[][] interactions) {
        assert (interactions.length == bseq1.length());
        assert (interactions[0].length == bseq2.length());
        double score = 0.0;
        for (int i = 0; i < interactions.length; ++i) {
            for (int j = 0; j < interactions[i].length; ++j) {
                if (interactions[i][j] == 1) {
                    if (this.isWatsonCrick(bseq1.charAt(i), bseq2.charAt(j))) continue;
                    score += this.mismatchPenalty;
                    continue;
                }
                if (interactions[i][j] != -1 || !this.isWatsonCrick(bseq1.charAt(i), bseq2.charAt(j)) || i <= 0 || j + 1 >= bseq2.length() || !this.isWatsonCrick(bseq1.charAt(i - 1), bseq2.charAt(j + 1)) || j <= 0 || i + 1 >= bseq1.length() || !this.isWatsonCrick(bseq1.charAt(i + 1), bseq2.charAt(j - 1)) || i <= 1 || j + 2 >= bseq2.length() || !this.isWatsonCrick(bseq1.charAt(i - 2), bseq2.charAt(j + 2)) || j <= 1 || i + 2 >= bseq1.length() || !this.isWatsonCrick(bseq1.charAt(i + 2), bseq2.charAt(j - 2))) continue;
                score += this.matchPenalty;
            }
        }
        return score;
    }

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        String scoreString = this.generateReport(bseqs, structure, interactionMatrices, 0).getProperty("score");
        assert (scoreString != null);
        return Double.parseDouble(scoreString);
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        return this.generateReport(bseqs, structure, interactionMatrices, 10);
    }

    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices, int verbosity) {
        Properties resultProperties = new Properties();
        double score = 0.0;
        for (int i = 0; i < bseqs.length; ++i) {
            score += this.scoreStructureSequence(bseqs[i], interactionMatrices[i][i]);
            for (int j = i + 1; j < bseqs.length; ++j) {
                score += this.scoreStructureSequencePair(bseqs[i], bseqs[j], interactionMatrices[i][j]);
            }
        }
        resultProperties.setProperty("score", "" + score);
        return resultProperties;
    }
}

