/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import rnasecondary.MatchFoldAllSecondaryStructurePredictor;
import rnasecondary.SecondaryStructure;
import secondarystructuredesign.AbstractSecondaryStructureScorer;
import sequence.DuplicateNameException;
import sequence.UnevenAlignment;
import sequence.UnknownSymbolException;

public class MatchFoldAllSecondaryStructureScorer
extends AbstractSecondaryStructureScorer {
    public static final double YIELD_LOW_LIM = 1.0E-100;
    private double scale = 1.0;
    private Level debugLevel = Level.FINE;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private double yieldWeight = 10.0;

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        String scoreString = this.generateReport(bseqs, structure, interactionMatrices, 0).getProperty("score");
        assert (scoreString != null);
        return Double.parseDouble(scoreString);
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        return this.generateReport(bseqs, structure, interactionMatrices, 10);
    }

    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices, int verbosity) {
        UnevenAlignment ali;
        Properties resultProperties;
        block8: {
            resultProperties = new Properties();
            ali = null;
            try {
                ali = this.generateAlignment(bseqs);
            }
            catch (UnknownSymbolException use) {
                System.out.println(use.getMessage());
                assert (false);
            }
            catch (DuplicateNameException dne) {
                System.out.println(dne.getMessage());
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        int totLen = 0;
        for (StringBuffer bseq : bseqs) {
            totLen += bseq.length();
        }
        MatchFoldAllSecondaryStructurePredictor predictor = new MatchFoldAllSecondaryStructurePredictor(ali);
        predictor.run();
        SecondaryStructure prediction = (SecondaryStructure)predictor.getResult();
        assert (prediction != null);
        double result = this.scorePrediction(prediction, structure, interactionMatrices);
        double errorFrac = result / (double)totLen;
        double yieldFrac = 1.0 - prediction.getEnergy();
        if (yieldFrac < 1.0E-100) {
            yieldFrac = 1.0E-100;
        }
        double finalResult = errorFrac - this.yieldWeight * Math.log(yieldFrac);
        assert (finalResult >= 0.0);
        resultProperties.setProperty("score", "" + finalResult);
        return resultProperties;
    }
}

