/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.PropertyTools;
import generaltools.Randomizer;
import generaltools.SimplePropertyCarrier;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import rnasecondary.Interaction;
import rnasecondary.RnaSecondaryTools;
import rnasecondary.SecondaryStructure;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import secondarystructuredesign.CritonScorer;
import secondarystructuredesign.PackageConstants;
import secondarystructuredesign.RnacofoldSecondaryStructureScorer;
import secondarystructuredesign.SecondaryStructureScorer;
import secondarystructuredesign.SequenceConstraintScorer;
import secondarystructuredesign.SequenceOptimizer;
import sequence.Alphabet;
import sequence.DnaTools;
import sequence.Residue;
import sequence.Sequence;

public class MonteCarloSequenceOptimizer
extends SimplePropertyCarrier
implements SequenceOptimizer {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private Alphabet alphabet = DnaTools.RNA_ALPHABET;
    private double errorScoreLimit = 0.0;
    private double errorScoreLimit2 = 0.0;
    private int iterMax = 500;
    private int iter2Max = 200;
    private int rerun = 1;
    private double kt = 0.5;
    private double kt2 = 0.2;
    private double gcContent = 0.6;
    private boolean ignoreNotConstantMode = false;
    private double mismatchPenalty = 1.0;
    private double matchPenalty = 1.0;
    private double energyAU = -0.8;
    private double energyGC = -1.2;
    private double sameResiduePenalty = 0.2;
    private double finalScoreWeight = 0.1;
    private Random rand = Randomizer.getInstance();
    private boolean randomizeFlag = true;
    private int[] nucleotideProbabilities;
    private static final int CHAR_HELP_SIZE = 100;
    private char[] nucleotideHelperChars;
    private SecondaryStructureScorer defaultScorer = new CritonScorer();
    private SecondaryStructureScorer finalScorer = new RnacofoldSecondaryStructureScorer();
    private int stride1 = 1000;
    private int stride2 = 100;
    private boolean doSanityChecks = false;
    private Level debugLogLevel = Level.INFO;
    private SequenceConstraintScorer constraintScorer = null;
    private String algorithm = "twostage";

    public MonteCarloSequenceOptimizer() {
        this.nucleotideProbabilities = new int[this.alphabet.size()];
        this.initProbabilities();
    }

    @Override
    public int getIterMax() {
        return this.iterMax;
    }

    @Override
    public int getIter2Max() {
        return this.iter2Max;
    }

    private void initProbabilities() {
        this.nucleotideProbabilities[0] = (int)(100.0 * (1.0 - this.gcContent) / 2.0);
        this.nucleotideProbabilities[1] = (int)(100.0 * this.gcContent / 2.0);
        this.nucleotideProbabilities[2] = (int)(100.0 * this.gcContent / 2.0);
        this.nucleotideProbabilities[3] = (int)(100.0 * (1.0 - this.gcContent) / 2.0);
        int sum = 0;
        for (int i = 0; i < this.nucleotideProbabilities.length; ++i) {
            sum += this.nucleotideProbabilities[i];
        }
        this.nucleotideHelperChars = new char[sum];
        int pc = 0;
        for (int i = 0; i < this.nucleotideProbabilities.length; ++i) {
            int numChar = this.nucleotideProbabilities[i];
            for (int j = 0; j < numChar; ++j) {
                if (pc >= this.nucleotideHelperChars.length) assert (false);
                this.nucleotideHelperChars[pc++] = this.alphabet.getSymbol(i).getCharacter();
            }
        }
        if (pc != 100) {
            this.log.severe("Bad helper index: " + pc + " " + 100);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.nucleotideHelperChars.length; ++i) {
            buf.append("" + this.nucleotideHelperChars[i]);
        }
        this.log.finest("Helper character array: " + buf.toString());
    }

    @Override
    public Properties eval(SecondaryStructure structure) {
        assert (this.finalScorer != null);
        assert (this.defaultScorer != null);
        Properties properties = new Properties();
        this.log.info("Starting MonteCarloSequenceOptimizer.eval !");
        this.constraintScorer = new SequenceConstraintScorer(structure);
        int[][][][] interactionMatrices = this.generateInteractionMatrices(structure);
        StringBuffer[] bseqs = this.initStringBuffers2(structure, false, interactionMatrices, structure.getAlphabets());
        this.log.info("Starting evaluation with sequences: " + PackageConstants.NEWLINE + this.generateSequencesOutputString(bseqs));
        if (!this.sanityCheck(bseqs, structure, interactionMatrices)) {
            this.log.log(this.debugLogLevel, "Not all base pairs are yet compatible!");
        }
        if (this.doSanityChecks) {
            this.sanityCheck(bseqs, structure, interactionMatrices);
        }
        try {
            Properties defaultProperties = this.defaultScorer.generateReport(bseqs, structure, interactionMatrices);
            double errorScore = Double.parseDouble(defaultProperties.getProperty("score"));
            Properties finalProperties = this.finalScorer.generateReport(bseqs, structure, interactionMatrices);
            double errorScore2 = Double.parseDouble(finalProperties.getProperty("score"));
            double errorScoreTot = errorScore + this.finalScoreWeight * errorScore2;
            properties.setProperty("score", "" + errorScoreTot);
            properties.setProperty("score1", "" + errorScore);
            properties.setProperty("score2", "" + errorScore2);
            PropertyTools.mergeProperties(properties, defaultProperties, "s1.");
            PropertyTools.mergeProperties(properties, finalProperties, "s2.");
            if (this.constraintScorer != null) {
                Properties constraintScorerProps = this.constraintScorer.generateReport(bseqs, structure, interactionMatrices);
                PropertyTools.mergeProperties(properties, constraintScorerProps, "s3.");
            }
            double finalTotalScore = Double.parseDouble(defaultProperties.getProperty("score")) + this.finalScoreWeight * Double.parseDouble(finalProperties.getProperty("score"));
            if (this.getProperty("s3.score") != null) {
                finalTotalScore += Double.parseDouble(this.getProperty("s3.score"));
            }
            properties.setProperty("total_score", "" + finalTotalScore);
            this.log.info("Ended evaluation " + errorScore + " " + errorScore2 + " " + errorScoreTot);
        }
        catch (NumberFormatException nfe) {
            properties.setProperty("error", "An error occurred during score calculation. " + nfe.getMessage());
            properties.setProperty("total_score", "Internal error: could not add score components.");
        }
        this.log.info("Finished MonteCarloSequenceOptimizer.eval.");
        return properties;
    }

    public SecondaryStructureScorer getDefaultScorer() {
        return this.defaultScorer;
    }

    @Override
    public double getErrorScoreLimit() {
        return this.errorScoreLimit;
    }

    public SecondaryStructureScorer getFinalScorer() {
        return this.finalScorer;
    }

    public boolean getIgnoreNotConstantMode() {
        return this.ignoreNotConstantMode;
    }

    public double getFinalScoreWeight() {
        return this.finalScoreWeight;
    }

    public double getGcContent() {
        return this.gcContent;
    }

    public double getKt() {
        return this.kt;
    }

    public void setDefaultScorer(SecondaryStructureScorer scorer) {
        this.defaultScorer = scorer;
    }

    public void setFinalScorer(SecondaryStructureScorer scorer) {
        this.finalScorer = scorer;
    }

    public void setFinalScoreWeight(double w) {
        this.finalScoreWeight = w;
    }

    public void setGcContent(double x) {
        this.gcContent = x;
        this.initProbabilities();
    }

    @Override
    public void setErrorScoreLimit(double x) {
        this.errorScoreLimit = x;
    }

    public void setErrorScoreLimit2(double x) {
        this.errorScoreLimit2 = x;
    }

    public void setIgnoreNotConstantMode(boolean mode) {
        this.ignoreNotConstantMode = mode;
    }

    @Override
    public void setIterMax(int n) {
        this.iterMax = n;
    }

    @Override
    public void setIter2Max(int n) {
        this.iter2Max = n;
    }

    @Override
    public void setRerun(int n) {
        this.rerun = n;
    }

    public void setKt(double kt) {
        assert (kt > 0.0);
        this.kt = kt;
    }

    public void setKt2(double kt2) {
        assert (kt2 > 0.0);
        this.kt2 = kt2;
    }

    private char mutateCharacter(char c) {
        if (Character.isLowerCase(c)) {
            return c;
        }
        char result = c;
        while ((result = this.nucleotideHelperChars[this.rand.nextInt(this.nucleotideHelperChars.length)]) == c) {
        }
        return result;
    }

    private void randomizeSequence(StringBuffer buf) {
        int origLen = buf.length();
        for (int i = 0; i < buf.length(); ++i) {
            if (!Character.isUpperCase(buf.charAt(i))) continue;
            buf.setCharAt(i, this.mutateCharacter(buf.charAt(i)));
        }
        assert (buf.length() == origLen);
    }

    private String generateRandomWatsonCrick() {
        String result = "";
        result = this.rand.nextDouble() > this.gcContent ? "AU" : "CG";
        if (this.rand.nextDouble() > 0.5) {
            return "" + result.charAt(1) + result.charAt(0);
        }
        assert (result.length() == 2);
        return result;
    }

    private boolean isInAlphabet(char c, Alphabet alphabet) {
        return alphabet.contains(c);
    }

    private boolean isInAlphabet(char c1, char c2, Alphabet alphabet1, Alphabet alphabet2) {
        return this.isInAlphabet(c1, alphabet1) && this.isInAlphabet(c2, alphabet2);
    }

    private String generateWatsonCrick(int id) {
        assert (id >= 0 && id < 4);
        switch (id) {
            case 0: {
                return "AU";
            }
            case 1: {
                return "CG";
            }
            case 2: {
                return "GC";
            }
            case 3: {
                return "UA";
            }
        }
        return null;
    }

    private String generateRandomWatsonCrick(Alphabet alphabet1, Alphabet alphabet2) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            String pair = this.generateWatsonCrick(i);
            if (!this.isInAlphabet(pair.charAt(0), pair.charAt(1), alphabet1, alphabet2)) continue;
            ids.add(i);
        }
        if (ids.size() == 0) {
            System.out.println("Could not generate watson crick pairs for alphabets: " + alphabet1 + " + " + alphabet2);
            return null;
        }
        int rid = this.rand.nextInt(ids.size());
        int id = (Integer)ids.get(rid);
        String result = this.generateWatsonCrick(id);
        assert (this.isInAlphabet(result.charAt(0), result.charAt(1), alphabet1, alphabet2));
        return result;
    }

    private void randomizeSequences2(StringBuffer[] buf, int[][][][] interactionMatrices, List<Alphabet> alphabets) {
        int i;
        assert (buf != null && buf.length > 0);
        assert (interactionMatrices != null && interactionMatrices.length == buf.length);
        assert (alphabets == null || alphabets.size() == buf.length);
        for (i = 0; i < buf.length; ++i) {
            this.randomizeSequence(buf[i]);
        }
        for (i = 0; i < interactionMatrices.length; ++i) {
            for (int j = i; j < interactionMatrices[i].length; ++j) {
                if (interactionMatrices[i][j].length != buf[i].length()) {
                    this.log.warning("" + i + " " + j + " " + interactionMatrices[i][j].length + " " + buf[i].length());
                }
                assert (interactionMatrices[i][j].length == buf[i].length());
                for (int k = 0; k < interactionMatrices[i][j].length; ++k) {
                    assert (interactionMatrices[i][j][k].length == buf[j].length());
                    for (int m = 0; m < interactionMatrices[i][j][k].length; ++m) {
                        if (interactionMatrices[i][j][k][m] != 1 || RnaSecondaryTools.isWatsonCrick(buf[i].charAt(k), buf[j].charAt(m))) continue;
                        if (Character.isUpperCase(buf[i].charAt(k)) && Character.isUpperCase(buf[j].charAt(m))) {
                            String randWC = this.generateRandomWatsonCrick();
                            assert (randWC != null);
                            if (alphabets != null) {
                                randWC = this.generateRandomWatsonCrick(alphabets.get(i), alphabets.get(j));
                                assert (randWC != null && randWC.length() == 2 && this.isInAlphabet(randWC.charAt(0), alphabets.get(i)) && this.isInAlphabet(randWC.charAt(1), alphabets.get(j)));
                            }
                            assert (randWC != null);
                            assert (randWC.length() == 2);
                            assert (buf != null);
                            assert (buf[i] != null);
                            assert (buf[j] != null);
                            if (randWC == null) {
                                System.out.println("Randwc is null! Internal error!");
                                assert (false);
                            }
                            char c1 = randWC.charAt(0);
                            char c2 = randWC.charAt(1);
                            StringBuffer buf1 = buf[i];
                            StringBuffer buf2 = buf[j];
                            buf1.setCharAt(k, c1);
                            buf2.setCharAt(m, c2);
                            continue;
                        }
                        if (Character.isUpperCase(buf[i].charAt(k))) {
                            buf[i].setCharAt(k, this.generateWatsonCrickPartner(buf[j].charAt(m)));
                            continue;
                        }
                        if (!Character.isUpperCase(buf[j].charAt(m))) continue;
                        buf[j].setCharAt(m, this.generateWatsonCrickPartner(buf[i].charAt(k)));
                    }
                }
            }
        }
    }

    private void randomizeSequences2Orig(StringBuffer[] buf, int[][][][] interactionMatrices, List<Alphabet> alphabets) {
        int i;
        assert (buf != null && buf.length > 0);
        assert (interactionMatrices != null && interactionMatrices.length == buf.length);
        assert (alphabets == null || alphabets.size() == buf.length);
        for (i = 0; i < buf.length; ++i) {
            this.randomizeSequence(buf[i]);
        }
        for (i = 0; i < interactionMatrices.length; ++i) {
            for (int j = i; j < interactionMatrices[i].length; ++j) {
                if (interactionMatrices[i][j].length != buf[i].length()) {
                    this.log.warning("" + i + " " + j + " " + interactionMatrices[i][j].length + " " + buf[i].length());
                }
                assert (interactionMatrices[i][j].length == buf[i].length());
                for (int k = 0; k < interactionMatrices[i][j].length; ++k) {
                    assert (interactionMatrices[i][j][k].length == buf[j].length());
                    for (int m = 0; m < interactionMatrices[i][j][k].length; ++m) {
                        if (!Character.isUpperCase(buf[i].charAt(k)) || !Character.isUpperCase(buf[j].charAt(m)) || interactionMatrices[i][j][k][m] != 1) continue;
                        String randWC = this.generateRandomWatsonCrick();
                        assert (randWC != null);
                        if (alphabets != null) {
                            randWC = this.generateRandomWatsonCrick(alphabets.get(i), alphabets.get(j));
                            assert (randWC != null && randWC.length() == 2 && this.isInAlphabet(randWC.charAt(0), alphabets.get(i)) && this.isInAlphabet(randWC.charAt(1), alphabets.get(j)));
                        }
                        assert (randWC != null);
                        assert (randWC.length() == 2);
                        assert (buf != null);
                        assert (buf[i] != null);
                        assert (buf[j] != null);
                        if (randWC == null) {
                            System.out.println("Randwc is null! Internal error!");
                            assert (false);
                        }
                        char c1 = randWC.charAt(0);
                        char c2 = randWC.charAt(1);
                        StringBuffer buf1 = buf[i];
                        StringBuffer buf2 = buf[j];
                        buf1.setCharAt(k, c1);
                        buf2.setCharAt(m, c2);
                    }
                }
            }
        }
    }

    private String generateSequencesOutputString(StringBuffer[] bufs) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bufs.length; ++i) {
            result.append(bufs[i]);
            result.append(PackageConstants.NEWLINE);
        }
        return result.toString();
    }

    private Mutation generateMutation(StringBuffer[] bseqs, List<Alphabet> alphabets) {
        Alphabet currAlph;
        int seqId = 0;
        int pos = 0;
        char newChar = 'N';
        char oldChar = 'N';
        while (Character.isLowerCase(oldChar = (char)bseqs[seqId = this.rand.nextInt(bseqs.length)].charAt(pos = this.rand.nextInt(bseqs[seqId].length())))) {
        }
        do {
            currAlph = this.alphabet;
            if (alphabets == null) continue;
            currAlph = alphabets.get(seqId);
        } while ((newChar = (char)currAlph.getSymbol(this.rand.nextInt(currAlph.size())).getCharacter()) == oldChar);
        assert (Character.isUpperCase(bseqs[seqId].charAt(pos)));
        return new Mutation(seqId, pos, newChar);
    }

    private char generateWatsonCrickPartner(char c) {
        c = Character.toUpperCase(c);
        switch (c) {
            case 'A': {
                return 'U';
            }
            case 'C': {
                return 'G';
            }
            case 'G': {
                return 'C';
            }
            case 'U': {
                return 'A';
            }
        }
        assert (false);
        return 'N';
    }

    Mutation findMatchingMutation(Mutation mutation, int[][][][] interactionMatrices, StringBuffer[] bseqs, List<Alphabet> alphabets) {
        int j;
        int i;
        assert (alphabets != null);
        int seqId = mutation.getSeqId();
        int pos = mutation.getPos();
        char c = mutation.getCharacter();
        char cPart = this.generateWatsonCrickPartner(c);
        for (i = 0; i <= seqId; ++i) {
            for (j = 0; j < interactionMatrices[i][seqId].length; ++j) {
                if (interactionMatrices[i][seqId][j][pos] != 1) continue;
                assert (alphabets != null);
                if (!alphabets.get(i).contains(cPart) || Character.isLowerCase(bseqs[i].charAt(j))) {
                    return new Mutation(-i - 1, j, cPart);
                }
                assert (Character.isUpperCase(bseqs[i].charAt(j)));
                return new Mutation(i, j, cPart);
            }
        }
        for (i = seqId + 1; i < interactionMatrices[seqId].length; ++i) {
            for (j = 0; j < interactionMatrices[seqId][i][pos].length; ++j) {
                if (interactionMatrices[seqId][i][pos][j] != 1) continue;
                assert (alphabets != null);
                if (!alphabets.get(i).contains(cPart) || Character.isLowerCase(bseqs[i].charAt(j))) {
                    return new Mutation(-i - 1, j, cPart);
                }
                assert (Character.isUpperCase(bseqs[i].charAt(j)));
                return new Mutation(i, j, cPart);
            }
        }
        return null;
    }

    private StringBuffer[] initStringBuffers2(SecondaryStructure structure, boolean randomizeFlag, int[][][][] interactionMatrices, List<Alphabet> alphabets) {
        StringBuffer[] bseqs = new StringBuffer[structure.getSequenceCount()];
        for (int i = 0; i < bseqs.length; ++i) {
            Sequence sequence = structure.getSequence(i);
            bseqs[i] = new StringBuffer(sequence.sequenceString());
            for (int j = 0; j < bseqs[i].length(); ++j) {
                Residue res = sequence.getResidue(j);
                if ("fragment".equals(res.getProperty("sequence_status"))) {
                    bseqs[i].setCharAt(j, Character.toLowerCase(bseqs[i].charAt(j)));
                    continue;
                }
                if ("adhoc".equals(res.getProperty("sequence_status"))) {
                    bseqs[i].setCharAt(j, Character.toUpperCase(bseqs[i].charAt(j)));
                    continue;
                }
                this.log.fine("Residue status unknown: " + bseqs[i] + " " + res.getSymbol() + " " + (i + 1) + " " + (j + 1) + " : setting for optimizable (adhoc)");
                bseqs[i].setCharAt(j, Character.toUpperCase(bseqs[i].charAt(j)));
            }
        }
        if (randomizeFlag) {
            this.log.info("Randomizing sequences (2)!");
            this.randomizeSequences2(bseqs, interactionMatrices, structure.getAlphabets());
        }
        return bseqs;
    }

    private void applyMutation(Mutation mutation, StringBuffer[] bseqs) {
        if (Character.isUpperCase(bseqs[mutation.getSeqId()].charAt(mutation.getPos()))) {
            bseqs[mutation.getSeqId()].setCharAt(mutation.getPos(), mutation.getCharacter());
        }
    }

    int[][] generateInteractionMatrix(SecondaryStructure structure, int id1, int id2) {
        int i;
        Sequence seq1 = structure.getSequence(id1);
        Sequence seq2 = structure.getSequence(id2);
        int[][] result = new int[seq1.size()][seq2.size()];
        for (i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = -1;
            }
        }
        for (i = 0; i < structure.getInteractionCount(); ++i) {
            Interaction interaction = structure.getInteraction(i);
            int pos1 = interaction.getResidue1().getPos();
            int pos2 = interaction.getResidue2().getPos();
            if (interaction.getSequence1() == seq1 && interaction.getSequence2() == seq2) {
                result[pos1][pos2] = interaction.getInteractionType().getSubTypeId();
                if (id1 != id2) continue;
                result[pos2][pos1] = result[pos1][pos2];
                continue;
            }
            if (interaction.getSequence2() != seq1 || interaction.getSequence1() != seq2) continue;
            result[pos2][pos1] = interaction.getInteractionType().getSubTypeId();
            assert (id1 != id2);
        }
        for (i = 0; i < result.length; ++i) {
            if (!"ignore".equals(seq1.getResidue(i).getProperty("seqstatus")) && (!this.ignoreNotConstantMode || !"fragment".equals(seq1.getResidue(i).getProperty("sequence_status")))) continue;
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = 0;
            }
        }
        for (i = 0; i < result[0].length; ++i) {
            if (!"ignore".equals(seq2.getResidue(i).getProperty("seqstatus")) && (!this.ignoreNotConstantMode || !"fragment".equals(seq2.getResidue(i).getProperty("sequence_status")))) continue;
            for (int j = 0; j < result.length; ++j) {
                result[j][i] = 0;
            }
        }
        return result;
    }

    int[][][][] generateInteractionMatrices(SecondaryStructure structure) {
        int[][][][] matrices = new int[structure.getSequenceCount()][structure.getSequenceCount()][0][0];
        for (int i = 0; i < structure.getSequenceCount(); ++i) {
            for (int j = i; j < structure.getSequenceCount(); ++j) {
                matrices[i][j] = this.generateInteractionMatrix(structure, i, j);
            }
        }
        return matrices;
    }

    private boolean sanityCheck(StringBuffer sb1, StringBuffer sb2, SecondaryStructure structure, int[][] interactionMatrices, int m, int n) {
        assert (interactionMatrices.length == sb1.length());
        assert (interactionMatrices[0].length == sb2.length());
        for (int i = 0; i < interactionMatrices.length; ++i) {
            for (int j = 0; j < interactionMatrices[0].length; ++j) {
                if (interactionMatrices[i][j] != 1 || RnaSecondaryTools.isWatsonCrick(sb1.charAt(i), sb2.charAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean sanityCheck(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        for (int i = 0; i < bseqs.length; ++i) {
            for (int j = i; j < bseqs.length; ++j) {
                if (this.sanityCheck(bseqs[i], bseqs[j], structure, interactionMatrices[i][j], i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean sanityCheckSlow(String[] seqs, SecondaryStructure structure) {
        System.out.println("sanityCheckSlow");
        int[][][][] interactionMatrices = this.generateInteractionMatrices(structure);
        StringBuffer[] bseqs = new StringBuffer[seqs.length];
        for (int i = 0; i < bseqs.length; ++i) {
            System.out.println("seqs[i]");
            bseqs[i] = new StringBuffer(seqs[i]);
        }
        System.out.println("Structure: " + ((Object)structure).toString());
        return this.sanityCheck(bseqs, structure, interactionMatrices);
    }

    private double optimizationTrial(StringBuffer[] bseqs, SecondaryStructure structure, double oldScore, int[][][][] interactionMatrices, boolean finalMode, List<Alphabet> alphabets) {
        this.log.finest("Starting optimizationTrial: " + oldScore);
        assert (alphabets != null);
        if (this.doSanityChecks) assert (this.sanityCheck(bseqs, structure, interactionMatrices));
        Mutation mutation = null;
        Mutation mutation2 = null;
        while ((mutation2 = this.findMatchingMutation(mutation = this.generateMutation(bseqs, alphabets), interactionMatrices, bseqs, alphabets)) != null && mutation2.getSeqId() < 0 || !structure.isActive(mutation.getSeqId())) {
        }
        boolean count = false;
        char oldCharacter = bseqs[mutation.getSeqId()].charAt(mutation.getPos());
        char oldCharacter2 = 'X';
        this.applyMutation(mutation, bseqs);
        if (mutation2 != null) {
            oldCharacter2 = bseqs[mutation2.getSeqId()].charAt(mutation2.getPos());
            this.applyMutation(mutation2, bseqs);
        }
        boolean undo = false;
        double newScore = oldScore;
        if (this.doSanityChecks && !this.sanityCheck(bseqs, structure, interactionMatrices)) {
            this.log.severe("Sanity check after sequence mutation failed!: " + PackageConstants.NEWLINE + this.generateSequencesOutputString(bseqs));
            assert (false);
        }
        newScore = this.defaultScorer.scoreStructure(bseqs, structure, interactionMatrices);
        if (this.constraintScorer != null) {
            double constraintScore = this.constraintScorer.scoreStructure(bseqs, structure, interactionMatrices);
            newScore += constraintScore;
        }
        if (finalMode) {
            double newScore2 = this.finalScorer.scoreStructure(bseqs, structure, interactionMatrices);
            newScore += this.finalScoreWeight * newScore2;
        }
        this.log.fine("new score: " + newScore);
        if (Math.exp(-(newScore - oldScore) / this.kt) < this.rand.nextDouble()) {
            undo = true;
        } else if (newScore < oldScore) {
            this.log.finest("New score accepted: " + newScore + " " + oldScore);
        }
        if (undo) {
            mutation.setCharacter(oldCharacter);
            this.applyMutation(mutation, bseqs);
            if (mutation2 != null) {
                mutation2.setCharacter(oldCharacter2);
                this.applyMutation(mutation2, bseqs);
            }
            newScore = oldScore;
        }
        if (this.doSanityChecks) assert (this.sanityCheck(bseqs, structure, interactionMatrices));
        this.log.finest("Finished optimizationTrial!");
        return newScore;
    }

    private double optimizationSystematicTrial(StringBuffer[] bseqs, SecondaryStructure structure, double oldScore, int[][][][] interactionMatrices, boolean finalMode, List<Alphabet> alphabets, int[] iterators) {
        this.log.finest("Starting optimizationTrial: " + oldScore);
        assert (alphabets != null);
        if (this.doSanityChecks) assert (this.sanityCheck(bseqs, structure, interactionMatrices));
        assert (iterators.length == 1);
        int trialIter = iterators[0];
        Mutation mutation = null;
        Mutation mutation2 = null;
        while ((mutation2 = this.findMatchingMutation(mutation = this.generateMutation(bseqs, alphabets), interactionMatrices, bseqs, alphabets)) != null && mutation2.getSeqId() < 0 || !structure.isActive(mutation.getSeqId())) {
        }
        boolean count = false;
        char oldCharacter = bseqs[mutation.getSeqId()].charAt(mutation.getPos());
        char oldCharacter2 = 'X';
        this.applyMutation(mutation, bseqs);
        if (mutation2 != null) {
            oldCharacter2 = bseqs[mutation2.getSeqId()].charAt(mutation2.getPos());
            this.applyMutation(mutation2, bseqs);
        } else {
            this.log.fine("No matching mutation found");
        }
        boolean undo = false;
        double newScore = oldScore;
        if (this.doSanityChecks && !this.sanityCheck(bseqs, structure, interactionMatrices)) {
            this.log.severe("Sanity check after sequence mutation failed!: " + PackageConstants.NEWLINE + this.generateSequencesOutputString(bseqs));
            assert (false);
        }
        newScore = this.defaultScorer.scoreStructure(bseqs, structure, interactionMatrices);
        if (this.constraintScorer != null) {
            double constraintScore = this.constraintScorer.scoreStructure(bseqs, structure, interactionMatrices);
            newScore += constraintScore;
        }
        if (finalMode) {
            double newScore2 = this.finalScorer.scoreStructure(bseqs, structure, interactionMatrices);
            newScore += this.finalScoreWeight * newScore2;
        }
        this.log.fine("new score: " + newScore);
        if (Math.exp(-(newScore - oldScore) / this.kt) < this.rand.nextDouble()) {
            undo = true;
        } else if (newScore < oldScore) {
            this.log.finest("New score accepted: " + newScore + " " + oldScore);
        }
        if (undo) {
            mutation.setCharacter(oldCharacter);
            this.applyMutation(mutation, bseqs);
            if (mutation2 != null) {
                mutation2.setCharacter(oldCharacter2);
                this.applyMutation(mutation2, bseqs);
            }
            newScore = oldScore;
        }
        if (this.doSanityChecks) assert (this.sanityCheck(bseqs, structure, interactionMatrices));
        this.log.finest("Finished optimizationTrial!");
        return newScore;
    }

    boolean hasUpperCaseCharacters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    boolean hasUpperCaseCharacters(StringBuffer[] bseqs) {
        for (int i = 0; i < bseqs.length; ++i) {
            if (!this.hasUpperCaseCharacters(bseqs[i].toString())) continue;
            return true;
        }
        return false;
    }

    private StringBuffer[] cloneBuffers(StringBuffer[] bufs) {
        assert (bufs != null);
        StringBuffer[] result = new StringBuffer[bufs.length];
        for (int i = 0; i < bufs.length; ++i) {
            result[i] = new StringBuffer(bufs[i].toString());
        }
        return result;
    }

    public String[] optimize2Stage(SecondaryStructure structure) {
        assert (this.finalScorer != null);
        assert (structure.getAlphabets() != null);
        assert (this.defaultScorer != null);
        this.log.info("Starting MonteCarloSequenceOptimizer.optimize !");
        int rerunCount = 0;
        int[][][][] interactionMatrices = this.generateInteractionMatrices(structure);
        double errorScoreTotBest = 99999.0;
        double errorScoreBest = 1.0E10;
        this.constraintScorer = new SequenceConstraintScorer(structure);
        System.out.println("Defined sequence constraints: " + this.constraintScorer.toString());
        StringBuffer[] bseqsFinal = null;
        block2: do {
            StringBuffer[] bseqs;
            double errorScore;
            if ((errorScore = this.defaultScorer.scoreStructure(bseqs = this.initStringBuffers2(structure, this.randomizeFlag, interactionMatrices, structure.getAlphabets()), structure, interactionMatrices) + this.constraintScorer.scoreStructure(bseqs, structure, interactionMatrices)) < errorScoreBest) {
                errorScoreBest = errorScore;
            }
            this.log.info("Starting optimization run " + (rerunCount + 1) + " with score : " + errorScore + " and sequences: " + PackageConstants.NEWLINE + this.generateSequencesOutputString(bseqs));
            if (!this.hasUpperCaseCharacters(bseqs)) {
                this.log.warning("No residue can be optimized because they are all in lower case characters!");
                break;
            }
            int stage1Steps = 0;
            int stage2Steps = 0;
            int i = 0;
            while (i < this.iterMax && errorScore > 0.0) {
                if (!this.sanityCheck(bseqs, structure, interactionMatrices)) {
                    this.log.log(this.debugLogLevel, "Not all base pairs are yet compatible!");
                }
                assert (structure.getAlphabets() != null);
                errorScore = this.optimizationTrial(bseqs, structure, errorScore, interactionMatrices, false, structure.getAlphabets());
                if (this.doSanityChecks) {
                    this.sanityCheck(bseqs, structure, interactionMatrices);
                }
                if (i % this.stride1 == 0 || errorScore < errorScoreBest) {
                    System.out.println("Round " + (rerunCount + 1) + " : Sequences at stage 1 iteration " + (i + 1) + " and score: " + errorScore + " so far best: " + errorScoreBest);
                    System.out.println(this.generateSequencesOutputString(bseqs));
                    PropertyTools.printProperties(System.out, this.defaultScorer.generateReport(bseqs, structure, interactionMatrices));
                }
                if (errorScore < errorScoreBest) {
                    errorScoreBest = errorScore;
                    this.log.info("New best sequence optimization (stage 1) score found at run " + (rerunCount + 1) + " and iteration " + (i + 1) + " " + errorScoreBest);
                }
                if (errorScore <= this.errorScoreLimit || i >= this.iterMax - 1) {
                    double errorScore2 = this.finalScorer.scoreStructure(bseqs, structure, interactionMatrices);
                    double errorScoreTot = errorScore + this.finalScoreWeight * errorScore2;
                    this.log.info("Starting stage 2 of sequence optimization with error score:" + errorScore + " " + errorScore2 + " " + errorScoreTot);
                    int i2 = 0;
                    while (i2 < this.iter2Max) {
                        if (this.doSanityChecks) assert (this.sanityCheck(bseqs, structure, interactionMatrices));
                        errorScoreTot = this.optimizationTrial(bseqs, structure, errorScoreTot, interactionMatrices, true, structure.getAlphabets());
                        if (this.doSanityChecks) assert (this.sanityCheck(bseqs, structure, interactionMatrices));
                        if (errorScoreTot < errorScoreTotBest || i2 % this.stride2 == 0) {
                            System.out.println("Round " + (rerunCount + 1) + " : Sequences at stage 2 iteration " + (i2 + 1) + " and score: " + errorScoreTot + " so far best: " + errorScoreTotBest);
                            System.out.println(this.generateSequencesOutputString(bseqs));
                        }
                        if (errorScoreTot < errorScoreTotBest) {
                            this.log.info("Found new best sequences (stage 2) with score: " + errorScoreTot + " at outer iteration " + (i + 1) + " and inner iteration: " + (i2 + 1));
                            errorScoreTotBest = errorScoreTot;
                            bseqsFinal = this.cloneBuffers(bseqs);
                            if (errorScoreTot < this.errorScoreLimit2) {
                                System.out.println("Overall optimization goal of score " + this.errorScoreLimit2 + " achieved, quitting optimization loop!");
                                break block2;
                            }
                        }
                        ++i2;
                        ++stage2Steps;
                    }
                    break;
                }
                ++i;
                ++stage1Steps;
            }
            this.log.info("Ended optimization run after round " + (rerunCount + 1) + " steps " + stage1Steps + " " + stage2Steps + " with strings: " + PackageConstants.NEWLINE + this.generateSequencesOutputString(bseqs));
        } while (++rerunCount < this.rerun);
        if (bseqsFinal == null) {
            this.log.warning("Sorry, no sequences that fullfill all optimization criteria found!");
            return null;
        }
        String[] result = new String[bseqsFinal.length];
        this.log.info("Best error score of all runs: " + errorScoreBest);
        this.log.info("Best error score 2 of all runs: " + errorScoreTotBest);
        this.setProperty("best_score", "" + errorScoreBest);
        this.setProperty("best_score2", "" + errorScoreTotBest);
        this.log.info("Final strings: " + PackageConstants.NEWLINE + this.generateSequencesOutputString(bseqsFinal));
        for (int i = 0; i < bseqsFinal.length; ++i) {
            result[i] = bseqsFinal[i].toString();
        }
        Properties defScorerProps = this.defaultScorer.generateReport(bseqsFinal, structure, interactionMatrices);
        Properties finalScorerProps = this.finalScorer.generateReport(bseqsFinal, structure, interactionMatrices);
        this.mergeProperties(defScorerProps, "s1.");
        this.mergeProperties(finalScorerProps, "s2.");
        if (this.constraintScorer != null) {
            Properties constraintScorerProps = this.constraintScorer.generateReport(bseqsFinal, structure, interactionMatrices);
            this.mergeProperties(constraintScorerProps, "s3.");
        }
        try {
            double finalTotalScore = Double.parseDouble(defScorerProps.getProperty("score")) + this.finalScoreWeight * Double.parseDouble(finalScorerProps.getProperty("score"));
            if (this.getProperty("s3.score") != null) {
                finalTotalScore += Double.parseDouble(this.getProperty("s3.score"));
            }
            this.setProperty("total_score", "" + finalTotalScore);
        }
        catch (NumberFormatException nfe) {
            this.setProperty("total_score", "Internal error: could not add score components.");
        }
        this.log.info("Finished MonteCarloSequenceOptimizer.optimize !");
        return result;
    }

    public String[] optimizeSystematic(SecondaryStructure structure) {
        int i;
        assert (this.finalScorer != null);
        assert (structure.getAlphabets() != null);
        assert (this.defaultScorer != null);
        this.log.info("Starting MonteCarloSequenceOptimizer.optimize !");
        int rerunCount = 0;
        int[][][][] interactionMatrices = this.generateInteractionMatrices(structure);
        double errorScoreTotBest = 99999.0;
        double errorScoreBest = 1.0E10;
        this.constraintScorer = new SequenceConstraintScorer(structure);
        System.out.println("Defined sequence constraints: " + this.constraintScorer.toString());
        StringBuffer[] bseqsFinal = null;
        StringBuffer[] bseqs = this.initStringBuffers2(structure, this.randomizeFlag, interactionMatrices, structure.getAlphabets());
        double errorScore = this.defaultScorer.scoreStructure(bseqs, structure, interactionMatrices) + this.constraintScorer.scoreStructure(bseqs, structure, interactionMatrices);
        if (errorScore < errorScoreBest) {
            errorScoreBest = errorScore;
        }
        this.log.info("Starting optimization run " + (rerunCount + 1) + " with score : " + errorScore + " and sequences: " + PackageConstants.NEWLINE + this.generateSequencesOutputString(bseqs));
        if (!this.hasUpperCaseCharacters(bseqs)) {
            this.log.warning("No residue can be optimized because they are all in lower case characters!");
            return null;
        }
        int stage1Steps = 0;
        int stage2Steps = 0;
        int trialMax = 0;
        for (i = 0; i < bseqs.length; ++i) {
            trialMax += bseqs[i].length();
        }
        i = 0;
        while (i < this.iterMax && errorScore > 0.0) {
            int trialIter = 0;
            int[] trialIters = new int[]{trialIter};
            while (trialIter < trialMax) {
                if (!this.sanityCheck(bseqs, structure, interactionMatrices)) {
                    this.log.log(this.debugLogLevel, "Not all base pairs are yet compatible!");
                }
                assert (structure.getAlphabets() != null);
                errorScore = this.optimizationSystematicTrial(bseqs, structure, errorScore, interactionMatrices, false, structure.getAlphabets(), trialIters);
                if (this.doSanityChecks) {
                    this.sanityCheck(bseqs, structure, interactionMatrices);
                }
                if (i % this.stride1 == 0 || errorScore < errorScoreBest) {
                    System.out.println("Round " + (rerunCount + 1) + " : Sequences at stage 1 iteration " + (i + 1) + " and score: " + errorScore + " so far best: " + errorScoreBest);
                    System.out.println(this.generateSequencesOutputString(bseqs));
                    PropertyTools.printProperties(System.out, this.defaultScorer.generateReport(bseqs, structure, interactionMatrices));
                }
                if (!(errorScore < errorScoreBest)) continue;
                errorScoreBest = errorScore;
                this.log.info("New best sequence optimization (stage 1) score found at run " + (rerunCount + 1) + " and iteration " + (i + 1) + " " + errorScoreBest);
                bseqsFinal = this.cloneBuffers(bseqs);
            }
            ++i;
            ++stage1Steps;
        }
        this.log.info("Ended optimization run after steps " + stage1Steps + " " + stage2Steps + " with strings: " + PackageConstants.NEWLINE + this.generateSequencesOutputString(bseqs));
        if (bseqsFinal == null) {
            this.log.warning("Sorry, no sequences that fullfill all optimization criteria found!");
            return null;
        }
        String[] result = new String[bseqsFinal.length];
        this.log.info("Best error score of all runs: " + errorScoreBest);
        this.log.info("Best error score 2 of all runs: " + errorScoreTotBest);
        this.setProperty("best_score", "" + errorScoreBest);
        this.setProperty("best_score2", "" + errorScoreBest);
        this.log.info("Final strings: " + PackageConstants.NEWLINE + this.generateSequencesOutputString(bseqsFinal));
        for (int i2 = 0; i2 < bseqsFinal.length; ++i2) {
            result[i2] = bseqsFinal[i2].toString();
        }
        Properties defScorerProps = this.defaultScorer.generateReport(bseqsFinal, structure, interactionMatrices);
        Properties finalScorerProps = this.finalScorer.generateReport(bseqsFinal, structure, interactionMatrices);
        this.mergeProperties(defScorerProps, "s1.");
        this.mergeProperties(finalScorerProps, "s2.");
        if (this.constraintScorer != null) {
            Properties constraintScorerProps = this.constraintScorer.generateReport(bseqsFinal, structure, interactionMatrices);
            this.mergeProperties(constraintScorerProps, "s3.");
        }
        this.log.info("Finished MonteCarloSequenceOptimizer.optimize !");
        return result;
    }

    @Override
    public String[] optimize(SecondaryStructure structure) {
        SecondaryStructureScriptFormatWriter writer = new SecondaryStructureScriptFormatWriter();
        System.out.println("Starting sequence optimization with algorithm " + this.algorithm + " and structure:");
        System.out.println(writer.writeString(structure));
        if (this.algorithm.equals("twostage")) {
            return this.optimize2Stage(structure);
        }
        if (this.algorithm.equals("systematic")) {
            return this.optimizeSystematic(structure);
        }
        this.log.warning("Unknown optimization algorithm! Defined: twostage");
        return null;
    }

    @Override
    public void setRandomizeFlag(boolean flag) {
        this.randomizeFlag = flag;
    }

    private class Mutation {
        private int seqId;
        private int pos;
        private char character;

        public Mutation(int seqId, int pos, char character) {
            this.seqId = seqId;
            this.pos = pos;
            this.character = character;
        }

        public int getPos() {
            return this.pos;
        }

        public char getCharacter() {
            return this.character;
        }

        public int getSeqId() {
            return this.seqId;
        }

        public void setCharacter(char c) {
            this.character = c;
        }

        public String toString() {
            return "" + (this.seqId + 1) + " " + (this.pos + 1) + " " + this.character;
        }
    }
}

