/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import java.util.ArrayList;
import java.util.Properties;
import rnasecondary.SecondaryStructure;
import secondarystructuredesign.SecondaryStructureScorer;

public class SequenceConstraintScorer
implements SecondaryStructureScorer {
    private double penalty = 1000.0;
    private ArrayList<SequenceConstraint> constraints = new ArrayList();

    public SequenceConstraintScorer(SecondaryStructure structure) {
        for (int i = 0; i < structure.getSequenceCount(); ++i) {
            String s = structure.getSequence(i).sequenceString();
            for (int j = 0; j < s.length(); ++j) {
                if (s.charAt(j) != 'W' && s.charAt(j) != 'S') continue;
                this.constraints.add(new SequenceConstraint(i, j, s.charAt(j)));
            }
        }
    }

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        String scoreString = this.generateReport(bseqs, structure, interactionMatrices, 0).getProperty("score");
        assert (scoreString != null);
        return Double.parseDouble(scoreString);
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        return this.generateReport(bseqs, structure, interactionMatrices, 10);
    }

    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices, int verbosity) {
        Properties resultProperties = new Properties();
        double result = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.constraints.get(i).isValid(bseqs)) continue;
            result += this.penalty;
        }
        resultProperties.setProperty("score", "" + result);
        return resultProperties;
    }

    public int size() {
        return this.constraints.size();
    }

    public String toString() {
        String result = "(SequenceConstraintScorer " + this.size() + " ";
        for (int i = 0; i < this.size(); ++i) {
            result = result + this.constraints.get(i).toString() + " ";
        }
        result = result + ")";
        return result;
    }

    private class SequenceConstraint {
        int seqId;
        int id;
        char constraint;

        SequenceConstraint(int _seqId, int _id, char _constraint) {
            this.seqId = _seqId;
            this.id = _id;
            this.constraint = _constraint;
        }

        boolean isValid(char base) {
            return this.isValid(base, this.constraint);
        }

        boolean isValid(String sequence) {
            return this.isValid(sequence.charAt(this.id), this.constraint);
        }

        boolean isValid(String[] sequences) {
            return this.isValid(sequences[this.seqId].charAt(this.id), this.constraint);
        }

        boolean isValid(StringBuffer[] sequences) {
            return this.isValid(sequences[this.seqId].charAt(this.id), this.constraint);
        }

        boolean isValid(char base, char constraint) {
            switch (constraint) {
                case 'S': {
                    return base == 'G' || base == 'C';
                }
                case 'W': {
                    return base == 'A' || base == 'U';
                }
            }
            assert (false);
            return false;
        }

        public String toString() {
            return "" + (this.seqId + 1) + " " + (this.id + 1) + " " + this.constraint;
        }
    }
}

