/*
 * Decompiled with CFR 0.152.
 */
package sequence;

import java.io.InputStream;
import java.util.Properties;
import sequence.LetterSymbol;
import sequence.Residue;

public class SimpleResidue
implements Residue {
    private LetterSymbol symbol;
    private int pos;
    private int assignedNumber;
    private String assignedName = "";
    private Object parentObject;
    private Properties properties;

    public SimpleResidue(LetterSymbol symbol, Object parentObject, int pos) {
        this.symbol = symbol;
        this.parentObject = parentObject;
        this.pos = pos;
        this.assignedNumber = 0;
    }

    @Override
    public Object cloneDeep() {
        SimpleResidue residue = new SimpleResidue(this.symbol, this.parentObject, this.pos);
        residue.setAssignedNumber(this.assignedNumber);
        residue.setAssignedName(new String(this.assignedName));
        return residue;
    }

    @Override
    public String getAssignedName() {
        return this.assignedName;
    }

    @Override
    public int getAssignedNumber() {
        return this.assignedNumber;
    }

    @Override
    public LetterSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public Object getParentObject() {
        return this.parentObject;
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    @Override
    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean isSameSequence(Residue other) {
        return this.getParentObject() != null && this.getParentObject() == other.getParentObject();
    }

    @Override
    public void read(InputStream is) {
        assert (false);
    }

    @Override
    public void setAssignedNumber(int number) {
        this.assignedNumber = number;
    }

    @Override
    public void setAssignedName(String name) {
        this.assignedName = name;
    }

    @Override
    public void setPos(int pos) {
        this.pos = pos;
    }

    @Override
    public void setProperties(Properties prop) {
        this.properties = prop;
    }

    @Override
    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
    }

    @Override
    public void setParentObject(Object parentObject) {
        this.parentObject = parentObject;
    }

    @Override
    public void setSymbol(LetterSymbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public String infoString() {
        return this.toString();
    }

    public String toString() {
        String s = new String(this.symbol.toString() + " " + this.pos);
        return s;
    }
}

