/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import tools3d.Matrix3D;
import tools3d.Vector3D;

public class OrientationTools {
    public static final double MIN_EIGENVALUE = 0.01;

    public static Vector3D computeCenterOfGravity(Vector3D[] mol) {
        Vector3D result = new Vector3D();
        for (Vector3D v : mol) {
            result.add(v);
        }
        if (mol.length > 0) {
            result.scale(1.0 / (double)mol.length);
        }
        return result;
    }

    public static Matrix3D computeInertiaTensor(Vector3D[] v, double[] weights) {
        assert (v != null && (weights == null || weights.length == v.length));
        Matrix3D m = new Matrix3D();
        Matrix3D unitMatrix = new Matrix3D(1.0, 1.0, 1.0);
        for (int i = 0; i < v.length; ++i) {
            Matrix3D tmpMatrix = unitMatrix.multiply(v[i].dot(v[i])).minus(Matrix3D.outerProduct(v[i], v[i]));
            if (weights != null) {
                tmpMatrix.scale(weights[i]);
            }
            m.add(tmpMatrix);
        }
        return m;
    }

    public static EigenvalueDecomposition computeGyrationGeometry(Vector3D[] v, double[] weights) {
        assert (v != null && (weights == null || v.length == weights.length));
        Matrix3D inertiaTensor = OrientationTools.computeInertiaTensor(v, weights);
        Matrix inertiaMatrix = new Matrix(inertiaTensor.toArray());
        return new EigenvalueDecomposition(inertiaMatrix);
    }

    private static boolean hasPrecedence(double[] v1, double[] v2) {
        int i = 0;
        while (i < v1.length && i < v2.length) {
            if (v1[i] > v2[i]) {
                return true;
            }
            if (!(v1[i] < v2[i])) continue;
            return false;
        }
        return v1.length > v2.length;
    }

    public static Vector3D[] computeNormalizedOrientation(Vector3D[] mol, double[] weights) {
        assert (mol != null && (weights == null || mol.length == weights.length));
        if (mol.length < 3) {
            return null;
        }
        Vector3D origin = OrientationTools.computeCenterOfGravity(mol);
        Vector3D x1 = new Vector3D(1.0, 0.0, 0.0);
        Vector3D x2 = new Vector3D(0.0, 1.0, 0.0);
        assert (mol.length >= 3);
        EigenvalueDecomposition eigen = OrientationTools.computeGyrationGeometry(mol, weights);
        double[] eigenValues = eigen.getRealEigenvalues();
        double[][] eigenVectors = eigen.getV().getArray();
        for (int i = 0; i < 3; ++i) {
            if (!(eigenValues[i] < 0.01)) continue;
            eigenValues[i] = 0.01;
        }
        int best = 0;
        int second = 1;
        int third = 2;
        assert (best != second);
        assert (best != third);
        assert (second != third);
        x1 = new Vector3D(eigenVectors[best][0], eigenVectors[best][1], eigenVectors[best][2]);
        x2 = new Vector3D(eigenVectors[second][0], eigenVectors[second][1], eigenVectors[second][2]);
        Vector3D[] result = new Vector3D[]{origin, x1, x2};
        assert (Math.abs(result[1].dot(result[2])) < 0.01);
        return result;
    }
}

