/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.util.Properties;
import tools3d.Appearance;
import tools3d.CoordinateSystem;
import tools3d.Edge3D;
import tools3d.Face3D;
import tools3d.Geometry;
import tools3d.Matrix3D;
import tools3d.Point3D;
import tools3d.Positionable3D;
import tools3d.Shape3D;
import tools3d.Shape3DActor;
import tools3d.StandardGeometry;
import tools3d.Vector3D;

public class SimpleShape3D
implements Shape3D {
    private Appearance appearance;
    private boolean geometryUpToDate = false;
    private boolean selected = false;
    private int number = 0;
    private int typeId = 0;
    private double boundingRadius;
    private Properties properties = new Properties();
    private Shape3DActor actor = null;
    private String className = "Object3D";
    protected Geometry geometry;
    private String name;
    private Vector3D dimensions;
    private Vector3D relativePosition;
    private Vector3D scaling;
    private Vector3D rotationAxis;
    private double rotationAngle = 0.0;
    double zBufValue = 0.0;

    public SimpleShape3D() {
        this.appearance = new Appearance();
        this.name = new String();
        this.relativePosition = new Vector3D(0.0, 0.0, 0.0);
        this.scaling = new Vector3D(1.0, 1.0, 1.0);
        this.rotationAxis = new Vector3D(1.0, 0.0, 0.0);
    }

    @Override
    public void act() {
        if (this.actor != null) {
            this.actor.act(this);
        }
    }

    @Override
    public void activeTransform(CoordinateSystem cs) {
        assert (false);
    }

    @Override
    public void passiveTransform(CoordinateSystem cs) {
        assert (false);
    }

    @Override
    public int compareTo(Positionable3D o) {
        double oVal = o.getZBufValue();
        if (this.zBufValue < oVal) {
            return -1;
        }
        if (this.zBufValue > oVal) {
            return 1;
        }
        return 0;
    }

    @Override
    public Geometry createGeometry(double angleDelta) {
        if (this.geometry != null) {
            return this.geometry;
        }
        Point3D[] points = new Point3D[]{new Point3D(this.getPosition())};
        Edge3D[] edges = new Edge3D[]{};
        Face3D[] faces = new Face3D[]{};
        this.geometry = new StandardGeometry(points, edges, faces);
        return this.geometry;
    }

    @Override
    public double distance(Positionable3D other) {
        return this.getPosition().minus(other.getPosition()).length();
    }

    @Override
    public Shape3DActor getActor() {
        return this.actor;
    }

    @Override
    public Appearance getAppearance() {
        return this.appearance;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public Vector3D getDimensions() {
        return this.dimensions;
    }

    void setGeometry(Geometry geometry) {
        this.geometry = geometry;
        this.geometryUpToDate = true;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getShapeName() {
        return "SimpleShape3D";
    }

    @Override
    public double getZBufValue() {
        return this.zBufValue;
    }

    protected boolean isGeometryUpToDate() {
        return this.geometryUpToDate;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean isValid() {
        return this.getPosition().isValid();
    }

    @Override
    public void setSelected(boolean f) {
        this.selected = f;
    }

    @Override
    public Object cloneDeep() {
        assert (false);
        return null;
    }

    @Override
    public Vector3D getPosition() {
        return this.relativePosition;
    }

    @Override
    public Vector3D getRotationAxis() {
        return this.rotationAxis;
    }

    @Override
    public double getRotationAngle() {
        return this.rotationAngle;
    }

    @Override
    public Vector3D getScalingFactor() {
        return this.scaling;
    }

    @Override
    public double getBoundingRadius() {
        return this.boundingRadius;
    }

    public void clear() {
        this.number = 0;
        this.typeId = 0;
        this.boundingRadius = 1.0;
        this.name = "";
        this.relativePosition.mul(0.0);
        this.scaling = new Vector3D(1.0, 1.0, 1.0);
        this.rotationAxis = new Vector3D(1.0, 1.0, 1.0);
        this.rotationAngle = 0.0;
        this.properties = null;
    }

    @Override
    public void setActor(Shape3DActor actor) {
        this.actor = actor;
    }

    @Override
    public void setAppearance(Appearance appearance) {
        this.appearance = appearance;
    }

    protected void setGeometryUpToDate(boolean b) {
        this.geometryUpToDate = b;
    }

    @Override
    public void setDimensions(Vector3D d) {
        this.dimensions = d;
    }

    @Override
    public void setPosition(Vector3D point) {
        this.relativePosition = point;
        this.geometryUpToDate = false;
    }

    @Override
    public void setRotationAngle(double angle) {
        this.rotationAngle = angle;
    }

    @Override
    public void setRotationAxis(Vector3D axis) {
        this.rotationAxis = axis;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void rotate(Vector3D axis, double angle) {
        this.geometryUpToDate = false;
    }

    @Override
    public void rotate(Vector3D center, Vector3D axis, double angle) {
        this.geometryUpToDate = false;
    }

    @Override
    public void rotate(Vector3D center, Matrix3D rotationMatrix) {
        assert (false);
        this.geometryUpToDate = false;
    }

    @Override
    public void translate(Vector3D vec) {
        this.relativePosition.add(vec);
        this.geometryUpToDate = false;
    }

    @Override
    public void scale(Vector3D factor) {
        this.scaling.copy(factor);
        this.geometryUpToDate = false;
    }

    @Override
    public void setBoundingRadius(double radius) {
        this.boundingRadius = radius;
        this.geometryUpToDate = false;
    }

    @Override
    public void setZBufValue(double d) {
        this.zBufValue = d;
    }

    public void copy(SimpleShape3D orig) {
    }

    public String toStringBody() {
        return "";
    }

    public String toString() {
        String result = new String();
        result = "(" + this.getClassName() + " " + this.toStringBody() + " )";
        return result;
    }
}

