/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.util.Properties;
import tools3d.Edge3D;
import tools3d.Face3D;
import tools3d.Geometry;
import tools3d.Point3D;
import tools3d.Vector3D;
import tools3d.ZBuffer;

public class StandardGeometry
implements Geometry {
    private Point3D[] points;
    private Edge3D[] edges;
    private Face3D[] faces;
    private Properties properties;
    private boolean selected = false;

    public StandardGeometry() {
        this.points = new Point3D[0];
        this.edges = new Edge3D[0];
        this.faces = new Face3D[0];
    }

    public StandardGeometry(Point3D[] points, Edge3D[] edges, Face3D[] faces) {
        this.points = points;
        this.edges = edges;
        this.faces = faces;
    }

    public StandardGeometry(Point3D[] points, Edge3D[] edges, Face3D[] faces, Properties properties) {
        this.points = points;
        this.edges = edges;
        this.faces = faces;
        this.setProperties(properties);
    }

    @Override
    public void addToZBuffer(ZBuffer zBuf) {
        int i;
        for (i = 0; i < this.points.length; ++i) {
            zBuf.add(this.points[i]);
        }
        for (i = 0; i < this.edges.length; ++i) {
            zBuf.add(this.edges[i]);
        }
        for (i = 0; i < this.faces.length; ++i) {
            zBuf.add(this.faces[i]);
        }
    }

    @Override
    public Edge3D getEdge(int n) {
        return this.edges[n];
    }

    @Override
    public int getNumberEdges() {
        return this.edges.length;
    }

    @Override
    public int getNumberPoints() {
        return this.points.length;
    }

    @Override
    public int getNumberFaces() {
        return this.faces.length;
    }

    @Override
    public Face3D getFace(int n) {
        return this.faces[n];
    }

    @Override
    public Point3D getPoint(int n) {
        return this.points[n];
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void merge(Geometry other) {
    }

    public static Geometry createSinglePointGeometry(Vector3D position) {
        Point3D[] points = new Point3D[]{new Point3D(position)};
        Edge3D[] edges = new Edge3D[]{};
        Face3D[] faces = new Face3D[]{};
        return new StandardGeometry(points, edges, faces);
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
        if (properties != null) {
            int i;
            for (i = 0; i < this.points.length; ++i) {
                this.points[i].setProperties(properties);
            }
            for (i = 0; i < this.edges.length; ++i) {
                this.edges[i].setProperties(properties);
            }
            for (i = 0; i < this.faces.length; ++i) {
                this.faces[i].setProperties(properties);
            }
        }
    }

    @Override
    public void setSelected(boolean b) {
        int i;
        this.selected = b;
        for (i = 0; i < this.points.length; ++i) {
            this.points[i].setSelected(b);
        }
        for (i = 0; i < this.edges.length; ++i) {
            this.edges[i].setSelected(b);
        }
        for (i = 0; i < this.faces.length; ++i) {
            this.faces[i].setSelected(b);
        }
    }

    @Override
    public int size() {
        return this.points.length + this.edges.length + this.faces.length;
    }
}

