/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.util.Vector;
import java.util.logging.Logger;
import org.testng.annotations.Test;
import tools3d.Junction;
import tools3d.PackageConstants;
import tools3d.Point;
import tools3d.SymmetryLink;

public class Symmetry {
    public static final int C2_SYMMETRY = 2;
    public static final int C3_SYMMETRY = 3;
    public static final int C4_SYMMETRY = 4;
    public static final int C5_SYMMETRY = 5;
    public static final int C6_SYMMETRY = 6;
    public static final int C7_SYMMETRY = 7;
    public static final int C8_SYMMETRY = 8;
    public static final String C2_SYMMETRY_STRING = "C2";
    public static final String C3_SYMMETRY_STRING = "C3";
    public static final String C4_SYMMETRY_STRING = "C4";
    public static final String C5_SYMMETRY_STRING = "C5";
    public static final String C6_SYMMETRY_STRING = "C6";
    public static final String C7_SYMMETRY_STRING = "C7";
    public static final String C8_SYMMETRY_STRING = "C8";
    private int type = 0;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private Point endPoint = new Point("END", 0.0, 0.0, 0.0);
    private Point startPoint = new Point("START", 0.0, 0.0, 0.0);
    private String name = "";
    private Vector<Junction> junctions = new Vector();
    private Vector<SymmetryLink> links = new Vector();

    public Symmetry() {
    }

    public Symmetry(String name) {
        this.setName(name);
    }

    public Symmetry(String name, int type) {
        this.setName(name);
        this.setType(type);
    }

    public Symmetry(String name, String type) {
        this.setName(name);
        this.setType(type);
    }

    public Symmetry(String name, int type, Point startPoint, Point endPoint) {
        this.setName(name);
        this.setType(type);
        this.setStartPoint(startPoint);
        this.setEndPoint(endPoint);
    }

    public Symmetry(String name, String type, Point startPoint, Point endPoint) {
        this.setName(name);
        this.setType(type);
        this.setStartPoint(startPoint);
        this.setEndPoint(endPoint);
    }

    public void addJunction(int i, Junction junction) {
        this.junctions.add(i, junction);
    }

    public void addJunction(Junction junction) {
        this.junctions.add(junction);
    }

    @Test
    public void testAddJunction() {
        Symmetry s = new Symmetry();
        Junction j = new Junction("testJunction");
        s.addJunction(0, j);
        assert (s.getJunction(0).equals(j));
        s = new Symmetry();
        s.addJunction(j);
        assert (s.getJunction(0).equals(j));
    }

    public void addLink(int i, SymmetryLink link) {
        this.links.add(i, link);
    }

    public void addLink(SymmetryLink link) {
        this.links.add(link);
    }

    @Test
    public void testAddLink() {
        Symmetry s = new Symmetry();
        SymmetryLink l = new SymmetryLink();
        this.addLink(0, l);
    }

    public Object cloneDeep() {
        Symmetry newSym = new Symmetry();
        newSym.copyDeepThisCore(this);
        assert (this.getNumJunctions() == newSym.getNumJunctions());
        return newSym;
    }

    @Test
    public void testCloneDeep() {
    }

    protected void copyDeepThisCore(Symmetry s) {
        this.setName(s.getName());
        if (s.getType() != 0) {
            this.setType(s.getType());
        }
        this.setStartPoint(s.getStartPoint());
        this.setEndPoint(s.getEndPoint());
        Vector<Junction> j = new Vector<Junction>();
        for (int i = 0; i < s.getNumJunctions(); ++i) {
            j.add((Junction)s.getJunction(i).cloneDeep());
        }
        this.junctions = j;
        Vector<SymmetryLink> l = new Vector<SymmetryLink>();
        for (int i = 0; i < s.getNumLinks(); ++i) {
            l.add((SymmetryLink)s.getLink(i).cloneDeep());
        }
        this.links = l;
    }

    public Point getCenterPoint(Junction j) {
        return j.getCenterPoint();
    }

    @Test
    public void testGetCenterPoint() {
    }

    public Point getEndPoint() {
        return this.endPoint;
    }

    @Test
    public void testGetEndPoint() {
    }

    public double getEndX() {
        return this.endPoint.getX();
    }

    @Test
    public void testGetEndX() {
    }

    public double getEndY() {
        return this.endPoint.getY();
    }

    @Test
    public void testGetEndY() {
    }

    public double getEndZ() {
        return this.endPoint.getZ();
    }

    @Test
    public void testGetEndZ() {
    }

    public Junction getJunction(int i) {
        return this.junctions.get(i);
    }

    public Junction getJunction(String junctionName) {
        for (int i = 0; i < this.getNumJunctions(); ++i) {
            if (!this.junctions.get(i).getName().equals(junctionName)) continue;
            return this.junctions.get(i);
        }
        return null;
    }

    @Test
    public void testGetJunction() {
    }

    public Vector<Junction> getJunctions() {
        return this.junctions;
    }

    @Test
    public void testGetJunctions() {
    }

    public SymmetryLink getLink(int i) {
        return this.links.get(i);
    }

    @Test
    public void testGetLink() {
    }

    public Vector<SymmetryLink> getLinks() {
        return this.links;
    }

    @Test
    public void testGetLinks() {
    }

    public String getName() {
        return this.name;
    }

    @Test
    public void testGetName() {
    }

    public int getNumJunctions() {
        return this.junctions.size();
    }

    @Test
    public void testGetNumJunctions() {
    }

    public int getNumLinks() {
        return this.links.size();
    }

    @Test
    public void testGetNumLinks() {
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    @Test
    public void testGetStartPoint() {
    }

    public double getStartX() {
        return this.startPoint.getX();
    }

    @Test
    public void testGetStartX() {
    }

    public double getStartY() {
        return this.startPoint.getY();
    }

    @Test
    public void testGetStartY() {
    }

    public double getStartZ() {
        return this.startPoint.getZ();
    }

    @Test
    public void testGetStartZ() {
    }

    public int getType() {
        return this.type;
    }

    @Test
    public void testGetType() {
    }

    public void setEndPoint(double x, double y, double z) {
        this.setEndX(x);
        this.setEndY(y);
        this.setEndZ(z);
    }

    public void setEndPoint(Point point) {
        this.endPoint = point;
    }

    @Test
    public void testSetEndPoint() {
    }

    public void setEndX(double x) {
        this.endPoint.setX(x);
    }

    @Test
    public void testSetEndX() {
    }

    public void setEndY(double y) {
        this.endPoint.setY(y);
    }

    @Test
    public void testSetEndY() {
    }

    public void setEndZ(double z) {
        this.endPoint.setZ(z);
    }

    @Test
    public void testSetEndZ() {
    }

    public void setName(String name) {
        this.name = name;
    }

    @Test
    public void testSetName() {
    }

    public void setStartPoint(Point point) {
        this.startPoint = point;
    }

    @Test
    public void testSetStartPoint() {
    }

    public void setStartX(double x) {
        this.startPoint.setX(x);
    }

    @Test
    public void testSetStartX() {
    }

    public void setStartY(double y) {
        this.startPoint.setY(y);
    }

    @Test
    public void testSetStartY() {
    }

    public void setStartZ(double z) {
        this.startPoint.setZ(z);
    }

    @Test
    public void testSetStartZ() {
    }

    public void setType(int i) {
        switch (i) {
            case 2: {
                this.type = 2;
                break;
            }
            case 3: {
                this.type = 3;
                break;
            }
            case 4: {
                this.type = 4;
                break;
            }
            case 5: {
                this.type = 5;
                break;
            }
            case 6: {
                this.type = 6;
                break;
            }
            case 7: {
                this.type = 7;
                break;
            }
            case 8: {
                this.type = 8;
                break;
            }
            default: {
                log.warning("Could not read type for int: " + i);
            }
        }
    }

    public void setType(String type) {
        if (type.toUpperCase().trim().equals(C2_SYMMETRY_STRING)) {
            this.type = 2;
        } else if (type.toUpperCase().trim().equals(C3_SYMMETRY_STRING)) {
            this.type = 3;
        } else if (type.toUpperCase().trim().equals(C4_SYMMETRY_STRING)) {
            this.type = 4;
        } else if (type.toUpperCase().trim().equals(C5_SYMMETRY_STRING)) {
            this.type = 5;
        } else if (type.toUpperCase().trim().equals(C6_SYMMETRY_STRING)) {
            this.type = 6;
        } else if (type.toUpperCase().trim().equals(C7_SYMMETRY_STRING)) {
            this.type = 7;
        } else if (type.toUpperCase().trim().equals(C8_SYMMETRY_STRING)) {
            this.type = 8;
        } else {
            log.warning("Error: Couldn't read type: " + type);
        }
    }

    @Test
    public void testSetType() {
    }

    public String toString() {
        int i;
        String s = new String("Symmetry " + this.name + " of type " + this.type + ";" + PackageConstants.NEWLINE + "Junctions:" + PackageConstants.NEWLINE);
        for (i = 0; i < this.getNumJunctions(); ++i) {
            s = s + this.getJunction(i) + PackageConstants.NEWLINE;
        }
        s = s + "Links:" + PackageConstants.NEWLINE;
        for (i = 0; i < this.getNumLinks(); ++i) {
            s = s + "   " + this.getLink(i) + PackageConstants.NEWLINE;
        }
        return s;
    }

    @Test
    public void testToString() {
    }
}

