/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DEmptyVisitor;
import tools3d.objects3d.Object3DSet;

public class SimpleObject3DSet
implements Object3DSet {
    private List<Object3D> objects = new ArrayList<Object3D>();
    private Properties properties = null;

    public SimpleObject3DSet() {
    }

    public SimpleObject3DSet(Object3D tree) {
        Object3DEmptyVisitor visitor = new Object3DEmptyVisitor(tree);
        while (visitor.hasNext()) {
            Object3D obj = (Object3D)visitor.next();
            this.add(obj);
        }
    }

    public SimpleObject3DSet(List<? extends Object3D> list) {
        for (Object3D object3D : list) {
            this.objects.add(object3D);
        }
    }

    @Override
    public void add(int i, Object3D object3d) {
        this.objects.add(i, object3d);
    }

    @Override
    public void add(Object3D object3d) {
        this.objects.add(object3d);
    }

    @Override
    public void clear() {
        this.objects.clear();
    }

    @Override
    public boolean contains(Object3D obj) {
        return this.objects.contains(obj);
    }

    @Override
    public List<Object3D> getAsList() {
        return this.objects;
    }

    @Override
    public List<Vector3D> getAsPositions() {
        ArrayList<Vector3D> positions = new ArrayList<Vector3D>();
        for (Object3D obj : this.objects) {
            positions.add(obj.getPosition());
        }
        return positions;
    }

    @Override
    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public int indexOf(Object3D obj) {
        return this.objects.indexOf(obj);
    }

    @Override
    public Object3D get(int n) throws IndexOutOfBoundsException {
        if (this.objects.get(n) == null) {
            return null;
        }
        return this.objects.get(n);
    }

    @Override
    public void merge(Object3DSet other) {
        if (other == null) {
            return;
        }
        for (int i = 0; i < other.size(); ++i) {
            this.add(other.get(i));
        }
    }

    @Override
    public void set(int n, Object3D obj) {
        assert (n < this.size());
        this.objects.set(n, obj);
    }

    @Override
    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    @Override
    public void remove(Object3D object3d) {
        this.objects.remove(object3d);
    }

    @Override
    public void removeExtras(Object3D objectTree) {
    }

    @Override
    public String toString() {
        String result = "(Object3DSet " + this.size() + " ";
        for (int i = 0; i < this.size(); ++i) {
            result = result + ((Object)this.get(i)).toString() + " ";
        }
        result = result + ")";
        return result;
    }
}

