/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d.modeling;

import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.modeling.ForceField;

public class GaussianRepulsionForceField
implements ForceField {
    @Override
    public double energy(Object3DSet objects, LinkSet links) {
        double result = 0.0;
        for (int i = 0; i < objects.size(); ++i) {
            for (int j = 0; j > i; ++j) {
                result += this.interactionEnergy(objects.get(i), objects.get(j));
            }
        }
        return result;
    }

    double interactionEnergy(Object3D o1, Object3D o2) {
        double result = 0.0;
        if (o1.getDepth() == o2.getDepth()) {
            double dist = o1.distance(o2);
            double r = o1.getBoundingRadius() + o2.getBoundingRadius();
            double term = dist / r;
            result = Math.exp(-term * term);
        }
        return result;
    }
}

