/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d.modeling;

import generaltools.DoubleFunctor;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.modeling.ForceFieldPairElement;

public class SimpleDistanceForceFieldPairElement
implements ForceFieldPairElement {
    private DoubleFunctor functor;
    private int linkNumberMax;
    private int linkNumberMin;
    private Object3D prototype;

    public SimpleDistanceForceFieldPairElement(Object3D prototype, DoubleFunctor functor, int linkNumberMin, int linkNumberMax) {
        this.prototype = prototype;
        this.functor = functor;
        this.linkNumberMin = linkNumberMin;
        this.linkNumberMax = linkNumberMax;
    }

    @Override
    public double pairEnergy(Object3D obj1, Object3D obj2, LinkSet links) {
        if (this.handles(obj1, obj2, links)) {
            double dist = obj1.distance(obj2);
            return this.functor.doubleFunc(dist);
        }
        return 0.0;
    }

    private boolean handlesLinkNumberMax(int linkNumber) {
        if (this.linkNumberMax <= 0) {
            return true;
        }
        return linkNumber <= this.linkNumberMax;
    }

    private boolean handlesLinkNumberMin(int linkNumber) {
        if (this.linkNumberMax < 0) {
            return true;
        }
        if (this.linkNumberMin == 0) {
            return linkNumber == 0;
        }
        return linkNumber >= this.linkNumberMin;
    }

    private boolean handlesLinkNumber(int linkNumber) {
        return this.handlesLinkNumberMax(linkNumber) && this.handlesLinkNumberMin(linkNumber);
    }

    @Override
    public boolean handles(Object3D obj1, Object3D obj2, LinkSet links) {
        if (this.prototype.getClassName().equals(obj1.getClassName()) && this.prototype.getClassName().equals(obj2.getClassName())) {
            int linkNumber = links.getLinkNumber(obj1, obj2);
            return this.handlesLinkNumber(linkNumber);
        }
        return false;
    }
}

