/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d.modeling;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.modeling.CoordinateSnapShot;
import tools3d.objects3d.modeling.Trajectory;

public class SimpleTrajectory
implements Trajectory {
    private List<CoordinateSnapShot> snapShots = new ArrayList<CoordinateSnapShot>();
    private Object3D root;
    private double timeIntervall;

    public SimpleTrajectory(Object3D root, double timeIntervall) {
        this.timeIntervall = timeIntervall;
        this.root = root;
    }

    @Override
    public void addSnapShot(CoordinateSnapShot snapShot) {
        this.snapShots.add(snapShot);
    }

    @Override
    public int getDefinedTimeStepCount() {
        return this.snapShots.size();
    }

    @Override
    public int getMaxTimeSteps() {
        return 0;
    }

    @Override
    public Object3D getObject3D(int timeStep) {
        this.applySnapShot(timeStep);
        return this.root;
    }

    @Override
    public Properties getProperties(int timeStep) {
        return null;
    }

    @Override
    public double getTime(int timeStep) {
        return this.timeIntervall * (double)timeStep;
    }

    public double getTimeIntervall() {
        return this.timeIntervall;
    }

    @Override
    public void setProperties(Properties p, int timeStep) {
    }

    private void applySnapShot(int timeStep) {
        CoordinateSnapShot snapShot = this.snapShots.get(timeStep);
        snapShot.applySnapShot(this.root);
    }
}

