/*
 * Decompiled with CFR 0.152.
 */
package viewer.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import viewer.commands.DisplayCommand;
import viewer.display.Display;
import viewer.display.DisplayFactory;
import viewer.display.MultiDisplay;
import viewer.event.DisplayEvent;
import viewer.event.DisplayLayoutListener;
import viewer.event.DisplayViewChangedListener;
import viewer.view.ViewOrientation;

public class MultiDisplayManager
extends JPanel
implements DisplayViewChangedListener {
    private ArrayList<DisplayLayoutListener> listeners = new ArrayList();
    private ArrayList<DisplayCommand> commands = new ArrayList();
    private MultiDisplay display;
    public static final Dimension CONFIG_SIZE = new Dimension(400, 500);

    public MultiDisplayManager() {
        this(DisplayFactory.PrefabricatedDisplays.FourQuadrants.getDefaultDisplay());
    }

    public MultiDisplayManager(MultiDisplay display) {
        this.display = display;
        this.setLayout(new BorderLayout());
        this.add((Component)display, "Center");
    }

    @Override
    public void displayChanged(DisplayEvent e) {
        if (e.getId() == 1) {
            for (final DisplayCommand c : this.commands) {
                final Display d = e.getDisplay();
                AbstractAction action = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        c.execute(d);
                    }
                };
                d.getActionMap().put(this.commands.indexOf(c), action);
                d.getInputMap().put(c.keyStroke(), this.commands.indexOf(c));
            }
        }
    }

    public void addCommand(DisplayCommand command) {
        this.commands.add(command);
        for (final Display d : this.display.getDisplays()) {
            final DisplayCommand c = command;
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    c.execute(d);
                }
            };
            d.getActionMap().put(this.commands.indexOf(c), action);
            d.getInputMap().put(c.keyStroke(), this.commands.indexOf(c));
        }
    }

    public List<DisplayCommand> getCommands() {
        return this.commands;
    }

    protected void refreshCommands() {
        for (final DisplayCommand c : this.commands) {
            for (final Display d : this.display.getDisplays()) {
                AbstractAction action = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        c.execute(d);
                    }
                };
                d.getActionMap().put(this.commands.indexOf(c), action);
                d.getInputMap().put(c.keyStroke(), this.commands.indexOf(c));
            }
        }
    }

    public MultiDisplay getDisplay() {
        return this.display;
    }

    public void addDisplayLayoutListener(DisplayLayoutListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeDisplayLayoutListener(DisplayLayoutListener listener) {
        return this.listeners.remove(listener);
    }

    public void notifyDisplayLayoutChanged() {
        for (DisplayLayoutListener l : this.listeners) {
            l.displayLayoutChanged(new DisplayEvent(this));
        }
    }

    public void setDisplay(MultiDisplay display) {
        if (display == null) {
            throw new IllegalArgumentException("Display cannot be null");
        }
        display.setPreferredSize(this.display.getPreferredSize());
        this.remove(this.display);
        this.display = display;
        this.add((Component)display, "Center");
        this.notifyDisplayLayoutChanged();
    }

    public void display() {
        for (Display d : this.getDisplay().getDisplays()) {
            System.out.println("Calling display for: " + d);
            d.display();
        }
    }

    public class Configuration
    extends JDialog {
        private JButton ok;
        private JButton close;
        private JComboBox comboBox;
        private OrientationPanel orientationPanel;
        private JTabbedPane pane;

        public JTabbedPane getPane() {
            return this.pane;
        }

        public JButton getOKButton() {
            return this.ok;
        }

        public JButton getCloseButton() {
            return this.close;
        }

        public Configuration(String title) {
            super((Frame)null, title, true);
            this.pane = new JTabbedPane();
            final JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            JLabel label = new JLabel("Select Display Layout");
            label.setAlignmentX(0.5f);
            this.comboBox = new JComboBox<DisplayFactory.PrefabricatedDisplays>(DisplayFactory.PrefabricatedDisplays.values());
            panel.add(label);
            panel.add(Box.createVerticalStrut(15));
            JPanel temp = new JPanel();
            temp.add(this.comboBox);
            JPanel preview = new JPanel(){
                {
                    this.setPreferredSize(new Dimension(59, 59));
                    this.setSize(new Dimension(59, 59));
                    this.setBackground(new Color(150, 150, 150));
                }

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    g.setColor(Color.white);
                    char[] numbers = new char[]{'1', '2', '3', '4'};
                    int height = 10;
                    DisplayFactory.PrefabricatedDisplays d = (DisplayFactory.PrefabricatedDisplays)((Object)Configuration.this.comboBox.getSelectedItem());
                    switch (d) {
                        case FourQuadrants: {
                            g.fillRect(3, 3, 25, 25);
                            g.fillRect(31, 31, 25, 25);
                            g.fillRect(3, 31, 25, 25);
                            g.fillRect(31, 3, 25, 25);
                            g.setColor(Color.black);
                            g.drawChars(numbers, 2, 1, 3, 31 + height);
                            g.drawChars(numbers, 3, 1, 31, 31 + height);
                            g.drawChars(numbers, 0, 1, 3, 3 + height);
                            g.drawChars(numbers, 1, 1, 31, 3 + height);
                            break;
                        }
                        case VerticalSplit: {
                            g.fillRect(3, 3, 25, 53);
                            g.fillRect(31, 3, 25, 53);
                            g.setColor(Color.black);
                            g.drawChars(numbers, 0, 1, 3, 3 + height);
                            g.drawChars(numbers, 1, 1, 31, 3 + height);
                            break;
                        }
                        case HorizontalSplit: {
                            g.fillRect(3, 3, 53, 25);
                            g.fillRect(3, 31, 53, 25);
                            g.setColor(Color.black);
                            g.drawChars(numbers, 0, 1, 3, 3 + height);
                            g.drawChars(numbers, 1, 1, 3, 31 + height);
                            break;
                        }
                        case TopAndTwoBottoms: {
                            g.fillRect(3, 3, 53, 25);
                            g.fillRect(31, 31, 25, 25);
                            g.fillRect(3, 31, 25, 25);
                            g.setColor(Color.black);
                            g.drawChars(numbers, 0, 1, 3, 3 + height);
                            g.drawChars(numbers, 1, 1, 3, 31 + height);
                            g.drawChars(numbers, 2, 1, 31, 31 + height);
                            break;
                        }
                        case Single: {
                            g.fillRect(3, 3, 53, 53);
                            g.setColor(Color.black);
                            g.drawChars(numbers, 0, 1, 3, 3 + height);
                            break;
                        }
                        case BottomAndTwoTops: {
                            g.fillRect(3, 31, 53, 25);
                            g.fillRect(3, 3, 25, 25);
                            g.fillRect(31, 3, 25, 25);
                            g.setColor(Color.black);
                            g.drawChars(numbers, 0, 1, 3, 3 + height);
                            g.drawChars(numbers, 1, 1, 31, 3 + height);
                            g.drawChars(numbers, 2, 1, 3, 31 + height);
                            break;
                        }
                        case LeftAndTwoRights: {
                            g.fillRect(3, 3, 25, 53);
                            g.fillRect(31, 31, 25, 25);
                            g.fillRect(31, 3, 25, 25);
                            g.setColor(Color.black);
                            g.drawChars(numbers, 0, 1, 3, 3 + height);
                            g.drawChars(numbers, 1, 1, 31, 3 + height);
                            g.drawChars(numbers, 2, 1, 31, 31 + height);
                            break;
                        }
                        case RightAndTwoLefts: {
                            g.fillRect(31, 3, 25, 53);
                            g.fillRect(3, 3, 25, 25);
                            g.fillRect(3, 31, 25, 25);
                            g.setColor(Color.black);
                            g.drawChars(numbers, 0, 1, 3, 3 + height);
                            g.drawChars(numbers, 1, 1, 31, 3 + height);
                            g.drawChars(numbers, 2, 1, 3, 31 + height);
                        }
                    }
                }
            };
            this.orientationPanel = new OrientationPanel();
            this.comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.remove(Configuration.this.orientationPanel);
                    Configuration.this.orientationPanel = new OrientationPanel();
                    panel.add(Configuration.this.orientationPanel);
                    panel.revalidate();
                    panel.repaint();
                    Configuration.this.orientationPanel.repaint();
                }
            });
            temp.add(Box.createHorizontalGlue());
            temp.add(preview);
            panel.add(temp);
            panel.add(Box.createVerticalStrut(15));
            panel.add(this.orientationPanel);
            panel.add(Box.createVerticalGlue());
            this.pane.addTab("Display Layout", panel);
            this.getContentPane().setLayout(new BorderLayout());
            this.add((Component)this.pane, "Center");
            this.ok = new JButton("OK");
            this.close = new JButton("Close");
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultiDisplayManager.this.remove(MultiDisplayManager.this.display);
                    DisplayFactory.PrefabricatedDisplays displayType = (DisplayFactory.PrefabricatedDisplays)((Object)Configuration.this.comboBox.getSelectedItem());
                    MultiDisplay d = displayType.getDisplay(Configuration.this.orientationPanel.getSelectedOrientations());
                    d.setModel(MultiDisplayManager.this.display.getModel());
                    d.setPreferredSize(MultiDisplayManager.this.display.getPreferredSize());
                    MultiDisplayManager.this.display = d;
                    MultiDisplayManager.this.refreshCommands();
                    MultiDisplayManager.this.add((Component)d, "Center");
                    MultiDisplayManager.this.revalidate();
                    MultiDisplayManager.this.notifyDisplayLayoutChanged();
                    Configuration.this.setVisible(false);
                    Configuration.this.dispose();
                }
            });
            this.close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Configuration.this.setVisible(false);
                    Configuration.this.dispose();
                }
            });
            JPanel bottom = new JPanel();
            bottom.add(this.ok);
            bottom.add(this.close);
            bottom.setAlignmentX(0.5f);
            this.add((Component)bottom, "South");
            this.setPreferredSize(CONFIG_SIZE);
            this.setDefaultCloseOperation(2);
            this.pack();
        }

        private class OrientationPanel
        extends JPanel {
            private ArrayList<JComboBox> boxes = new ArrayList();

            public OrientationPanel() {
                this.setLayout(new BoxLayout(this, 1));
                DisplayFactory.PrefabricatedDisplays d = (DisplayFactory.PrefabricatedDisplays)((Object)Configuration.this.comboBox.getSelectedItem());
                for (int i = 0; i < d.getViewCount(); ++i) {
                    JPanel panel = new JPanel();
                    panel.add(new JLabel("View " + (i + 1)));
                    JComboBox<ViewOrientation> box = new JComboBox<ViewOrientation>(ViewOrientation.values());
                    this.boxes.add(box);
                    panel.add(box);
                    this.add(panel);
                }
            }

            public ViewOrientation[] getSelectedOrientations() {
                ViewOrientation[] ret = new ViewOrientation[this.boxes.size()];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = (ViewOrientation)((Object)this.boxes.get(i).getSelectedItem());
                }
                return ret;
            }
        }
    }
}

