/*
 * Decompiled with CFR 0.152.
 */
package viewer.event;

import commandtools.CommandApplication;
import commandtools.CommandException;
import rnadesign.rnamodel.RnaTools;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DTools;

public class SelectionEvent {
    private Object3D selectedObject;
    private Object source;
    private boolean selectionAdjusting = false;

    public SelectionEvent(Object3D selectedObject, Object source) {
        this.selectedObject = selectedObject;
        this.source = source;
        System.out.println("3D object selected: " + selectedObject.getFullName());
        System.out.println("Closest objects for given class names: " + RnaTools.reportClosestRnaObjects(Object3DTools.findRoot(this.selectedObject), this.selectedObject.getPosition()));
    }

    public SelectionEvent(Object3D selectedObject, Object source, boolean selectionAdjusting) {
        this(selectedObject, source);
        this.selectionAdjusting = selectionAdjusting;
    }

    public Object3D getSelectedObject() {
        return this.selectedObject;
    }

    public void setSelectedObject(Object3D selectedObject) {
        this.selectedObject = selectedObject;
    }

    public void setSelectedObject(CommandApplication application, Object3D selectedObject) {
        try {
            application.runScriptLine("select " + Object3DTools.getFullName(selectedObject));
        }
        catch (CommandException e) {
            System.out.println(e + ": " + e.getMessage());
        }
        this.setSelectedObject(selectedObject);
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public boolean isSelectionAdjusting() {
        return this.selectionAdjusting;
    }
}

