/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import javax.media.opengl.GL;
import tools3d.Vector4D;
import viewer.graphics.AdvancedMesh;
import viewer.graphics.ColorVector;
import viewer.graphics.Material;
import viewer.graphics.Mesh;
import viewer.graphics.SolidMeshRenderer;

public class AdvancedSolidMeshRenderer
extends SolidMeshRenderer {
    public AdvancedSolidMeshRenderer(Mesh m) {
        super(m);
    }

    public AdvancedSolidMeshRenderer() {
    }

    @Override
    public void renderMesh(GL gl, Mesh mesh) {
        if (mesh instanceof AdvancedMesh) {
            Vector4D vertex;
            Vector4D normal;
            ColorVector vector;
            Material material;
            Vector4D vertex2;
            Vector4D normal2;
            ColorVector vector2;
            Material material2;
            AdvancedMesh m = (AdvancedMesh)mesh;
            gl.glPointSize((float)m.getPointSize());
            gl.glBegin(0);
            for (int[] point : m.getPoints()) {
                material2 = m.getVertexMaterial(point[0]);
                if (material2 != null) {
                    Material.renderMaterial(gl, material2);
                    vector2 = material2.getDiffuse();
                    gl.glColor3d(vector2.getRed(), vector2.getGreen(), vector2.getBlue());
                }
                normal2 = m.getNormal(point[0]);
                vertex2 = m.getVertex(point[0]);
                gl.glNormal3d(normal2.getX(), normal2.getY(), normal2.getZ());
                gl.glVertex3d(vertex2.getX(), vertex2.getY(), vertex2.getZ());
            }
            gl.glEnd();
            gl.glLineWidth((float)m.getLineWidth());
            gl.glBegin(1);
            for (int[] line : m.getLines()) {
                material2 = m.getVertexMaterial(line[0]);
                if (material2 != null) {
                    vector2 = material2.getDiffuse();
                    gl.glColor3d(vector2.getRed(), vector2.getGreen(), vector2.getBlue());
                    Material.renderMaterial(gl, material2);
                }
                normal2 = m.getNormal(line[0]);
                vertex2 = m.getVertex(line[0]);
                gl.glNormal3d(normal2.getX(), normal2.getY(), normal2.getZ());
                gl.glVertex3d(vertex2.getX(), vertex2.getY(), vertex2.getZ());
                material2 = m.getVertexMaterial(line[1]);
                if (material2 != null) {
                    Material.renderMaterial(gl, material2);
                    ColorVector vector3 = material2.getDiffuse();
                    gl.glColor3d(vector3.getRed(), vector3.getGreen(), vector3.getBlue());
                }
                normal2 = m.getNormal(line[1]);
                vertex2 = m.getVertex(line[1]);
                gl.glNormal3d(normal2.getX(), normal2.getY(), normal2.getZ());
                gl.glVertex3d(vertex2.getX(), vertex2.getY(), vertex2.getZ());
            }
            gl.glEnd();
            gl.glBegin(4);
            for (int[] a : m.getTriangles()) {
                for (int i = 0; i < 3; ++i) {
                    material = m.getVertexMaterial(a[i]);
                    if (material != null) {
                        Material.renderMaterial(gl, material);
                        vector = material.getDiffuse();
                        gl.glColor3d(vector.getRed(), vector.getGreen(), vector.getBlue());
                    }
                    normal = m.getNormal(a[i]);
                    vertex = m.getVertex(a[i]);
                    gl.glNormal3d(normal.getX(), normal.getY(), normal.getZ());
                    gl.glVertex3d(vertex.getX(), vertex.getY(), vertex.getZ());
                }
            }
            gl.glEnd();
            gl.glBegin(7);
            for (int[] a : m.getQuads()) {
                for (int i = 0; i < 4; ++i) {
                    material = m.getVertexMaterial(a[i]);
                    if (material != null) {
                        Material.renderMaterial(gl, material);
                        vector = material.getDiffuse();
                        gl.glColor3d(vector.getRed(), vector.getGreen(), vector.getBlue());
                    }
                    normal = m.getNormal(a[i]);
                    vertex = m.getVertex(a[i]);
                    gl.glNormal3d(normal.getX(), normal.getY(), normal.getZ());
                    gl.glVertex3d(vertex.getX(), vertex.getY(), vertex.getZ());
                }
            }
            gl.glEnd();
            for (int[] a : m.getGeometryElements()) {
                gl.glBegin(9);
                for (int i = 0; i < a.length; ++i) {
                    material = m.getVertexMaterial(a[i]);
                    if (material != null) {
                        Material.renderMaterial(gl, material);
                        vector = material.getDiffuse();
                        gl.glColor3d(vector.getRed(), vector.getGreen(), vector.getBlue());
                    }
                    normal = m.getNormal(a[i]);
                    vertex = m.getVertex(a[i]);
                    gl.glNormal3d(normal.getX(), normal.getY(), normal.getZ());
                    gl.glVertex3d(vertex.getX(), vertex.getY(), vertex.getZ());
                }
                gl.glEnd();
            }
        } else {
            super.renderMesh(gl, mesh);
        }
    }
}

