/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import javax.media.opengl.GL;
import tools3d.Vector3D;
import tools3d.Vector4D;
import viewer.graphics.CurveRenderer;
import viewer.graphics.Mesh;
import viewer.graphics.MeshOperations;
import viewer.graphics.MeshRenderer;
import viewer.graphics.SolidMeshRenderer;
import viewer.graphics.WireframeMeshRenderer;
import viewer.util.Tools;

public class CylindricalCurveRenderer
implements CurveRenderer {
    private Vector3D[] curve;
    private boolean wireframeMode;
    private Mesh mesh;
    private double radius;
    private int sides;
    private static final Vector4D POLYGON_NORMAL = new Vector4D(0.0, 1.0, 0.0, 0.0);

    public CylindricalCurveRenderer(Vector3D[] curve) {
        this(curve, false);
    }

    public CylindricalCurveRenderer(Vector3D[] curve, boolean wireframeMode) {
        this(curve, 0.5, 8, false);
    }

    public CylindricalCurveRenderer(Vector3D[] curve, double radius, int sides, boolean wireframeMode) {
        this.curve = curve;
        this.wireframeMode = wireframeMode;
        this.radius = radius;
        this.sides = sides;
        Vector4D[] polygon = new Vector4D[sides];
        Vector4D normal = Tools.orthogonal(POLYGON_NORMAL);
        normal.normalize();
        normal = normal.mul(radius);
        double angle = Math.PI * -2 / (double)sides;
        for (int i = 0; i < sides; ++i) {
            polygon[i] = normal;
            normal = Tools.rotate(normal, POLYGON_NORMAL, angle);
            normal.normalize();
            normal = normal.mul(radius);
        }
        this.mesh = MeshOperations.extend(polygon, POLYGON_NORMAL, curve);
    }

    @Override
    public Vector3D[] getCurve() {
        return this.curve;
    }

    @Override
    public void render(GL gl) {
        MeshRenderer renderer = this.wireframeMode ? new WireframeMeshRenderer(this.mesh) : new SolidMeshRenderer(this.mesh);
        renderer.render(gl);
    }

    public boolean isWireframeMode() {
        return this.wireframeMode;
    }

    public void setWireframeMode(boolean wireframeMode) {
        this.wireframeMode = wireframeMode;
    }
}

