/*
 * Decompiled with CFR 0.152.
 */
package viewer.rnadesign;

import java.awt.Color;
import java.util.Set;
import javax.media.opengl.GL;
import rnadesign.rnacontrol.LinkController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.Nucleotide3D;
import tools3d.Matrix4D;
import tools3d.Vector4D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import viewer.graphics.ColorModel;
import viewer.graphics.Material;
import viewer.graphics.Mesh;
import viewer.graphics.MeshRenderer;
import viewer.graphics.PrimitiveFactory;
import viewer.graphics.RenderableModel;
import viewer.graphics.SolidMeshRenderer;
import viewer.graphics.WireframeMeshRenderer;
import viewer.rnadesign.LinkVisualizationManager;
import viewer.util.Tools;

public class LinkRenderer
extends LinkVisualizationManager
implements RenderableModel {
    private Object3DGraphController controller;
    private static final Mesh CYLINDER = PrimitiveFactory.generateCylinder(new Vector4D(1.0, 0.0, 0.0, 0.0), 0.5, 2.0, 1, 8);
    private ColorModel colorModel;
    private Color basePairLinkColor = Color.GRAY;
    private Color covalentBondLinkColor = Color.WHITE;

    public LinkRenderer(Object3DGraphController controller, ColorModel colorModel) {
        this.controller = controller;
        this.colorModel = colorModel;
        assert (colorModel != null);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public void setColorModel(ColorModel colorModel) {
        this.colorModel = colorModel;
    }

    @Override
    public void render(GL gl) {
        if (!this.isRenderLinks()) {
            return;
        }
        Set<String> allowed = this.getAllowedLinks();
        LinkController linkController = this.controller.getLinks();
        for (int i = 0; i < linkController.size(); ++i) {
            Link l = linkController.get(i);
            if (!allowed.contains(l.getTypeName())) {
                return;
            }
            this.renderLink(l, gl);
        }
    }

    public void renderLink(Link l, GL gl) {
        Object3D o1 = l.getObj1();
        Object3D o2 = l.getObj2();
        Color color = this.getLinkColor(l);
        Material material = new Material(color);
        Material.renderMaterial(gl, material);
        switch (this.getRenderMode()) {
            case Cylinder: {
                Vector4D axis = new Vector4D(o1.getPosition().minus(o2.getPosition()));
                double length = axis.length() / 2.0;
                Vector4D midpoint = new Vector4D(o1.getPosition().plus(o2.getPosition()));
                midpoint = midpoint.mul(0.5);
                midpoint.setW(1.0);
                axis.setW(0.0);
                axis.normalize();
                MeshRenderer renderer = this.isWireframeMode() ? new WireframeMeshRenderer(CYLINDER) : new SolidMeshRenderer(CYLINDER);
                gl.glEnable(2977);
                gl.glPushMatrix();
                gl.glTranslated(midpoint.getX(), midpoint.getY(), midpoint.getZ());
                Vector4D rotationAxis = axis.cross(Tools.X_AXIS);
                double angle = Math.acos(axis.dot(Tools.X_AXIS));
                rotationAxis.normalize();
                Matrix4D rotation = Tools.getRotationMatrix(rotationAxis, angle);
                double[] matrix = rotation.getArray();
                gl.glMultMatrixd(matrix, 0);
                gl.glScaled(length, 1.0, 1.0);
                renderer.render(gl);
                gl.glPopMatrix();
                gl.glDisable(2977);
                break;
            }
            case Capsule: 
            case Line: {
                gl.glBegin(1);
                gl.glVertex3d(o1.getPosition().getX(), o1.getPosition().getY(), o1.getPosition().getZ());
                gl.glVertex3d(o2.getPosition().getX(), o2.getPosition().getY(), o2.getPosition().getZ());
                gl.glEnd();
            }
        }
    }

    private Color getCovalentBondLinkColor(Link link) {
        return this.covalentBondLinkColor;
    }

    private Color getBasePairLinkColor() {
        return this.basePairLinkColor;
    }

    private Color getBasePairLinkColor(Link link) {
        return this.basePairLinkColor;
    }

    private void setBasePairLinkColor(Color c) {
        this.basePairLinkColor = c;
    }

    private Color getAverageColor(Color color1, Color color2) {
        return color1;
    }

    private boolean isCovalentBondLink(Link link) {
        return link.getObj1() instanceof Atom3D && link.getObj2() instanceof Atom3D;
    }

    private boolean isBasePairLink(Link link) {
        return link.getObj1() instanceof Nucleotide3D && link.getObj2() instanceof Nucleotide3D;
    }

    public Color getLinkColor(Link link) {
        if (this.isCovalentBondLink(link)) {
            return this.getCovalentBondLinkColor(link);
        }
        if (this.isBasePairLink(link)) {
            return this.getBasePairLinkColor(link);
        }
        return super.getLinkColor();
    }

    public Object3DGraphController getController() {
        return this.controller;
    }

    public void setController(Object3DGraphController controller) {
        this.controller = controller;
    }
}

