/*
 * Decompiled with CFR 0.152.
 */
package viewer.rnadesign;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import viewer.graphics.Material;
import viewer.rnadesign.RNAColorModel;

public class StrandColorModel
extends RNAColorModel {
    private static final Color[][] COLOR_PAIRS = new Color[][]{{Color.red, Color.orange}, {Color.orange, Color.yellow}, {Color.yellow, Color.green}, {Color.green, Color.cyan}};
    private Map<Object3D, Material> map = new HashMap<Object3D, Material>();

    @Override
    public Material getAtomMaterial(Atom3D atom) {
        return this.materialFromParent(atom);
    }

    @Override
    public Material getBranchDescriptorMaterial(BranchDescriptor3D b) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getKissingLoopMaterial(KissingLoop3D k) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getNucleotideMaterial(Nucleotide3D n) {
        return this.materialFromParent(n);
    }

    @Override
    public Material getOtherMaterial(Object3D o) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getRnaStemMaterial(RnaStem3D s) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getRnaStrandMaterial(RnaStrand s) {
        if (this.map.containsKey(s)) {
            return this.map.get(s);
        }
        int size = s.getSiblingCount();
        int index = s.getParent().getIndexOfChild(s);
        if (index > 0) {
            ++index;
        }
        double ratio = (double)index / (double)size;
        System.out.println("Size: " + size + " index: " + index + " ratio: " + ratio);
        for (int section = 1; section <= COLOR_PAIRS.length; ++section) {
            double sectionStart = (double)(section - 1) / (double)COLOR_PAIRS.length;
            double sectionEnd = (double)section / (double)COLOR_PAIRS.length;
            if (!(ratio >= sectionStart) || !(ratio <= sectionEnd)) continue;
            Color color1 = COLOR_PAIRS[section - 1][0];
            Color color2 = COLOR_PAIRS[section - 1][1];
            int rRange = color2.getRed() - color1.getRed();
            int bRange = color2.getBlue() - color1.getBlue();
            int gRange = color2.getGreen() - color1.getGreen();
            double sectionRatio = (ratio - sectionStart) / (sectionEnd - sectionStart);
            Color c = new Color(color1.getRed() + (int)(sectionRatio * (double)rRange), color1.getGreen() + (int)(sectionRatio * (double)gRange), color1.getBlue() + (int)(sectionRatio * (double)bRange));
            Material m = new Material(c);
            this.map.put(s, m);
            return m;
        }
        return this.getDefaultMaterial();
    }

    @Override
    public Material getStrandJunctionMaterial(StrandJunction3D j) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getMaterial(Link link) {
        return this.getDefaultMaterial();
    }

    private Material materialFromParent(Object3D o) {
        if (o == null) {
            return this.getDefaultMaterial();
        }
        if (o instanceof RnaStrand) {
            if (this.map.containsKey(o)) {
                return this.map.get(o);
            }
            Random r = new Random();
            Color c = new Color(r.nextInt(200) + 55, r.nextInt(200) + 55, r.nextInt(200) + 55);
            Material m = new Material(c);
            this.map.put(o, m);
            return m;
        }
        return this.materialFromParent(o.getParent());
    }

    @Override
    public void reset() {
        this.map.clear();
    }
}

