/*
 * Decompiled with CFR 0.152.
 */
package viewer.view;

import tools3d.Matrix4D;
import tools3d.Vector4D;
import viewer.util.Tools;
import viewer.view.DefaultPerspectiveView;

public class AimablePerspectiveView
extends DefaultPerspectiveView {
    private Vector4D origin;
    private Vector4D axis = new Vector4D(1.0, 0.0, 0.0, 0.0);

    public AimablePerspectiveView() {
    }

    public AimablePerspectiveView(Vector4D viewDirection, Vector4D viewLocation, Vector4D viewNormal) {
        super(viewDirection, viewLocation, viewNormal);
    }

    public AimablePerspectiveView(Vector4D origin) {
        this.origin = origin;
        this.pointAtOrigin();
    }

    public Vector4D getOrigin() {
        return this.origin;
    }

    public boolean isPointing() {
        return this.origin != null;
    }

    public void point(Vector4D origin) {
        this.origin = origin;
        if (!this.isPointing()) {
            return;
        }
        this.pointAtOrigin();
        this.getManager().notifyViewChanged();
    }

    @Override
    public void lookAt(double x, double y, double z) {
        this.point(new Vector4D(x, y, z, 1.0));
    }

    @Override
    public void rotateLocalViewX(double angle) {
        if (!this.isPointing()) {
            super.rotateLocalViewX(angle);
            return;
        }
        this.rotatePointViewX(angle);
    }

    @Override
    public void rotateLocalViewY(double angle) {
        if (!this.isPointing()) {
            super.rotateLocalViewY(angle);
            return;
        }
        this.rotatePointViewY(angle);
    }

    @Override
    public void rotateLocalViewZ(double angle) {
        if (!this.isPointing()) {
            super.rotateLocalViewZ(angle);
            return;
        }
        this.rotatePointViewZ(angle);
    }

    @Override
    public void translateLocalView(double x, double y) {
        if (!this.isPointing()) {
            super.translateLocalView(x, y);
            return;
        }
        this.translatePointView(x, y);
    }

    @Override
    public void zoomLocalView(double zoom) {
        if (!this.isPointing()) {
            super.zoomLocalView(zoom);
            return;
        }
        this.zoomPointView(zoom);
    }

    @Override
    public void rotateWorldViewX(double angle) {
        if (!this.isPointing()) {
            super.rotateWorldViewX(angle);
            return;
        }
        this.rotatePointViewX(angle);
    }

    @Override
    public void rotateWorldViewY(double angle) {
        if (!this.isPointing()) {
            super.rotateWorldViewY(angle);
            return;
        }
        this.rotatePointViewY(angle);
    }

    @Override
    public void rotateWorldViewZ(double angle) {
        if (!this.isPointing()) {
            super.rotateWorldViewZ(angle);
            return;
        }
        this.rotatePointViewZ(angle);
    }

    @Override
    public void translateWorldView(double x, double y) {
        if (!this.isPointing()) {
            super.translateWorldView(x, y);
            return;
        }
        this.translatePointView(x, y);
    }

    @Override
    public void zoomWorldView(double z) {
        if (!this.isPointing()) {
            super.zoomWorldView(z);
            return;
        }
        this.zoomPointView(z);
    }

    public void zoomPointView(double z) {
        super.zoomLocalView(z);
    }

    public void rotatePointViewX(double angle) {
        angle = angle * Math.PI / 180.0;
        Vector4D viewLocation = this.getViewLocation();
        viewLocation = viewLocation.minus(this.origin);
        viewLocation = Tools.rotate(viewLocation, this.axis, angle);
        this.setViewDirection(Tools.rotate(this.getViewDirection(), this.axis, angle));
        this.setViewNormal(Tools.rotate(this.getViewDirectionNormal(), this.axis, angle));
        viewLocation.add(this.origin);
        this.setViewLocation(viewLocation);
        this.getManager().notifyViewChanged();
    }

    public void rotatePointViewY(double angle) {
        angle = angle * Math.PI / 180.0;
        Vector4D viewLocation = this.getViewLocation();
        viewLocation = viewLocation.minus(this.origin);
        Matrix4D matrix = new Matrix4D(1.0);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        matrix.setXX(cos);
        matrix.setXZ(sin);
        matrix.setZX(-sin);
        matrix.setZZ(cos);
        viewLocation = matrix.multiply(viewLocation);
        this.axis = matrix.multiply(this.axis);
        viewLocation.add(this.origin);
        this.setViewLocation(viewLocation);
        this.setViewDirection(matrix.multiply(this.getViewDirection()));
        this.setViewNormal(matrix.multiply(this.getViewDirectionNormal()));
        this.getManager().notifyViewChanged();
    }

    public void rotatePointViewZ(double angle) {
        super.rotateLocalViewZ(angle);
    }

    public void translatePointView(double x, double y) {
        Vector4D viewLocation = this.getViewLocation();
        viewLocation = Tools.translate(viewLocation, Tools.Z_AXIS, y);
        viewLocation = Tools.translate(viewLocation, Tools.X_AXIS, x);
        this.setViewLocation(viewLocation);
        this.pointAtOrigin();
        this.getManager().notifyViewChanged();
    }

    private void pointAtOrigin() {
        Vector4D oldDirection = this.getViewDirection();
        Vector4D newDirection = this.origin.minus(this.getViewLocation());
        newDirection.normalize();
        Vector4D x = Tools.X_AXIS.mul(newDirection.getX());
        Vector4D y = Tools.Y_AXIS.mul(newDirection.getY());
        Vector4D z = Tools.Z_AXIS.mul(newDirection.getZ());
        double xAngle = Tools.angle(x, oldDirection);
        double yAngle = Tools.angle(y, oldDirection);
        double zAngle = Tools.angle(z, oldDirection);
        double xSin = Math.sin(xAngle);
        double xCos = Math.cos(xAngle);
        double ySin = Math.sin(yAngle);
        double yCos = Math.cos(yAngle);
        double zSin = Math.sin(zAngle);
        double zCos = Math.cos(zAngle);
        Matrix4D xMatrix = new Matrix4D(1.0, 0.0, 0.0, 0.0, 0.0, xCos, -xSin, 0.0, 0.0, xSin, xCos, 0.0, 0.0, 0.0, 0.0, 1.0);
        Matrix4D yMatrix = new Matrix4D(yCos, 0.0, ySin, 0.0, 0.0, 1.0, 0.0, 0.0, -ySin, 0.0, yCos, 0.0, 0.0, 0.0, 0.0, 1.0);
        Matrix4D zMatrix = new Matrix4D(zCos, -zSin, 0.0, 0.0, zSin, zCos, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Vector4D viewNormal = this.getViewDirectionNormal();
        Vector4D xNorm = new Vector4D(viewNormal.getX(), 0.0, 0.0, 0.0);
        Vector4D yNorm = new Vector4D(0.0, viewNormal.getY(), 0.0, 0.0);
        Vector4D zNorm = new Vector4D(0.0, 0.0, viewNormal.getZ(), 0.0);
        Vector4D xAxis = new Vector4D(this.axis.getX(), 0.0, 0.0, 0.0);
        Vector4D yAxis = new Vector4D(0.0, this.axis.getY(), 0.0, 0.0);
        Vector4D zAxis = new Vector4D(0.0, 0.0, this.axis.getZ(), 0.0);
        xNorm = xMatrix.multiply(xNorm);
        yNorm = yMatrix.multiply(yNorm);
        zNorm = zMatrix.multiply(zNorm);
        xAxis = xMatrix.multiply(xAxis);
        yAxis = yMatrix.multiply(yAxis);
        zAxis = zMatrix.multiply(zAxis);
        this.setViewNormal(new Vector4D(xNorm.getX(), yNorm.getY(), zNorm.getZ(), 0.0));
        this.axis = new Vector4D(xAxis.getX(), yAxis.getY(), zAxis.getZ(), 0.0);
        this.setViewDirection(newDirection);
    }

    @Override
    public void reset() {
        super.reset();
        this.axis = new Vector4D(1.0, 0.0, 0.0, 0.0);
    }
}

