package rnadesign.rnamodel;

import java.util.List;
import java.util.ArrayList;
import tools3d.*;
import tools3d.objects3d.*;

/** describes vertex of graph, which includes 3D positions as well of set of allowed junctions */
public class GraphVertexDescriptor3D extends SimpleObject3D {
    
    List<DBElementDescriptor> allowedJunctions;

    public GraphVertexDescriptor3D() {
	super();
	allowedJunctions = new ArrayList<DBElementDescriptor>();
    }

    public GraphVertexDescriptor3D(Vector3D position) {
	super(position);
	allowedJunctions = new ArrayList<DBElementDescriptor>();
    }


    public void addAllowedJunction(DBElementDescriptor descriptor) {
	this.allowedJunctions.add(descriptor);
    }

    public boolean isAllowedJunction(DBElementDescriptor descriptor) {
	return (allowedJunctions.contains(descriptor));
    }

}
