package tools3d.objects3d;

import java.io.OutputStream;
import java.io.PrintStream;

public class Object3DDefaultWriter implements Object3DWriter {

    private int formatId = Object3DFormatter.LISP_FORMAT;

    public Object3DDefaultWriter() { }
    
    public int getFormatId() { return formatId; }

    public void write(OutputStream os, Object3D node) {
	PrintStream pw = new PrintStream(os);
	pw.println(writeString(node));
    }
    
    public String writeString(Object3D node) {
	return node.toString();
    }
    
    public void write(OutputStream os, LinkSet links) {
	PrintStream pw = new PrintStream(os);
	pw.println(links.toString());
    }


}
