package viewer.view;

import tools3d.*;

public class XYView extends AbstractOrthogonalView {

	private int scalar = 1;
	
	public XYView() {
		super(new Vector4D(0.0, 0.0, -1.0, 0.0), new Vector4D(0.0, 0.0, 1.0, 1.0),
				new Vector4D(0.0, 1.0, 0.0, 0.0));
		
	}
	
	public void lookAt(double x, double y, double z) {
		Vector4D oldLocation = new Vector4D(viewLocation);
		getViewLocation().setX(x);
		getViewLocation().setY(y);
		getManager().notifyViewTranslation(false, oldLocation, getViewLocation());
	}
	
	
	
	public void flipView() {
		viewDirection.setZ(viewDirection.getZ() * -1);
		viewLocation.setZ(viewLocation.getZ() * -1);
		scalar *= -1;

	}

	public void translateWorldView(double x, double y) {
		Vector4D translation = new Vector4D(-1 * scalar * x, -1 * scalar * y, 0.0, 0.0);
		Vector4D oldLocation = new Vector4D(viewLocation);
		viewLocation.add(translation);
		getManager().notifyViewTranslation(false, oldLocation, viewLocation);

	}

	

}
