/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;

public class SharedResourceRunner
implements Runnable {
    protected static final boolean DEBUG = GLDrawableImpl.DEBUG;
    final HashSet<String> devicesTried = new HashSet();
    final Implementation impl;
    Thread thread;
    boolean running;
    boolean ready;
    boolean shouldRelease;
    AbstractGraphicsDevice initDevice;
    AbstractGraphicsDevice releaseDevice;

    private boolean getDeviceTried(AbstractGraphicsDevice abstractGraphicsDevice) {
        return this.devicesTried.contains(abstractGraphicsDevice.getConnection());
    }

    private void addDeviceTried(AbstractGraphicsDevice abstractGraphicsDevice) {
        this.devicesTried.add(abstractGraphicsDevice.getConnection());
    }

    private void removeDeviceTried(AbstractGraphicsDevice abstractGraphicsDevice) {
        this.devicesTried.remove(abstractGraphicsDevice.getConnection());
    }

    public SharedResourceRunner(Implementation implementation) {
        this.impl = implementation;
        this.resetState();
    }

    private void resetState() {
        this.devicesTried.clear();
        this.thread = null;
        this.ready = false;
        this.running = false;
        this.shouldRelease = false;
        this.initDevice = null;
        this.releaseDevice = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread start() {
        SharedResourceRunner sharedResourceRunner = this;
        synchronized (sharedResourceRunner) {
            if (null != this.thread && !this.thread.isAlive()) {
                if (DEBUG) {
                    System.err.println("SharedResourceRunner.start() - dead-old-thread cleanup - " + SharedResourceRunner.getThreadName());
                }
                this.releaseSharedResources();
                this.thread = null;
                this.running = false;
            }
            if (null == this.thread) {
                if (DEBUG) {
                    System.err.println("SharedResourceRunner.start() - start new Thread - " + SharedResourceRunner.getThreadName());
                }
                this.resetState();
                this.thread = new Thread((Runnable)this, SharedResourceRunner.getThreadName() + "-SharedResourceRunner");
                this.thread.setDaemon(true);
                this.thread.start();
                while (!this.running) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SharedResourceRunner sharedResourceRunner = this;
        synchronized (sharedResourceRunner) {
            if (null != this.thread) {
                if (DEBUG) {
                    System.err.println("SharedResourceRunner.stop() - " + SharedResourceRunner.getThreadName());
                }
                SharedResourceRunner sharedResourceRunner2 = this;
                synchronized (sharedResourceRunner2) {
                    this.shouldRelease = true;
                    this.notifyAll();
                    while (this.running) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getOrCreateShared(AbstractGraphicsDevice abstractGraphicsDevice) {
        Resource resource = null;
        if (null != abstractGraphicsDevice) {
            SharedResourceRunner sharedResourceRunner = this;
            synchronized (sharedResourceRunner) {
                this.start();
                resource = this.impl.mapGet(abstractGraphicsDevice);
                if (null == resource && !this.getDeviceTried(abstractGraphicsDevice)) {
                    this.addDeviceTried(abstractGraphicsDevice);
                    if (DEBUG) {
                        System.err.println("SharedResourceRunner.getOrCreateShared() " + abstractGraphicsDevice + ": trying - " + SharedResourceRunner.getThreadName());
                        ExceptionUtils.dumpStack((PrintStream)System.err);
                    }
                    if (this.impl.isDeviceSupported(abstractGraphicsDevice)) {
                        this.doAndWait(abstractGraphicsDevice, null);
                        resource = this.impl.mapGet(abstractGraphicsDevice);
                    }
                    if (DEBUG) {
                        System.err.println("SharedResourceRunner.getOrCreateShared() " + abstractGraphicsDevice + ": " + (null != resource ? "success" : "failed") + " - " + SharedResourceRunner.getThreadName());
                    }
                }
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource releaseShared(AbstractGraphicsDevice abstractGraphicsDevice) {
        Resource resource = null;
        if (null != abstractGraphicsDevice) {
            SharedResourceRunner sharedResourceRunner = this;
            synchronized (sharedResourceRunner) {
                resource = this.impl.mapGet(abstractGraphicsDevice);
                if (null != resource) {
                    this.removeDeviceTried(abstractGraphicsDevice);
                    if (DEBUG) {
                        System.err.println("SharedResourceRunner.releaseShared() " + abstractGraphicsDevice + ": trying - " + SharedResourceRunner.getThreadName());
                    }
                    this.doAndWait(null, abstractGraphicsDevice);
                    if (DEBUG) {
                        System.err.println("SharedResourceRunner.releaseShared() " + abstractGraphicsDevice + ": done - " + SharedResourceRunner.getThreadName());
                    }
                }
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doAndWait(AbstractGraphicsDevice abstractGraphicsDevice, AbstractGraphicsDevice abstractGraphicsDevice2) {
        SharedResourceRunner sharedResourceRunner = this;
        synchronized (sharedResourceRunner) {
            String string = SharedResourceRunner.getThreadName();
            if (DEBUG) {
                System.err.println("SharedResourceRunner.doAndWait() START init: " + abstractGraphicsDevice + ", release: " + abstractGraphicsDevice2 + " - " + string);
            }
            while (!this.ready && this.running) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (DEBUG) {
                System.err.println("SharedResourceRunner.doAndWait() set command: " + abstractGraphicsDevice + ", release: " + abstractGraphicsDevice2 + " - " + string);
            }
            this.initDevice = abstractGraphicsDevice;
            this.releaseDevice = abstractGraphicsDevice2;
            this.notifyAll();
            while (this.running && (!this.ready || null != this.initDevice || null != this.releaseDevice)) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (DEBUG) {
                System.err.println("SharedResourceRunner.initializeAndWait END init: " + abstractGraphicsDevice + ", release: " + abstractGraphicsDevice2 + " - " + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        String string = SharedResourceRunner.getThreadName();
        if (DEBUG) {
            System.err.println("SharedResourceRunner.run(): STARTED - " + string);
        }
        SharedResourceRunner sharedResourceRunner = this;
        synchronized (sharedResourceRunner) {
            this.running = true;
            while (!this.shouldRelease) {
                block22: {
                    try {
                        this.ready = true;
                        if (DEBUG) {
                            System.err.println("SharedResourceRunner.run(): READY - " + string);
                        }
                        this.notifyAll();
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.shouldRelease = true;
                        if (!DEBUG) break block22;
                        System.err.println("SharedResourceRunner.run(): INTERRUPTED - " + string);
                        interruptedException.printStackTrace();
                    }
                }
                this.ready = false;
                if (!this.shouldRelease) {
                    Resource resource;
                    if (DEBUG) {
                        System.err.println("SharedResourceRunner.run(): WOKE UP for device connection init: " + this.initDevice + ", release: " + this.releaseDevice + " - " + string);
                    }
                    if (null != this.initDevice) {
                        if (DEBUG) {
                            System.err.println("SharedResourceRunner.run(): create Shared for: " + this.initDevice + " - " + string);
                        }
                        resource = null;
                        try {
                            resource = this.impl.createSharedResource(this.initDevice);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (null != resource) {
                            this.impl.mapPut(this.initDevice, resource);
                        }
                    }
                    if (null != this.releaseDevice) {
                        if (DEBUG) {
                            System.err.println("SharedResourceRunner.run(): release Shared for: " + this.releaseDevice + " - " + string);
                        }
                        if (null != (resource = this.impl.mapGet(this.releaseDevice))) {
                            try {
                                this.impl.releaseSharedResource(resource);
                                this.impl.mapPut(this.releaseDevice, null);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                this.initDevice = null;
                this.releaseDevice = null;
            }
            if (DEBUG) {
                System.err.println("SharedResourceRunner.run(): RELEASE START - " + string);
            }
            this.releaseSharedResources();
            if (DEBUG) {
                System.err.println("SharedResourceRunner.run(): RELEASE END - " + string);
            }
            this.shouldRelease = false;
            this.running = false;
            this.thread = null;
            this.notifyAll();
        }
    }

    private void releaseSharedResources() {
        this.devicesTried.clear();
        Collection<Resource> collection = this.impl.mapValues();
        Iterator<Resource> iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                this.impl.releaseSharedResource(iterator.next());
            }
            catch (Throwable throwable) {
                System.err.println("Caught exception on thread " + SharedResourceRunner.getThreadName());
                throwable.printStackTrace();
            }
        }
        this.impl.clear();
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static interface Implementation {
        public boolean isDeviceSupported(AbstractGraphicsDevice var1);

        public Resource createSharedResource(AbstractGraphicsDevice var1);

        public void releaseSharedResource(Resource var1);

        public void clear();

        public Resource mapPut(AbstractGraphicsDevice var1, Resource var2);

        public Resource mapGet(AbstractGraphicsDevice var1);

        public Collection<Resource> mapValues();
    }

    public static interface Resource {
        public boolean isAvailable();

        public AbstractGraphicsDevice getDevice();

        public AbstractGraphicsScreen getScreen();

        public GLDrawableImpl getDrawable();

        public GLContextImpl getContext();

        public GLRendererQuirks getRendererQuirks(GLProfile var1);
    }
}

