# RiboSketch: An Interactive RNA and DNA Secondary Structure Visualization Application #

## What is RiboSketch? ##
* RiboSketch is a drawing program for the production of RNA and DNA secondary structure images.
* The user provides an input file (.ct, .bpseq, .dbn, or the native save file type .rs) containing the sequence and base-pairing of the strand(s).
* RiboSketch works with structures composed of multiple strands, non-canonical interactions, hybrid RNA-DNA base-pairing, pseudoknots, and interstrand interactions.
* The program can create automatic layouts and circle diagrams, and/or simulate forces between nucleotides.
* RiboSketch enables the user to manipulate the structure and aesthetics of the model with precise and practical commands.
* The user may save the state of the program and load previous save-states.
* Actions may be undone and redone.

## Where can I get the program? ##
* Available at https://binkley2.ncifcrf.gov/users/bindewae/ribosketch_web/

# Using the Program #
* Load a secondary structure file (you can add additional bonds and non-canonicals once in the program)
* Default start state is the “Radial Layout”.
* Mouse over the top of the screen to access the MENU and to view COMMANDS.

## Mouse Commands ##
* Click on (or drag a selection box over) bases to select them. Hold shift to multi-select, or toggle the selection of bases.
* Click and drag selected nucleotides to move them
* To select individual nucleotides, hold ALT/OPTION and click.
* To select one half of a helix, you can either:
	1. Select the helix, then shift click on the side you don't want to unselect it.
	2. Click and drag a selection box over one side of the helix.
* ROTATION: “m” rotates clockwise about the mouse cursor, “n” counterclockwise. Hold shift to rotate with a smaller angle.

## GUI Features ##
### Sliders ###
* Base Size: Size of nucleotides
* Bond Length: Distance between base-paired nucleotides
* Chain Length: Effective only during simulation mode, controls distance between adjacent nucleotides
* Color Scheme: “Pastel”, “White”, "Light", “Bright”, “Grey"
  Special color schemes:
    “Base Type” (Each base type gets its own color),
    “Rainbow” (Each individual base gets its own color),
    “Structure” (Paired bases: Yellow,  Unpaired: Blue),
    “Custom” (Based on user input number values)

### Buttons ###
* Save: Writes state of program into a text file (.rs), which can be loaded into RiboSketch.
* Load File: Read a new secondary structure file into the program.
* Load Bonds: Add new bonds from a text file of comma-separated entries “firstID secondID bondType”
  Example:  3 20 cWW, 4 19 tHS, 6 30 cSS
* Load Colors: Color nucleotides based on a space-separated list of numbers (probing data) from a text file.
* Radial Layout: Position nucleotides with the NAView algorithm, expanded to accommodate multiple strands and pseudoknots.
* Circle Layout: Nucleotides are positioned in a circle with base pairs drawn as chords.
* Simulation Mode: Apply forces.
* Sim. Selected Mode: Only apply forces to selected nucleotides.
* Rigid Helices: Enforce right angles for helices.
* Rigid Loops: Circularize loops and straighten stems.
* Rigid Hairpins: Circularize hairpin loops. Only has effect when Rigid Loops is OFF.
* Zoom Reset: Return zoom to default.
* Outlines: Toggle drawing circles around nucleotides.
* Labels: Display numbering for every tenth nucleotide.
* PNG Screenshot: Saves a screen image to the folder of the input file.
* SVG Screenshot: Saves an SVG file of the screen to the folder of the input file.


## Keyboard Commands ##
### Editing ###
* ROTATION: “m” rotates clockwise about the mouse cursor, “n” counterclockwise. Hold shift to rotate with a smaller angle.
* "z": UNDO. Shift-Z to REDO.
* "s": Turn on SIMULATION MODE (forces)
* "S": Toggle the SIMULATION MODE to apply forces to selected nucleotides only or all nucleotides.
* "r": RELAX FORCES for selected nucleotides. Effective only in Simulation mode.
* “f”: FLIP the halves of a selected helix.
* “x” or “y”: Flips the selected bases over the X or Y-axis.

### Display ###
* \+ / -  : Zooms the screen in or out
* 0      : Resets the view scale
* Arrows : When no nucletodies are selected, the arrow keys translate the window view.
* 1 / 2  : Brings the selected bases to the front or back, akin to Powerpoint
* b / B  : Base SIZE +/-  (Same as slider)
* o      : Toggle OUTLINE
* i      : Toggle LETTERS
* l      : Toggle LABELS  (Same as button)
* k      : View base number in secondary file
* v      : Toggle ANNOTATIONS (5' and 3', strand number)
* c      : Changes the color scheme of the nucleotides
* p      : Saves a PNG SCREENSHOT (Same as the button)


## Adding/Deleting Bonds ##
* Adding: Hold Spacebar, click first base, click second base.
* Click "Load Bonds" button to add non-canonical interactions through text input (Ex: 3 25 cWW, 8 12 tHS)
* Deleting: Hold "d", click a base to delete its bonds.


# Questions? Contact: #
* Jacob Lu (stickydot@gmail.com)
* Eckart Bindewald (eckart@mail.nih.gov)


## Developers Note: How to edit RiboSketch ##
* Make changes to Processing pde files or the HTML files templateHead.txt and templateTail.txt
* Always generate the ribosketch.html file for the browser version by calling "./generateHtml.sh"