class DisplaySettings {
  static final int COLOR_MODE_FEW = 1; // from Stephen Few's book "Show Me The Numbers"
  static final int COLOR_MODE_WHITE = 2;
  static final int COLOR_MODE_RESIDUE = 3;
  static final int COLOR_MODE_STRUCTURE = 4;
  static final int COLOR_MODE_RAINBOW = 7;
  static final int COLOR_MODE_LIGHT = 5;
  static final int COLOR_MODE_BYG = 6;
  static final int COLOR_MODE_GREY = 8;
  static final int COLOR_MODE_RNADNA = 9; // distinguish RNA and DNA
  static final int COLOR_MODE_CUSTOM = 10;
  static final int COLOR_MODE_MAX = 11; // +1
  int colorMode = 1;
  // RGB values from Show Me the Numbers from Stephen Few:
  // 4D4D4D (gray)
  // 5DA5DA (blue)
  // FAA43A (orange)
  // 60BD68 (green)
  // F17CB0 (pink)
  // B2912F (brown)
  // B276B2 (purple)
  // DECF3F (yellow)
  // F15854 (red)
  color GUIColor = #38B2E8; //#38B2E8 //#42C6D3
  int colorMax = 360; // For color mode

  color bpCol = #1502CE; // Color of pair line
  float bpWeight = 1.5; // Weight of pair line
  color bbCol = #000000; // Backbone color
  float bbWeight = 2.25; // Backbone weight

  double radiusShowMul = 2.25;

  //color[] customColors;
  color startGradient = #FFFFFF; //#00FFFF; // Teal
  color endGradient = #FF0000; // Red

  boolean labelMode = true;
  boolean textMode = true;
  boolean outlineMode = true;
  boolean displayStrandInfo = false;
  float textReduction = 0.8;
  float textOffsX = -0.3;
  float textOffsY = 0.3;

  static final int MENU_APPEAR_X = 100;
  static final int MENU_APPEAR_Y = 60;
  float helpX = 20.0;
  color textCol = #000000;
  float helpTextSize = 13.2;

  float messageX = screenResX/3.0;
  float messageY = 50;
  float messageFontSize = 20.0;

  float labelWeight = 5; // Width of label line
  color highlightCol = #FFFF00; // Hightlight color
  double highlightMul = 1.5; // Size increase of selected residues

  float menuTextSize = 13.7;
  float sliderLabelWidth = 100;
  float sliderWidth = 300;
  float sliderHeight = 10;
  float sliderGap = 50;
  float sliderLabelX = (width / 2.0) - (sliderLabelWidth + sliderWidth + sliderGap/2.0); // layout of slider table

  float zoomFactor = 1.0; // for global zoom function
  float zoomMul = 1.1; // factor for zooming and and out
  float zoomTranslateX = 0.0; // translate view before applying scale
  float zoomTranslateY = 0.0; //

  double startPadding = 20;
  double padding = startPadding;
  double paddingScale = 250;

  /** Apply zoom factor "mul". Typical values: zoomMul (1.5) or 1/zoomMul
   */
   // DERIVATION:
   // we want that AbsMouseX(screenResX/2) remains unchanged!
   //    (mx - ds.zoomTranslateXorig)/ds.zoomFactorOrig == (mx - ds.zoomTranslateXorigNew)/ds.zoomFactorNew;
   // ds.zoomFactorNew = ds.zoomFactor*1.5
   //    (mx - ds.zoomTranslateXorig)/ds.zoomFactorOrig == (mx - ds.zoomTranslateXorigNew)/(1.5*ds.zoomFactorOrig);
   //    mx - ds.zoomTranslateXorig == (mx - ds.zoomTranslateXorigNew)/1.5;
   //    1.5*(mx - ds.zoomTranslateXorig) == mx - ds.zoomTranslateXorigNew;
   // ds.zoomTranslateXNew = mx - 1.5 * (mx - ds.zoomTranslateXorig)
   // ds.zoomTranslateXNew = (1-1.5)*mx + 1.5 * ds.zoomTranslateXorig
   // mx = screenResX/2
   // ds.zoomTranslateXNew = (1-1.5)*(screenResX/2) + 1.5 * ds.zoomTranslateXorig
   // ds.zoomFactor *= ds.zoomMul;
   // ds.zoomTranslateX = (1-ds.zoomMul)*(screenResX/2) + ds.zoomMul * ds.zoomTranslateX;
   // ds.zoomTranslateY = (1-ds.zoomMul)*(screenResY/2) + ds.zoomMul * ds.zoomTranslateY;
   
  void applyZoom(float mul) {
   zoomFactor *= mul;
   zoomTranslateX = (1-mul)*(screenResX/2) + mul * ds.zoomTranslateX;
   zoomTranslateY = (1-mul)*(screenResY/2) + mul * ds.zoomTranslateY;
  }

  void resetZoom() {
    zoomFactor = 1.0;
    zoomTranslateX = 0.0;
    zoomTranslateY = 0.0;
    // println("Zoom values after reset: " + zoomFactor + " " + zoomTranslateX + " " + zoomTranslateY);
  }
}
