/*
 * Decompiled with CFR 0.152.
 */
import de.bezier.guido.Interactive;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;
import processing.event.KeyEvent;

public class ribosketch
extends PApplet {
    final boolean BROWSER = false;
    boolean debugPrints = false;
    File userFile;
    DrawClass drawer = new DrawClass();
    String outputDir = "ribosketch_images";
    int pushedMatrices = 0;
    float zoomFactorSave = 1.0f;
    float zoomTranslateXSave = 0.0f;
    float zoomTranslateYSave = 0.0f;
    float cmx = 0.0f;
    float cmy = 0.0f;
    ArrayList<String> globalMessages = new ArrayList();
    ArrayList<SimulationState> undoStates = new ArrayList();
    int undoId = -1;
    HashMap<Integer, Integer> attachedIds = new HashMap();
    String picInfo = "(saved to folder of input file)";
    HashMap<String, String> helpCommands = new HashMap();
    String[] helpLines = new String[]{"Area-Select", "Multi-Select", "Select single base", "Select/Deselect All", "", "Move", "", "Rotation (Around Cursor):", "Clockwise (Large/ Small)", "Counter-Clockwise (Large/ Small)", "", "Undo / Redo", "Add Bond", "Delete Bond", "", "Simulation (Toggle)", "Simulate Selected only (Toggle)", "Scroll Screen", "Zoom In / Out", "Zoom Reset", "Relax Selected Bonds (Toggle)", "Flip helix strands", "Flip over X-axis / Y-axis", "Bring to Front / Send to Back", "Base Size +/-", "Base Characters (Toggle)", "Base Labels (Toggle)", "Base Information (Toggle)", "Annotations (Toggle)", "Change Color Mode", "PNG Screenshot", this.picInfo};
    String[] sliderNames = new String[]{"Base Size", "Bond Length", "Chain Length", "Color Scheme"};
    String[] checkBoxNames = new String[]{"Save", "Load File", "Load Bonds", "Load Colors", "Radial Layout", "Circle Layout", "Simulation Mode", "Sim. Selected Only", "Rigid Helices", "Rigid Loops", "Rigid Hairpins", "Zoom Reset", "Outlines", "Labels", "PNG Screenshot", "SVG Screenshot"};
    HashMap<String, CheckBox> checkBoxes = new HashMap(this.checkBoxNames.length);
    Slider[] sliders = new Slider[this.sliderNames.length];
    Listbox fileTypeSelector;
    int displaySelectorId;
    int textDisplayCount = 10000;
    String textDisplay = "";
    boolean menuVisible = false;
    boolean simulationMode = false;
    boolean simulateAllMode = true;
    boolean simWasOn = false;
    boolean rigidHelices = true;
    boolean rigidHairpins;
    boolean wasRigidHairpins = this.rigidHairpins = true;
    boolean rigidLoops;
    boolean wasRigidLoops = this.rigidLoops = true;
    boolean screenshot = false;
    int screenshotFormat = 2;
    boolean capturingScreen = false;
    boolean viewingBase = false;
    boolean checkLengthForRigidLoops = true;
    boolean selectingFileType = false;
    boolean runningSimulation = false;
    String errorMessage = "";
    boolean returnToSim = false;
    boolean clickCheck = false;
    boolean programLaunch = true;
    SimulationState currentState;
    ForceField ff;
    DisplaySettings ds;
    float helpY;
    float menuLimitY;
    float sliderMenuHeight;
    float sliderMenuWidth;
    float checkBoxWidth;
    float screenResX = 1200.0f;
    float screenResY = 750.0f;
    JavaScript javascript;
    float mouseXMark = -1.0f;
    float mouseYMark = -1.0f;
    boolean multiSelecting = false;
    boolean dragging = false;
    int dragId = -1;
    int pressTime;
    int bondSphereId = -1;
    boolean addingBond = false;
    boolean deletingBond = false;
    String radialAlgorithmException = "";

    public void setup() {
        this.surface.setResizable(true);
        this.ff = new ForceField();
        this.ds = new DisplaySettings();
        Interactive.make((PApplet)this);
        float yMax = 0.0f;
        int i = 0;
        while (i < this.sliderNames.length) {
            float x = this.ds.sliderLabelX;
            float y = (float)(i + 1) * this.ds.sliderHeight;
            if (i % 2 == 1) {
                x += this.ds.sliderWidth + this.ds.sliderLabelWidth + this.ds.sliderGap;
                y -= this.ds.sliderHeight;
            }
            this.sliders[i] = new Slider(x, y, this.ds.sliderWidth, this.ds.sliderHeight, this.sliderNames[i], this.ds.sliderLabelWidth, i);
            yMax = y + 2.5f * this.ds.sliderHeight;
            ++i;
        }
        int sliderLines = ribosketch.floor((float)((this.sliders.length + 1) / 2));
        this.sliderMenuHeight = (float)sliderLines * this.ds.sliderHeight + (float)(sliderLines - 1) * this.ds.sliderHeight + 10.0f;
        this.drawer.TextSize(this.ds.menuTextSize);
        int i2 = 0;
        while (i2 < this.checkBoxNames.length) {
            float x = this.ds.sliderLabelX;
            float y = yMax + (float)(i2 / 4) * 2.5f * this.ds.sliderHeight;
            if (i2 % 4 == 1) {
                x += (this.ds.sliderWidth + this.ds.sliderLabelWidth + this.ds.sliderGap) / 2.0f;
            } else if (i2 % 4 == 2) {
                x += this.ds.sliderWidth + this.ds.sliderLabelWidth + this.ds.sliderGap;
            } else if (i2 % 4 == 3) {
                x += (this.ds.sliderWidth + this.ds.sliderLabelWidth + this.ds.sliderGap) * 1.5f;
            }
            if (this.debugPrints) {
                ribosketch.println((String)("Creating CheckBox " + this.checkBoxNames[i2] + ",  x: " + x + "  y: " + y));
            }
            if ("Save".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new SaveCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("Load File".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new LoadCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("Load Bonds".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new BasePairLoadCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("Load Colors".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new ColorLoadCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("Radial Layout".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new ResetRadialCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("Circle Layout".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new ResetCircleCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("Simulation Mode".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new MovementCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("Rigid Helices".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new RigidHelixCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("Labels".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new LabelCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("PNG Screenshot".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new SnapCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("SVG Screenshot".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new SnapSVGCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2]), (int)this.screenResX, (int)this.screenResY));
            } else if ("Outlines".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new OutlineCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("Rigid Hairpins".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new RigidHairpinsCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("Sim. Selected Only".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new SimulateAllCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("Zoom Reset".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new ZoomResetBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            } else if ("Rigid Loops".equals(this.checkBoxNames[i2])) {
                this.checkBoxes.put(this.checkBoxNames[i2], new RigidLoopsCheckBox(this.checkBoxNames[i2], x, y, 15.0f, this.ds.sliderHeight, this.textWidth(this.checkBoxNames[i2])));
            }
            if (i2 == this.checkBoxNames.length - 1) {
                this.menuLimitY = y + 1.25f * this.ds.sliderHeight;
            }
            ++i2;
        }
        this.menuLimitY += 15.0f;
        this.helpY = this.menuLimitY + 5.0f;
        this.checkBoxWidth = (this.ds.sliderWidth + this.ds.sliderLabelWidth + this.ds.sliderGap) * 1.5f + this.ds.sliderLabelWidth + 15.0f;
        this.sliderMenuWidth = (this.ds.sliderLabelWidth + this.ds.sliderWidth) * 2.0f + this.ds.sliderGap + 10.0f;
        if (this.debugPrints) {
            ribosketch.println((String)("ds.menuLimitY: " + this.menuLimitY));
        }
        this.helpCommands.put("Area-Select", "Click and Drag");
        this.helpCommands.put("Multi-Select", "Hold SHIFT while selecting");
        this.helpCommands.put("Select single base", "Alt-Click");
        this.helpCommands.put("Select/Deselect All", "a");
        this.helpCommands.put("Move", "Select, & Drag or Arrow Keys");
        this.helpCommands.put("Clockwise (Large/ Small)", "m / M");
        this.helpCommands.put("Counter-Clockwise (Large/ Small)", "n / N");
        this.helpCommands.put("Undo / Redo", "z / Z");
        this.helpCommands.put("Simulation (Toggle)", "s");
        this.helpCommands.put("Simulate Selected only (Toggle)", "S");
        this.helpCommands.put("Add Bond", "Hold SPACE & Click 2 Bases");
        this.helpCommands.put("Delete Bond", "Hold d & Click Base");
        this.helpCommands.put("Flip helix strands", "f");
        this.helpCommands.put("Flip over X-axis / Y-axis", "x / y");
        this.helpCommands.put("Bring to Front / Send to Back", "1 / 2");
        this.helpCommands.put("Relax Selected Bonds (Toggle)", "r");
        this.helpCommands.put("Base Size +/-", "b / B");
        this.helpCommands.put("Base Characters (Toggle)", "i");
        this.helpCommands.put("Base Labels (Toggle)", "l");
        this.helpCommands.put("Base Information (Toggle)", "k");
        this.helpCommands.put("Annotations (Toggle)", "v");
        this.helpCommands.put("Change Color Mode", "c");
        this.helpCommands.put("Scroll Screen", "Deselect All, & Arrow Keys");
        this.helpCommands.put("Zoom In / Out", "+ / -");
        this.helpCommands.put("Zoom Reset", "0");
        this.helpCommands.put("PNG Screenshot", "p");
        this.drawer.TextSize(14.0f);
        this.colorMode(3, this.ds.colorMax);
        this.selectInput("Select a file to load", "fileSelected");
    }

    public void fileSelected(File selection) {
        if (selection == null) {
            ribosketch.println((String)"Window was closed or the user hit cancel.");
        } else {
            ribosketch.println((String)("User selected file " + selection.getAbsolutePath()));
            this.userFile = selection;
            this.outputDir = this.userFile.getParentFile().getAbsolutePath();
            this.setupState(selection.getAbsolutePath());
        }
    }

    public void setupState(String fileName) {
        this.setupState(fileName, null);
    }

    public void setupState() {
        this.setupState(null, null);
    }

    public void setupState(String fileName, String fileType) {
        SimulationSetup sim = new SimulationSetup();
        SimulationState tempState = sim.initFile(fileName, fileType);
        this.errorMessage = sim.errorMessage;
        this.cursor(3);
        if (this.errorMessage.equals("")) {
            this.currentState = tempState;
            if (this.checkLengthForRigidLoops && this.currentState.spheres.size() > 1000) {
                this.rigidLoops = false;
                this.checkBoxes.get((Object)"Rigid Loops").checked = false;
            } else {
                this.checkLengthForRigidLoops = true;
            }
            this.undoStates.clear();
            this.undoId = -1;
            this.attachedIds.clear();
            this.updateGUI();
            this.runningSimulation = true;
            this.menuVisible = true;
            if (!"RADIAL LAYOUT".equals(this.textDisplay) && !"SAVE FILE LOADED".equals(this.textDisplay)) {
                this.textDisplay = "";
            }
            this.textDisplayCount = 0;
            this.saveStateForUndo();
        } else {
            this.errorMessage = String.valueOf(this.errorMessage) + "\n" + sim.warningMessage;
            this.errorMessage = String.valueOf(this.errorMessage) + "\n***MAKE SURE YOUR FILE HAS THE CORRECT EXTENSION (.ct, .dbn, .bpseq, .rs)***\n";
            this.errorMessage = String.valueOf(this.errorMessage) + "\n\n***HOW TO FORMAT A DBN FILE***\n  1st line: string of characters representing sequences with either \"&\" or space seperating strands\n  2nd line: brackets representing pairs, or dots representing unpaired bases\n\n~~EXAMPLE~~\n  GGGGUAA&AACCCCUUG\n  ((((.[[&..))))]].\n\n\n\n***HOW TO FORMAT A CT OR BPSEQ FILE***\n  Lines preceded by \"#\" and empty lines are ignored.\n  If you have multiple strands in a ct file, the first line before the data should be a header line,\n  or the file should be formatted such that the line for each residue that begins a new strand has 0 as its 3rd column.\n  (bpseq files with multiple strands must use the header format)\n\n~~HEADER FORMAT (A line of space separated numbers before the structure info)~~\n  First number: Total number of bases\n  Second: Number of strands\n  Third: Start index of strand 1 (always 1)\n  Next n numbers: Start of strand 2, strand 3...\n\n~EXAMPLE HEADER for a structure with 150 bases,  3 strands,  1st strand starts with base #1,  2nd strand starts with base #40,  3rd with base #90~\n  150 3 1 40 90";
        }
        this.cursor(0);
    }

    public void updateGUI() {
        this.sliders[0].setValue((float)((this.ff.radius - this.ff.minRadius) / this.ff.radiusScale));
        this.sliders[1].setValue((float)((this.ff.bpDist - this.ff.minBpDist) / this.ff.bpDistScale));
        this.sliders[2].setValue((float)((this.ff.backboneDist - this.ff.minBackboneDist) / this.ff.backboneDistScale));
        this.sliders[3].setValue(((float)this.ds.colorMode - 1.0f) / 10.0f);
        this.checkBoxes.get((Object)"Labels").checked = this.ds.labelMode;
        this.checkBoxes.get((Object)"Simulation Mode").checked = this.simulationMode;
        this.checkBoxes.get((Object)"Rigid Helices").checked = this.rigidHelices;
    }

    public void draw() {
        this.mydraw();
    }

    public void mydraw() {
        this.drawer.clear();
        this.pushMatrix();
        this.globalMessages.clear();
        this.globalMessages.add("Menu");
        if (!this.runningSimulation) {
            this.menuVisible = false;
            if (this.selectingFileType) {
                this.background(-3552823);
                this.drawer.TextSize(16.0f);
                this.textAlign(37);
                String fileType = this.fileTypeSelector.lastItemClicked;
                if (fileType != null) {
                    this.text("File format " + fileType, 30.0f, 35.0f);
                }
                boolean aboveCancel = false;
                boolean aboveOk = false;
                if (this.height - 125 <= this.mouseY && this.mouseY <= this.height - 75) {
                    if ((float)this.width / 3.0f - 100.0f <= (float)this.mouseX && (float)this.mouseX <= (float)this.width / 3.0f + 100.0f) {
                        aboveCancel = true;
                    } else if ((float)(this.width * 2) / 3.0f - 100.0f <= (float)this.mouseX && (float)this.mouseX <= (float)(this.width * 2) / 3.0f + 100.0f) {
                        aboveOk = true;
                    }
                }
                if (aboveOk) {
                    this.strokeWeight(4.0f);
                    this.fill(-1875);
                } else {
                    this.strokeWeight(2.0f);
                    this.fill(-1);
                }
                this.stroke(this.ds.GUIColor);
                this.rectMode(3);
                this.rect((float)(this.width * 2) / 3.0f, this.height - 100, 200.0f, 50.0f, 10.0f);
                this.fill(-16777216);
                this.textAlign(3);
                this.drawer.TextSize(35.0f);
                this.text("OK", (float)(this.width * 2) / 3.0f, this.height - 85);
                if (aboveCancel) {
                    this.strokeWeight(4.0f);
                    this.fill(-1875);
                } else {
                    this.strokeWeight(2.0f);
                    this.fill(-1);
                }
                this.rectMode(3);
                this.rect((float)this.width / 3.0f, this.height - 100, 200.0f, 50.0f, 10.0f);
                this.fill(-16777216);
                this.text("CANCEL", (float)this.width / 3.0f, this.height - 85);
                if (this.mousePressed) {
                    this.clickCheck = true;
                } else if (this.clickCheck) {
                    this.clickCheck = false;
                    if (aboveCancel) {
                        this.selectingFileType = false;
                        this.errorMessage = "";
                        if (this.returnToSim) {
                            this.simulationMode = this.simWasOn;
                            this.runningSimulation = true;
                        }
                    } else if (aboveOk && this.fileTypeSelector.lastItemClicked != null) {
                        this.selectingFileType = false;
                        this.errorMessage = "";
                        this.setupState(this.userFile.getAbsolutePath(), this.fileTypeSelector.lastItemClicked);
                    }
                }
            } else if (!this.errorMessage.equals("")) {
                this.background(-3552823);
                this.strokeWeight(3.0f);
                this.stroke(-16733953);
                this.fill(-1);
                this.rectMode(0);
                this.rect(30.0f, 30.0f, this.width - 60, this.height - 60, 10.0f);
                this.fill(-16777216);
                this.drawer.TextSize(15.0f);
                this.textAlign(37);
                this.text(this.errorMessage, 50.0f, 50.0f, this.width - 100, this.height - 200);
                boolean aboveOk = false;
                if (this.height - 125 <= this.mouseY && this.mouseY <= this.height - 75 && (float)this.width / 2.0f - 50.0f <= (float)this.mouseX && (float)this.width / 2.0f + 50.0f >= (float)this.mouseX) {
                    aboveOk = true;
                }
                this.rectMode(3);
                int fc = aboveOk ? -1 : -16777216;
                this.fill(fc);
                this.rect((float)this.width / 2.0f, this.height - 100, 100.0f, 50.0f, 10.0f);
                fc = aboveOk ? -16777216 : -1;
                this.fill(fc);
                this.textAlign(3);
                this.drawer.TextSize(34.0f);
                this.text("OK", (float)this.width / 2.0f, this.height - 90);
                if (this.mousePressed) {
                    this.clickCheck = true;
                } else if (this.clickCheck) {
                    this.clickCheck = false;
                    this.errorMessage = "";
                    if (this.returnToSim) {
                        this.simulationMode = this.simWasOn;
                        this.runningSimulation = true;
                    } else {
                        this.selectInput("Select a file to load:", "fileSelected");
                    }
                }
            } else {
                int c;
                this.background(-1);
                this.fill(-1);
                this.strokeWeight(3.0f);
                this.stroke(-16733953);
                this.ellipse((float)this.width / 2.0f, (float)this.height / 2.0f, 900.0f, 400.0f);
                this.fill(-16777216);
                this.drawer.TextSize(100.0f);
                this.textAlign(3);
                this.text("RiboSketch", (float)this.width / 2.0f, (float)this.height / 2.0f + 20.0f);
                this.rectMode(3);
                if ((float)this.width / 2.0f - 110.0f <= (float)this.mouseX && (float)this.mouseX <= (float)this.width / 2.0f + 110.0f && (float)this.height * 0.68f - 25.0f <= (float)this.mouseY && (float)this.mouseY <= (float)this.height * 0.68f + 25.0f) {
                    this.fill(-1);
                    c = -16777216;
                } else {
                    this.fill(-16777216);
                    c = -1;
                }
                this.rect((float)this.width / 2.0f, (float)this.height * 0.68f, 220.0f, 50.0f, 10.0f);
                this.fill(c);
                this.drawer.TextSize(32.0f);
                this.text("Click to Load", (float)this.width / 2.0f, (float)this.height * 0.68f + 9.0f);
                if (this.mousePressed) {
                    this.clickCheck = true;
                } else if (this.clickCheck) {
                    this.clickCheck = false;
                    this.selectInput("Select a file to load:", "fileSelected");
                }
            }
        } else {
            if (!this.capturingScreen) {
                this.background(-1);
            }
            if ((float)this.mouseY > this.menuLimitY && this.menuVisible) {
                this.menuVisible = false;
                if (this.pushedMatrices > 0) {
                    this.popMatrix();
                    --this.pushedMatrices;
                    this.ds.zoomFactor = this.zoomFactorSave;
                    this.ds.zoomTranslateX = this.zoomTranslateXSave;
                    this.ds.zoomTranslateY = this.zoomTranslateYSave;
                }
                Slider[] sliderArray = this.sliders;
                int aboveOk = this.sliders.length;
                int fc = 0;
                while (fc < aboveOk) {
                    Slider slider = sliderArray[fc];
                    slider.isPressed = false;
                    ++fc;
                }
            } else if (!(this.menuVisible || this.mouseY >= 60 || this.mouseX >= 100 || this.multiSelecting || this.dragging)) {
                this.menuVisible = true;
                if (this.pushedMatrices == 0) {
                    this.pushMatrix();
                    ++this.pushedMatrices;
                    this.zoomFactorSave = this.ds.zoomFactor;
                    this.zoomTranslateXSave = this.ds.zoomTranslateX;
                    this.zoomTranslateYSave = this.ds.zoomTranslateY;
                    this.ds.zoomFactor = 1.0f;
                    this.ds.zoomTranslateX = 0.0f;
                    this.ds.zoomTranslateY = 0.0f;
                }
            }
            this.translate(this.ds.zoomTranslateX, this.ds.zoomTranslateY);
            if (this.ds.zoomFactor != 1.0f && !this.menuVisible) {
                this.scale(this.ds.zoomFactor);
            }
            if (this.multiSelecting && !this.capturingScreen) {
                float x = this.AbsMouseX(this.mouseX);
                float y = this.AbsMouseY(this.mouseY);
                this.stroke(-16777216);
                this.drawer.StrokeWeight(1.0f / this.ds.zoomFactor);
                this.drawer.Line(this.mouseXMark, this.mouseYMark, this.mouseXMark, y);
                this.drawer.Line(this.mouseXMark, y, x, y);
                this.drawer.Line(x, y, x, this.mouseYMark);
                this.drawer.Line(x, this.mouseYMark, this.mouseXMark, this.mouseYMark);
            }
            SphereList spheres = this.currentState.getSpheres();
            if (this.simulationMode) {
                PVector centerOfMass = spheres.computeCenterOfMass();
                this.cmx = centerOfMass.x;
                this.cmy = centerOfMass.y;
                spheres.update();
                if (this.rigidHelices || this.rigidHairpins) {
                    this.currentState.spheres.fixHelices();
                }
                if (this.rigidLoops) {
                    this.currentState.spheres.fixLoops();
                }
            }
            this.displayNonCanonicals();
            if (this.addingBond && this.bondSphereId >= 0 && !this.capturingScreen) {
                Sphere2D origS = spheres.get(this.bondSphereId);
                this.stroke(this.ds.bpCol);
                this.strokeWeight(3.0f);
                this.line((float)origS.x, (float)origS.y, this.AbsMouseX(this.mouseX), this.AbsMouseY(this.mouseY));
            }
            spheres.display();
            if (this.ds.labelMode) {
                spheres.displayLabels();
            }
            if (this.ds.displayStrandInfo) {
                spheres.displayInfo();
            }
            if (this.screenshot) {
                this.screenshot = false;
                switch (this.screenshotFormat) {
                    case 2: {
                        this.saveScreen(new File(this.outputDir));
                        break;
                    }
                    case 1: {
                        this.saveScreenSVGFile(new File(this.outputDir));
                        this.capturingScreen = false;
                        break;
                    }
                    default: {
                        ribosketch.println((String)"Internal error: Unknown image format");
                    }
                }
            }
            if (!this.capturingScreen) {
                int diff;
                if (this.menuVisible) {
                    this.fill(-1, (float)this.ds.colorMax / 1.5f);
                    this.noStroke();
                    this.rectMode(0);
                    this.rect(this.ds.sliderLabelX - this.ds.sliderLabelWidth - 5.0f, 5.0f, this.sliderMenuWidth, this.sliderMenuHeight);
                    this.rect(this.ds.sliderLabelX - 5.0f, this.sliderMenuHeight + 10.0f, this.checkBoxWidth, 90.0f);
                    this.rect(this.ds.helpX - 15.0f, this.helpY, this.ds.helpX + 275.0f, this.helpY + (float)this.helpLines.length * 14.2f);
                    String currentCommand = "";
                    int i = 0;
                    while (i < this.helpLines.length) {
                        this.fill(-16777216);
                        this.drawer.TextSize(this.ds.helpTextSize);
                        this.textAlign(37);
                        currentCommand = this.helpLines[i];
                        this.text(currentCommand, this.ds.helpX, this.helpY + 12.0f + (float)i * 1.4f * this.ds.helpTextSize);
                        if (this.helpCommands.containsKey(currentCommand)) {
                            this.textAlign(39);
                            this.text(this.helpCommands.get(currentCommand), this.ds.helpX + 270.0f, this.helpY + 12.0f + (float)i * 1.4f * this.ds.helpTextSize);
                        }
                        ++i;
                    }
                }
                if (this.addingBond) {
                    this.fill(this.ds.GUIColor);
                    this.textAlign(3);
                    int pulseNum = 40;
                    diff = pulseNum - this.frameCount % (pulseNum * 2);
                    if (diff < 0) {
                        diff *= -1;
                    }
                    this.drawer.TextSize(20.0f + (float)diff * 0.3f);
                    this.text("Click bonding base", (float)this.width / 2.0f, this.height - 100);
                } else if (this.keyPressed && " ".equals(ribosketch.str((char)this.key))) {
                    this.fill(this.ds.GUIColor);
                    this.textAlign(3);
                    int pulseNum = 40;
                    diff = pulseNum - this.frameCount % (pulseNum * 2);
                    if (diff < 0) {
                        diff *= -1;
                    }
                    this.drawer.TextSize(20.0f + (float)diff * 0.3f);
                    this.text("Click a base to add a bond", (float)this.width / 2.0f, this.height - 100);
                } else if (this.deletingBond) {
                    this.fill(-1564383);
                    this.textAlign(3);
                    int pulseNum = 40;
                    diff = pulseNum - this.frameCount % (pulseNum * 2);
                    if (diff < 0) {
                        diff *= -1;
                    }
                    this.drawer.TextSize(20.0f + (float)diff * 0.3f);
                    this.text("Click a base to delete bonds", (float)this.width / 2.0f, this.height - 100);
                } else if (this.viewingBase) {
                    double[] closestOutput = spheres.findClosest(this.AbsMouseX(this.mouseX), this.AbsMouseY(this.mouseY));
                    double closestD = closestOutput[1];
                    this.fill(this.ds.textCol);
                    if (closestD <= this.ds.radiusShowMul * this.ff.radius) {
                        int closestId = (int)closestOutput[0];
                        int sid = this.currentState.sim.seqIds[closestId];
                        int relId = closestId - this.currentState.sim.starts[sid];
                        String message = "Residue: " + this.currentState.sim.seqTot.charAt(closestId) + "  Abs. Index: " + (closestId + 1) + "  Strand: " + (sid + 1) + "  Strand-Relative Index: " + (relId + 1);
                        this.globalMessages.add(message);
                    }
                }
            }
        }
        this.popMatrix();
        if (this.textDisplayCount < 60) {
            this.fill(this.ds.GUIColor);
            this.textAlign(3);
            this.drawer.TextSize((float)(60 - this.textDisplayCount) * 0.5f + 60.0f);
            this.text(this.textDisplay, (float)this.width / 2.0f, (float)this.height / 2.0f);
            ++this.textDisplayCount;
            this.textAlign(37);
            this.fill(-16777216);
        }
        float amx = this.mouseX;
        float amy = this.mouseY;
        if (!this.menuVisible && !this.capturingScreen && this.globalMessages.size() > 0 && amx > 1.0f && amy > 1.0f && amx < (float)this.width && amy < (float)this.height) {
            this.drawer.TextSize(15.0f);
            this.textAlign(37);
            String msg = "";
            int i = 0;
            while (i < this.globalMessages.size()) {
                if (i > 0) {
                    msg = String.valueOf(msg) + " | ";
                }
                msg = String.valueOf(msg) + this.globalMessages.get(i);
                ++i;
            }
            this.fill(-16777216);
            this.textSize(20.0f);
            this.text(msg, 30.0f, 38.0f);
        }
    }

    public void saveScreen(File outputDirFile) {
        String str;
        if (outputDirFile == null) {
            outputDirFile = new File(".");
        }
        String basename = "ribosketch_out";
        if (this.userFile != null && (str = this.userFile.getName()).length() > 3 && str.contains(".")) {
            basename = str.substring(0, str.lastIndexOf(46));
        }
        String imageFile = String.valueOf(outputDirFile.getAbsolutePath()) + File.separator + basename + "_" + this.frameCount % 10000 + ".png";
        ribosketch.println((String)("Writing to image file " + imageFile));
        this.menuVisible = false;
        float scaleFactor = 4.0f;
        ribosketch.println((String)("Creating PNG graphics device with" + this.width * (int)scaleFactor + " x " + this.height * (int)scaleFactor));
        PGraphics hiRes = this.createGraphics(this.width * (int)scaleFactor, this.height * (int)scaleFactor);
        if (hiRes == null) {
            ribosketch.println((String)"Warning: cannot create PNG graphics device");
            return;
        }
        this.beginRecord(hiRes);
        hiRes.scale(scaleFactor);
        this.mydraw();
        this.endRecord();
        this.capturingScreen = false;
        hiRes.save(imageFile);
        this.menuVisible = false;
        this.textDisplayCount = 0;
        this.textDisplay = "PNG SCREENSHOT: " + imageFile;
    }

    public String saveScreenSVGFile(File folder) {
        if (folder == null) {
            return null;
        }
        if (!folder.isDirectory()) {
            return null;
        }
        String userFileName = this.userFile.getName();
        String fname = String.valueOf(userFileName.substring(0, userFileName.length() - 3)) + "_" + this.frameCount % 10000 + ".svg";
        String imageFile = String.valueOf(folder.getAbsolutePath()) + File.separator + fname;
        ribosketch.println((String)("Writing to image file " + imageFile));
        String[] svgStrings = this.drawer.toSVG();
        this.saveStrings(imageFile, svgStrings);
        this.textDisplayCount = 0;
        this.textDisplay = "SVG SCREENSHOT: " + imageFile;
        return imageFile;
    }

    public void saveStateForUndo() {
        int undoSize;
        if (this.debugPrints) {
            ribosketch.println((String)("\nSaving state for undo stack! undoId Before: " + this.undoId));
        }
        int i = undoSize = this.undoStates.size() - 1;
        while (i > this.undoId) {
            this.undoStates.remove(i);
            --i;
        }
        SimulationState undoSaveState = new SimulationState(this.currentState);
        this.undoStates.add(undoSaveState);
        this.undoId = this.undoStates.size() - 1;
        if (this.debugPrints) {
            ribosketch.println((String)("Id after: " + this.undoId + ", undoStates size: " + this.undoStates.size()));
        }
    }

    public void undoState() {
        if (this.debugPrints) {
            ribosketch.println((String)"Undoing");
        }
        if (this.undoStates.size() >= 2 && this.undoId >= 1) {
            --this.undoId;
            this.currentState = new SimulationState(this.undoStates.get(this.undoId));
            this.textDisplay = "UNDO";
            this.textDisplayCount = 0;
        } else if (this.debugPrints) {
            ribosketch.println((String)"No undo state available!");
        }
    }

    public void redoState() {
        if (this.debugPrints) {
            ribosketch.println((String)"Redoing");
        }
        if (this.undoStates.size() > 0 && this.undoStates.size() - 1 > this.undoId) {
            ++this.undoId;
            this.currentState = new SimulationState(this.undoStates.get(this.undoId));
            this.textDisplay = "REDO";
            this.textDisplayCount = 0;
        } else if (this.debugPrints) {
            ribosketch.println((String)"No redo state available!");
        }
    }

    public void displayNonCanonicals() {
        for (Map.Entry<String, String> nc : this.currentState.sim.nonCanonicals.entrySet()) {
            float p4y;
            float p4x;
            float p3y;
            float p3x;
            float p2y;
            float p2x;
            float p1y;
            float p1x;
            float midInnerSideY;
            float midInnerSideX;
            String edge2;
            String[] pair = nc.getKey().split(" ");
            Sphere2D s1 = this.currentState.spheres.get(PApplet.parseInt((String)pair[0]));
            Sphere2D s2 = this.currentState.spheres.get(PApplet.parseInt((String)pair[1]));
            this.drawer.Stroke(this.ds.bpCol);
            this.drawer.StrokeWeight(this.ds.bpWeight / this.ds.zoomFactor);
            this.drawer.Line((float)s1.x, (float)s1.y, (float)s2.x, (float)s2.y);
            String pairType = nc.getValue();
            int ncFill = "c".equals(pairType.substring(0, 1).toLowerCase()) ? this.ds.bpCol : -1;
            this.drawer.Fill(ncFill);
            float d = (float)s1.distance(s2);
            float dx = (float)(s2.x - s1.x);
            float dy = (float)(s2.y - s1.y);
            float dx0 = dx / d;
            float dy0 = dy / d;
            float midX = (float)(s1.x + s2.x) / 2.0f;
            float midY = (float)(s1.y + s2.y) / 2.0f;
            float symbolSide = d * 0.16f;
            if ((double)symbolSide > this.ff.radius * 2.0) {
                symbolSide = (float)(this.ff.radius * 2.0);
            }
            ArrayList<Float> xv = new ArrayList<Float>();
            ArrayList<Float> yv = new ArrayList<Float>();
            int i = 0;
            while (i < 4) {
                xv.add(Float.valueOf(0.0f));
                yv.add(Float.valueOf(0.0f));
                ++i;
            }
            float xOffset = dy0 * (symbolSide / 2.0f);
            float yOffset = -1.0f * dx0 * (symbolSide / 2.0f);
            String edge1 = pairType.substring(1, 2).toLowerCase();
            if (edge1.equals(edge2 = pairType.substring(2, 3).toLowerCase())) {
                float p3y2;
                float p3x2;
                if ("w".equals(edge1)) {
                    this.drawer.Ellipse(midX, midY, symbolSide, symbolSide);
                    continue;
                }
                float p1x2 = midX - symbolSide / 2.0f * dx0 + xOffset;
                float p1y2 = midY - symbolSide / 2.0f * dy0 + yOffset;
                float p2x2 = midX - symbolSide / 2.0f * dx0 - xOffset;
                float p2y2 = midY - symbolSide / 2.0f * dy0 - yOffset;
                if ("s".equals(edge1)) {
                    p3x2 = p1x2 + ribosketch.cos((float)(ribosketch.atan2((float)(-2.0f * yOffset), (float)(-2.0f * xOffset)) - 1.0471976f)) * symbolSide;
                    p3y2 = p1y2 + ribosketch.sin((float)(ribosketch.atan2((float)(-2.0f * yOffset), (float)(-2.0f * xOffset)) - 1.0471976f)) * symbolSide;
                    this.drawer.Triangle(p1x2, p1y2, p2x2, p2y2, p3x2, p3y2);
                    continue;
                }
                if (!"H".equals(edge1) && !"h".equals(edge1)) continue;
                p3x2 = p2x2 + symbolSide * dx0;
                p3y2 = p2y2 + symbolSide * dy0;
                float p4x2 = p1x2 + symbolSide * dx0;
                float p4y2 = p1y2 + symbolSide * dy0;
                xv.set(0, Float.valueOf(p1x2));
                xv.set(1, Float.valueOf(p2x2));
                xv.set(2, Float.valueOf(p3x2));
                xv.set(3, Float.valueOf(p4x2));
                yv.set(0, Float.valueOf(p1y2));
                yv.set(1, Float.valueOf(p2y2));
                yv.set(2, Float.valueOf(p3y2));
                yv.set(3, Float.valueOf(p4y2));
                this.drawer.Polygon(xv, yv);
                continue;
            }
            float gap = symbolSide * 0.2f;
            if ("w".equals(edge1)) {
                float s1midX = midX - (symbolSide / 2.0f + gap) * dx0;
                float s1midY = midY - (symbolSide / 2.0f + gap) * dy0;
                this.drawer.Ellipse(s1midX, s1midY, symbolSide, symbolSide);
            } else {
                midInnerSideX = midX - gap * dx0;
                midInnerSideY = midY - gap * dy0;
                p1x = midInnerSideX + xOffset;
                p1y = midInnerSideY + yOffset;
                p2x = midInnerSideX - xOffset;
                p2y = midInnerSideY - yOffset;
                if ("s".equals(edge1)) {
                    p3x = p2x - ribosketch.cos((float)(ribosketch.atan2((float)(-2.0f * yOffset), (float)(-2.0f * xOffset)) - 1.0471976f)) * symbolSide;
                    p3y = p2y - ribosketch.sin((float)(ribosketch.atan2((float)(-2.0f * yOffset), (float)(-2.0f * xOffset)) - 1.0471976f)) * symbolSide;
                    this.drawer.Triangle(p1x, p1y, p2x, p2y, p3x, p3y);
                } else {
                    if (!"h".equals(edge1)) continue;
                    p3x = p2x - symbolSide * dx0;
                    p3y = p2y - symbolSide * dy0;
                    p4x = p1x - symbolSide * dx0;
                    p4y = p1y - symbolSide * dy0;
                    xv.set(0, Float.valueOf(p1x));
                    xv.set(1, Float.valueOf(p2x));
                    xv.set(2, Float.valueOf(p3x));
                    xv.set(3, Float.valueOf(p4x));
                    yv.set(0, Float.valueOf(p1y));
                    yv.set(1, Float.valueOf(p2y));
                    yv.set(2, Float.valueOf(p3y));
                    yv.set(3, Float.valueOf(p4y));
                    this.drawer.Polygon(xv, yv);
                }
            }
            if ("w".equals(edge2)) {
                float s2midX = midX + (symbolSide / 2.0f + gap) * dx0;
                float s2midY = midY + (symbolSide / 2.0f + gap) * dy0;
                this.drawer.Ellipse(s2midX, s2midY, symbolSide, symbolSide);
                continue;
            }
            midInnerSideX = midX + gap * dx0;
            midInnerSideY = midY + gap * dy0;
            p1x = midInnerSideX + xOffset;
            p1y = midInnerSideY + yOffset;
            p2x = midInnerSideX - xOffset;
            p2y = midInnerSideY - yOffset;
            if ("s".equals(edge2)) {
                p3x = p1x + ribosketch.cos((float)(ribosketch.atan2((float)(-2.0f * yOffset), (float)(-2.0f * xOffset)) - 1.0471976f)) * symbolSide;
                p3y = p1y + ribosketch.sin((float)(ribosketch.atan2((float)(-2.0f * yOffset), (float)(-2.0f * xOffset)) - 1.0471976f)) * symbolSide;
                this.drawer.Triangle(p1x, p1y, p2x, p2y, p3x, p3y);
                continue;
            }
            if (!"h".equals(edge2)) continue;
            p3x = p2x + symbolSide * dx0;
            p3y = p2y + symbolSide * dy0;
            p4x = p1x + symbolSide * dx0;
            p4y = p1y + symbolSide * dy0;
            xv.set(0, Float.valueOf(p1x));
            xv.set(1, Float.valueOf(p2x));
            xv.set(2, Float.valueOf(p3x));
            xv.set(3, Float.valueOf(p4x));
            yv.set(0, Float.valueOf(p1y));
            yv.set(1, Float.valueOf(p2y));
            yv.set(2, Float.valueOf(p3y));
            yv.set(3, Float.valueOf(p4y));
            this.drawer.Polygon(xv, yv);
        }
    }

    public void resetCircle() {
        this.currentState.sim.initTables();
        SphereList spheres = this.currentState.getSpheres();
        this.currentState = this.currentState.sim.createCircleState(spheres);
        this.updateGUI();
        this.saveStateForUndo();
    }

    public void resetRadial() {
        this.currentState.sim.initTables();
        SphereList spheres = this.currentState.getSpheres();
        this.currentState = this.currentState.sim.createRadialState(spheres);
        this.updateGUI();
        this.saveStateForUndo();
    }

    public double normFunction(double dx, double dy, double dz) {
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double[] rotatedVector(double vx, double vy, double angle) {
        double len = this.normFunction(vx, vy, 0.0);
        double[] result = new double[2];
        if (len == 0.0) {
            vx = 1.0;
            vy = 0.0;
        }
        double ang = Math.atan2(vy, vx);
        double x = vx * Math.cos(ang += angle) - vy * Math.sin(ang);
        double y = vx * Math.sin(ang) + vy * Math.cos(ang);
        result[0] = x;
        result[1] = y;
        return result;
    }

    public void setNewPair(Sphere2D s1, Sphere2D s2, String type, SimulationSetup sim) {
        if (s1.id > s2.id) {
            this.setNewPair(s2, s1, type, sim);
            return;
        }
        int id1 = s1.id;
        int id2 = s2.id;
        boolean force = false;
        if (sim.pairTable[id1] == -1 && sim.pairTable[id2] == -1) {
            this.setForcePair(s1, s2, type, sim);
            sim.pairTable[id1] = (short)id2;
            sim.pairTable[id2] = (short)id1;
            force = true;
        }
        if (!"cWW".equals(type) || !force && (sim.pairTable[id1] != id2 || sim.pairTable[id2] != id1)) {
            sim.nonCanonicals.put(String.valueOf(id1) + " " + id2, type);
            if (!force) {
                s1.bonds[id2] = type;
                s2.bonds[id1] = type;
            }
        }
    }

    public void setForcePair(Sphere2D s1, Sphere2D s2, String type, SimulationSetup sim) {
        s1.pairedWForce = s2;
        s2.pairedWForce = s1;
        int id1 = s1.id;
        int id2 = s2.id;
        int sq1 = sim.seqIds[id1];
        int sq2 = sim.seqIds[id2];
        if (s1.fiveP != null && s2.threeP != null && s1.fiveP.pairedWForce == s2.threeP && sim.seqIds[id1 - 1] == sq1 && sim.seqIds[id2 + 1] == sq2) {
            s1.hasHelixUp = true;
            s2.hasHelixDown = true;
            s1.fiveP.hasHelixDown = true;
            s2.threeP.hasHelixUp = true;
        } else {
            s1.hasHelixUp = false;
            s2.hasHelixDown = false;
        }
        if (s1.threeP != null && s2.fiveP != null && s1.threeP.pairedWForce == s2.fiveP && sim.seqIds[id1 + 1] == sq1 && sim.seqIds[id2 - 1] == sq2) {
            s1.hasHelixDown = true;
            s2.hasHelixUp = true;
            s1.threeP.hasHelixUp = true;
            s2.fiveP.hasHelixDown = true;
        } else {
            s1.hasHelixDown = false;
            s2.hasHelixUp = false;
        }
        if (s1.threeP != null && s1.threeP.id == s2.id && s2.strandId == s1.strandId) {
            s1.hasHelixDown = false;
            s2.hasHelixUp = false;
        }
        s1.bonds[id2] = type;
        s2.bonds[id1] = type;
    }

    public void unsetForcePair(Sphere2D s1, Sphere2D s2) {
        if (s1 != null) {
            if (s1.hasHelixUp) {
                s1.fiveP.hasHelixDown = false;
            }
            if (s1.hasHelixDown) {
                s1.threeP.hasHelixUp = false;
            }
            s1.pairedWForce = null;
            s1.hasHelixUp = false;
            s1.hasHelixDown = false;
        }
        if (s2 != null) {
            if (s2.hasHelixDown) {
                s2.threeP.hasHelixUp = false;
            }
            if (s2.hasHelixUp) {
                s2.fiveP.hasHelixDown = false;
            }
            s2.pairedWForce = null;
            s2.hasHelixUp = false;
            s2.hasHelixDown = false;
        }
    }

    public double stringToDouble(String s) {
        if (!s.matches("[-+]?\\d*\\.?\\d*")) {
            if (this.debugPrints) {
                ribosketch.println((String)"NaN given to stringToDouble! Returning dummy value of 0!");
            }
            return 0.0;
        }
        double d = 0.0;
        String[] splitNum = ribosketch.split((String)s, (String)".");
        String beforeDec = splitNum[0];
        double mul = 1.0;
        int i = beforeDec.length();
        while (i > 0) {
            double num = PApplet.parseInt((String)beforeDec.substring(i - 1, i));
            d += num * mul;
            mul *= 10.0;
            --i;
        }
        if (splitNum.length > 1) {
            String afterDec = splitNum[1];
            mul = 0.1f;
            int i2 = 0;
            while (i2 < afterDec.length()) {
                double num = PApplet.parseInt((String)afterDec.substring(i2, i2 + 1));
                d += num * mul;
                mul /= 10.0;
                ++i2;
            }
        }
        if (beforeDec.length() > 0 && "-".equals(beforeDec.substring(0, 1))) {
            d *= -1.0;
        }
        return d;
    }

    public boolean stringToBoolean(String s) {
        return "true".equals(s) || "True".equals(s);
    }

    public String[] stringArrayClone(String[] orig) {
        String[] result = new String[orig.length];
        int i = 0;
        while (i < orig.length) {
            result[i] = orig[i];
            ++i;
        }
        return result;
    }

    public int[] intArrayClone(int[] orig) {
        int[] result = new int[orig.length];
        int i = 0;
        while (i < orig.length) {
            result[i] = orig[i];
            ++i;
        }
        return result;
    }

    public Short[] shortArrayClone(Short[] orig) {
        Short[] result = new Short[orig.length];
        int i = 0;
        while (i < orig.length) {
            result[i] = orig[i];
            ++i;
        }
        return result;
    }

    public float angleBetweenFunct(PVector v1, PVector v2) {
        double v2mag;
        if (v1.x == 0.0f && v1.y == 0.0f && v1.z == 0.0f) {
            return 0.0f;
        }
        if (v2.x == 0.0f && v2.y == 0.0f && v2.z == 0.0f) {
            return 0.0f;
        }
        double dot = v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
        double v1mag = Math.sqrt(v1.x * v1.x + v1.y * v1.y + v1.z * v1.z);
        double amt = dot / (v1mag * (v2mag = Math.sqrt(v2.x * v2.x + v2.y * v2.y + v2.z * v2.z)));
        if (amt <= -1.0) {
            return (float)Math.PI;
        }
        if (amt >= 1.0) {
            return 0.0f;
        }
        return (float)Math.acos(amt);
    }

    public void loadCalled() {
        if (this.runningSimulation) {
            this.saveStateForUndo();
            this.simWasOn = this.simulationMode;
            this.simulationMode = false;
            this.selectInput("Select a .ct, .bpseq, or .rs file to load", "loadFile");
        }
    }

    public void loadFile(File selection) {
        if (selection == null) {
            ribosketch.println((String)"Window was closed or the user hit cancel.");
            this.simulationMode = this.simWasOn;
        } else {
            this.multiSelecting = false;
            this.dragging = false;
            this.runningSimulation = false;
            this.userFile = selection;
            this.returnToSim = true;
            this.setupState(selection.getAbsolutePath());
        }
    }

    public void loadColorFile(File selection) {
        if (selection == null) {
            ribosketch.println((String)"Window was closed or the user hit cancel.");
        } else {
            this.loadColor(ribosketch.loadStrings((File)selection));
        }
    }

    public void loadColorBrowserCall() {
        if (this.javascript != null) {
            String rawInput = this.javascript.getTextInput("inputcolor");
            String[] rawInputLines = rawInput.trim().split("\\r\\n|\\n|\\r");
            this.loadColor(rawInputLines);
        } else {
            ribosketch.println((String)"javascript object is null in loadColorBrowserCall()");
        }
    }

    public void loadColor(String[] rawLines) {
        double minColor;
        ArrayList<Double> colorData = new ArrayList<Double>();
        boolean flag = false;
        String splitter = "\\s++";
        String[] stringArray = rawLines;
        int n = rawLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (flag) break;
            String[] line2 = line.trim().split(splitter);
            if (!"".equals(line2[0]) && !line2[0].trim().substring(0, 1).equals("#")) {
                String[] stringArray2 = line2;
                int n3 = line2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String number = stringArray2[n4];
                    if ((number = number.trim()).length() > 0 && number.substring(0, 1).equals("#")) break;
                    if (!number.matches("-?\\d+(\\.\\d+)?")) {
                        flag = true;
                        break;
                    }
                    colorData.add(this.stringToDouble(number));
                    ++n4;
                }
            }
            ++n2;
        }
        if (colorData.size() == 0) {
            this.textDisplay = "COLOR FILE IS EMPTY";
            this.textDisplayCount = 0;
            return;
        }
        if (this.currentState.spheres == null || colorData.size() > this.currentState.spheres.size()) {
            if (this.debugPrints) {
                ribosketch.println((String)"Warning: invalid color input. Should be a space or line seperated list of numbers, equal in length to the number of residues.");
                ribosketch.println((String)("Spheres size: " + this.currentState.spheres.size() + ", color size: " + colorData.size()));
            }
            this.textDisplay = "TOO MANY NUMBERS";
            this.textDisplayCount = 0;
            return;
        }
        double maxColor = minColor = ((Double)colorData.get(0)).doubleValue();
        for (Double number : colorData) {
            if (number < minColor) {
                minColor = number;
            }
            if (!(number > maxColor)) continue;
            maxColor = number;
        }
        double dist0 = 0.0 - minColor;
        int i = 0;
        int l = colorData.size();
        while (i < l) {
            double denominator = maxColor + dist0;
            float colorNum = denominator <= 0.0 ? 0.0f : (float)(((Double)colorData.get(i) + dist0) / denominator);
            if (colorNum < 0.001f) {
                colorNum = 0.0f;
            }
            this.currentState.spheres.get((int)i).baseColor = this.lerpColor(this.ds.startGradient, this.ds.endGradient, colorNum);
            this.currentState.spheres.get((int)i).colorNum = colorNum;
            ++i;
        }
        i = colorData.size();
        while (i < this.currentState.spheres.size()) {
            this.currentState.spheres.get((int)i).baseColor = this.lerpColor(this.ds.startGradient, this.ds.endGradient, 0.0f);
            this.currentState.spheres.get((int)i).colorNum = 0.0f;
            ++i;
        }
        this.ds.colorMode = 10;
        this.sliders[3].setValue(((float)this.ds.colorMode - 1.0f) / 10.0f);
        this.displayColorMode();
    }

    public void loadBondFile(File selection) {
        if (selection == null) {
            ribosketch.println((String)"Window was closed or the user hit cancel.");
        } else {
            this.loadBonds(ribosketch.loadStrings((File)selection));
        }
    }

    public void loadBondsBrowserCall() {
        if (this.javascript != null) {
            String rawInput = this.javascript.getTextInput("inputbonds");
            String[] rawInputLines = rawInput.trim().split("\\r\\n|\\n|\\r");
            this.loadBonds(rawInputLines);
        } else {
            ribosketch.println((String)"javascript object is null in loadBondsBrowserCall()");
        }
    }

    public void loadBonds(String[] rawLines) {
        HashMap inputPairs = new HashMap();
        boolean flag = false;
        this.textDisplay = "ERROR: ";
        SimulationSetup s = this.currentState.sim;
        String splitter = "\\s++";
        String[] stringArray = rawLines;
        int n = rawLines.length;
        int n2 = 0;
        block0: while (n2 < n) {
            String line = stringArray[n2];
            String[] pairs = line.trim().split(",");
            if (!"".equals(pairs[0]) && !pairs[0].trim().substring(0, 1).equals("#")) {
                String[] stringArray2 = pairs;
                int n3 = pairs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String pair = stringArray2[n4];
                    String[] entries = pair.trim().split(splitter);
                    if (entries.length < 2 || entries.length > 3 || !entries[0].matches("^\\d+$") || !entries[1].matches("^\\d+$")) {
                        flag = true;
                        break block0;
                    }
                    int id1 = PApplet.parseInt((String)entries[0]) - 1;
                    int id2 = PApplet.parseInt((String)entries[1]) - 1;
                    if (id1 < 0 || id1 >= s.lenTot || id2 < 0 || id2 >= s.lenTot) {
                        flag = true;
                        this.textDisplay = String.valueOf(this.textDisplay) + "ID OUT OF BOUNDS!";
                        break block0;
                    }
                    if (id1 == id2) {
                        flag = true;
                        this.textDisplay = String.valueOf(this.textDisplay) + "A BASE CANNOT PAIR WITH ITSELF!";
                        break block0;
                    }
                    if (id1 > id2) {
                        int tempId = id1;
                        id1 = id2;
                        id2 = tempId;
                    }
                    String type = "cWW";
                    if (entries.length == 3 && !"".equals(entries[2])) {
                        type = entries[2];
                    }
                    ArrayList<Integer> inputKey = new ArrayList<Integer>(2);
                    inputKey.add(id1);
                    inputKey.add(id2);
                    inputPairs.put(inputKey, type);
                    ++n4;
                }
            }
            ++n2;
        }
        if (this.debugPrints) {
            ribosketch.println((String)"\nNew non-canonicals:");
            for (Map.Entry nc : inputPairs.entrySet()) {
                ArrayList bases = (ArrayList)nc.getKey();
                ribosketch.println((String)(bases.get(0) + " " + bases.get(1) + " " + (String)nc.getValue()));
            }
        }
        if (!flag) {
            if (inputPairs.size() == 0) {
                this.textDisplay = "BOND FILE EMPTY";
            } else {
                for (Map.Entry nc : inputPairs.entrySet()) {
                    ArrayList bases = (ArrayList)nc.getKey();
                    this.setNewPair(this.currentState.spheres.get((Integer)bases.get(0)), this.currentState.spheres.get((Integer)bases.get(1)), (String)nc.getValue(), s);
                }
                this.textDisplay = "ADDED BONDS";
            }
        }
        this.textDisplayCount = 0;
    }

    public void saveStateBrowser() {
        String[] saveLines = this.currentState.writeSaveFile();
        this.javascript.saveFileBrowser(saveLines);
        this.textDisplay = "SAVED STATE TO BOX BELOW";
        this.textDisplayCount = 0;
    }

    public void saveSVGBrowser(String[] saveLines) {
        this.javascript.saveSVGBrowser(saveLines);
        this.textDisplay = "SAVED SVG IMAGE";
        this.textDisplayCount = 0;
    }

    public void saveFolderSelected(File selection) {
        if (selection == null) {
            return;
        }
        if (!selection.isDirectory()) {
            return;
        }
        try {
            File saveFile;
            String inputFileName;
            String fileBase = inputFileName = this.userFile.getName();
            int i = inputFileName.length();
            block2: while (i > 0) {
                if (".".equals(inputFileName.substring(i - 1, i))) {
                    fileBase = inputFileName.substring(0, i - 1);
                    if (!inputFileName.substring(i).equals("rs")) break;
                    int j = fileBase.length() - 5;
                    while (j > 0) {
                        if (inputFileName.substring(j, j + 5).equals("_save")) {
                            fileBase = inputFileName.substring(0, j);
                            break block2;
                        }
                        --j;
                    }
                    break;
                }
                --i;
            }
            int saveNum = 1;
            while (true) {
                String saveFileName = String.valueOf(fileBase) + "_save" + saveNum + ".rs";
                saveFile = new File(selection.getAbsolutePath(), saveFileName);
                if (!saveFile.exists()) break;
                ++saveNum;
            }
            this.simulationMode = this.simWasOn;
            String[] saveLines = this.currentState.writeSaveFile();
            PrintWriter output = this.createWriter(saveFile.getAbsolutePath());
            String[] stringArray = saveLines;
            int n = saveLines.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                output.println(s);
                ++n2;
            }
            output.flush();
            output.close();
            this.textDisplay = "STATE SAVED AS " + saveFile.getName();
            this.textDisplayCount = 0;
            this.surface.setTitle(saveFile.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.simulationMode = this.simWasOn;
            this.textDisplay = "COULD NOT SAVE";
            this.textDisplayCount = 0;
        }
    }

    public void bindJavaScript(JavaScript js) {
        this.javascript = js;
    }

    public void startBrowser() {
        if (this.javascript != null) {
            this.setupState();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (!this.runningSimulation) {
            return;
        }
        double angleUnit = 0.008726646192371845;
        double angleShift = 25.0;
        String keyS = ribosketch.str((char)this.key);
        SphereList spheres = this.currentState.getSpheres();
        if (keyS.equals("a")) {
            if (this.attachedIds.size() == this.currentState.sim.lenTot) {
                this.attachedIds.clear();
            } else {
                int i = 0;
                while (i < spheres.size()) {
                    this.attachedIds.put(i, 1);
                    ++i;
                }
            }
        } else if (keyS.equals("b")) {
            if (!this.sliders[0].isPressed) {
                this.ff.radius *= (double)1.1f;
                if (this.ff.radius > this.ff.minRadius + this.ff.radiusScale) {
                    this.ff.radius = this.ff.minRadius + this.ff.radiusScale;
                }
                this.sliders[0].setValue((float)((this.ff.radius - this.ff.minRadius) / this.ff.radiusScale));
            }
        } else if (keyS.equals("B")) {
            if (!this.sliders[0].isPressed) {
                this.ff.radius /= (double)1.1f;
                if (this.ff.radius < this.ff.minRadius) {
                    this.ff.radius = this.ff.minRadius;
                }
                this.sliders[0].setValue((float)((this.ff.radius - this.ff.minRadius) / this.ff.radiusScale));
            }
        } else if (keyS.equals("c")) {
            if (!this.sliders[3].isPressed) {
                ++this.ds.colorMode;
                if (this.ds.colorMode >= 11) {
                    this.ds.colorMode = 1;
                }
                this.displayColorMode();
                this.sliders[3].setValue(((float)this.ds.colorMode - 1.0f) / 10.0f);
            }
        } else if (keyS.equals("f")) {
            if (this.attachedIds.size() > 0) {
                this.saveStateForUndo();
                for (int id : this.attachedIds.keySet()) {
                    Sphere2D s1 = spheres.get(id);
                    if (s1.pairedWForce == null) continue;
                    Sphere2D s2 = s1.pairedWForce;
                    if (this.attachedIds.containsKey(s2.id) && s1.id > s2.id) continue;
                    double hx = s1.x;
                    double hy = s1.y;
                    s1.x = s2.x;
                    s1.y = s2.y;
                    s2.x = hx;
                    s2.y = hy;
                    s1.vx = 0.0;
                    s1.vy = 0.0;
                    s2.vx = 0.0;
                    s2.vy = 0.0;
                }
            }
        } else if (keyS.equals("l")) {
            this.ds.labelMode = !this.ds.labelMode;
            this.checkBoxes.get((Object)"Labels").checked = !this.checkBoxes.get((Object)"Labels").checked;
        } else if (keyS.equals("v")) {
            this.ds.displayStrandInfo = !this.ds.displayStrandInfo;
        } else if (keyS.equals("s")) {
            this.saveStateForUndo();
            this.simulationMode = !this.simulationMode;
            boolean bl = this.checkBoxes.get((Object)"Simulation Mode").checked = !this.checkBoxes.get((Object)"Simulation Mode").checked;
            if (!this.simulationMode) {
                this.textDisplay = "FREEZE";
                spheres.stopVelocities();
            } else {
                this.textDisplay = "UNFREEZE";
            }
            this.textDisplayCount = 0;
        } else if (keyS.equals("S")) {
            this.simulateAllMode = !this.simulateAllMode;
            this.checkBoxes.get((Object)"Sim. Selected Only").checked = !this.checkBoxes.get((Object)"Sim. Selected Only").checked;
            this.textDisplay = !this.simulateAllMode ? "SIMULATE SELECTED ONLY" : "SIMULATE ALL";
            this.textDisplayCount = 0;
        } else if (keyS.equals("i")) {
            this.ds.textMode = !this.ds.textMode;
        } else if (keyS.equals("o")) {
            this.ds.outlineMode = !this.ds.outlineMode;
            this.checkBoxes.get((Object)"Outlines").checked = !this.checkBoxes.get((Object)"Outlines").checked;
        } else if (keyS.equals("p")) {
            this.screenshot = true;
            this.capturingScreen = true;
        } else if (keyS.equals("z") || keyS.equals("Z")) {
            this.simulationMode = false;
            this.checkBoxes.get((Object)"Simulation Mode").checked = false;
            if (keyS.equals("z")) {
                this.undoState();
            } else {
                this.redoState();
            }
        } else if (keyS.equals("y")) {
            if (this.attachedIds.size() > 0) {
                this.saveStateForUndo();
                Iterator<Integer> it = this.attachedIds.keySet().iterator();
                while (it.hasNext()) {
                    Sphere2D sphere = spheres.get(it.next());
                    sphere.x = (double)this.width - sphere.x;
                    sphere.vx = 0.0;
                    sphere.vy = 0.0;
                }
            }
        } else if (keyS.equals("x")) {
            if (this.attachedIds.size() > 0) {
                this.saveStateForUndo();
                Iterator<Integer> it = this.attachedIds.keySet().iterator();
                while (it.hasNext()) {
                    Sphere2D sphere = spheres.get(it.next());
                    sphere.y = (double)this.height - sphere.y;
                    sphere.vx = 0.0;
                    sphere.vy = 0.0;
                }
            }
        } else if (this.key == '\uffff') {
            double keyShift = 18.0;
            double keyShiftZoom = 80.0;
            if (!this.menuVisible && this.attachedIds.size() == 0) {
                if (this.keyCode == 37) {
                    this.ds.zoomTranslateX = (float)((double)this.ds.zoomTranslateX + keyShiftZoom);
                } else if (this.keyCode == 39) {
                    this.ds.zoomTranslateX = (float)((double)this.ds.zoomTranslateX - keyShiftZoom);
                } else if (this.keyCode == 38) {
                    this.ds.zoomTranslateY = (float)((double)this.ds.zoomTranslateY + keyShiftZoom);
                } else if (this.keyCode == 40) {
                    this.ds.zoomTranslateY = (float)((double)this.ds.zoomTranslateY - keyShiftZoom);
                }
            } else if (this.keyCode == 37) {
                for (int id : this.attachedIds.keySet()) {
                    spheres.get((int)id).x -= keyShift;
                }
            } else if (this.keyCode == 39) {
                for (int id : this.attachedIds.keySet()) {
                    spheres.get((int)id).x += keyShift;
                }
            } else if (this.keyCode == 38) {
                for (int id : this.attachedIds.keySet()) {
                    spheres.get((int)id).y -= keyShift;
                }
            } else if (this.keyCode == 40) {
                for (int id : this.attachedIds.keySet()) {
                    spheres.get((int)id).y += keyShift;
                }
            }
        } else if (keyS.equals("n")) {
            for (int id : this.attachedIds.keySet()) {
                spheres.get(id).rotateSphere(-angleUnit * angleShift, this.AbsMouseX(this.mouseX), this.AbsMouseY(this.mouseY));
            }
        } else if (keyS.equals("m")) {
            for (int id : this.attachedIds.keySet()) {
                spheres.get(id).rotateSphere(angleUnit * angleShift, this.AbsMouseX(this.mouseX), this.AbsMouseY(this.mouseY));
            }
        } else if (keyS.equals("N")) {
            for (int id : this.attachedIds.keySet()) {
                spheres.get(id).rotateSphere(-angleUnit, this.AbsMouseX(this.mouseX), this.AbsMouseY(this.mouseY));
            }
        } else if (keyS.equals("M")) {
            for (int id : this.attachedIds.keySet()) {
                spheres.get(id).rotateSphere(angleUnit, this.AbsMouseX(this.mouseX), this.AbsMouseY(this.mouseY));
            }
        } else if (keyS.equals("r")) {
            this.saveStateForUndo();
            if (this.attachedIds.size() == 0) {
                spheres.relaxedIds.clear();
            } else {
                for (int id : this.attachedIds.keySet()) {
                    if (!spheres.relaxedIds.containsKey(id)) {
                        spheres.relaxedIds.put(id, 1);
                        spheres.get((int)id).vx = 0.0;
                        spheres.get((int)id).vy = 0.0;
                        continue;
                    }
                    spheres.relaxedIds.remove(id);
                }
            }
        } else if (keyS.equals("1")) {
            if (this.attachedIds.size() > 0) {
                this.saveStateForUndo();
                int index = 0;
                int i = 0;
                while (i < spheres.displayOrder.size()) {
                    if (this.attachedIds.containsKey(spheres.displayOrder.get(index))) {
                        int id = spheres.displayOrder.remove(index);
                        spheres.displayOrder.add(id);
                    } else {
                        ++index;
                    }
                    ++i;
                }
            }
        } else if (keyS.equals("2")) {
            if (this.attachedIds.size() > 0) {
                this.saveStateForUndo();
                int index = spheres.displayOrder.size() - 1;
                int i = 0;
                while (i < spheres.displayOrder.size()) {
                    if (this.attachedIds.containsKey(spheres.displayOrder.get(index))) {
                        int id = spheres.displayOrder.remove(index);
                        spheres.displayOrder.add(0, id);
                    } else {
                        --index;
                    }
                    ++i;
                }
            }
        } else if (keyS.equals("d")) {
            this.deletingBond = true;
            this.addingBond = false;
            this.bondSphereId = -1;
        } else if (keyS.equals(" ")) {
            this.deletingBond = false;
        } else if (keyS.equals("k")) {
            this.viewingBase = !this.viewingBase;
        } else if (!this.menuVisible && (keyS.equals("+") || keyS.equals("="))) {
            if (this.ds.zoomFactor < 16.0f) {
                this.ds.applyZoom(this.ds.zoomMul);
            }
        } else if (!this.menuVisible && keyS.equals("-")) {
            if (1.0f / this.ds.zoomFactor < 16.0f) {
                this.ds.applyZoom(1.0f / this.ds.zoomMul);
            }
        } else if (keyS.equals("0")) {
            this.ds.resetZoom();
        }
    }

    public void keyReleased() {
        if (this.addingBond) {
            this.addingBond = false;
            this.bondSphereId = -1;
        }
        if (this.deletingBond) {
            this.deletingBond = false;
        }
    }

    public void displayColorMode() {
        if (this.ds.colorMode == 1) {
            this.textDisplay = "PASTEL";
        } else if (this.ds.colorMode == 2) {
            this.textDisplay = "WHITE";
        } else if (this.ds.colorMode == 6) {
            this.textDisplay = "BRIGHT";
        } else if (this.ds.colorMode == 8) {
            this.textDisplay = "GREY";
        } else if (this.ds.colorMode == 7) {
            this.textDisplay = "RAINBOW";
        } else if (this.ds.colorMode == 3) {
            this.textDisplay = "BASE TYPE";
        } else if (this.ds.colorMode == 10) {
            this.textDisplay = "CUSTOM";
        } else if (this.ds.colorMode == 4) {
            this.textDisplay = "STRUCTURE";
        } else if (this.ds.colorMode == 5) {
            this.textDisplay = "LIGHT";
        } else if (this.ds.colorMode == 9) {
            this.textDisplay = "RNADNA";
        }
        this.textDisplayCount = 0;
    }

    public float AbsMouseX(float mx) {
        return (mx - this.ds.zoomTranslateX) / this.ds.zoomFactor;
    }

    public float AbsMouseY(float my) {
        return (my - this.ds.zoomTranslateY) / this.ds.zoomFactor;
    }

    public void mousePressed() {
        this.pressTime = this.millis();
        if (!this.runningSimulation) {
            return;
        }
        if (this.mouseButton == 37) {
            if (this.keyPressed && " ".equals(ribosketch.str((char)this.key)) && !this.deletingBond) {
                SphereList spheres = this.currentState.getSpheres();
                double[] closestOutput = spheres.findClosest(this.AbsMouseX(this.mouseX), this.AbsMouseY(this.mouseY));
                double closestD = closestOutput[1];
                if (closestD <= this.ds.radiusShowMul * this.ff.radius) {
                    int closestId = (int)closestOutput[0];
                    if (!this.addingBond) {
                        this.bondSphereId = closestId;
                        this.addingBond = true;
                    } else {
                        Sphere2D s1 = spheres.get(this.bondSphereId);
                        this.addingBond = false;
                        this.bondSphereId = -1;
                        this.saveStateForUndo();
                        this.setNewPair(s1, spheres.get(closestId), "cWW", this.currentState.sim);
                    }
                } else {
                    this.addingBond = false;
                    this.bondSphereId = -1;
                }
            } else if (!this.menuVisible) {
                SphereList spheres = this.currentState.getSpheres();
                double[] closestOutput = spheres.findClosest(this.AbsMouseX(this.mouseX), this.AbsMouseY(this.mouseY));
                int closest = (int)closestOutput[0];
                double closestD = closestOutput[1];
                if (closestD <= this.ff.radius * this.ds.radiusShowMul && this.attachedIds.containsKey(closest)) {
                    this.dragging = true;
                    this.dragId = closest;
                }
                if (!this.dragging) {
                    this.multiSelecting = true;
                    this.mouseXMark = this.AbsMouseX(this.mouseX);
                    this.mouseYMark = this.AbsMouseY(this.mouseY);
                }
            }
        }
        if (this.programLaunch) {
            this.programLaunch = false;
        }
    }

    public void mouseDragged() {
        if (!this.runningSimulation) {
            return;
        }
        if (this.dragging) {
            SphereList spheres = this.currentState.getSpheres();
            double dx = (double)this.AbsMouseX(this.mouseX) - spheres.get((int)this.dragId).x;
            double dy = (double)this.AbsMouseY(this.mouseY) - spheres.get((int)this.dragId).y;
            Iterator<Integer> it = this.attachedIds.keySet().iterator();
            while (it.hasNext()) {
                Sphere2D currentSphere = spheres.get(it.next());
                currentSphere.x += dx;
                currentSphere.y += dy;
            }
        }
    }

    public void mouseReleased() {
        int elapsedTime = this.millis() - this.pressTime;
        if (this.runningSimulation) {
            if (this.dragging) {
                this.dragging = false;
                this.saveStateForUndo();
            } else if (this.multiSelecting) {
                float help;
                this.multiSelecting = false;
                if (!this.keyPressed || this.key != '\uffff' || this.keyCode != 16 && this.keyCode != 18) {
                    this.attachedIds.clear();
                }
                SphereList spheres = this.currentState.getSpheres();
                float mouseXMark2 = this.AbsMouseX(this.mouseX);
                float mouseYMark2 = this.AbsMouseY(this.mouseY);
                if (mouseXMark2 < this.mouseXMark) {
                    help = this.mouseXMark;
                    this.mouseXMark = mouseXMark2;
                    mouseXMark2 = help;
                }
                if (mouseYMark2 < this.mouseYMark) {
                    help = this.mouseYMark;
                    this.mouseYMark = mouseYMark2;
                    mouseYMark2 = help;
                }
                int i = 0;
                while (i < spheres.size()) {
                    double x = spheres.get((int)i).x;
                    double y = spheres.get((int)i).y;
                    if (x >= (double)this.mouseXMark && x <= (double)mouseXMark2 && y >= (double)this.mouseYMark && y <= (double)mouseYMark2 && !this.attachedIds.containsKey(i)) {
                        this.attachedIds.put(i, 1);
                        if (!this.keyPressed || this.key != '\uffff' || this.keyCode != 18) {
                            Sphere2D sphere = spheres.get(i);
                            if (sphere.pairedWForce != null) {
                                Sphere2D s2 = sphere;
                                while (s2.hasHelixDown) {
                                    s2 = s2.threeP;
                                    if (this.attachedIds.containsKey(s2.id)) continue;
                                    this.attachedIds.put(s2.id, 1);
                                }
                                s2 = sphere;
                                while (s2.hasHelixUp) {
                                    s2 = s2.fiveP;
                                    if (this.attachedIds.containsKey(s2.id)) continue;
                                    this.attachedIds.put(s2.id, 1);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            Slider[] sliderArray = this.sliders;
            int n = this.sliders.length;
            int n2 = 0;
            while (n2 < n) {
                Slider slider = sliderArray[n2];
                slider.isPressed = false;
                ++n2;
            }
        }
        if (elapsedTime < 170) {
            this.mouseClickedFunction();
        }
    }

    public void mouseClickedFunction() {
        if (this.runningSimulation && this.mouseButton == 37 && !this.menuVisible && !this.addingBond) {
            SphereList spheres = this.currentState.getSpheres();
            double[] closestOutput = spheres.findClosest(this.AbsMouseX(this.mouseX), this.AbsMouseY(this.mouseY));
            int closest = (int)closestOutput[0];
            double closestD = closestOutput[1];
            if (this.deletingBond) {
                if (closestD <= this.ds.radiusShowMul * this.ff.radius) {
                    this.saveStateForUndo();
                    Sphere2D sphereD = spheres.get(closest);
                    short pairId = this.currentState.sim.pairTable[sphereD.id];
                    if (pairId >= 0) {
                        this.currentState.sim.pairTable[sphereD.id] = -1;
                        this.currentState.sim.pairTable[pairId] = -1;
                    }
                    this.unsetForcePair(sphereD, sphereD.pairedWForce);
                    int i = 0;
                    while (i < sphereD.bonds.length) {
                        String bond = sphereD.bonds[i];
                        if (bond != null && !"".equals(bond)) {
                            sphereD.bonds[i] = null;
                            spheres.get((int)i).bonds[closest] = null;
                            String ncKey = closest < i ? String.valueOf(closest) + " " + i : String.valueOf(i) + " " + closest;
                            this.currentState.sim.nonCanonicals.remove(ncKey);
                        }
                        ++i;
                    }
                }
            } else if (this.attachedIds.size() == 0 && closestD <= 15.0 || closestD <= this.ds.radiusShowMul * this.ff.radius) {
                Sphere2D sphere = spheres.get(closest);
                if (this.attachedIds.containsKey(closest) && this.keyPressed && this.key == '\uffff' && (this.keyCode == 16 || this.keyCode == 18)) {
                    this.attachedIds.remove(closest);
                    if (!(this.keyPressed && this.key == '\uffff' && this.keyCode == 18 || sphere.pairedWForce == null)) {
                        Sphere2D s2 = sphere;
                        while (s2.hasHelixDown) {
                            s2 = s2.threeP;
                            if (!this.attachedIds.containsKey(s2.id)) continue;
                            this.attachedIds.remove(s2.id);
                        }
                        s2 = sphere;
                        while (s2.hasHelixUp) {
                            s2 = s2.fiveP;
                            if (!this.attachedIds.containsKey(s2.id)) continue;
                            this.attachedIds.remove(s2.id);
                        }
                    }
                } else {
                    if (!this.keyPressed || this.key != '\uffff' || this.keyCode != 16 && this.keyCode != 18) {
                        this.attachedIds.clear();
                    }
                    this.attachedIds.put(closest, 1);
                    if (!(this.keyPressed && this.key == '\uffff' && this.keyCode == 18 || sphere.pairedWForce == null)) {
                        Sphere2D s2 = sphere;
                        while (s2.hasHelixDown) {
                            s2 = s2.threeP;
                            if (!this.attachedIds.containsKey(s2.id)) {
                                this.attachedIds.put(s2.id, 1);
                            }
                            if (this.attachedIds.containsKey(s2.pairedWForce.id)) continue;
                            this.attachedIds.put(s2.pairedWForce.id, 1);
                        }
                        s2 = sphere;
                        while (s2.hasHelixUp) {
                            s2 = s2.fiveP;
                            if (!this.attachedIds.containsKey(s2.id)) {
                                this.attachedIds.put(s2.id, 1);
                            }
                            if (this.attachedIds.containsKey(s2.pairedWForce.id)) continue;
                            this.attachedIds.put(s2.pairedWForce.id, 1);
                        }
                        if (!this.attachedIds.containsKey(sphere.pairedWForce.id)) {
                            this.attachedIds.put(sphere.pairedWForce.id, 1);
                        }
                    }
                }
            } else if (!this.keyPressed || this.key != '\uffff' || this.keyCode != 16) {
                this.attachedIds.clear();
            }
        }
    }

    public void settings() {
        this.size(1200, 750);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"ribosketch"};
        if (passedArgs != null) {
            PApplet.main((String[])ribosketch.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Base {
        private int mate;
        private double x;
        private double y;
        private boolean extracted;
        private Region region;

        Base() {
            this.region = new Region();
        }

        public int getMate() {
            return this.mate;
        }

        public void setMate(int mate) {
            this.mate = mate;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }

        public boolean isExtracted() {
            return this.extracted;
        }

        public void setExtracted(boolean extracted) {
            this.extracted = extracted;
        }

        public Region getRegion() {
            return this.region;
        }

        public void setRegion(Region region) {
            this.region = region;
        }
    }

    public class BasePairLoadCheckBox
    extends CheckBox {
        BasePairLoadCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.selectInput("Select a basepair file to load", "loadBondFile");
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class CheckBox {
        boolean checked;
        float x;
        float y;
        float boxWidth;
        float boxHeight;
        String label;
        float padx = 7.0f;
        boolean visible = true;
        float labelWidth;

        CheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            this.label = l;
            this.labelWidth = labelSize;
            this.x = xx;
            this.y = yy;
            this.boxWidth = ww;
            this.boxHeight = hh;
            Interactive.add((Object)this);
        }

        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            this.checked = !this.checked;
        }

        public void draw() {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.noStroke();
            if (this.x <= (float)ribosketch.this.mouseX && (float)ribosketch.this.mouseX <= this.x + this.boxWidth && this.y <= (float)ribosketch.this.mouseY && (float)ribosketch.this.mouseY <= this.y + this.boxHeight) {
                ribosketch.this.fill(-11821403);
            } else {
                ribosketch.this.fill(-16777216);
            }
            ribosketch.this.rectMode(0);
            ribosketch.this.rect(this.x, this.y, this.boxWidth, this.boxHeight, 4.0f);
            if (this.checked) {
                ribosketch.this.fill(ribosketch.this.ds.GUIColor);
                ribosketch.this.rect(this.x + 2.0f, this.y + 2.0f, this.boxWidth - 4.0f, this.boxHeight - 4.0f, 4.0f);
            }
            ribosketch.this.fill(-16777216);
            ribosketch.this.textAlign(37);
            ribosketch.this.textSize(ribosketch.this.ds.menuTextSize);
            ribosketch.this.text(this.label, this.x + this.boxWidth + this.padx, this.y + this.boxHeight);
        }

        public boolean isInside(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return false;
            }
            return Interactive.insideRect((float)this.x, (float)this.y, (float)(this.boxWidth + this.labelWidth), (float)this.boxHeight, (float)mx, (float)my);
        }

        public void setVisible(boolean flag) {
            this.visible = flag;
        }
    }

    public class ColorLoadCheckBox
    extends CheckBox {
        ColorLoadCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.selectInput("Select a color file to load", "loadColorFile");
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class Connection {
        private Loop loop;
        private Region region;
        private int start;
        private int end;
        private double xrad;
        private double yrad;
        private double angle;
        private boolean extruded;
        private boolean broken;
        private boolean _isNull;

        public Connection() {
            this.loop = new Loop();
            this.region = new Region();
            this._isNull = false;
        }

        public boolean isNull() {
            return this._isNull;
        }

        public void setNull(boolean isNull) {
            this._isNull = isNull;
        }

        public Loop getLoop() {
            return this.loop;
        }

        public void setLoop(Loop loop) {
            this.loop = loop;
        }

        public Region getRegion() {
            return this.region;
        }

        public void setRegion(Region region) {
            this.region = region;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public double getXrad() {
            return this.xrad;
        }

        public void setXrad(double xrad) {
            this.xrad = xrad;
        }

        public double getYrad() {
            return this.yrad;
        }

        public void setYrad(double yrad) {
            this.yrad = yrad;
        }

        public double getAngle() {
            return this.angle;
        }

        public void setAngle(double angle) {
            this.angle = angle;
        }

        public boolean isExtruded() {
            return this.extruded;
        }

        public void setExtruded(boolean extruded) {
            this.extruded = extruded;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public void setBroken(boolean broken) {
            this.broken = broken;
        }
    }

    class DisplaySettings {
        static final int COLOR_MODE_FEW = 1;
        static final int COLOR_MODE_WHITE = 2;
        static final int COLOR_MODE_RESIDUE = 3;
        static final int COLOR_MODE_STRUCTURE = 4;
        static final int COLOR_MODE_RAINBOW = 7;
        static final int COLOR_MODE_LIGHT = 5;
        static final int COLOR_MODE_BYG = 6;
        static final int COLOR_MODE_GREY = 8;
        static final int COLOR_MODE_RNADNA = 9;
        static final int COLOR_MODE_CUSTOM = 10;
        static final int COLOR_MODE_MAX = 11;
        int colorMode = 1;
        int GUIColor = -13061400;
        int colorMax = 360;
        int bpCol = -15400242;
        float bpWeight = 1.5f;
        int bbCol = -16777216;
        float bbWeight = 2.25f;
        double radiusShowMul = 2.25;
        int startGradient = -1;
        int endGradient = -65536;
        boolean labelMode = true;
        boolean textMode = true;
        boolean outlineMode = true;
        boolean displayStrandInfo = false;
        float textReduction = 0.8f;
        float textOffsX = -0.3f;
        float textOffsY = 0.3f;
        static final int MENU_APPEAR_X = 100;
        static final int MENU_APPEAR_Y = 60;
        float helpX = 20.0f;
        int textCol = -16777216;
        float helpTextSize = 13.2f;
        float messageX;
        float messageY;
        float messageFontSize;
        float labelWeight;
        int highlightCol;
        double highlightMul;
        float menuTextSize;
        float sliderLabelWidth;
        float sliderWidth;
        float sliderHeight;
        float sliderGap;
        float sliderLabelX;
        float zoomFactor;
        float zoomMul;
        float zoomTranslateX;
        float zoomTranslateY;
        double startPadding;
        double padding;
        double paddingScale;

        DisplaySettings() {
            this.messageX = ribosketch.this.screenResX / 3.0f;
            this.messageY = 50.0f;
            this.messageFontSize = 20.0f;
            this.labelWeight = 5.0f;
            this.highlightCol = -256;
            this.highlightMul = 1.5;
            this.menuTextSize = 13.7f;
            this.sliderLabelWidth = 100.0f;
            this.sliderWidth = 300.0f;
            this.sliderHeight = 10.0f;
            this.sliderGap = 50.0f;
            this.sliderLabelX = (float)ribosketch.this.width / 2.0f - (this.sliderLabelWidth + this.sliderWidth + this.sliderGap / 2.0f);
            this.zoomFactor = 1.0f;
            this.zoomMul = 1.1f;
            this.zoomTranslateX = 0.0f;
            this.zoomTranslateY = 0.0f;
            this.padding = this.startPadding = 20.0;
            this.paddingScale = 250.0;
        }

        public void applyZoom(float mul) {
            this.zoomFactor *= mul;
            this.zoomTranslateX = (1.0f - mul) * (ribosketch.this.screenResX / 2.0f) + mul * ribosketch.this.ds.zoomTranslateX;
            this.zoomTranslateY = (1.0f - mul) * (ribosketch.this.screenResY / 2.0f) + mul * ribosketch.this.ds.zoomTranslateY;
        }

        public void resetZoom() {
            this.zoomFactor = 1.0f;
            this.zoomTranslateX = 0.0f;
            this.zoomTranslateY = 0.0f;
        }
    }

    class DrawClass {
        public static final int FORMAT_NONE = 0;
        public static final int FORMAT_SVG = 1;
        public static final int FORMAT_PNG = 2;
        ArrayList<String> sb = new ArrayList();
        ArrayList<String> sb_last = new ArrayList();
        String fontFamily = "Ariel, sans-serif";
        int format = 1;
        int fillCol = -16777216;
        float fontSize = 14.0f;
        boolean noStrokeMode = false;
        int strokeCol = -16777216;
        float strokeWidth = 1.0f;
        String textAnchor = "start";
        float viewBoxXMin = 0.0f;
        float viewBoxXMax;
        float viewBoxYMin;
        float viewBoxYMax;
        float viewBoxPad;

        DrawClass() {
            this.viewBoxXMax = ribosketch.this.width;
            this.viewBoxYMin = 0.0f;
            this.viewBoxYMax = ribosketch.this.height;
            this.viewBoxPad = 50.0f;
        }

        public void Ellipse(float cx, float cy, float rx, float ry) {
            if (cx - rx < this.viewBoxXMin) {
                this.viewBoxXMin = cx - rx - this.viewBoxPad;
            } else if (cx + rx > this.viewBoxXMax) {
                this.viewBoxXMax = cx + rx + this.viewBoxPad;
            }
            if (cy - ry < this.viewBoxYMin) {
                this.viewBoxYMin = cy - ry - this.viewBoxPad;
            } else if (cy + ry > this.viewBoxYMax) {
                this.viewBoxYMax = cy + ry + this.viewBoxPad;
            }
            switch (this.format) {
                case 1: {
                    if (!this.noStrokeMode) {
                        this.sb.add("<ellipse cx=\"" + cx + "\" cy=\"" + cy + "\" rx=\"" + rx / 2.0f + "\" ry=\"" + ry / 2.0f + "\" stroke=\"" + this.Hex(this.strokeCol) + "\" fill=\"" + this.Hex(this.fillCol) + "\" stroke-width=\"" + this.strokeWidth + "\"/>\n");
                        break;
                    }
                    this.sb.add("<ellipse cx=\"" + cx + "\" cy=\"" + cy + "\" rx=\"" + rx / 2.0f + "\" ry=\"" + ry / 2.0f + "\" fill=\"" + this.Hex(this.fillCol) + "\"/>\n");
                }
            }
            ribosketch.this.ellipse(cx, cy, rx, ry);
        }

        public void Polygon(ArrayList<Float> xv, ArrayList<Float> yv) {
            int i;
            int n = xv.size();
            if (yv.size() < n) {
                n = yv.size();
            }
            String s = "";
            switch (this.format) {
                case 1: {
                    s = "<polygon points=\"";
                    i = 0;
                    while (i < n) {
                        float x = xv.get(i).floatValue();
                        float y = yv.get(i).floatValue();
                        s = String.valueOf(s) + x + "," + y + " ";
                        ++i;
                    }
                    s = String.valueOf(s) + "\"";
                    if (!this.noStrokeMode) {
                        s = String.valueOf(s) + " stroke=\"" + this.Hex(this.strokeCol) + "\" stroke-width=\"" + this.strokeWidth + "\"";
                    }
                    s = String.valueOf(s) + " fill=\"" + this.Hex(this.fillCol) + "\"/>\n";
                    this.sb.add(s);
                }
            }
            ribosketch.this.beginShape();
            i = 0;
            while (i < n) {
                ribosketch.this.vertex(xv.get(i).floatValue(), yv.get(i).floatValue());
                ++i;
            }
            if (n > 1) {
                ribosketch.this.vertex(xv.get(0).floatValue(), yv.get(0).floatValue());
            }
            ribosketch.this.endShape();
        }

        public void Triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
            switch (this.format) {
                case 1: {
                    if (!this.noStrokeMode) {
                        this.sb.add("<polygon points=\"" + x1 + "," + y1 + " " + x2 + "," + y2 + " " + x3 + "," + y3 + "\" stroke=\"" + this.Hex(this.strokeCol) + "\" fill=\"" + this.Hex(this.fillCol) + "\" stroke-width=\"" + this.strokeWidth + "\"/>\n");
                        break;
                    }
                    this.sb.add("<polygon points=\"" + x1 + "," + y1 + " " + x2 + "," + y2 + " " + x3 + "," + y3 + "\" stroke=\"" + this.Hex(this.strokeCol) + "\" fill=\"" + this.Hex(this.fillCol) + "\"/>\n");
                }
            }
            ribosketch.this.triangle(x1, y1, x2, y2, x3, y3);
        }

        public void Fill(int col) {
            this.fillCol = col;
            ribosketch.this.fill(col);
        }

        public String Hex(int c) {
            String s = ribosketch.hex((int)c);
            s = "#" + s.substring(2);
            return s;
        }

        public void Line(float x1, float y1, float x2, float y2) {
            if (this.format == 1) {
                this.sb.add("<line x1=\"" + x1 + "\" y1=\"" + y1 + "\" x2=\"" + x2 + "\" y2=\"" + y2 + "\" stroke=\"black\" stroke-width=\"" + this.strokeWidth + "\" />\n");
            }
            ribosketch.this.line(x1, y1, x2, y2);
        }

        public void NoStroke() {
            this.noStrokeMode = true;
            ribosketch.this.noStroke();
        }

        public void setFormat(int formatId) {
            this.format = formatId;
        }

        public void Stroke(int c) {
            this.noStrokeMode = false;
            this.strokeCol = c;
            ribosketch.this.stroke(c);
        }

        public void StrokeWeight(float x) {
            this.strokeWidth = x;
            ribosketch.this.strokeWeight(x);
        }

        public void Text(String txt, float x, float y) {
            if (this.format == 1) {
                this.sb.add("<text x=\"" + x + "\" y=\"" + y + "\" text-anchor=\"" + this.textAnchor + "\" fill=\"" + this.Hex(this.fillCol) + "\" font-size=\"" + this.fontSize + "px\" font-family=\"" + this.fontFamily + "\" >" + txt + "</text>\n");
            }
            ribosketch.this.text(txt, x, y);
        }

        public void TextSize(float size) {
            this.fontSize = size;
            ribosketch.this.textSize(size);
        }

        public void clear() {
            this.sb_last = new ArrayList<String>(this.sb);
            this.sb.clear();
            this.viewBoxXMin = 0.0f;
            this.viewBoxXMax = ribosketch.this.width;
            this.viewBoxYMin = 0.0f;
            this.viewBoxYMax = ribosketch.this.height;
        }

        public String toString() {
            return this.sb.toString();
        }

        public synchronized String[] toSVG() {
            String s;
            ArrayList<String> sbc = new ArrayList<String>();
            int i = 0;
            while (i < this.sb_last.size()) {
                if (i < this.sb_last.size()) {
                    sbc.add(this.sb_last.get(i));
                }
                ++i;
            }
            int n = sbc.size();
            String[] result = new String[n + 2];
            result[0] = s = "<svg width=\"" + ribosketch.this.width + "\" height=\"" + ribosketch.this.height + "\" viewBox=\"" + this.viewBoxXMin + " " + this.viewBoxYMin + " " + this.viewBoxXMax + " " + this.viewBoxYMax + "\" xmlns=\"http://www.w3.org/2000/svg\">\n";
            int i2 = 0;
            while (i2 < n) {
                if (i2 >= sbc.size()) {
                    ribosketch.println((String)"Warning!!! DrawClass.pde L168");
                }
                if (i2 + 1 >= result.length) {
                    ribosketch.println((String)"Warning!!! DrawClass.pde L171");
                }
                result[i2 + 1] = (String)sbc.get(i2);
                ++i2;
            }
            result[result.length - 1] = "</svg>";
            return result;
        }
    }

    class ForceField {
        double radius;
        final double minRadius = 1.0;
        final double radiusScale = 50.0;
        double backboneDist;
        final double minBackboneDist = 2.0;
        final double backboneDistScale = 100.0;
        double bpDist;
        final double minBpDist = 3.0;
        final double bpDistScale = 150.0;
        double vdWeight = 8.0;
        double eWeight = 5.0;
        double eCutoffScale = 12.0;
        double straightWeight = 0.0125f;
        double stretchWeight = 2.5;
        double padWeight = 0.005f;
        double cmWeight = 0.3f;
        double mass = 25.0;
        double velMax = 12.0;
        double damping = 0.5;
        double hairpinWeight = 4.5;
        double loopWeight = 1.0;
        double branchStraightenWeight = 1.5;

        ForceField() {
        }
    }

    class Helix {
        int id;
        int[] ends = new int[2];
        int size = 0;
        int numCrossed = 0;
        HashMap<Integer, Helix> crossedW = new HashMap();

        Helix(int end1, int end2, int id) {
            this.ends[0] = end1;
            this.ends[1] = end2;
            this.id = id;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }

    class HelixEnd {
        int strandId;
        int relId;
        int origId;

        HelixEnd() {
        }

        public void setStrandId(int strandId) {
            this.strandId = strandId;
        }

        public void setRelId(int relId) {
            this.relId = relId;
        }

        public void setOrigId(int origId) {
            this.origId = origId;
        }
    }

    class InterHelix {
        HelixEnd end1;
        HelixEnd end2;

        InterHelix(int strand1, int relId1, int strand2, int relId2) {
            this.end1 = new HelixEnd();
            this.end2 = new HelixEnd();
            this.end1.setStrandId(strand1);
            this.end1.setRelId(relId1);
            this.end2.setStrandId(strand2);
            this.end2.setRelId(relId2);
        }

        InterHelix(int strand1, int relId1, int origId1, int strand2, int relId2, int origId2) {
            this(strand1, relId1, strand2, relId2);
            this.end1.setOrigId(origId1);
            this.end2.setOrigId(origId2);
        }
    }

    static interface JavaScript {
        public String getTextInput(String var1);

        public String getFileTypeBrowser();

        public void screenshotBrowser();

        public void saveFileBrowser(String[] var1);

        public void saveSVGBrowser(String[] var1);
    }

    public class LabelCheckBox
    extends CheckBox {
        LabelCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
            this.checked = ribosketch.this.ds.labelMode;
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            this.checked = !this.checked;
            ribosketch.this.ds.labelMode = !ribosketch.this.ds.labelMode;
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class Listbox {
        float x;
        float y;
        float width;
        float height;
        ArrayList<String> items;
        int itemHeight;
        int listStartAt;
        int hoverItem;
        int selectorId;
        float valueY;
        boolean hasSlider;
        String lastItemClicked;

        Listbox(float xx, float yy, float ww, float hh, int itemHeight, String[] fileTypes, int selectorId) {
            this.x = xx;
            this.valueY = this.y = yy;
            this.width = ww;
            this.height = hh;
            this.selectorId = selectorId;
            this.itemHeight = itemHeight;
            this.listStartAt = 0;
            this.hoverItem = -1;
            this.hasSlider = false;
            this.items = new ArrayList();
            String[] stringArray = fileTypes;
            int n = fileTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                this.addItem(type);
                ++n2;
            }
            Interactive.add((Object)this);
        }

        public void addItem(String item) {
            this.items.add(item);
            this.hasSlider = (float)(this.items.size() * this.itemHeight) > this.height;
        }

        public void mouseMoved(float mx, float my) {
            if (!ribosketch.this.selectingFileType) {
                return;
            }
            if (this.hasSlider && mx > this.width - 20.0f) {
                return;
            }
            this.hoverItem = this.listStartAt + PApplet.parseInt((float)((my - this.y) / (float)this.itemHeight));
        }

        public void mouseExited(float mx, float my) {
            this.hoverItem = -1;
        }

        public void mouseDragged(float mx, float my, float dx, float dy) {
            if (!ribosketch.this.selectingFileType) {
                return;
            }
            if (!this.hasSlider) {
                return;
            }
            if (mx < this.x + this.width - 20.0f) {
                return;
            }
            this.valueY = my - 10.0f;
            this.valueY = ribosketch.constrain((float)this.valueY, (float)this.y, (float)(this.y + this.height - 20.0f));
            this.update();
        }

        public void mouseScrolled(float step) {
            if (!ribosketch.this.selectingFileType) {
                return;
            }
            this.valueY += step;
            this.valueY = ribosketch.constrain((float)this.valueY, (float)this.y, (float)(this.y + this.height - 20.0f));
            this.update();
        }

        public void update() {
            if (!ribosketch.this.selectingFileType) {
                return;
            }
            float totalHeight = this.items.size() * this.itemHeight;
            float listOffset = ribosketch.map((float)this.valueY, (float)this.y, (float)(this.y + this.height - 20.0f), (float)0.0f, (float)(totalHeight - this.height));
            this.listStartAt = PApplet.parseInt((float)(listOffset / (float)this.itemHeight));
        }

        public void mousePressed(float mx, float my) {
            if (!ribosketch.this.selectingFileType) {
                return;
            }
            if (this.hasSlider && mx > this.width - 20.0f) {
                return;
            }
            int item = this.listStartAt + PApplet.parseInt((float)((my - this.y) / (float)this.itemHeight));
            this.lastItemClicked = this.items.get(item);
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)this.lastItemClicked);
            }
        }

        public void draw() {
            if (!ribosketch.this.selectingFileType || this.selectorId != ribosketch.this.displaySelectorId) {
                return;
            }
            ribosketch.this.noStroke();
            ribosketch.this.fill(-1);
            ribosketch.this.rectMode(0);
            ribosketch.this.rect(this.x, this.y, this.width, this.height);
            ribosketch.this.strokeWeight(2.0f);
            if (this.items != null) {
                int i = 0;
                while (i < PApplet.parseInt((float)(this.height / (float)this.itemHeight)) && i < this.items.size()) {
                    String currentItem = this.items.get(i + this.listStartAt);
                    ribosketch.this.stroke(ribosketch.this.ds.GUIColor);
                    if (currentItem.equals(this.lastItemClicked)) {
                        ribosketch.this.fill(-16777216);
                    } else {
                        ribosketch.this.fill(-1);
                    }
                    if (i + this.listStartAt == this.hoverItem) {
                        ribosketch.this.fill(-1875);
                    }
                    ribosketch.this.rect(this.x, this.y + (float)(i * this.itemHeight), this.width, this.itemHeight);
                    ribosketch.this.noStroke();
                    if (currentItem.equals(this.lastItemClicked)) {
                        if (i + this.listStartAt == this.hoverItem) {
                            ribosketch.this.fill(-16755969);
                        } else {
                            ribosketch.this.fill(-1);
                        }
                    } else {
                        ribosketch.this.fill(-16777216);
                    }
                    ribosketch.this.textSize((float)this.itemHeight * 0.75f);
                    ribosketch.this.textAlign(37);
                    ribosketch.this.text(currentItem, this.x + 5.0f, this.y + (float)((i + 1) * this.itemHeight) - 5.0f);
                    ++i;
                }
            }
            if (this.hasSlider) {
                ribosketch.this.rectMode(0);
                ribosketch.this.stroke(80);
                ribosketch.this.fill(100);
                ribosketch.this.rect(this.x + this.width - 20.0f, this.y, 20.0f, this.height);
                ribosketch.this.fill(120);
                ribosketch.this.rect(this.x + this.width - 20.0f, this.valueY, 20.0f, 20.0f);
            }
        }
    }

    public class LoadCheckBox
    extends CheckBox {
        LoadCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.loadCalled();
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class Loop {
        private int nconnection;
        private ArrayList<Connection> connections = new ArrayList();
        private HashMap<Integer, Connection> _connections = new HashMap();
        private int number;
        private int depth;
        private boolean mark;
        private double x;
        private double y;
        private double radius;

        public int getNconnection() {
            return this.nconnection;
        }

        public void setNconnection(int nconnection) {
            this.nconnection = nconnection;
        }

        public void setConnection(int i, Connection c) {
            Integer n = i;
            if (c != null) {
                this._connections.put(n, c);
            } else {
                if (!this._connections.containsKey(n)) {
                    this._connections.put(n, new Connection());
                }
                this._connections.get(i).setNull(true);
            }
        }

        public Connection getConnection(int i) {
            Connection c;
            Integer n = i;
            if (!this._connections.containsKey(n)) {
                this._connections.put(n, new Connection());
            }
            if ((c = this._connections.get(n)).isNull()) {
                return null;
            }
            return c;
        }

        public void addConnection(int i, Connection c) {
            this._connections.put(this._connections.size(), c);
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public boolean isMark() {
            return this.mark;
        }

        public void setMark(boolean mark) {
            this.mark = mark;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }

        public double getRadius() {
            return this.radius;
        }

        public void setRadius(double radius) {
            this.radius = radius;
        }

        public String toString() {
            String result = "Loop:";
            result = String.valueOf(result) + " nconnection " + this.nconnection;
            result = String.valueOf(result) + " depth " + this.depth;
            return result;
        }
    }

    public class MovementCheckBox
    extends CheckBox {
        MovementCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
            this.checked = ribosketch.this.simulationMode;
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.saveStateForUndo();
            this.checked = !this.checked;
            ribosketch.this.simulationMode = !ribosketch.this.simulationMode;
            ribosketch.this.textDisplay = !ribosketch.this.simulationMode ? "FREEZE" : "UNFREEZE";
            ribosketch.this.textDisplayCount = 0;
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class OutlineCheckBox
    extends CheckBox {
        OutlineCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
            this.checked = ribosketch.this.ds.outlineMode;
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.ds.outlineMode = this.checked = !this.checked;
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class Radial {
        private final double ANUM = 9999.0;
        private final int MAXITER = 500;
        private ArrayList<Base> bases;
        private int nbase;
        private int nregion;
        private int loop_count;
        private Loop root;
        private ArrayList<Loop> loops;
        private ArrayList<Region> regions;
        private Radloop rlphead;
        private double lencut;
        private final double RADIUS_REDUCTION_FACTOR = (double)1.4f;
        private boolean debug;
        private double angleinc;
        private double _h;
        private boolean noIterationFailureYet;
        double HELIX_FACTOR;
        double BACKBONE_DISTANCE;

        public Radial() {
            this.root = new Loop();
            this.rlphead = new Radloop();
            this.lencut = 0.8f;
            this.RADIUS_REDUCTION_FACTOR = 1.4f;
            this.debug = false;
            this.noIterationFailureYet = true;
            this.HELIX_FACTOR = 0.6f;
            this.BACKBONE_DISTANCE = 27.0;
            ribosketch.this.radialAlgorithmException = "";
        }

        public int xyCoordinates(ArrayList<Short> pair_table2, ArrayList<Double> x, ArrayList<Double> y) {
            if (this.debug) {
                ribosketch.println((String)"xy_coordinates");
            }
            if (pair_table2.size() == 0) {
                return 0;
            }
            ArrayList<Integer> pair_table = new ArrayList<Integer>(pair_table2.size() + 1);
            pair_table.add(pair_table2.size());
            int j = 0;
            while (j < pair_table2.size()) {
                pair_table.add(pair_table2.get(j) + 1);
                ++j;
            }
            if (this.debug) {
                this.infoStructure(pair_table);
            }
            this.nbase = pair_table.get(0);
            this.bases = new ArrayList(this.nbase + 1);
            int index = 0;
            while (index < this.bases.size()) {
                this.bases.add(new Base());
                ++index;
            }
            this.regions = new ArrayList();
            index = 0;
            while (index < this.nbase + 1) {
                this.regions.add(new Region());
                ++index;
            }
            this.read_in_bases(pair_table);
            if (this.debug) {
                this.infoBasesMate();
            }
            this.rlphead = null;
            this.find_regions();
            this.loop_count = 0;
            this.loops = new ArrayList(this.nbase + 1);
            index = 0;
            while (index < this.nbase + 1) {
                this.loops.add(new Loop());
                ++index;
            }
            this.construct_loop(0);
            if (!"".equals(ribosketch.this.radialAlgorithmException)) {
                return -1;
            }
            if (this.debug) {
                this.infoBasesExtracted();
            }
            this.find_central_loop();
            if (this.debug) {
                this.infoRoot();
            }
            if (this.debug) {
                this.dump_loops();
            }
            this.traverse_loop(this.root, null);
            if (!"".equals(ribosketch.this.radialAlgorithmException)) {
                return -1;
            }
            int i = 0;
            while (i < this.nbase) {
                x.add(100.0 + this.BACKBONE_DISTANCE * this.bases.get(i + 1).getX());
                y.add(100.0 + this.BACKBONE_DISTANCE * this.bases.get(i + 1).getY());
                ++i;
            }
            return this.nbase;
        }

        private void infoStructure(ArrayList<Integer> pair_table) {
            ribosketch.println((String)"structure:");
            int j = 0;
            while (j < pair_table.size()) {
                ribosketch.print((String)("#" + j + ":" + pair_table.get(j) + "\t"));
                if (j % 10 == 0) {
                    ribosketch.println((String)"");
                }
                ++j;
            }
            ribosketch.println((String)"");
        }

        private void infoBasesMate() {
            ribosketch.println((String)"Bases mate:");
            int index = 0;
            while (index < this.bases.size()) {
                ribosketch.print((String)("#" + index + ":" + this.bases.get(index).getMate() + "\t"));
                if (index % 10 == 0) {
                    ribosketch.println((String)"");
                }
                ++index;
            }
            ribosketch.println((String)"");
        }

        private void infoRegions() {
            ribosketch.println((String)"regions:");
            int index = 0;
            while (index < this.regions.size()) {
                ribosketch.print((String)("(" + this.regions.get(index).getStart1() + "," + this.regions.get(index).getStart2() + ";" + this.regions.get(index).getEnd1() + "," + this.regions.get(index).getEnd2() + ")\t\t"));
                if (index + 1 == 0) {
                    ribosketch.println((String)"");
                }
                ++index;
            }
            ribosketch.println((String)"");
        }

        private void infoBasesExtracted() {
            ribosketch.println((String)"Bases extracted:");
            int index = 0;
            while (index < this.bases.size()) {
                ribosketch.print((String)("i=" + index + ":" + this.bases.get(index).isExtracted() + "\t"));
                if (index % 5 == 0) {
                    ribosketch.println((String)"");
                }
                ++index;
            }
            ribosketch.println((String)"");
        }

        private void infoRoot() {
            ribosketch.println((String)("root" + this.root.getNconnection() + ";" + this.root.getNumber()));
            ribosketch.println((String)"\troot : ");
            ribosketch.println((String)("\tdepth=" + this.root.getDepth()));
            ribosketch.println((String)("\tmark=" + this.root.isMark()));
            ribosketch.println((String)("\tnumber=" + this.root.getNumber()));
            ribosketch.println((String)("\tradius=" + this.root.getRadius()));
            ribosketch.println((String)("\tx=" + this.root.getX()));
            ribosketch.println((String)("\ty=" + this.root.getY()));
            ribosketch.println((String)("\tnconnection=" + this.root.getNconnection()));
        }

        private void read_in_bases(ArrayList<Integer> pair_table) {
            if (this.debug) {
                ribosketch.println((String)"read_in_bases");
            }
            this.bases.add(new Base());
            this.bases.get(0).setMate(0);
            this.bases.get(0).setExtracted(false);
            this.bases.get(0).setX(9999.0);
            this.bases.get(0).setY(9999.0);
            int npairs = 0;
            int i = 1;
            while (i <= this.nbase) {
                this.bases.add(new Base());
                this.bases.get(i).setExtracted(false);
                this.bases.get(i).setX(9999.0);
                this.bases.get(i).setY(9999.0);
                this.bases.get(i).setMate(pair_table.get(i));
                if (pair_table.get(i) > i) {
                    ++npairs;
                }
                ++i;
            }
            if (npairs == 0) {
                this.bases.get(1).setMate(this.nbase);
                this.bases.get(this.nbase).setMate(1);
            }
        }

        private void find_regions() {
            if (this.debug) {
                ribosketch.println((String)"find_regions");
            }
            int nb1 = this.nbase + 1;
            ArrayList<Boolean> mark = new ArrayList<Boolean>(nb1);
            int i = 0;
            while (i < nb1) {
                mark.add(false);
                ++i;
            }
            this.nregion = 0;
            i = 0;
            while (i <= this.nbase) {
                int mate = this.bases.get(i).getMate();
                if (mate != 0 && !((Boolean)mark.get(i)).booleanValue()) {
                    this.regions.get(this.nregion).setStart1(i);
                    this.regions.get(this.nregion).setEnd2(mate);
                    mark.set(i, true);
                    mark.set(mate, true);
                    this.bases.get(i).setRegion(this.regions.get(this.nregion));
                    this.bases.get(mate).setRegion(this.regions.get(this.nregion));
                    ++i;
                    --mate;
                    while (i < mate && this.bases.get(i).getMate() == mate) {
                        mark.set(mate, true);
                        mark.set(i, true);
                        this.bases.get(i).setRegion(this.regions.get(this.nregion));
                        this.bases.get(mate).setRegion(this.regions.get(this.nregion));
                        ++i;
                        --mate;
                    }
                    this.regions.get(this.nregion).setEnd1(--i);
                    this.regions.get(this.nregion).setStart2(mate + 1);
                    if (this.debug) {
                        if (this.nregion == 0) {
                            ribosketch.println((String)"\nRegions are:\n");
                        }
                        ribosketch.println((Object[])new Object[]{"Region %d is %d-%d and %d-%d with gap of %d.\n", this.nregion + 1, this.regions.get(this.nregion).getStart1(), this.regions.get(this.nregion).getEnd1(), this.regions.get(this.nregion).getStart2(), this.regions.get(this.nregion).getEnd2(), this.regions.get(this.nregion).getStart2() - this.regions.get(this.nregion).getEnd1() + 1});
                    }
                    ++this.nregion;
                }
                ++i;
            }
        }

        private Loop construct_loop(int ibase) {
            if (this.debug) {
                ribosketch.println((String)"construct_loop");
            }
            Loop retloop = new Loop();
            Loop lp = new Loop();
            Connection cp = new Connection();
            Region rp = new Region();
            Radloop rlp = new Radloop();
            retloop = this.loops.get(this.loop_count++);
            retloop.setNconnection(0);
            retloop.setDepth(0);
            retloop.setNumber(this.loop_count);
            retloop.setRadius(0.0);
            rlp = this.rlphead;
            while (rlp != null) {
                if (rlp.getLoopnumber() == this.loop_count) {
                    retloop.setRadius(rlp.getRadius());
                }
                rlp = rlp.getNext();
            }
            int i = ibase;
            do {
                int mate;
                if ((mate = this.bases.get(i).getMate()) != 0) {
                    rp = this.bases.get(i).getRegion();
                    if (!this.bases.get(rp.getStart1()).isExtracted()) {
                        if (i == rp.getStart1()) {
                            this.bases.get(rp.getStart1()).setExtracted(true);
                            this.bases.get(rp.getEnd1()).setExtracted(true);
                            this.bases.get(rp.getStart2()).setExtracted(true);
                            this.bases.get(rp.getEnd2()).setExtracted(true);
                            lp = this.construct_loop(rp.getEnd1() < this.nbase ? rp.getEnd1() + 1 : 0);
                            if (!"".equals(ribosketch.this.radialAlgorithmException)) {
                                return new Loop();
                            }
                        } else if (i == rp.getStart2()) {
                            this.bases.get(rp.getStart2()).setExtracted(true);
                            this.bases.get(rp.getEnd2()).setExtracted(true);
                            this.bases.get(rp.getStart1()).setExtracted(true);
                            this.bases.get(rp.getEnd1()).setExtracted(true);
                            lp = this.construct_loop(rp.getEnd2() < this.nbase ? rp.getEnd2() + 1 : 0);
                            if (!"".equals(ribosketch.this.radialAlgorithmException)) {
                                return new Loop();
                            }
                        } else {
                            ribosketch.println((String)("Error detected in construct_loop. i = " + i + " not found in region table.\n"));
                            ribosketch.this.radialAlgorithmException = "Error detected in construct_loop. i = " + i + " not found in region table.\n";
                            return new Loop();
                        }
                        retloop.setNconnection(retloop.getNconnection() + 1);
                        cp = new Connection();
                        retloop.setConnection(retloop.getNconnection() - 1, cp);
                        retloop.setConnection(retloop.getNconnection(), null);
                        cp.setLoop(lp);
                        cp.setRegion(rp);
                        if (i == rp.getStart1()) {
                            cp.setStart(rp.getStart1());
                            cp.setEnd(rp.getEnd2());
                        } else {
                            cp.setStart(rp.getStart2());
                            cp.setEnd(rp.getEnd1());
                        }
                        cp.setExtruded(false);
                        cp.setBroken(false);
                        lp.setNconnection(lp.getNconnection() + 1);
                        cp = new Connection();
                        lp.setConnection(lp.getNconnection() - 1, cp);
                        lp.setConnection(lp.getNconnection(), null);
                        cp.setLoop(retloop);
                        cp.setRegion(rp);
                        if (i == rp.getStart1()) {
                            cp.setStart(rp.getStart2());
                            cp.setEnd(rp.getEnd1());
                        } else {
                            cp.setStart(rp.getStart1());
                            cp.setEnd(rp.getEnd2());
                        }
                        cp.setExtruded(false);
                        cp.setBroken(false);
                    }
                    i = mate;
                }
                if (++i <= this.nbase) continue;
                i = 0;
            } while (i != ibase);
            return retloop;
        }

        private void dump_loops() {
            ribosketch.println((String)"dump_loops");
            int il = 0;
            while (il < this.loop_count) {
                Connection cp;
                Loop lp = this.loops.get(il);
                int i = 0;
                while ((cp = lp.getConnection(i)) != null) {
                    int cfr_ignored_0 = this.loops.indexOf(cp.getLoop()) + 1;
                    int cfr_ignored_1 = this.regions.indexOf(cp.getRegion()) + 1;
                    ++i;
                }
                ++il;
            }
        }

        private void find_central_loop() {
            if (this.debug) {
                ribosketch.println((String)"find_central_loop");
            }
            Loop lp = new Loop();
            this.determine_depths();
            int maxconn = 0;
            int maxdepth = -1;
            int i = 0;
            while (i < this.loop_count) {
                lp = this.loops.get(i);
                if (lp.getNconnection() > maxconn) {
                    maxdepth = lp.getDepth();
                    maxconn = lp.getNconnection();
                    this.root = lp;
                } else if (lp.getDepth() > maxdepth && lp.getNconnection() == maxconn) {
                    maxdepth = lp.getDepth();
                    this.root = lp;
                }
                ++i;
            }
        }

        private void determine_depths() {
            if (this.debug) {
                ribosketch.println((String)"determine_depths");
            }
            Loop lp = new Loop();
            int i = 0;
            while (i < this.loop_count) {
                lp = this.loops.get(i);
                int j = 0;
                while (j < this.loop_count) {
                    this.loops.get(j).setMark(false);
                    ++j;
                }
                lp.setDepth(this.depth(lp));
                ++i;
            }
        }

        private int depth(Loop lp) {
            if (lp.getNconnection() <= 1) {
                return 0;
            }
            if (lp.isMark()) {
                return -1;
            }
            lp.setMark(true);
            int count = 0;
            int ret = 0;
            int i = 0;
            while (lp.getConnection(i) != null) {
                int d = this.depth(lp.getConnection(i).getLoop());
                if (d >= 0) {
                    if (++count == 1) {
                        ret = d;
                    } else if (ret > d) {
                        ret = d;
                    }
                }
                ++i;
            }
            lp.setMark(false);
            return ret + 1;
        }

        private void traverse_loop(Loop lp, Connection anchor_connection) {
            int n;
            Connection cpnext;
            int j;
            Connection cp;
            if (this.debug) {
                ribosketch.println((String)"  traverse_loop");
            }
            int imaxloop = 0;
            double angleinc = (float)Math.PI * 2 / (float)(this.nbase + 1);
            Connection acp = null;
            int icroot = -1;
            int indice = 0;
            int ic = 0;
            while ((cp = lp.getConnection(indice)) != null) {
                double xs = -Math.sin(angleinc * (double)cp.getStart());
                double ys = Math.cos(angleinc * (double)cp.getStart());
                double xe = -Math.sin(angleinc * (double)cp.getEnd());
                double ye = Math.cos(angleinc * (double)cp.getEnd());
                double xn = ye - ys;
                double yn = xs - xe;
                double r = Math.sqrt(xn * xn + yn * yn);
                cp.setXrad(xn / r);
                cp.setYrad(yn / r);
                cp.setAngle(Math.atan2(yn, xn));
                if (cp.getAngle() < 0.0) {
                    cp.setAngle(cp.getAngle() + Math.PI * 2);
                }
                if (anchor_connection != null && anchor_connection.getRegion() == cp.getRegion()) {
                    acp = cp;
                    icroot = ic;
                }
                ++indice;
                ++ic;
            }
            block1: while (true) {
                int i;
                double acn;
                double rr;
                double dy;
                double dx;
                int icend;
                double ac;
                double xc;
                double yc;
                this.determine_radius(lp, this.lencut);
                double radius = lp.getRadius() / (double)1.4f;
                if (anchor_connection == null) {
                    yc = 0.0;
                    xc = 0.0;
                } else {
                    double xo = (this.bases.get(acp.getStart()).getX() + this.bases.get(acp.getEnd()).getX()) / 2.0;
                    double yo = (this.bases.get(acp.getStart()).getY() + this.bases.get(acp.getEnd()).getY()) / 2.0;
                    xc = xo - radius * acp.getXrad();
                    yc = yo - radius * acp.getYrad();
                }
                int icstart = icroot == -1 ? 0 : icroot;
                cp = lp.getConnection(icstart);
                int count = 0;
                if (this.debug) {
                    ribosketch.print((String)("Now processing loop " + lp.getNumber()));
                    ribosketch.println((String)("  " + lp));
                }
                boolean done = false;
                do {
                    Connection cpprev;
                    if ((j = icstart - 1) < 0) {
                        j = lp.getNconnection() - 1;
                    }
                    if (!this.connected_connection(cpprev = lp.getConnection(j), cp)) {
                        done = true;
                    } else {
                        icstart = j;
                        cp = cpprev;
                    }
                    if (++count <= lp.getNconnection()) continue;
                    double maxang = -1.0;
                    ic = 0;
                    while (ic < lp.getNconnection()) {
                        j = ic + 1;
                        if (j >= lp.getNconnection()) {
                            j = 0;
                        }
                        cp = lp.getConnection(ic);
                        cpnext = lp.getConnection(j);
                        ac = cpnext.getAngle() - cp.getAngle();
                        if (ac < 0.0) {
                            ac += Math.PI * 2;
                        }
                        if (ac > maxang) {
                            maxang = ac;
                            imaxloop = ic;
                        }
                        ++ic;
                    }
                    icend = imaxloop;
                    icstart = imaxloop + 1;
                    if (icstart >= lp.getNconnection()) {
                        icstart = 0;
                    }
                    cp = lp.getConnection(icend);
                    cp.setBroken(true);
                    done = true;
                } while (!done);
                boolean done_all_connections = false;
                int icstart1 = icstart;
                if (this.debug) {
                    ribosketch.println((String)("  Icstart1 = " + icstart1));
                }
                while (!done_all_connections) {
                    int icdown;
                    count = 0;
                    done = false;
                    icend = icstart;
                    boolean rooted = false;
                    while (!done) {
                        cp = lp.getConnection(icend);
                        if (icend == icroot) {
                            rooted = true;
                        }
                        if ((j = icend + 1) >= lp.getNconnection()) {
                            j = 0;
                        }
                        if (this.connected_connection(cp, cpnext = lp.getConnection(j))) {
                            if (++count >= lp.getNconnection()) break;
                            icend = j;
                            continue;
                        }
                        done = true;
                    }
                    int icmiddle = this.find_ic_middle(icstart, icend, anchor_connection, acp, lp);
                    if (!"".equals(ribosketch.this.radialAlgorithmException)) {
                        return;
                    }
                    int icup = icdown = icmiddle;
                    ic = icdown;
                    done = false;
                    int direction = 0;
                    while (!done) {
                        ic = direction < 0 ? icup : (direction == 0 ? icmiddle : icdown);
                        if (ic >= 0) {
                            cp = lp.getConnection(ic);
                            if (anchor_connection == null || acp != cp) {
                                double rl;
                                double da;
                                double lny;
                                double lnx;
                                double cny;
                                double cnx;
                                if (direction == 0) {
                                    double astart = cp.getAngle() - Math.asin(0.5 / radius);
                                    double aend = cp.getAngle() + Math.asin(0.5 / radius);
                                    this.bases.get(cp.getStart()).setX(xc + radius * Math.cos(astart));
                                    this.bases.get(cp.getStart()).setY(yc + radius * Math.sin(astart));
                                    this.bases.get(cp.getEnd()).setX(xc + radius * Math.cos(aend));
                                    this.bases.get(cp.getEnd()).setY(yc + radius * Math.sin(aend));
                                } else if (direction < 0) {
                                    j = ic + 1;
                                    if (j >= lp.getNconnection()) {
                                        j = 0;
                                    }
                                    cp = lp.getConnection(ic);
                                    cpnext = lp.getConnection(j);
                                    double cpx = cp.getXrad();
                                    double cpy = cp.getYrad();
                                    ac = (cp.getAngle() + cpnext.getAngle()) / 2.0;
                                    if (cp.getAngle() > cpnext.getAngle()) {
                                        ac -= Math.PI;
                                    }
                                    cnx = Math.cos(ac);
                                    lnx = cny = Math.sin(ac);
                                    lny = -cnx;
                                    da = cpnext.getAngle() - cp.getAngle();
                                    if (da < 0.0) {
                                        da += Math.PI * 2;
                                    }
                                    rl = cp.isExtruded() ? (da <= 1.5707963267948966 ? 2.0 : 1.5) : 1.0;
                                    this.bases.get(cp.getEnd()).setX(this.bases.get(cpnext.getStart()).getX() + rl * lnx);
                                    this.bases.get(cp.getEnd()).setY(this.bases.get(cpnext.getStart()).getY() + rl * lny);
                                    this.bases.get(cp.getStart()).setX(this.bases.get(cp.getEnd()).getX() + cpy);
                                    this.bases.get(cp.getStart()).setY(this.bases.get(cp.getEnd()).getY() - cpx);
                                } else {
                                    j = ic - 1;
                                    if (j < 0) {
                                        j = lp.getNconnection() - 1;
                                    }
                                    cp = lp.getConnection(j);
                                    cpnext = lp.getConnection(ic);
                                    double cpnextx = cpnext.getXrad();
                                    double cpnexty = cpnext.getYrad();
                                    ac = (cp.getAngle() + cpnext.getAngle()) / 2.0;
                                    if (cp.getAngle() > cpnext.getAngle()) {
                                        ac -= Math.PI;
                                    }
                                    cnx = Math.cos(ac);
                                    cny = Math.sin(ac);
                                    lnx = -cny;
                                    lny = cnx;
                                    da = cpnext.getAngle() - cp.getAngle();
                                    if (da < 0.0) {
                                        da += Math.PI * 2;
                                    }
                                    rl = cp.isExtruded() ? (da <= 1.5707963267948966 ? 2.0 : 1.5) : 1.0;
                                    this.bases.get(cpnext.getStart()).setX(this.bases.get(cp.getEnd()).getX() + rl * lnx);
                                    this.bases.get(cpnext.getStart()).setY(this.bases.get(cp.getEnd()).getY() + rl * lny);
                                    this.bases.get(cpnext.getEnd()).setX(this.bases.get(cpnext.getStart()).getX() - cpnexty);
                                    this.bases.get(cpnext.getEnd()).setY(this.bases.get(cpnext.getStart()).getY() + cpnextx);
                                }
                            }
                        }
                        if (direction < 0) {
                            if (icdown == icend) {
                                icdown = -1;
                            } else if (icdown >= 0 && ++icdown >= lp.getNconnection()) {
                                icdown = 0;
                            }
                            direction = 1;
                        } else {
                            if (icup == icstart) {
                                icup = -1;
                            } else if (icup >= 0 && --icup < 0) {
                                icup = lp.getNconnection() - 1;
                            }
                            direction = -1;
                        }
                        boolean bl = done = icup == -1 && icdown == -1;
                    }
                    int icnext = icend + 1;
                    if (icnext >= lp.getNconnection()) {
                        icnext = 0;
                    }
                    if (icend != icstart && (icstart != icstart1 || icnext != icstart1)) {
                        cp = lp.getConnection(icstart);
                        cpnext = lp.getConnection(icend);
                        dx = this.bases.get(cpnext.getEnd()).getX() - this.bases.get(cp.getStart()).getX();
                        dy = this.bases.get(cpnext.getEnd()).getY() - this.bases.get(cp.getStart()).getY();
                        double midx = this.bases.get(cp.getStart()).getX() + dx / 2.0;
                        double midy = this.bases.get(cp.getStart()).getY() + dy / 2.0;
                        rr = Math.sqrt(dx * dx + dy * dy);
                        double mx = dx / rr;
                        double my = dy / rr;
                        double vx = xc - midx;
                        double vy = yc - midy;
                        rr = Math.sqrt(dx * dx + dy * dy);
                        double dotmv = (vx /= rr) * mx + (vy /= rr) * my;
                        double nrx = dotmv * mx - vx;
                        double nry = dotmv * my - vy;
                        rr = Math.sqrt(nrx * nrx + nry * nry);
                        nrx /= rr;
                        nry /= rr;
                        dx = this.bases.get(cp.getStart()).getX() - xc;
                        dy = this.bases.get(cp.getStart()).getY() - yc;
                        ac = Math.atan2(dy, dx);
                        if (ac < 0.0) {
                            ac += Math.PI * 2;
                        }
                        dx = this.bases.get(cpnext.getEnd()).getX() - xc;
                        dy = this.bases.get(cpnext.getEnd()).getY() - yc;
                        acn = Math.atan2(dy, dx);
                        if (acn < 0.0) {
                            acn += Math.PI * 2;
                        }
                        if (acn < ac) {
                            acn += Math.PI * 2;
                        }
                        int sign = acn - ac > Math.PI ? -1 : 1;
                        double nmidx = xc + (double)sign * radius * nrx;
                        double nmidy = yc + (double)sign * radius * nry;
                        if (rooted) {
                            xc -= nmidx - midx;
                            yc -= nmidy - midy;
                        } else {
                            ic = icstart;
                            while (true) {
                                cp = lp.getConnection(ic);
                                i = cp.getStart();
                                this.bases.get(i).setX(this.bases.get(i).getX() + nmidx - midx);
                                this.bases.get(i).setY(this.bases.get(i).getY() + nmidy - midy);
                                i = cp.getEnd();
                                this.bases.get(i).setX(this.bases.get(i).getX() + nmidx - midx);
                                this.bases.get(i).setY(this.bases.get(i).getY() + nmidy - midy);
                                if (ic == icend) break;
                                if (++ic < lp.getNconnection()) continue;
                                ic = 0;
                            }
                        }
                    }
                    boolean bl = done_all_connections = (icstart = icnext) == icstart1;
                }
                ic = 0;
                while (ic < lp.getNconnection()) {
                    cp = lp.getConnection(ic);
                    j = ic + 1;
                    if (j >= lp.getNconnection()) {
                        j = 0;
                    }
                    cpnext = lp.getConnection(j);
                    dx = this.bases.get(cp.getEnd()).getX() - xc;
                    dy = this.bases.get(cp.getEnd()).getY() - yc;
                    double rc = Math.sqrt(dx * dx + dy * dy);
                    ac = Math.atan2(dy, dx);
                    if (ac < 0.0) {
                        ac += Math.PI * 2;
                    }
                    dx = this.bases.get(cpnext.getStart()).getX() - xc;
                    dy = this.bases.get(cpnext.getStart()).getY() - yc;
                    double rcn = Math.sqrt(dx * dx + dy * dy);
                    acn = Math.atan2(dy, dx);
                    if (acn < 0.0) {
                        acn += Math.PI * 2;
                    }
                    if (acn < ac) {
                        acn += Math.PI * 2;
                    }
                    double dan = acn - ac;
                    double dcp = cpnext.getAngle() - cp.getAngle();
                    if (dcp <= 0.0) {
                        dcp += Math.PI * 2;
                    }
                    if (Math.abs(dan - dcp) > Math.PI) {
                        if (cp.isExtruded()) {
                            this.warningEmition("Warning from traverse_loop. Loop " + lp.getNumber() + " has crossed regions\n");
                            return;
                        }
                        if (cpnext.getStart() - cp.getEnd() != 1) {
                            cp.setExtruded(true);
                            continue block1;
                        }
                    }
                    if (cp.isExtruded()) {
                        this.construct_extruded_segment(cp, cpnext);
                        if (!"".equals(ribosketch.this.radialAlgorithmException)) {
                            return;
                        }
                    } else {
                        n = cpnext.getStart() - cp.getEnd();
                        if (n < 0) {
                            n += this.nbase + 1;
                        }
                        angleinc = dan / (double)n;
                        j = 1;
                        while (j < n) {
                            i = cp.getEnd() + j;
                            if (i > this.nbase) {
                                i -= this.nbase + 1;
                            }
                            double a = ac + (double)j * angleinc;
                            rr = rc + (rcn - rc) * (a - ac) / dan;
                            this.bases.get(i).setX(xc + rr * Math.cos(a));
                            this.bases.get(i).setY(yc + rr * Math.sin(a));
                            ++j;
                        }
                    }
                    ++ic;
                }
                break;
            }
            ic = 0;
            while (ic < lp.getNconnection()) {
                if (icroot != ic) {
                    cp = lp.getConnection(ic);
                    this.generate_region(cp);
                    if (!"".equals(ribosketch.this.radialAlgorithmException)) {
                        return;
                    }
                    this.traverse_loop(cp.getLoop(), cp);
                    if (!"".equals(ribosketch.this.radialAlgorithmException)) {
                        return;
                    }
                }
                ++ic;
            }
            n = 0;
            double sx = 0.0;
            double sy = 0.0;
            ic = 0;
            while (ic < lp.getNconnection()) {
                j = ic + 1;
                if (j >= lp.getNconnection()) {
                    j = 0;
                }
                cp = lp.getConnection(ic);
                cpnext = lp.getConnection(j);
                n += 2;
                sx += this.bases.get(cp.getStart()).getX() + this.bases.get(cp.getEnd()).getX();
                sy += this.bases.get(cp.getStart()).getY() + this.bases.get(cp.getEnd()).getY();
                if (!cp.isExtruded()) {
                    j = cp.getEnd() + 1;
                    while (j != cpnext.getStart()) {
                        if (j > this.nbase) {
                            j -= this.nbase + 1;
                        }
                        ++n;
                        sx += this.bases.get(j).getX();
                        sy += this.bases.get(j).getY();
                        ++j;
                    }
                }
                ++ic;
            }
            lp.setX(sx / (double)n);
            lp.setY(sy / (double)n);
        }

        private void determine_radius(Loop lp, double lencut) {
            double radius;
            double mindit;
            if (this.debug) {
                ribosketch.println((String)"  Determine_radius");
            }
            int imindit = 0;
            Connection cp = new Connection();
            Connection cpnext = new Connection();
            double rt2_2 = 0.7071068286895752;
            do {
                mindit = 1.0E10;
                double sumd = 0.0;
                double sumn = 0.0;
                int i = 0;
                while (i < lp.getNconnection()) {
                    double dt;
                    cp = lp.getConnection(i);
                    int j = i + 1;
                    if (j >= lp.getNconnection()) {
                        j = 0;
                    }
                    cpnext = lp.getConnection(j);
                    int end = cp.getEnd();
                    int start = cpnext.getStart();
                    if (start < end) {
                        start += this.nbase + 1;
                    }
                    if ((dt = cpnext.getAngle() - cp.getAngle()) <= 0.0) {
                        dt += Math.PI * 2;
                    }
                    double ci = !cp.isExtruded() ? (double)(start - end) : (dt <= 1.5707963267948966 ? 2.0 : 1.5);
                    sumn += dt * (1.0 / ci + 1.0);
                    sumd += dt * dt / ci;
                    double dit = dt / ci;
                    if (dit < mindit && !cp.isExtruded() && ci > 1.0) {
                        mindit = dit;
                        imindit = i;
                    }
                    ++i;
                }
                radius = sumn / sumd;
                if (radius < rt2_2) {
                    radius = rt2_2;
                }
                if (!(mindit * radius < lencut)) continue;
                lp.getConnection(imindit).setExtruded(true);
            } while (mindit * radius < lencut);
            if (lp.getRadius() > 0.0) {
                radius = lp.getRadius();
            } else {
                lp.setRadius(radius);
            }
        }

        private boolean connected_connection(Connection cp, Connection cpnext) {
            if (this.debug) {
                ribosketch.println((String)"  Connected_connection");
            }
            if (cp.isExtruded()) {
                return true;
            }
            return cp.getEnd() + 1 == cpnext.getStart();
        }

        private int find_ic_middle(int icstart, int icend, Connection anchor_connection, Connection acp, Loop lp) {
            if (this.debug) {
                ribosketch.println((String)"  Find_ic_middle");
            }
            int count = 0;
            int ret = -1;
            int ic = icstart;
            boolean done = false;
            while (!done) {
                if (count++ > lp.getNconnection() * 2) {
                    ribosketch.println((String)"Infinite loop detected in find_ic_middle");
                    ribosketch.this.radialAlgorithmException = "Infinite loop detected in find_ic_middle";
                    return -1;
                }
                if (anchor_connection != null && lp.getConnection(ic) == acp) {
                    ret = ic;
                }
                boolean bl = done = ic == icend;
                if (++ic < lp.getNconnection()) continue;
                ic = 0;
            }
            if (ret == -1) {
                int i = 1;
                ic = icstart;
                while (i < (count + 1) / 2) {
                    if (++ic >= lp.getNconnection()) {
                        ic = 0;
                    }
                    ++i;
                }
                ret = ic;
            }
            return ret;
        }

        private void generate_region(Connection cp) {
            int end;
            int start;
            if (this.debug) {
                ribosketch.println((String)"  Generate_region");
            }
            Region rp = cp.getRegion();
            int l = 0;
            if (cp.getStart() == rp.getStart1()) {
                start = rp.getStart1();
                end = rp.getEnd1();
            } else {
                start = rp.getStart2();
                end = rp.getEnd2();
            }
            if (this.bases.get(cp.getStart()).getX() > 9899.0 || this.bases.get(cp.getEnd()).getX() > 9899.0) {
                ribosketch.println((String)"Bad region passed to generate_region. Coordinates not defined.");
                ribosketch.this.radialAlgorithmException = "Bad region passed to generate_region. Coordinates not defined.";
                return;
            }
            int i = start + 1;
            while (i <= end) {
                this.bases.get(i).setX(this.bases.get(cp.getStart()).getX() + this.HELIX_FACTOR * (double)(++l) * cp.getXrad());
                this.bases.get(i).setY(this.bases.get(cp.getStart()).getY() + this.HELIX_FACTOR * (double)l * cp.getYrad());
                int mate = this.bases.get(i).getMate();
                this.bases.get(mate).setX(this.bases.get(cp.getEnd()).getX() + this.HELIX_FACTOR * (double)l * cp.getXrad());
                this.bases.get(mate).setY(this.bases.get(cp.getEnd()).getY() + this.HELIX_FACTOR * (double)l * cp.getYrad());
                ++i;
            }
        }

        private void construct_circle_segment(int start, int end) {
            if (this.debug) {
                ribosketch.println((String)"  Construct_circle_segment");
            }
            double dx = this.bases.get(end).getX() - this.bases.get(start).getX();
            double dy = this.bases.get(end).getY() - this.bases.get(start).getY();
            double rr = Math.sqrt(dx * dx + dy * dy);
            int l = end - start;
            if (l < 0) {
                l += this.nbase + 1;
            }
            if (rr >= (double)l) {
                dx /= rr;
                dy /= rr;
                int j = 1;
                while (j < l) {
                    int i = start + j;
                    if (i > this.nbase) {
                        i -= this.nbase + 1;
                    }
                    this.bases.get(i).setX(this.bases.get(start).getX() + dx * (double)j / (double)l);
                    this.bases.get(i).setY(this.bases.get(start).getY() + dy * (double)j / (double)l);
                    ++j;
                }
            } else {
                this.find_center_for_arc(l - 1, rr);
                if (!"".equals(ribosketch.this.radialAlgorithmException)) {
                    return;
                }
                double midx = this.bases.get(start).getX() + (dx /= rr) * rr / 2.0;
                double midy = this.bases.get(start).getY() + (dy /= rr) * rr / 2.0;
                double xn = dy;
                double yn = -dx;
                double nrx = midx + this._h * xn;
                double nry = midy + this._h * yn;
                double mx = this.bases.get(start).getX() - nrx;
                double my = this.bases.get(start).getY() - nry;
                rr = Math.sqrt(mx * mx + my * my);
                double a = Math.atan2(my, mx);
                int j = 1;
                while (j < l) {
                    int i = start + j;
                    if (i > this.nbase) {
                        i -= this.nbase + 1;
                    }
                    this.bases.get(i).setX(nrx + rr * Math.cos(a + (double)j * this.angleinc));
                    this.bases.get(i).setY(nry + rr * Math.sin(a + (double)j * this.angleinc));
                    ++j;
                }
            }
        }

        private void construct_extruded_segment(Connection cp, Connection cpnext) {
            boolean collision;
            int nend;
            int nstart;
            double da;
            if (this.debug) {
                ribosketch.println((String)"  Construct_extruded_segment");
            }
            double astart = cp.getAngle();
            double aend1 = cpnext.getAngle();
            double aend2 = aend1;
            if (aend2 < astart) {
                aend2 += 6.2831854820251465;
            }
            double aave = (astart + aend2) / 2.0;
            int start = cp.getEnd();
            int end = cpnext.getStart();
            int n = end - start;
            if (n < 0) {
                n += this.nbase + 1;
            }
            if ((da = cpnext.getAngle() - cp.getAngle()) < 0.0) {
                da += 6.2831854820251465;
            }
            if (n == 2) {
                this.construct_circle_segment(start, end);
            }
            if (!"".equals(ribosketch.this.radialAlgorithmException)) {
                return;
            }
            double dx = this.bases.get(end).getX() - this.bases.get(start).getX();
            double dy = this.bases.get(end).getY() - this.bases.get(start).getY();
            double rr = Math.sqrt(dx * dx + dy * dy);
            dx /= rr;
            dy /= rr;
            if (rr >= 1.5 && da <= 1.5707963267948966) {
                nstart = start + 1;
                if (nstart > this.nbase) {
                    nstart -= this.nbase + 1;
                }
                if ((nend = end - 1) < 0) {
                    nend += this.nbase + 1;
                }
                this.bases.get(nstart).setX(this.bases.get(start).getX() + 0.5 * dx);
                this.bases.get(nstart).setY(this.bases.get(start).getY() + 0.5 * dy);
                this.bases.get(nend).setX(this.bases.get(end).getX() - 0.5 * dx);
                this.bases.get(nend).setY(this.bases.get(end).getY() - 0.5 * dy);
                start = nstart;
                end = nend;
            }
            do {
                double dac;
                collision = false;
                this.construct_circle_segment(start, end);
                if (!"".equals(ribosketch.this.radialAlgorithmException)) {
                    return;
                }
                nstart = start + 1;
                if (nstart > this.nbase) {
                    nstart -= this.nbase + 1;
                }
                dx = this.bases.get(nstart).getX() - this.bases.get(start).getX();
                dy = this.bases.get(nstart).getY() - this.bases.get(start).getY();
                double a1 = Math.atan2(dy, dx);
                if (a1 < 0.0) {
                    a1 += Math.PI * 2;
                }
                if ((dac = a1 - astart) < 0.0) {
                    dac += Math.PI * 2;
                }
                if (dac > Math.PI) {
                    collision = true;
                }
                if ((nend = end - 1) < 0) {
                    nend += this.nbase + 1;
                }
                dx = this.bases.get(nend).getX() - this.bases.get(end).getX();
                dy = this.bases.get(nend).getY() - this.bases.get(end).getY();
                double a2 = Math.atan2(dy, dx);
                if (a2 < 0.0) {
                    a2 += Math.PI * 2;
                }
                if ((dac = aend1 - a2) < 0.0) {
                    dac += Math.PI * 2;
                }
                if (dac > Math.PI) {
                    collision = true;
                }
                if (!collision) continue;
                double ac = this.minf2(aave, astart + 0.5);
                this.bases.get(nstart).setX(this.bases.get(start).getX() + Math.cos(ac));
                this.bases.get(nstart).setY(this.bases.get(start).getY() + Math.sin(ac));
                start = nstart;
                ac = this.maxf2(aave, aend2 - 0.5);
                this.bases.get(nend).setX(this.bases.get(end).getX() + Math.cos(ac));
                this.bases.get(nend).setY(this.bases.get(end).getY() + Math.sin(ac));
                end = nend;
                n -= 2;
            } while (collision && n > 1);
        }

        private void find_center_for_arc(double n, double b) {
            double theta;
            double h;
            double e;
            if (this.debug) {
                ribosketch.println((String)"  Find_center_for_arc");
            }
            double hhi = (n + 1.0) / Math.PI;
            double hlow = -hhi - b / (n + (double)1.000001f - b);
            if (b < 1.0) {
                hlow = 0.0;
            }
            int iter = 0;
            do {
                double phi;
                h = (hhi + hlow) / 2.0;
                double r = ribosketch.sqrt((float)((float)(h * h + b * b / 4.0)));
                double disc = 1.0 - 0.5 / (h * h + b * b / 4.0);
                if (ribosketch.abs((float)((float)disc)) > 1.0f) {
                    ribosketch.println((String)("WARNING! Unexpectedly large magnitude discriminant = " + disc + " r: " + r));
                    if (disc < -1.0) {
                        disc = -1.0;
                        ribosketch.println((String)"WARNING! forcing disc to be -1 from less than -1");
                    }
                }
                if ((e = (theta = Math.acos(disc)) * (n + 1.0) + 2.0 * (phi = Math.acos(h / r)) - Math.PI * 2) > 0.0) {
                    hlow = h;
                    continue;
                }
                hhi = h;
            } while (Math.abs(e) > (double)1.0E-4f && ++iter < 500);
            if (iter >= 500) {
                if (this.noIterationFailureYet) {
                    this.noIterationFailureYet = false;
                    this.warningEmition("Iteration failed in find_center_for_arc");
                    return;
                }
                h = 0.0;
                theta = 0.0;
            }
            this._h = h;
            this.angleinc = theta;
        }

        private double minf2(double x1, double x2) {
            return x1 < x2 ? x1 : x2;
        }

        private double maxf2(double x1, double x2) {
            return x1 > x2 ? x1 : x2;
        }

        public void warningEmition(String warningMessage) {
            ribosketch.this.radialAlgorithmException = warningMessage;
            ribosketch.println((String)warningMessage);
        }
    }

    public class Radloop {
        private double radius;
        private int loopnumber;
        private Radloop next;
        private Radloop prev;

        public double getRadius() {
            return this.radius;
        }

        public void setRadius(double radius) {
            this.radius = radius;
        }

        public int getLoopnumber() {
            return this.loopnumber;
        }

        public void setLoopnumber(int loopnumber) {
            this.loopnumber = loopnumber;
        }

        public Radloop getNext() {
            return this.next;
        }

        public void setNext(Radloop next) {
            this.next = next;
        }

        public Radloop getPrev() {
            return this.prev;
        }

        public void setPrev(Radloop prev) {
            this.prev = prev;
        }
    }

    public class Region {
        private int _start1;
        private int _end1;
        private int _start2;
        private int _end2;

        public int getStart1() {
            return this._start1;
        }

        public void setStart1(int start1) {
            this._start1 = start1;
        }

        public int getEnd1() {
            return this._end1;
        }

        public void setEnd1(int end1) {
            this._end1 = end1;
        }

        public int getStart2() {
            return this._start2;
        }

        public void setStart2(int start2) {
            this._start2 = start2;
        }

        public int getEnd2() {
            return this._end2;
        }

        public void setEnd2(int end2) {
            this._end2 = end2;
        }
    }

    public class ResetCircleCheckBox
    extends CheckBox {
        ResetCircleCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.saveStateForUndo();
            ribosketch.this.resetCircle();
            ribosketch.this.textDisplay = "CIRCLE LAYOUT";
            ribosketch.this.textDisplayCount = 0;
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class ResetRadialCheckBox
    extends CheckBox {
        ResetRadialCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.saveStateForUndo();
            ribosketch.this.resetRadial();
            ribosketch.this.textDisplay = "RADIAL LAYOUT";
            ribosketch.this.textDisplayCount = 0;
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class RigidHairpinsCheckBox
    extends CheckBox {
        RigidHairpinsCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
            this.checked = ribosketch.this.rigidHairpins;
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.wasRigidHairpins = ribosketch.this.rigidHairpins = (this.checked = !this.checked);
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class RigidHelixCheckBox
    extends CheckBox {
        RigidHelixCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
            this.checked = ribosketch.this.rigidHelices;
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.saveStateForUndo();
            this.checked = !this.checked;
            boolean bl = ribosketch.this.rigidHelices = !ribosketch.this.rigidHelices;
            if (ribosketch.this.rigidHelices) {
                ribosketch.this.rigidHairpins = ribosketch.this.wasRigidHairpins;
                ribosketch.this.checkBoxes.get((Object)"Rigid Loops").checked = ribosketch.this.rigidLoops = ribosketch.this.wasRigidLoops;
                ribosketch.this.checkBoxes.get((Object)"Rigid Hairpins").checked = ribosketch.this.rigidHairpins;
            } else {
                ribosketch.this.wasRigidLoops = ribosketch.this.rigidLoops;
                ribosketch.this.wasRigidHairpins = ribosketch.this.rigidHairpins;
                ribosketch.this.rigidLoops = false;
                ribosketch.this.checkBoxes.get((Object)"Rigid Loops").checked = false;
                ribosketch.this.rigidHairpins = false;
                ribosketch.this.checkBoxes.get((Object)"Rigid Hairpins").checked = false;
            }
            ribosketch.this.textDisplay = ribosketch.this.rigidHelices ? "HELICES FIXED" : "HELICES UNFIXED";
            ribosketch.this.textDisplayCount = 0;
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class RigidLoopsCheckBox
    extends CheckBox {
        RigidLoopsCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
            this.checked = ribosketch.this.rigidLoops;
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.wasRigidLoops = ribosketch.this.rigidLoops = (this.checked = !this.checked);
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class SaveCheckBox
    extends CheckBox {
        SaveCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.saveStateForUndo();
            ribosketch.this.simWasOn = ribosketch.this.simulationMode;
            ribosketch.this.simulationMode = false;
            ribosketch.this.selectFolder("Select a folder to save to", "saveFolderSelected", ribosketch.this.userFile.getParentFile());
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class SimulateAllCheckBox
    extends CheckBox {
        SimulateAllCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
            this.checked = !ribosketch.this.simulateAllMode;
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            this.checked = !this.checked;
            ribosketch.this.simulateAllMode = !this.checked;
            ribosketch.this.textDisplay = !ribosketch.this.simulateAllMode ? "SIMULATE SELECTED ONLY" : "SIMULATE ALL";
            ribosketch.this.textDisplayCount = 0;
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    class SimulationSetup {
        String seqTot;
        int lenTot;
        int[] starts;
        String[] sequences;
        int[] seqIds;
        ArrayList<int[]> foldSteps = new ArrayList();
        int[] strandOrder;
        int[] residueOrder;
        Short[] pairTable;
        ArrayList<Short> pairTableOptimal = new ArrayList();
        HashMap<String, String> nonCanonicals = new HashMap();
        String errorMessage = "";
        String warningMessage = "";

        SimulationSetup() {
        }

        public SimulationSetup cloneFunction() {
            SimulationSetup result = new SimulationSetup();
            result.nonCanonicals.putAll(this.nonCanonicals);
            result.pairTableOptimal.addAll(this.pairTableOptimal);
            result.seqTot = this.seqTot;
            result.lenTot = this.lenTot;
            result.starts = ribosketch.this.intArrayClone(this.starts);
            result.sequences = ribosketch.this.stringArrayClone(this.sequences);
            result.seqIds = ribosketch.this.intArrayClone(this.seqIds);
            result.foldSteps.addAll(this.foldSteps);
            result.strandOrder = ribosketch.this.intArrayClone(this.strandOrder);
            result.residueOrder = ribosketch.this.intArrayClone(this.residueOrder);
            result.pairTable = ribosketch.this.shortArrayClone(this.pairTable);
            result.errorMessage = this.errorMessage;
            result.warningMessage = this.warningMessage;
            return result;
        }

        public SimulationState initFile(String fileName, String fileType) {
            File loadFile;
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)("\nStarting SimulationSetup.initFile for input file " + fileName));
            }
            if (!(loadFile = new File(fileName)).isFile()) {
                ribosketch.println((String)("Could not find file with name " + fileName));
                this.errorMessage = "File  " + fileName + "  could not be loaded";
                return new SimulationState();
            }
            String userFileName = ribosketch.this.userFile.getName();
            ribosketch.this.surface.setTitle(userFileName);
            if (fileType == null) {
                fileType = "";
                int i = userFileName.length();
                while (i > 0) {
                    if (".".equals(userFileName.substring(i - 1, i))) {
                        if (i >= userFileName.length()) break;
                        fileType = userFileName.substring(i);
                        break;
                    }
                    --i;
                }
            }
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)("File type is " + fileType));
            }
            return this.initFileType(fileName, fileType);
        }

        public SimulationState initFileType(String fileName, String fileType) {
            if ("ct".equals(fileType) || "bpseq".equals(fileType)) {
                this.initColumnFile(fileName, fileType);
            } else if ("dbn".equals(fileType)) {
                this.initBracketFile(fileName);
            } else {
                if ("rs".equals(fileType)) {
                    SimulationState simState = this.initSaveFile(fileName);
                    if ("".equals(this.errorMessage)) {
                        ribosketch.this.checkLengthForRigidLoops = false;
                        return simState;
                    }
                    if (ribosketch.this.debugPrints) {
                        ribosketch.println((String)"InitFileException caught from rs file type in initFile:");
                        ribosketch.println((String)this.errorMessage);
                    }
                    return new SimulationState();
                }
                if ("nts".equals(fileType)) {
                    this.initNtsPairs(fileName);
                } else if ("seq".equals(fileType)) {
                    this.initSequenceFile(fileName);
                } else {
                    String[] stringArray = new String[]{"ct", "bpseq", "dbn", "rs", "nts", "seq"};
                    String[] fileTypes = stringArray;
                    int itemHeight = 40;
                    float listHeight = fileTypes.length * itemHeight;
                    float yStart = 100.0f;
                    if (listHeight + yStart > (float)(ribosketch.this.height - 135) && (listHeight = (float)(PApplet.parseInt((float)(((float)(ribosketch.this.height - 135) - yStart) / (float)itemHeight)) * itemHeight)) < (float)itemHeight) {
                        listHeight = itemHeight;
                    }
                    ribosketch.this.fileTypeSelector = new Listbox(30.0f, yStart, 150.0f, listHeight, itemHeight, fileTypes, ++ribosketch.this.displaySelectorId);
                    ribosketch.this.selectingFileType = true;
                    if (ribosketch.this.debugPrints) {
                        ribosketch.println((String)"Please input file type");
                    }
                    this.errorMessage = String.valueOf(this.errorMessage) + "Could not identify file type automatically";
                    return new SimulationState();
                }
            }
            if ("".equals(this.errorMessage)) {
                this.initTables();
                if (ribosketch.this.debugPrints) {
                    this.setupDebug();
                }
                ribosketch.this.ds = new DisplaySettings();
                if (this.lenTot > 1300) {
                    ribosketch.this.ds.labelMode = false;
                    if (this.lenTot > 2500) {
                        ribosketch.this.ds.outlineMode = false;
                    }
                }
                SphereList spheres = this.initDefSphereList();
                return this.createRadialState(spheres);
            }
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"InitFileException caught in initFile:");
                ribosketch.println((String)this.errorMessage);
            }
            return new SimulationState();
        }

        public void initFoldSteps() {
            ArrayList<int[]> pairs = new ArrayList<int[]>();
            int i = 0;
            while (i < this.pairTable.length) {
                short pairId = this.pairTable[i];
                if (pairId > i) {
                    int[] pair = new int[]{i, pairId};
                    pairs.add(pair);
                }
                ++i;
            }
            this.foldSteps = pairs;
        }

        public void initTables() {
            this.initFoldSteps();
            this.strandOrder = this.orderStrands();
            this.residueOrder = this.initOrder(this);
            this.generatePairTableOptimal();
        }

        public SphereList initDefSphereList() {
            SphereList sl = new SphereList();
            int i = 0;
            while (i < this.lenTot) {
                sl.add(new Sphere2D(i, this.seqIds[i], this.seqTot.substring(i, i + 1), new String[this.lenTot]));
                if (i > 0 && this.seqIds[i - 1] == this.seqIds[i]) {
                    sl.get((int)(i - 1)).threeP = sl.get(i);
                    sl.get((int)i).fiveP = sl.get(i - 1);
                }
                ++i;
            }
            int currStrandId = sl.get((int)0).strandId;
            int idOffset = 0;
            int i2 = 0;
            while (i2 < this.lenTot) {
                int relId;
                int strandId = sl.get((int)i2).strandId;
                if (strandId != currStrandId) {
                    idOffset = i2;
                    currStrandId = strandId;
                }
                sl.get((int)i2).relId = relId = i2 - idOffset;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.pairTable.length) {
                short pairId = this.pairTable[i2];
                if (pairId > i2) {
                    String type = "cWW";
                    if (this.nonCanonicals.containsKey(String.valueOf(i2) + " " + pairId)) {
                        type = this.nonCanonicals.get(String.valueOf(i2) + " " + pairId);
                    }
                    ribosketch.this.setForcePair(sl.get(i2), sl.get(pairId), type, this);
                }
                ++i2;
            }
            for (Map.Entry<String, String> nc : this.nonCanonicals.entrySet()) {
                String bondType;
                String[] pair = nc.getKey().split(" ");
                int id1 = PApplet.parseInt((String)pair[0]);
                int id2 = PApplet.parseInt((String)pair[1]);
                sl.get((int)id1).bonds[id2] = bondType = nc.getValue();
                sl.get((int)id2).bonds[id1] = bondType;
            }
            return sl;
        }

        public void initColumnFile(String fileName, String fileType) {
            int i;
            int numColumns = 6;
            int pairedCol = 4;
            if ("bpseq".equals(fileType)) {
                numColumns = 3;
                pairedCol = 2;
            }
            String[] lines = ribosketch.this.loadStrings(fileName);
            int i2 = 0;
            while (i2 < lines.length) {
                lines[i2] = lines[i2].trim().replaceAll("\\s+", " ");
                ++i2;
            }
            String[] header = null;
            int headerIndex = -1;
            int i3 = 0;
            while (i3 < lines.length) {
                if (!lines[i3].equals("") && !lines[i3].substring(0, 1).equals("#")) {
                    header = ribosketch.split((String)lines[i3], (String)" ");
                    headerIndex = i3;
                    break;
                }
                ++i3;
            }
            if (header == null) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"No valid lines");
                }
                this.errorMessage = "No valid lines!";
                return;
            }
            if (header.length == numColumns && header[0].matches("^\\d+$") && PApplet.parseInt((String)header[0]) == 1 && header[1].matches("[a-zA-Z]") && header[pairedCol].matches("^\\d+$") && ("bpseq".equals(fileType) || "ct".equals(fileType) && header[2].matches("^\\d+$") && header[3].matches("^\\d+$") && header[5].matches("^\\d+$"))) {
                header = null;
                --headerIndex;
            }
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)("headerIndex: " + headerIndex));
            }
            int numSeqs = 1;
            this.starts = new int[1];
            this.starts[0] = 0;
            this.sequences = new String[1];
            int dataLength = lines.length - (headerIndex + 1);
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)("dataLength: " + dataLength));
            }
            boolean multipleStrands = false;
            if (header != null && header.length > 3) {
                boolean flag = false;
                String[] stringArray = header;
                int n = header.length;
                int n2 = 0;
                while (n2 < n) {
                    String argument = stringArray[n2];
                    if (!argument.matches("^\\d+$")) {
                        flag = true;
                        break;
                    }
                    ++n2;
                }
                if (!flag && PApplet.parseInt((String)header[1]) == header.length - 2 && PApplet.parseInt((String)header[2]) == 1) {
                    int arg1;
                    numSeqs = PApplet.parseInt((String)header[1]);
                    this.starts = new int[numSeqs];
                    this.starts[0] = 0;
                    flag = false;
                    int i4 = 1;
                    while (i4 < numSeqs) {
                        if (PApplet.parseInt((String)header[i4 + 2]) <= PApplet.parseInt((String)header[i4 + 1])) {
                            flag = true;
                            if (!ribosketch.this.debugPrints) break;
                            ribosketch.println((String)"The strand start indexes (arguments 3 and up in header) must be in ascending order!");
                            break;
                        }
                        this.starts[i4] = PApplet.parseInt((String)header[i4 + 2]) - 1;
                        ++i4;
                    }
                    if (!flag && (arg1 = PApplet.parseInt((String)header[0])) >= 2 && arg1 <= dataLength && this.starts[this.starts.length - 1] < arg1 && arg1 >= numSeqs) {
                        multipleStrands = true;
                        this.sequences = new String[numSeqs];
                    }
                }
            }
            if (ribosketch.this.debugPrints && multipleStrands) {
                ribosketch.println((String)"multipleStrands = true");
            }
            if (!multipleStrands) {
                numSeqs = 1;
                this.starts = new int[1];
                this.starts[0] = 0;
                this.sequences = new String[1];
            }
            this.seqTot = "";
            ArrayList<Short> pairedIdCol = new ArrayList<Short>();
            if ("bpseq".equals(fileType) || multipleStrands) {
                int index = headerIndex + 1;
                boolean endOfData = false;
                i = 0;
                while (i < numSeqs) {
                    if (!endOfData) {
                        int endIndex = i + 1 < this.starts.length ? this.starts[i + 1] : dataLength;
                        this.sequences[i] = "";
                        int j = this.starts[i];
                        while (j < endIndex) {
                            if (index >= lines.length) {
                                if (!ribosketch.this.debugPrints) break;
                                ribosketch.println((String)"End of file");
                                break;
                            }
                            if (!lines[index].equals("") && !lines[index].substring(0, 1).equals("#")) {
                                String[] columns = ribosketch.split((String)lines[index], (String)" ");
                                if (!(columns.length == numColumns && columns[0].matches("^\\d+$") && PApplet.parseInt((String)columns[0]) == j + 1 && columns[1].matches("[a-zA-Z]") && columns[1].length() == 1 && columns[pairedCol].matches("^\\d+$") && PApplet.parseInt((String)columns[pairedCol]) <= 32765)) {
                                    if (j < dataLength) {
                                        if (ribosketch.this.debugPrints) {
                                            ribosketch.println((String)("CAUTION, INVALID LINE: " + ribosketch.str((int)(index + 1))));
                                        }
                                        this.warningMessage = String.valueOf(this.warningMessage) + "Caution: File line " + ribosketch.str((int)(index + 1)) + " (info for base " + ribosketch.str((int)(j + 1)) + ") is invalid.\n";
                                    }
                                    endOfData = true;
                                    break;
                                }
                                ++j;
                                this.seqTot = String.valueOf(this.seqTot) + columns[1];
                                int n = i;
                                this.sequences[n] = String.valueOf(this.sequences[n]) + columns[1];
                                int pairedId = PApplet.parseInt((String)columns[pairedCol]);
                                pairedIdCol.add((short)(pairedId - 1));
                            }
                            ++index;
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"Looking for strand starts as 0s in the 3rd column of ct");
                }
                ArrayList<String> sequencesList = new ArrayList<String>();
                ArrayList<Integer> startsList = new ArrayList<Integer>();
                int baseCount = 0;
                String currentSeq = "";
                int i5 = headerIndex + 1;
                while (i5 < lines.length && baseCount < dataLength) {
                    if (!lines[i5].equals("") && !lines[i5].substring(0, 1).equals("#")) {
                        String[] columns = ribosketch.split((String)lines[i5], (String)" ");
                        if (!(columns.length == numColumns && columns[0].matches("^\\d+$") && PApplet.parseInt((String)columns[0]) == baseCount + 1 && columns[1].matches("[a-zA-Z]") && columns[1].length() == 1 && columns[pairedCol].matches("^\\d+$") && PApplet.parseInt((String)columns[pairedCol]) <= 32765 && columns[2].matches("^\\d+$") && columns[3].matches("^\\d+$"))) {
                            if (baseCount >= dataLength) break;
                            if (ribosketch.this.debugPrints) {
                                ribosketch.println((String)("CAUTION: INVALID LINE: " + ribosketch.str((int)(i5 + 1))));
                            }
                            this.warningMessage = String.valueOf(this.warningMessage) + "Caution: File line " + ribosketch.str((int)(i5 + 1)) + " (info for base " + ribosketch.str((int)(this.seqTot.length() + 1)) + ") is invalid.\n";
                            break;
                        }
                        pairedIdCol.add((short)(PApplet.parseInt((String)columns[pairedCol]) - 1));
                        if ("0".equals(columns[2])) {
                            startsList.add(baseCount);
                            if (baseCount != 0) {
                                sequencesList.add(currentSeq);
                                currentSeq = "";
                            }
                        }
                        currentSeq = String.valueOf(currentSeq) + columns[1];
                        this.seqTot = String.valueOf(this.seqTot) + columns[1];
                        ++baseCount;
                    }
                    ++i5;
                }
                sequencesList.add(currentSeq);
                this.starts = new int[startsList.size()];
                Iterator iterator = startsList.iterator();
                int i6 = 0;
                while (i6 < this.starts.length) {
                    this.starts[i6] = (Integer)iterator.next();
                    ++i6;
                }
                this.sequences = sequencesList.toArray(new String[sequencesList.size()]);
                numSeqs = this.starts.length;
            }
            this.pairTable = pairedIdCol.toArray(new Short[pairedIdCol.size()]);
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)("Number of pairs: " + lines.length));
            }
            this.lenTot = this.seqTot.length();
            if (this.lenTot <= 0 || this.starts.length == 0) {
                this.errorMessage = "No valid lines found!";
                return;
            }
            if (this.starts[this.starts.length - 1] >= this.lenTot || multipleStrands && header != null && this.lenTot != PApplet.parseInt((String)header[0])) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"First arg incorrect");
                }
                this.warningMessage = String.valueOf(this.warningMessage) + "Caution: The first argument in the file header (total sequence length) does not equal the # of valid lines.\n\n";
                numSeqs = 1;
                this.starts = new int[1];
                this.starts[0] = 0;
                this.sequences = new String[1];
                this.sequences[0] = this.seqTot;
                multipleStrands = false;
            }
            this.checkPairTable(this.pairTable, this.lenTot);
            if (!"".equals(this.errorMessage)) {
                return;
            }
            this.seqIds = new int[this.lenTot];
            int sId = 0;
            int pc = 0;
            i = 0;
            while (i < numSeqs) {
                int j = 0;
                while (j < this.sequences[i].length()) {
                    this.seqIds[pc] = sId;
                    ++pc;
                    ++j;
                }
                ++sId;
                ++i;
            }
        }

        public void initBracketFile(String fileName) {
            int j;
            String[] lines = ribosketch.this.loadStrings(fileName);
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"Raw input:");
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    ribosketch.println((String)s);
                    ++n2;
                }
            }
            int i = 0;
            while (i < lines.length) {
                lines[i] = lines[i].trim().replaceAll("\\s+", " ");
                ++i;
            }
            int sequenceIndex = -1;
            int structureIndex = -1;
            int i2 = 0;
            while (i2 < lines.length) {
                String line = lines[i2];
                if (line.length() > 0) {
                    String seqChar = line.substring(0, 1);
                    if (line.matches("[a-zA-Z& ]+")) {
                        sequenceIndex = i2;
                        int j2 = i2 + 1;
                        while (j2 < lines.length) {
                            String startChar;
                            if (lines[j2].length() >= 1 && !(startChar = lines[j2].substring(0, 1)).equals("#") && !startChar.equals(" ")) {
                                structureIndex = j2;
                            }
                            ++j2;
                        }
                        break;
                    }
                }
                ++i2;
            }
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)("sequenceIndex: " + sequenceIndex));
                ribosketch.println((String)("structureIndex: " + structureIndex));
            }
            if (sequenceIndex < 0 || sequenceIndex >= lines.length - 1 || structureIndex < 1 || structureIndex >= lines.length) {
                this.errorMessage = "Could not read input \"dot bracket\" file";
                return;
            }
            String sequenceInput = lines[sequenceIndex];
            String structureInput = lines[structureIndex];
            ArrayList<Integer> startsList = new ArrayList<Integer>();
            startsList.add(0);
            this.seqTot = "";
            int i3 = 0;
            int l = 0;
            while (i3 < sequenceInput.length()) {
                String currentChar = sequenceInput.substring(i3, i3 + 1);
                if (!" ".equals(currentChar) && !"&".equals(currentChar)) {
                    String prevChar;
                    this.seqTot = String.valueOf(this.seqTot) + currentChar;
                    if (++l > 1 && (" ".equals(prevChar = sequenceInput.substring(i3 - 1, i3)) || "&".equals(prevChar))) {
                        startsList.add(l - 1);
                    }
                }
                ++i3;
            }
            this.starts = new int[startsList.size()];
            Iterator iterator = startsList.iterator();
            int i4 = 0;
            while (i4 < this.starts.length) {
                this.starts[i4] = (Integer)iterator.next();
                ++i4;
            }
            String catStruct = "";
            int i5 = 0;
            while (i5 < structureInput.length()) {
                String currentChar = structureInput.substring(i5, i5 + 1);
                if (!" ".equals(currentChar) && !"&".equals(currentChar)) {
                    catStruct = String.valueOf(catStruct) + currentChar;
                }
                ++i5;
            }
            if (this.seqTot.length() != catStruct.length()) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"seqTot and catStruct not same length");
                }
                this.errorMessage = "Sequence and structure input lines are not the same length";
                return;
            }
            this.lenTot = this.seqTot.length();
            if (this.lenTot > 32765) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)("Input structure (" + this.lenTot + " nucleotides) is too large."));
                }
                this.errorMessage = "Input structure (" + this.lenTot + " nucleotides) is too large.";
                return;
            }
            this.pairTable = new Short[this.lenTot];
            String[] pairChars = new String[]{"()", "[]", "{}", "<>"};
            ArrayList<OpenPair> pairs = new ArrayList<OpenPair>();
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"\n***Starting structure building loop***");
            }
            int i6 = 0;
            while (i6 < this.lenTot) {
                String currentChar = catStruct.substring(i6, i6 + 1);
                boolean match = false;
                int j3 = 0;
                while (j3 < pairChars.length) {
                    if (pairChars[j3].substring(0, 1).equals(currentChar)) {
                        match = true;
                        break;
                    }
                    ++j3;
                }
                if (match) {
                    pairs.add(new OpenPair(i6, currentChar));
                    if (ribosketch.this.debugPrints) {
                        ribosketch.println((String)("Added new open pair " + i6 + ", " + currentChar));
                    }
                } else {
                    this.pairTable[i6] = -1;
                    String pairChar = "";
                    j = 0;
                    while (j < pairChars.length) {
                        if (pairChars[j].substring(1, 2).equals(currentChar)) {
                            match = true;
                            pairChar = pairChars[j].substring(0, 1);
                            break;
                        }
                        ++j;
                    }
                    if (match) {
                        if (ribosketch.this.debugPrints) {
                            ribosketch.println((String)("Found closing " + i6 + ", " + currentChar));
                        }
                        j = pairs.size() - 1;
                        while (j >= 0) {
                            OpenPair op = (OpenPair)pairs.get(j);
                            if (pairChar.equals(op.openChar)) {
                                this.pairTable[op.index] = (short)i6;
                                this.pairTable[i6] = (short)op.index;
                                if (ribosketch.this.debugPrints) {
                                    ribosketch.println((String)("Adding bond " + i6 + ", " + op.index));
                                }
                                pairs.remove(j);
                                break;
                            }
                            --j;
                        }
                        if (this.pairTable[i6] == -1) {
                            if (ribosketch.this.debugPrints) {
                                ribosketch.println((String)("Unpaired " + currentChar + " at position " + ribosketch.str((int)(i6 + 1))));
                            }
                            this.errorMessage = "Unpaired \"" + currentChar + "\" at position " + ribosketch.str((int)(i6 + 1)) + " in structure file";
                            return;
                        }
                    }
                }
                ++i6;
            }
            this.checkPairTable(this.pairTable, this.lenTot);
            if (!"".equals(this.errorMessage)) {
                return;
            }
            int numSeqs = this.starts.length;
            this.sequences = new String[numSeqs];
            int i7 = 0;
            int l2 = numSeqs - 1;
            while (i7 < l2) {
                this.sequences[i7] = this.seqTot.substring(this.starts[i7], this.starts[i7 + 1]);
                ++i7;
            }
            this.sequences[numSeqs - 1] = this.seqTot.substring(this.starts[numSeqs - 1], this.lenTot);
            this.seqIds = new int[this.lenTot];
            int sId = 0;
            int pc = 0;
            int i8 = 0;
            while (i8 < numSeqs) {
                j = 0;
                while (j < this.sequences[i8].length()) {
                    this.seqIds[pc] = sId;
                    ++pc;
                    ++j;
                }
                ++sId;
                ++i8;
            }
        }

        public void initSequenceFile(String fileName) {
            String[] lines = ribosketch.this.loadStrings(fileName);
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"Raw input:");
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    ribosketch.println((String)s);
                    ++n2;
                }
            }
            int i = 0;
            while (i < lines.length) {
                lines[i] = lines[i].trim().replaceAll("\\s+", " ");
                ++i;
            }
            int sequenceIndex = -1;
            int structureIndex = -1;
            int i2 = 0;
            while (i2 < lines.length) {
                String line = lines[i2];
                if (line.length() > 0) {
                    String seqChar = line.substring(0, 1);
                    if (line.matches("[a-zA-Z& ]+")) {
                        sequenceIndex = i2;
                        int j = i2 + 1;
                        while (j < lines.length) {
                            String startChar;
                            if (lines[j].length() >= 1 && !(startChar = lines[j].substring(0, 1)).equals("#") && !startChar.equals(" ")) {
                                structureIndex = j;
                            }
                            ++j;
                        }
                        break;
                    }
                }
                ++i2;
            }
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)("sequenceIndex: " + sequenceIndex));
                ribosketch.println((String)("structureIndex: " + structureIndex));
            }
            if (sequenceIndex < 0 || sequenceIndex >= lines.length - 1) {
                this.errorMessage = "Could not read input \"dot bracket\" file";
                return;
            }
            String sequenceInput = lines[sequenceIndex];
            ArrayList<Integer> startsList = new ArrayList<Integer>();
            startsList.add(0);
            this.seqTot = "";
            int i3 = 0;
            int l = 0;
            while (i3 < sequenceInput.length()) {
                String currentChar = sequenceInput.substring(i3, i3 + 1);
                if (!" ".equals(currentChar) && !"&".equals(currentChar)) {
                    String prevChar;
                    this.seqTot = String.valueOf(this.seqTot) + currentChar;
                    if (++l > 1 && (" ".equals(prevChar = sequenceInput.substring(i3 - 1, i3)) || "&".equals(prevChar))) {
                        startsList.add(l - 1);
                    }
                }
                ++i3;
            }
            this.starts = new int[startsList.size()];
            Iterator iterator = startsList.iterator();
            int i4 = 0;
            while (i4 < this.starts.length) {
                this.starts[i4] = (Integer)iterator.next();
                ++i4;
            }
            this.lenTot = this.seqTot.length();
            if (this.lenTot > 32765) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)("Input structure (" + this.lenTot + " nucleotides) is too large."));
                }
                this.errorMessage = "Input structure (" + this.lenTot + " nucleotides) is too large.";
                return;
            }
            if (!"".equals(this.errorMessage)) {
                return;
            }
            int numSeqs = this.starts.length;
            this.sequences = new String[numSeqs];
            int i5 = 0;
            int l2 = numSeqs - 1;
            while (i5 < l2) {
                this.sequences[i5] = this.seqTot.substring(this.starts[i5], this.starts[i5 + 1]);
                ++i5;
            }
            this.sequences[numSeqs - 1] = this.seqTot.substring(this.starts[numSeqs - 1], this.lenTot);
            this.seqIds = new int[this.lenTot];
            int sId = 0;
            int pc = 0;
            int i6 = 0;
            while (i6 < numSeqs) {
                int j = 0;
                while (j < this.sequences[i6].length()) {
                    this.seqIds[pc] = sId;
                    ++pc;
                    ++j;
                }
                ++sId;
                ++i6;
            }
        }

        public void initNtsPairs(String fileName) {
            int pairsEndIndex;
            int ntsEndIndex;
            String[] lines = ribosketch.this.loadStrings(fileName);
            int i = 0;
            while (i < lines.length) {
                lines[i] = lines[i].trim().replaceAll("\\s+", " ");
                ++i;
            }
            int ntsIndex = -1;
            int pairsIndex = -1;
            int i2 = 0;
            while (i2 < lines.length) {
                String line = lines[i2];
                if ("NTS:".equals(line) || "nts:".equals(line) || "NUCLEOTIDES:".equals(line) || "nucleotides:".equals(line) || "Nucleotides:".equals(line)) {
                    ntsIndex = i2;
                } else if ("PAIRS:".equals(line) || "pairs:".equals(line) || "Pairs:".equals(line)) {
                    pairsIndex = i2;
                }
                if (ntsIndex != -1 && pairsIndex != -1) break;
                ++i2;
            }
            if (ntsIndex < 0 || ntsIndex >= lines.length || pairsIndex < 0 || pairsIndex >= lines.length || ntsIndex == pairsIndex) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"Could not read Nucleotides / Pairs file!");
                }
                this.errorMessage = "Could not read Nucleotides / Pairs file!";
                return;
            }
            if (ntsIndex < pairsIndex) {
                ntsEndIndex = pairsIndex - 1;
                pairsEndIndex = lines.length;
            } else {
                pairsEndIndex = ntsIndex - 1;
                ntsEndIndex = lines.length;
            }
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)("Starts: Nts=" + ntsIndex + ", pairs=" + pairsIndex));
                ribosketch.println((String)("Ends: Nts=" + ntsEndIndex + ", pairs=" + pairsEndIndex));
            }
            HashMap<String, Short> ntCodes = new HashMap<String, Short>();
            ArrayList<Integer> startsList = new ArrayList<Integer>();
            this.seqTot = "";
            int i3 = ntsIndex + 2;
            int count = 0;
            while (i3 < ntsEndIndex) {
                String[] line = lines[i3].split(" ");
                if (line.length != 0 && line[0].trim().length() != 0 && !"#".equals(line[0].trim().substring(0, 1))) {
                    if (line.length != 8 || !line[2].matches("^\\d+$") || line[6].length() != 3) break;
                    if ("1".equals(line[2])) {
                        startsList.add(count);
                    }
                    this.seqTot = String.valueOf(this.seqTot) + line[6].substring(1, 2);
                    ntCodes.put(line[7].substring(1, line[7].length()), (short)count);
                    ++count;
                }
                ++i3;
            }
            this.starts = new int[startsList.size()];
            Iterator iterator = startsList.iterator();
            int i4 = 0;
            while (i4 < this.starts.length) {
                this.starts[i4] = (Integer)iterator.next();
                ++i4;
            }
            if (this.starts.length == 0 || this.starts[0] != 0) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"Strand indecies in Nucleotides / Pairs file not formatted correctly!");
                }
                this.errorMessage = "Strand indecies in Nucleotides / Pairs file not formatted correctly!";
                return;
            }
            this.lenTot = this.seqTot.length();
            if (this.lenTot > 32765) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)("Input structure (" + this.lenTot + " nucleotides) is too large."));
                }
                this.errorMessage = "Input structure (" + this.lenTot + " nucleotides) is too large.";
                return;
            }
            int numSeqs = this.starts.length;
            this.sequences = new String[numSeqs];
            int i5 = 0;
            int l = numSeqs - 1;
            while (i5 < l) {
                this.sequences[i5] = this.seqTot.substring(this.starts[i5], this.starts[i5 + 1]);
                ++i5;
            }
            this.sequences[numSeqs - 1] = this.seqTot.substring(this.starts[numSeqs - 1], this.lenTot);
            this.pairTable = new Short[this.lenTot];
            i5 = 0;
            l = this.pairTable.length;
            while (i5 < l) {
                this.pairTable[i5] = -1;
                ++i5;
            }
            i5 = pairsIndex + 2;
            while (i5 < pairsEndIndex) {
                String[] line = lines[i5].split(" ");
                if (line.length != 0 && !"#".equals(lines[i5].trim().substring(0, 1))) {
                    short id2;
                    if (line.length != 9 || line[7].length() != 5) break;
                    String ntCode1 = line[2].substring(1, line[2].length());
                    String ntCode2 = line[3].substring(1, line[3].length());
                    short id1 = (Short)ntCodes.get(ntCode1);
                    if (id1 > (id2 = ((Short)ntCodes.get(ntCode2)).shortValue())) {
                        short tempId = id1;
                        id1 = id2;
                        id2 = tempId;
                    }
                    boolean firstBond = false;
                    if (this.pairTable[id1] == -1 && this.pairTable[id2] == -1) {
                        this.pairTable[id1] = id2;
                        this.pairTable[id2] = id1;
                        firstBond = true;
                    }
                    if (!"\"cWW\"".equals(line[7]) || !firstBond) {
                        this.nonCanonicals.put(String.valueOf(id1) + " " + id2, line[7].substring(1, 4));
                    }
                }
                ++i5;
            }
            this.checkPairTable(this.pairTable, this.lenTot);
            if (!"".equals(this.errorMessage)) {
                return;
            }
            this.seqIds = new int[this.lenTot];
            int sId = 0;
            int pc = 0;
            int i6 = 0;
            while (i6 < numSeqs) {
                int j = 0;
                while (j < this.sequences[i6].length()) {
                    this.seqIds[pc] = sId;
                    ++pc;
                    ++j;
                }
                ++sId;
                ++i6;
            }
        }

        /*
         * Unable to fully structure code
         */
        public SimulationState initSaveFile(String loadFileName) {
            simState = new SimulationState();
            spheres = new SphereList();
            s = simState.sim = new SimulationSetup();
            tempff = new ForceField();
            tempds = new DisplaySettings();
            noRigidLoopsEntry = true;
            coordinates = null;
            colorData = new ArrayList<Double>();
            input = ribosketch.this.loadStrings(loadFileName);
            i = 0;
            while (i < input.length) {
                block107: {
                    block113: {
                        block114: {
                            block111: {
                                block112: {
                                    block110: {
                                        block109: {
                                            block108: {
                                                if (input[i].equals("") || input[i].substring(0, 1).equals("#") || (words = input[i].split("=")).length < 2) break block107;
                                                if (!words[0].equals("sequences")) break block108;
                                                s.sequences = words[1].split("; ");
                                                break block107;
                                            }
                                            if (!words[0].equals("starts")) break block109;
                                            words2 = words[1].split(",");
                                            s.starts = new int[words2.length];
                                            j = 0;
                                            while (j < words2.length) {
                                                if (!words2[j].matches("^\\d+$")) {
                                                    this.errorMessage = "Start " + (j + 1) + " is not a valid number!";
                                                    return new SimulationState();
                                                }
                                                s.starts[j] = PApplet.parseInt((String)words2[j]);
                                                ++j;
                                            }
                                            break block107;
                                        }
                                        if (!words[0].equals("positions")) break block110;
                                        coordinates = words[1].split("; ");
                                        break block107;
                                    }
                                    if (!words[0].equals("radius")) break block111;
                                    if (!words[1].matches("[-+]?\\d*\\.?\\d*")) break block112;
                                    tempff.radius = ribosketch.this.stringToDouble(words[1]);
                                    if (tempff.radius < tempff.minRadius) {
                                        tempff.radius = tempff.minRadius;
                                    } else if (tempff.radius > tempff.minRadius + tempff.radiusScale) {
                                        tempff.radius = tempff.minRadius + tempff.radiusScale;
                                    }
                                    break block107;
                                }
                                this.errorMessage = "Radius is not a valid number!";
                                return new SimulationState();
                            }
                            if (!words[0].equals("backbone_distance")) break block113;
                            if (!words[1].matches("[-+]?\\d*\\.?\\d*")) break block114;
                            tempff.backboneDist = ribosketch.this.stringToDouble(words[1]);
                            if (tempff.backboneDist < tempff.minBackboneDist) {
                                tempff.backboneDist = tempff.minBackboneDist;
                            } else if (tempff.backboneDist > tempff.minBackboneDist + tempff.backboneDistScale) {
                                tempff.backboneDist = tempff.minBackboneDist + tempff.backboneDistScale;
                            }
                            break block107;
                        }
                        this.errorMessage = "Backbone distance is not a valid number!";
                        return new SimulationState();
                    }
                    if (!words[0].equals("basepair_distance")) ** GOTO lbl74
                    if (words[1].matches("[-+]?\\d*\\.?\\d*")) {
                        tempff.bpDist = ribosketch.this.stringToDouble(words[1]);
                        if (tempff.bpDist < tempff.minBpDist) {
                            tempff.bpDist = tempff.minBpDist;
                        } else if (tempff.bpDist > tempff.minBpDist + tempff.bpDistScale) {
                            tempff.bpDist = tempff.minBpDist + tempff.bpDistScale;
                        }
                    } else {
                        this.errorMessage = "Basepair distance is not a valid number!";
                        return new SimulationState();
lbl74:
                        // 1 sources

                        if (words[0].equals("color_scheme")) {
                            if (words[1].matches("^\\d+$") && PApplet.parseInt((String)words[1]) < 11) {
                                tempds.colorMode = PApplet.parseInt((String)words[1]);
                            }
                        } else if (words[0].equals("outline")) {
                            tempds.outlineMode = ribosketch.this.stringToBoolean(words[1]);
                        } else if (words[0].equals("movement")) {
                            ribosketch.this.simulationMode = ribosketch.this.stringToBoolean(words[1]);
                        } else if (words[0].equals("simulation_type")) {
                            ribosketch.this.simulateAllMode = ribosketch.this.stringToBoolean(words[1]);
                        } else if (words[0].equals("labels")) {
                            tempds.labelMode = ribosketch.this.stringToBoolean(words[1]);
                        } else if (words[0].equals("rigid_helices")) {
                            ribosketch.this.rigidHelices = ribosketch.this.stringToBoolean(words[1]);
                        } else if (words[0].equals("rigid_hairpins")) {
                            ribosketch.this.wasRigidHairpins = ribosketch.this.rigidHairpins = ribosketch.this.stringToBoolean(words[1]);
                        } else if (words[0].equals("rigid_loops")) {
                            noRigidLoopsEntry = false;
                            ribosketch.this.wasRigidLoops = ribosketch.this.rigidLoops = ribosketch.this.stringToBoolean(words[1]);
                        } else if (words[0].equals("relaxed_ids")) {
                            var17_49 = ids = words[1].split(" ");
                            var16_42 = ids.length;
                            var15_33 = 0;
                            while (var15_33 < var16_42) {
                                id = var17_49[var15_33];
                                if (id.matches("^\\d+$")) {
                                    spheres.relaxedIds.put(PApplet.parseInt((String)id), 1);
                                }
                                ++var15_33;
                            }
                        } else if (words[0].equals("display_order")) {
                            var17_49 = ids = words[1].split(",");
                            var16_43 = ids.length;
                            var15_34 = 0;
                            while (var15_34 < var16_43) {
                                id = var17_49[var15_34];
                                if (id.matches("^\\d+$")) {
                                    spheres.displayOrder.add(PApplet.parseInt((String)id));
                                }
                                ++var15_34;
                            }
                        } else if (words[0].equals("pair_table")) {
                            words2 = words[1].split(",");
                            s.pairTable = new Short[words2.length];
                            j = 0;
                            while (j < words2.length) {
                                pairedW = words2[j];
                                if (pairedW.matches("^-?\\d+$")) {
                                    if (PApplet.parseInt((String)pairedW) >= 32765) {
                                        this.errorMessage = "pair_table value " + (j + 1) + " is greater than the max value (32764)!";
                                        return new SimulationState();
                                    }
                                } else {
                                    this.errorMessage = "pair_table value " + (j + 1) + " is not a valid number";
                                    return new SimulationState();
                                }
                                s.pairTable[j] = (short)PApplet.parseInt((String)pairedW);
                                ++j;
                            }
                        } else if (words[0].equals("non_canonicals")) {
                            words2 = words[1].split(", ");
                            s.nonCanonicals = new HashMap<K, V>(words2.length);
                            j = 0;
                            while (j < words2.length) {
                                word = words2[j];
                                entries = word.split(" ");
                                if (entries.length == 3 && entries[0].matches("^\\d+$") && entries[1].matches("^\\d+$") && entries[2].length() == 3) {
                                    s.nonCanonicals.put(String.valueOf(entries[0]) + " " + entries[1], entries[2]);
                                } else if (ribosketch.this.debugPrints) {
                                    ribosketch.println((String)("Non Canonical entry number " + (j + 1) + " in save file incorrectly formatted"));
                                }
                                ++j;
                            }
                        } else if (words[0].equals("base_colors")) {
                            var17_49 = nums = words[1].split(",");
                            entries = nums.length;
                            word = 0;
                            while (word < entries) {
                                num = var17_49[word];
                                if (num.matches("-?\\d+(\\.\\d+)?")) {
                                    colorData.add(ribosketch.this.stringToDouble(num));
                                    ++word;
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                }
                ++i;
            }
            if (s.starts == null) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"Starts is null!");
                }
                this.errorMessage = "Missing starts argument in load file";
                return new SimulationState();
            }
            if (s.starts[0] != 0) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"First start is not 0!");
                }
                this.errorMessage = "First sequence start is not 0 (cooresponding to first residue)!";
                return new SimulationState();
            }
            i = 1;
            while (i < s.starts.length) {
                if (s.starts[i] <= s.starts[i - 1]) {
                    if (ribosketch.this.debugPrints) {
                        ribosketch.println((String)"Strand starts not in ascending order!");
                    }
                    this.errorMessage = "Strand starts not in ascending order!";
                    return new SimulationState();
                }
                ++i;
            }
            if (s.sequences == null) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"Sequences is null!");
                }
                this.errorMessage = "Missing sequences argument in load file";
                return new SimulationState();
            }
            if (s.starts.length != s.sequences.length) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"Sequences and starts arrays not of same length!");
                }
                this.errorMessage = "Sequences and starts arrays not of same length!";
                return new SimulationState();
            }
            i = 1;
            while (i < s.starts.length) {
                size = s.starts[i] - s.starts[i - 1];
                if (size != s.sequences[i - 1].length()) {
                    if (ribosketch.this.debugPrints) {
                        ribosketch.println((String)("Start " + (i - 1) + " to " + i + " does not match sequence " + i + " length!"));
                    }
                    this.errorMessage = "Start " + (i - 1) + " to " + i + " does not match sequence " + i + " length!";
                    return new SimulationState();
                }
                ++i;
            }
            s.seqTot = "";
            num = s.sequences;
            nums = s.sequences.length;
            size = 0;
            while (size < nums) {
                seq = num[size];
                s.seqTot = String.valueOf(s.seqTot) + seq;
                ++size;
            }
            s.lenTot = s.seqTot.length();
            s.seqIds = new int[s.lenTot];
            sId = 0;
            pc = 0;
            i = 0;
            while (i < s.sequences.length) {
                j = 0;
                while (j < s.sequences[i].length()) {
                    s.seqIds[pc] = sId;
                    ++pc;
                    ++j;
                }
                ++sId;
                ++i;
            }
            if (s.pairTable == null) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"pairTable array is null!");
                }
                this.errorMessage = "pair_table argument is missing from the load file!";
                return new SimulationState();
            }
            if (s.pairTable.length != s.lenTot) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"pairTable length does not equal lenTot!");
                }
                this.errorMessage = "Length of pair_table does not match the number of residues!";
                return new SimulationState();
            }
            this.checkPairTable(s.pairTable, s.lenTot);
            if (!"".equals(this.errorMessage)) {
                return new SimulationState();
            }
            s.initTables();
            for (Map.Entry<String, String> nc : s.nonCanonicals.entrySet()) {
                saveKey = nc.getKey().split(" ");
                id1 = PApplet.parseInt((String)saveKey[0]);
                if (id1 == (id2 = PApplet.parseInt((String)saveKey[1]))) {
                    if (!ribosketch.this.debugPrints) continue;
                    ribosketch.println((String)("In save file, non canonical pair \"" + nc + "\" describes a base paired with itself, which is impossible"));
                    this.warningMessage = String.valueOf(this.warningMessage) + "In save file, non canonical pair \"" + nc + "\" describes a base paired with itself, which is impossible";
                    continue;
                }
                if (id1 >= 0 && id1 < s.lenTot && id2 >= 0 && id2 < s.lenTot) continue;
                ribosketch.println((String)("In save file, non canonical pair \"" + nc + "\" is out of bounds!"));
                this.warningMessage = String.valueOf(this.warningMessage) + "In save file, non canonical pair \"" + nc + "\" is out of bounds!";
            }
            if (coordinates == null) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"coordinates array is null!");
                }
                this.errorMessage = "coordinates of bases are missing from the load file!";
                return new SimulationState();
            }
            if (coordinates.length != s.lenTot) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"Number of coordinate arguments does not match the number of residues!");
                }
                this.errorMessage = "Number of coordinate arguments does not match the number of residues!";
                return new SimulationState();
            }
            if (spheres.displayOrder.size() > s.lenTot) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"displayOrder greater than lenTot!");
                }
                this.errorMessage = "display_order is longer than the number of residues!";
                return new SimulationState();
            }
            if (spheres.displayOrder.size() < s.lenTot) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"displayOrder less than lenTot!");
                }
                this.errorMessage = "display_order is shorter than the number of residues!";
                return new SimulationState();
            }
            numChecks = new boolean[s.lenTot];
            for (int i : spheres.displayOrder) {
                if (i < 0 || i >= s.lenTot) {
                    if (ribosketch.this.debugPrints) {
                        ribosketch.println((String)("Value " + i + " in displayOrder is out of bounds!"));
                    }
                    this.errorMessage = "Value " + i + " in display_order is out of bounds!";
                    return new SimulationState();
                }
                if (numChecks[i]) {
                    if (ribosketch.this.debugPrints) {
                        ribosketch.println((String)"Repeated value in displayOrder. A residue cannot have two positions in the order!");
                    }
                    this.errorMessage = "Repeated value in display_order. A residue cannot have two positions in the order!";
                    return new SimulationState();
                }
                numChecks[i] = true;
            }
            numChecks = new boolean[s.lenTot];
            for (int relaxedId : spheres.relaxedIds.keySet()) {
                if (relaxedId < 0 || relaxedId >= s.lenTot) {
                    if (ribosketch.this.debugPrints) {
                        ribosketch.println((String)"Relaxed ids are out of bounds!");
                    }
                    this.errorMessage = "Relaxed ids are out of bounds!";
                    return new SimulationState();
                }
                if (numChecks[relaxedId]) {
                    if (ribosketch.this.debugPrints) {
                        ribosketch.println((String)("Relaxed id " + relaxedId + " is repeated!"));
                    }
                    this.errorMessage = "Relaxed id " + relaxedId + " is repeated!";
                    return new SimulationState();
                }
                numChecks[relaxedId] = true;
            }
            simState.spheres = s.initDefSphereList();
            newSpheres = simState.getSpheres();
            newSpheres.relaxedIds = spheres.relaxedIds;
            newSpheres.displayOrder = spheres.displayOrder;
            i = 0;
            while (i < s.lenTot) {
                words = coordinates[i].split(",");
                if (words.length < 2) {
                    if (ribosketch.this.debugPrints) {
                        ribosketch.println((String)("Not enough values for coordinate " + i + "!!!"));
                    }
                    x = 0.0;
                    y = 0.0;
                    z = 0.0;
                } else if (words[0].matches("[-+]?\\d*\\.?\\d*") && words[1].matches("[-+]?\\d*\\.?\\d*") && (words.length == 2 || words[2].matches("[-+]?\\d*\\.?\\d*"))) {
                    x = ribosketch.this.stringToDouble(words[0]);
                    y = ribosketch.this.stringToDouble(words[1]);
                    z = words.length >= 3 ? ribosketch.this.stringToDouble(words[2]) : 0.0;
                } else {
                    if (ribosketch.this.debugPrints) {
                        ribosketch.println((String)("Coordinate " + i + " has non-number values!"));
                    }
                    this.errorMessage = "Coordinate " + i + " has non-number values!";
                    return new SimulationState();
                }
                newSpheres.get((int)i).x = x;
                newSpheres.get((int)i).y = y;
                newSpheres.get((int)i).z = z;
                ++i;
            }
            if (colorData.size() == s.lenTot) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"Loading color data");
                }
                i = 0;
                while (i < s.lenTot) {
                    colorNumber = (Double)colorData.get(i);
                    newSpheres.get((int)i).colorNum = (float)colorNumber;
                    newSpheres.get((int)i).baseColor = ribosketch.this.lerpColor(tempds.startGradient, tempds.endGradient, (float)colorNumber);
                    ++i;
                }
            }
            ribosketch.this.ff = tempff;
            ribosketch.this.ds = tempds;
            if (noRigidLoopsEntry) {
                ribosketch.this.rigidLoops = false;
            }
            ribosketch.this.checkBoxes.get((Object)"Outlines").checked = ribosketch.this.ds.outlineMode;
            ribosketch.this.checkBoxes.get((Object)"Labels").checked = ribosketch.this.ds.labelMode;
            ribosketch.this.checkBoxes.get((Object)"Rigid Loops").checked = ribosketch.this.rigidLoops;
            ribosketch.this.checkBoxes.get((Object)"Rigid Hairpins").checked = ribosketch.this.rigidHairpins;
            ribosketch.this.checkBoxes.get((Object)"Sim. Selected Only").checked = ribosketch.this.simulateAllMode == false;
            ribosketch.this.textDisplay = "SAVE FILE LOADED";
            return simState;
        }

        public void checkPairTable(Short[] pairTable, int lenTot) {
            boolean[] pairCheck = new boolean[lenTot];
            int i = 0;
            while (i < pairTable.length) {
                short pairId = pairTable[i];
                if (pairId < -1 || pairId >= lenTot) {
                    if (ribosketch.this.debugPrints) {
                        ribosketch.println((String)("Residue " + (i + 1) + " paired with an out-of-bounds number"));
                    }
                    this.errorMessage = "Residue " + (i + 1) + " paired with an out of bounds number!";
                    return;
                }
                if (pairId != -1) {
                    if (pairId == i) {
                        if (ribosketch.this.debugPrints) {
                            ribosketch.println((String)("Residue " + i + " paired with itself!"));
                        }
                        this.errorMessage = "Residue " + (i + 1) + " cannot be paired with itself!";
                        return;
                    }
                    if (pairCheck[pairId]) {
                        if (ribosketch.this.debugPrints) {
                            ribosketch.println((String)("Residue " + (pairId + 1) + " is paired with multiple others!"));
                        }
                        this.errorMessage = "Residue " + (pairId + 1) + " is paired with multiple other residues!";
                        return;
                    }
                    if (pairTable[pairId] != i) {
                        if (ribosketch.this.debugPrints) {
                            ribosketch.println((String)("Residue " + (i + 1) + " is paired with residue " + (pairId + 1) + ", but residue " + (pairId + 1) + " is paired with " + (pairTable[pairId] + 1)));
                        }
                        this.errorMessage = "Residue " + (i + 1) + " is paired with residue " + (pairId + 1) + ", but residue " + (pairId + 1) + " is paired with " + (pairTable[pairId] + 1);
                        return;
                    }
                    pairCheck[pairId] = true;
                }
                i = (short)(i + 1);
            }
        }

        public int[] orderStrands() {
            ArrayList<InterHelix> helices = new ArrayList<InterHelix>();
            int startStrandId = -1;
            int endStrandId = -1;
            boolean foundHelix = false;
            int curHelSize = 0;
            int curStartStrand = -1;
            int curEndStrand = -1;
            int i = 0;
            int l = this.foldSteps.size();
            while (i < l) {
                int start = this.foldSteps.get(i)[0];
                int j = 0;
                while (j < this.starts.length) {
                    if (start >= this.starts[j] && (j >= this.starts.length - 1 || start < this.starts[j + 1])) {
                        startStrandId = j;
                        break;
                    }
                    ++j;
                }
                int end = this.foldSteps.get(i)[1];
                int j2 = 0;
                while (j2 < this.starts.length) {
                    if (end >= this.starts[j2] && (j2 >= this.starts.length - 1 || end < this.starts[j2 + 1])) {
                        endStrandId = j2;
                        break;
                    }
                    ++j2;
                }
                if (foundHelix) {
                    boolean connectedStrands;
                    InterHelix lastHelix = (InterHelix)helices.get(helices.size() - 1);
                    boolean sameHelix = lastHelix.end1.origId + curHelSize == start && lastHelix.end2.origId - 1 == end;
                    boolean bl = connectedStrands = curStartStrand == startStrandId || curEndStrand == endStrandId;
                    if (sameHelix && connectedStrands) {
                        ++curHelSize;
                        curStartStrand = startStrandId;
                        curEndStrand = endStrandId;
                        lastHelix.end2.origId = end;
                        lastHelix.end2.strandId = endStrandId;
                        lastHelix.end2.relId = end - this.starts[endStrandId];
                    } else {
                        foundHelix = false;
                    }
                }
                if (!foundHelix && startStrandId >= 0 && endStrandId >= 1 && startStrandId < endStrandId) {
                    helices.add(new InterHelix(startStrandId, start - this.starts[startStrandId], start, endStrandId, end - this.starts[endStrandId], end));
                    foundHelix = true;
                    curHelSize = 1;
                    curStartStrand = startStrandId;
                    curEndStrand = endStrandId;
                }
                ++i;
            }
            ArrayList<Strand> strands = new ArrayList<Strand>();
            int i2 = 0;
            while (i2 < this.sequences.length) {
                int strandLength = 0;
                int strandStart = this.starts[i2];
                strandLength = i2 < this.sequences.length - 1 ? this.starts[i2 + 1] - strandStart : this.lenTot - strandStart;
                strands.add(new Strand(i2, strandLength));
                ++i2;
            }
            for (InterHelix h : helices) {
                ((Strand)strands.get(h.end1.strandId)).addEnd(h.end1);
                ((Strand)strands.get(h.end2.strandId)).addEnd(h.end2);
            }
            int j = 0;
            while (j < this.sequences.length - 1) {
                int smallestDistance = 32765;
                int bestHelixId = -1;
                boolean forward = true;
                int i3 = 0;
                while (i3 < helices.size()) {
                    InterHelix h = (InterHelix)helices.get(i3);
                    if (h.end1.strandId != h.end2.strandId) {
                        int strandLength1 = ((Strand)strands.get((int)h.end1.strandId)).length;
                        int strandLength2 = ((Strand)strands.get((int)h.end2.strandId)).length;
                        int distanceSum = strandLength1 - h.end1.relId + h.end2.relId + 1;
                        if (distanceSum < smallestDistance) {
                            smallestDistance = distanceSum;
                            bestHelixId = i3;
                            forward = true;
                        }
                        if ((distanceSum = strandLength2 - h.end2.relId + h.end1.relId + 1) < smallestDistance) {
                            smallestDistance = distanceSum;
                            bestHelixId = i3;
                            forward = false;
                        }
                    }
                    ++i3;
                }
                if (bestHelixId == -1) break;
                InterHelix bestHelix = (InterHelix)helices.get(bestHelixId);
                Strand strand1 = (Strand)strands.get(bestHelix.end1.strandId);
                Strand strand2 = (Strand)strands.get(bestHelix.end2.strandId);
                if (!forward) {
                    Strand temp = strand1;
                    strand1 = strand2;
                    strand2 = temp;
                }
                for (HelixEnd end : strand2.helixEnds) {
                    end.relId += strand1.length;
                    end.strandId = strand1.id;
                    strand1.helixEnds.add(end);
                }
                strand1.length += strand2.length;
                Iterator<Object> iterator = strand2.strandIds.iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    strand1.strandIds.add(id);
                }
                strand2.length = 0;
                strand2.helixEnds.clear();
                strand2.strandIds.clear();
                ++j;
            }
            ArrayList<Integer> strandOrder = new ArrayList<Integer>();
            for (Strand s : strands) {
                strandOrder.addAll(s.strandIds);
            }
            int[] strandOrderOutput = new int[strandOrder.size()];
            if (ribosketch.this.debugPrints) {
                ribosketch.print((String)"\nOrder:");
            }
            int i4 = 0;
            while (i4 < strandOrder.size()) {
                strandOrderOutput[i4] = (Integer)strandOrder.get(i4);
                if (ribosketch.this.debugPrints) {
                    ribosketch.print((String)(" " + strandOrderOutput[i4]));
                }
                ++i4;
            }
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"");
            }
            return strandOrderOutput;
        }

        public int[] initOrder(SimulationSetup s) {
            int[] residueOrderIds = new int[s.lenTot];
            int orderId = 0;
            int[] nArray = s.strandOrder;
            int n = s.strandOrder.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                int strandLength = 0;
                int strandStart = s.starts[i];
                strandLength = i < s.sequences.length - 1 ? s.starts[i + 1] - strandStart : s.lenTot - strandStart;
                int j = strandStart;
                while (j < strandStart + strandLength) {
                    residueOrderIds[j] = orderId++;
                    ++j;
                }
                ++n2;
            }
            return residueOrderIds;
        }

        public void generatePairTableOptimal() {
            int[] residueOrderSequence = new int[this.lenTot];
            int i = 0;
            while (i < this.lenTot) {
                residueOrderSequence[this.residueOrder[i]] = i;
                ++i;
            }
            this.pairTableOptimal = new ArrayList(this.pairTable.length);
            i = 0;
            while (i < this.pairTable.length) {
                short pairedId = this.pairTable[residueOrderSequence[i]];
                short pairedOrderedId = pairedId != -1 ? (short)((short)this.residueOrder[pairedId]) : (short)-1;
                this.pairTableOptimal.add(pairedOrderedId);
                ++i;
            }
            ArrayList<Helix> helices = new ArrayList<Helix>();
            short end2 = -1;
            int size = 0;
            boolean inHelix = false;
            int i2 = 0;
            while (i2 < this.pairTableOptimal.size()) {
                short pairedW = this.pairTableOptimal.get(i2);
                if (!inHelix) {
                    if (i2 < pairedW) {
                        inHelix = true;
                        size = 1;
                        end2 = pairedW;
                        helices.add(new Helix(i2, end2, i2));
                    }
                    ++i2;
                    continue;
                }
                if (--end2 == pairedW) {
                    ++i2;
                    ++size;
                    continue;
                }
                ((Helix)helices.get(helices.size() - 1)).setSize(size);
                inHelix = false;
            }
            i2 = 0;
            int l = helices.size();
            while (i2 < l) {
                Helix h1 = (Helix)helices.get(i2);
                int j = i2 + 1;
                while (j < l) {
                    Helix h2 = (Helix)helices.get(j);
                    if ((h1.ends[0] < h2.ends[0] && h2.ends[0] < h1.ends[1]) ^ (h1.ends[0] < h2.ends[1] && h2.ends[1] < h1.ends[1])) {
                        h1.crossedW.put(h2.id, h2);
                        h2.crossedW.put(h1.id, h1);
                        h1.numCrossed += h2.size;
                        h2.numCrossed += h1.size;
                    }
                    ++j;
                }
                ++i2;
            }
            ArrayList<Helix> ignoredHelices = new ArrayList<Helix>();
            boolean finished = false;
            int i3 = 0;
            while (i3 < helices.size() - 1) {
                Object nextH;
                if (finished) break;
                Helix mostCrossed = (Helix)helices.get(0);
                int j = 1;
                while (j < helices.size()) {
                    nextH = (Helix)helices.get(j);
                    if (((Helix)nextH).numCrossed > mostCrossed.numCrossed) {
                        mostCrossed = nextH;
                    }
                    ++j;
                }
                if (mostCrossed.numCrossed < 0 && ribosketch.this.debugPrints) {
                    ribosketch.println((String)"NUM CROSSED OUT OF BOUNDS IN generatePairTableOptimal!");
                }
                if (mostCrossed.numCrossed == 0) {
                    finished = true;
                    break;
                }
                ignoredHelices.add(mostCrossed);
                nextH = mostCrossed.crossedW.keySet().iterator();
                while (nextH.hasNext()) {
                    int id = (Integer)nextH.next();
                    Helix h = mostCrossed.crossedW.get(id);
                    h.crossedW.remove(mostCrossed.id);
                    h.numCrossed -= mostCrossed.size;
                }
                mostCrossed.numCrossed = 0;
                mostCrossed.crossedW.clear();
                ++i3;
            }
            for (Helix h : ignoredHelices) {
                int i4 = 0;
                while (i4 < h.size) {
                    this.pairTableOptimal.set(h.ends[0] + i4, (short)-1);
                    this.pairTableOptimal.set(h.ends[1] - i4, (short)-1);
                    ++i4;
                }
            }
        }

        public void setupDebug() {
            ribosketch.println((String)"\n*** SETUP ***");
            ribosketch.println((String)("lenTot: " + this.lenTot));
            ribosketch.println((String)("seqTot: " + this.seqTot));
            ribosketch.print((String)"Starts:");
            int[] nArray = this.starts;
            int n = this.starts.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                ribosketch.print((String)(" " + s));
                ++n2;
            }
            ribosketch.println((String)"");
            ribosketch.print((String)"Pair Table:");
            int i = 0;
            while (i < this.pairTable.length) {
                ribosketch.print((String)(" " + this.pairTable[i]));
                ++i;
            }
            ribosketch.println((String)"\n");
            ribosketch.println((String)"foldSteps:");
            for (int[] pair : this.foldSteps) {
                ribosketch.println((String)(String.valueOf(pair[0]) + " " + pair[1]));
            }
        }

        public SimulationState createCircleState(SphereList spheres) {
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"\nStarting SimulationSetup.createCircleState...");
            }
            SimulationState simState = new SimulationState();
            simState.sim = this;
            double circleReduction = 10.0;
            double startCircleRadius = (double)((float)ribosketch.this.height / 2.0f) - (ribosketch.this.ds.startPadding + (double)ribosketch.this.height / circleReduction);
            if (startCircleRadius < (double)((float)ribosketch.this.height / 8.0f)) {
                startCircleRadius = (float)ribosketch.this.height / 8.0f;
            }
            ribosketch.this.ff.radius = Math.PI * startCircleRadius / (double)this.lenTot;
            if (ribosketch.this.ff.radius < ribosketch.this.ff.minRadius) {
                ribosketch.this.ff.radius = ribosketch.this.ff.minRadius;
            }
            if (ribosketch.this.ff.radius > ribosketch.this.ff.minRadius + ribosketch.this.ff.radiusScale) {
                ribosketch.this.ff.radius = ribosketch.this.ff.minRadius + ribosketch.this.ff.radiusScale;
            }
            ribosketch.this.ff.backboneDist = ribosketch.this.ff.radius * 2.5;
            if (ribosketch.this.ff.backboneDist < ribosketch.this.ff.minBackboneDist) {
                ribosketch.this.ff.backboneDist = ribosketch.this.ff.minBackboneDist;
            }
            if (ribosketch.this.ff.backboneDist > ribosketch.this.ff.minBackboneDist + ribosketch.this.ff.backboneDistScale) {
                ribosketch.this.ff.backboneDist = ribosketch.this.ff.minBackboneDist + ribosketch.this.ff.backboneDistScale;
            }
            ribosketch.this.ff.bpDist = ribosketch.this.ff.radius * 3.75;
            if (ribosketch.this.ff.bpDist < ribosketch.this.ff.minBpDist) {
                ribosketch.this.ff.bpDist = ribosketch.this.ff.minBpDist;
            }
            if (ribosketch.this.ff.bpDist > ribosketch.this.ff.minBpDist + ribosketch.this.ff.bpDistScale) {
                ribosketch.this.ff.bpDist = ribosketch.this.ff.minBpDist + ribosketch.this.ff.bpDistScale;
            }
            ribosketch.this.ds.padding = ribosketch.this.ds.startPadding;
            startCircleRadius += (double)ribosketch.this.height / circleReduction;
            spheres.displayOrder.clear();
            spheres.relaxedIds.clear();
            int i = 0;
            while (i < this.lenTot) {
                double ang = (double)((float)this.residueOrder[i] * 2.0f) * Math.PI / (double)this.lenTot;
                spheres.get((int)i).x = (double)(ribosketch.this.width / 2) + Math.cos(ang) * startCircleRadius;
                spheres.get((int)i).y = (double)(ribosketch.this.height / 2) + Math.sin(ang) * startCircleRadius;
                spheres.displayOrder.add(i);
                ++i;
            }
            ribosketch.this.simulationMode = false;
            ribosketch.this.rigidHelices = true;
            simState.spheres = spheres;
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"Finished SimulationSetup.createCircleState!");
            }
            return simState;
        }

        public SimulationState createRadialState(SphereList spheres) {
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"\nStarting SimulationSetup.createRadialState...");
            }
            SimulationState simState = new SimulationState();
            simState.sim = this;
            ArrayList<Double> X = new ArrayList<Double>();
            ArrayList<Double> Y = new ArrayList<Double>();
            Radial radial = new Radial();
            radial.xyCoordinates(this.pairTableOptimal, X, Y);
            if (!"".equals(ribosketch.this.radialAlgorithmException)) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"Caught RadialAlgorithmException in createRadialState!");
                    ribosketch.println((String)ribosketch.this.radialAlgorithmException);
                }
                this.errorMessage = ribosketch.this.radialAlgorithmException;
                return new SimulationState();
            }
            if (X.size() != Y.size()) {
                if (ribosketch.this.debugPrints) {
                    ribosketch.println((String)"Coordinate arrays of unequal size!");
                }
                this.errorMessage = "Coordinate arrays of unequal size";
                return new SimulationState();
            }
            double minX = X.get(0);
            double maxX = X.get(0);
            double minY = Y.get(0);
            double maxY = Y.get(0);
            int i = 0;
            while (i < X.size()) {
                double x = X.get(i);
                double y = Y.get(i);
                if (x < minX) {
                    minX = x;
                } else if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                } else if (y > maxY) {
                    maxY = y;
                }
                ++i;
            }
            double xDif = maxX - minX;
            double xRatio = xDif / (double)ribosketch.this.width;
            double yDif = maxY - minY;
            double yRatio = yDif / (double)ribosketch.this.height;
            double scaleFactor = xRatio > yRatio ? (double)0.85f / xRatio : (double)0.85f / yRatio;
            double xShift = (double)((float)ribosketch.this.width / 2.0f) - scaleFactor * (xDif / 2.0 + minX);
            double yShift = (double)((float)ribosketch.this.height / 2.0f) - scaleFactor * (yDif / 2.0 + minY);
            int i2 = 0;
            while (i2 < X.size()) {
                X.set(i2, X.get(i2) * scaleFactor + xShift);
                Y.set(i2, Y.get(i2) * scaleFactor + yShift);
                ++i2;
            }
            double avgDist = 0.0;
            int numDists = 0;
            int numCounted = PApplet.parseInt((float)(X.size() / 4));
            if (numCounted < 50) {
                numCounted = 50;
            }
            if (numCounted > X.size()) {
                numCounted = X.size();
            }
            int i3 = 1;
            while (i3 < numCounted) {
                if (i3 >= X.size()) break;
                ++numDists;
                avgDist += ribosketch.this.normFunction(X.get(i3) - X.get(i3 - 1), Y.get(i3) - Y.get(i3 - 1), 0.0);
                ++i3;
            }
            avgDist = numDists != 0 ? (avgDist /= (double)numDists) : ribosketch.this.ff.minBackboneDist;
            ribosketch.this.ff.backboneDist = avgDist < 8.0 ? avgDist * (double)0.35f : avgDist * (double)0.95f;
            if (ribosketch.this.ff.backboneDist < ribosketch.this.ff.minBackboneDist) {
                ribosketch.this.ff.backboneDist = ribosketch.this.ff.minBackboneDist;
            }
            if (ribosketch.this.ff.backboneDist > ribosketch.this.ff.minBackboneDist + ribosketch.this.ff.backboneDistScale) {
                ribosketch.this.ff.backboneDist = ribosketch.this.ff.minBackboneDist + ribosketch.this.ff.backboneDistScale;
            }
            ribosketch.this.ff.radius = avgDist / 3.0;
            if (ribosketch.this.ff.radius < ribosketch.this.ff.minRadius) {
                ribosketch.this.ff.radius = ribosketch.this.ff.minRadius;
            }
            if (ribosketch.this.ff.radius > ribosketch.this.ff.minRadius + ribosketch.this.ff.radiusScale) {
                ribosketch.this.ff.radius = ribosketch.this.ff.minRadius + ribosketch.this.ff.radiusScale;
            }
            avgDist = 0.0;
            numDists = 0;
            i3 = 0;
            while (i3 < this.pairTableOptimal.size()) {
                short pairedWId = this.pairTableOptimal.get(i3);
                if (pairedWId != -1 && i3 < pairedWId) {
                    ++numDists;
                    avgDist += ribosketch.this.normFunction(X.get(i3) - X.get(pairedWId), Y.get(i3) - Y.get(pairedWId), 0.0);
                }
                ++i3;
            }
            avgDist = numDists != 0 ? (avgDist /= (double)numDists) : ribosketch.this.ff.minBpDist;
            ribosketch.this.ff.bpDist = avgDist;
            if (ribosketch.this.ff.bpDist < ribosketch.this.ff.minBpDist) {
                ribosketch.this.ff.bpDist = ribosketch.this.ff.minBpDist;
            }
            if (ribosketch.this.ff.bpDist > ribosketch.this.ff.minBpDist + ribosketch.this.ff.bpDistScale) {
                ribosketch.this.ff.bpDist = ribosketch.this.ff.minBpDist + ribosketch.this.ff.bpDistScale;
            }
            ribosketch.this.ds.padding = ribosketch.this.ds.startPadding;
            spheres.displayOrder.clear();
            spheres.relaxedIds.clear();
            i3 = 0;
            while (i3 < this.lenTot) {
                int pairTableId = this.residueOrder[i3];
                spheres.get((int)i3).x = X.get(pairTableId);
                spheres.get((int)i3).y = Y.get(pairTableId);
                spheres.displayOrder.add(i3);
                ++i3;
            }
            ribosketch.this.simulationMode = false;
            ribosketch.this.rigidHelices = true;
            ribosketch.this.textDisplay = "RADIAL LAYOUT";
            simState.spheres = spheres;
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"Finished SimulationSetup.createRadialState!");
            }
            return simState;
        }

        class OpenPair {
            int index = -1;
            String openChar = "";

            OpenPair(int id, String oc) {
                this.index = id;
                this.openChar = oc;
            }
        }
    }

    class SimulationState {
        SimulationSetup sim;
        SphereList spheres;
        int foldStep = -1;

        SimulationState() {
            this.spheres = new SphereList();
            this.sim = new SimulationSetup();
        }

        SimulationState(SimulationState other) {
            this.sim = other.sim.cloneFunction();
            this.spheres = other.getSpheres().cloneFunction();
            this.foldStep = other.foldStep;
        }

        SimulationState(SimulationSetup _sim, SphereList _spheres, int _foldStep) {
            this.sim = _sim.cloneFunction();
            this.spheres = _spheres.cloneFunction();
            this.foldStep = _foldStep;
        }

        public SimulationState cloneFunction() {
            SimulationState result = new SimulationState(this.sim, this.spheres, this.foldStep);
            return result;
        }

        public SphereList getSpheres() {
            return this.spheres;
        }

        public String[] writeSaveFile() {
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"Starting writeSaveFile...");
            }
            SimulationSetup s = this.sim;
            ArrayList<String> saveLines = new ArrayList<String>();
            String line = "sequences=";
            int i = 0;
            while (i < s.sequences.length) {
                line = String.valueOf(line) + s.sequences[i];
                if (i + 1 < s.sequences.length) {
                    line = String.valueOf(line) + "; ";
                }
                ++i;
            }
            saveLines.add(line);
            line = "starts=";
            i = 0;
            while (i < s.starts.length) {
                line = String.valueOf(line) + s.starts[i];
                if (i + 1 < s.starts.length) {
                    line = String.valueOf(line) + ",";
                }
                ++i;
            }
            saveLines.add(line);
            line = "positions=";
            i = 0;
            while (i < this.spheres.size()) {
                line = String.valueOf(line) + (int)this.spheres.get((int)i).x + "," + (int)this.spheres.get((int)i).y + "," + (int)this.spheres.get((int)i).z;
                if (i + 1 < this.spheres.size()) {
                    line = String.valueOf(line) + "; ";
                }
                ++i;
            }
            saveLines.add(line);
            saveLines.add("radius=" + ribosketch.this.ff.radius);
            saveLines.add("backbone_distance=" + ribosketch.this.ff.backboneDist);
            saveLines.add("basepair_distance=" + ribosketch.this.ff.bpDist);
            saveLines.add("color_scheme=" + ribosketch.this.ds.colorMode);
            saveLines.add("outline=" + ribosketch.this.ds.outlineMode);
            saveLines.add("movement=" + ribosketch.this.simulationMode);
            saveLines.add("simulation_type=" + ribosketch.this.simulateAllMode);
            saveLines.add("labels=" + ribosketch.this.ds.labelMode);
            saveLines.add("rigid_helices=" + ribosketch.this.rigidHelices);
            saveLines.add("rigid_hairpins=" + ribosketch.this.rigidHairpins);
            saveLines.add("rigid_loops=" + ribosketch.this.rigidLoops);
            line = "relaxed_ids=";
            Iterator<Integer> it = this.spheres.relaxedIds.keySet().iterator();
            while (it.hasNext()) {
                line = String.valueOf(line) + it.next() + " ";
            }
            saveLines.add(line.trim());
            line = "display_order=";
            i = 0;
            while (i < this.spheres.displayOrder.size()) {
                line = String.valueOf(line) + this.spheres.displayOrder.get(i);
                if (i + 1 < this.spheres.displayOrder.size()) {
                    line = String.valueOf(line) + ",";
                }
                ++i;
            }
            saveLines.add(line);
            line = "pair_table=";
            i = 0;
            while (i < s.pairTable.length) {
                line = String.valueOf(line) + s.pairTable[i];
                if (i + 1 < s.pairTable.length) {
                    line = String.valueOf(line) + ",";
                }
                i = (short)(i + 1);
            }
            saveLines.add(line);
            line = "non_canonicals=";
            for (Map.Entry<String, String> nc : s.nonCanonicals.entrySet()) {
                line = String.valueOf(line) + nc.getKey() + " " + nc.getValue() + ", ";
            }
            line = line.substring(0, line.length() - 2);
            saveLines.add(line);
            line = "base_colors=";
            i = 0;
            int l = this.spheres.size();
            while (i < l) {
                line = String.valueOf(line) + this.spheres.get((int)i).colorNum;
                if (i + 1 < l) {
                    line = String.valueOf(line) + ",";
                }
                ++i;
            }
            saveLines.add(line);
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"Finished writeSaveFile!");
            }
            return saveLines.toArray(new String[saveLines.size()]);
        }

        public String[] writeCtFile() {
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"Starting writeCtFile...");
            }
            SimulationSetup s = this.sim;
            ArrayList<String> saveLines = new ArrayList<String>();
            String concatSeq = "";
            int i = 0;
            while (i < s.sequences.length) {
                concatSeq = String.valueOf(concatSeq) + s.sequences[i];
                ++i;
            }
            String DELI = " ";
            String headerLine = concatSeq.length() + "  " + s.starts.length;
            int i2 = 0;
            while (i2 < s.starts.length) {
                headerLine = String.valueOf(headerLine) + (s.starts[i2] + 1);
                if (i2 + 1 < s.starts.length) {
                    headerLine = String.valueOf(headerLine) + " ";
                }
                ++i2;
            }
            saveLines.add(headerLine);
            i2 = 0;
            while (i2 < s.pairTable.length) {
                int firstId = i2;
                if (i2 > 0 && s.seqIds[i2] != s.seqIds[i2 - 1]) {
                    firstId = 0;
                }
                int bp = s.pairTable[i2] + 1;
                String line = i2 + 1 + DELI + concatSeq.charAt(i2) + DELI + firstId + DELI + (i2 + 2) + DELI + bp + DELI + (i2 + 1);
                saveLines.add(line);
                i2 = (short)(i2 + 1);
            }
            if (ribosketch.this.debugPrints) {
                ribosketch.println((String)"Finished writeCtFile!");
            }
            return saveLines.toArray(new String[saveLines.size()]);
        }
    }

    public class Slider {
        float x;
        float y;
        float width;
        float height;
        float labelWidth;
        float valueX = 0.0f;
        float value;
        String label;
        boolean visible = true;
        boolean isPressed = false;
        int sliderId;
        boolean updating = false;

        Slider(float xx, float yy, float ww, float hh, String _label, float _labelWidth, int id) {
            this.x = xx;
            this.y = yy;
            this.width = ww;
            this.height = hh;
            this.valueX = this.x;
            this.label = _label;
            this.labelWidth = _labelWidth;
            this.sliderId = id;
            Interactive.add((Object)this);
        }

        public void mousePressed() {
            this.isPressed = true;
        }

        public void dragged() {
            if (this.updating) {
                return;
            }
            this.valueX = (float)ribosketch.this.mouseX - this.height / 2.0f;
            if (this.valueX < this.x) {
                this.valueX = this.x;
            }
            if (this.valueX > this.x + this.width - this.height) {
                this.valueX = this.x + this.width - this.height;
            }
            this.value = ribosketch.map((float)this.valueX, (float)this.x, (float)(this.x + this.width - this.height), (float)0.0f, (float)1.0f);
            this.updateFromSlider();
        }

        public void draw() {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            if (this.x <= (float)ribosketch.this.mouseX && (float)ribosketch.this.mouseX <= this.x + this.width && this.y <= (float)ribosketch.this.mouseY && (float)ribosketch.this.mouseY <= this.y + this.height) {
                ribosketch.this.strokeWeight(1.5f);
                ribosketch.this.stroke(ribosketch.this.ds.GUIColor);
            } else {
                ribosketch.this.noStroke();
            }
            ribosketch.this.rectMode(0);
            ribosketch.this.fill(0.0f, 0.0f, 0.0f);
            ribosketch.this.rect(this.x, this.y, this.width, this.height, 4.0f);
            ribosketch.this.fill(ribosketch.this.ds.GUIColor);
            ribosketch.this.rect(this.valueX, this.y, this.height, this.height, 3.0f);
            ribosketch.this.fill(0.0f, 0.0f, 0.0f);
            if (this.valueX > this.x + this.height / 2.0f) {
                ribosketch.this.stroke(ribosketch.this.ds.GUIColor);
                ribosketch.this.strokeWeight(2.5f);
                ribosketch.this.line(this.x + this.height / 2.0f, this.y + this.height / 2.0f, this.valueX, this.y + this.height / 2.0f);
                ribosketch.this.stroke(-16777216);
            }
            if (this.label != null) {
                ribosketch.this.textSize(ribosketch.this.ds.menuTextSize);
                ribosketch.this.textAlign(37);
                ribosketch.this.text(this.label, this.x - this.labelWidth, this.y + this.height);
            }
            if (this.isPressed) {
                this.dragged();
            }
        }

        public void setValue(float _value) {
            this.value = _value;
            this.valueX = ribosketch.map((float)this.value, (float)0.0f, (float)1.0f, (float)this.x, (float)(this.x + this.width - this.height));
        }

        public void updateFromSlider() {
            if (this.sliderId == 0) {
                ribosketch.this.ff.radius = ribosketch.this.ff.minRadius + (double)ribosketch.this.sliders[this.sliderId].value * ribosketch.this.ff.radiusScale;
            } else if (this.sliderId == 1) {
                double newBpDist = ribosketch.this.ff.minBpDist + (double)ribosketch.this.sliders[this.sliderId].value * ribosketch.this.ff.bpDistScale;
                if (!ribosketch.this.simulationMode) {
                    double distChange = newBpDist - ribosketch.this.ff.bpDist;
                    if (!this.updating && (distChange >= 0.5 || distChange <= -0.5)) {
                        this.updating = true;
                        SphereList spheres = ribosketch.this.currentState.getSpheres();
                        for (Sphere2D s : spheres) {
                            if (s.pairedWForce == null || s.id >= s.pairedWForce.id) continue;
                            Sphere2D pairedBase = s.pairedWForce;
                            double pairDist = s.distance(pairedBase);
                            double moveDist = distChange / 2.0;
                            if (distChange < 0.0) {
                                if (pairDist <= ribosketch.this.ff.minBpDist) continue;
                                if (pairDist + distChange < ribosketch.this.ff.minBpDist) {
                                    moveDist = (ribosketch.this.ff.minBpDist - pairDist) / 2.0;
                                }
                            }
                            double moveX = moveDist * (s.x - pairedBase.x) / pairDist;
                            s.x += moveX;
                            pairedBase.x -= moveX;
                            double moveY = moveDist * (s.y - pairedBase.y) / pairDist;
                            s.y += moveY;
                            pairedBase.y -= moveY;
                        }
                        ribosketch.this.ff.bpDist = newBpDist;
                        this.updating = false;
                    }
                } else {
                    ribosketch.this.ff.bpDist = newBpDist;
                }
            } else if (this.sliderId == 2) {
                ribosketch.this.ff.backboneDist = ribosketch.this.ff.minBackboneDist + (double)ribosketch.this.sliders[this.sliderId].value * ribosketch.this.ff.backboneDistScale;
            } else if (this.sliderId == 3) {
                int prevColor = ribosketch.this.ds.colorMode;
                ribosketch.this.ds.colorMode = PApplet.parseInt((float)(ribosketch.this.sliders[this.sliderId].value * 10.0f)) + 1;
                if (ribosketch.this.ds.colorMode >= 11) {
                    ribosketch.this.ds.colorMode = 10;
                }
                if (prevColor != ribosketch.this.ds.colorMode) {
                    ribosketch.this.displayColorMode();
                }
            } else {
                ribosketch.println((String)("Warning: invalid sliderId: " + this.sliderId));
            }
        }
    }

    public class SnapCheckBox
    extends CheckBox {
        SnapCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.screenshot = true;
            ribosketch.this.capturingScreen = true;
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class SnapFormatCheckBox
    extends CheckBox {
        SnapFormatCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            this.checked = !this.checked;
            ribosketch.this.screenshotFormat = this.checked ? 1 : 2;
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class SnapSVGCheckBox
    extends CheckBox {
        int resx;
        int resy;

        SnapSVGCheckBox(String l, float xx, float yy, float ww, float hh, float labelSize, int _resx, int _resy) {
            super(l, xx, yy, ww, hh, labelSize);
            this.resx = _resx;
            this.resy = _resy;
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.saveStateForUndo();
            ribosketch.this.selectFolder("Select a folder to save to", "saveScreenSVGFile", ribosketch.this.userFile.getParentFile());
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    class Sphere2D {
        int id;
        int relId;
        int strandId = 0;
        String residue = "";
        Sphere2D fiveP;
        Sphere2D threeP;
        Sphere2D pairedWForce;
        Sphere2D pairedH;
        Sphere2D pairedS;
        boolean hasHelixUp = false;
        boolean hasHelixDown = false;
        double vx = 0.0;
        double vy = 0.0;
        double vz = 0.0;
        double x;
        double y;
        double z = 0.0;
        double forceX = 0.0;
        double forceY = 0.0;
        double forceZ = 0.0;
        float colorNum = 0.0f;
        int baseColor = -1;
        String[] bonds;

        Sphere2D(int _id, int _strandId, String _residue, String[] _bonds) {
            this.id = _id;
            this.strandId = _strandId;
            this.residue = _residue;
            this.bonds = _bonds;
        }

        Sphere2D(int _id, int _strandId, String _residue, double xpos, double ypos, double zpos) {
            this.id = _id;
            this.strandId = _strandId;
            this.residue = _residue;
            this.x = xpos;
            this.y = ypos;
            this.z = zpos;
        }

        public Sphere2D cloneFunction() {
            Sphere2D result = new Sphere2D(this.id, this.strandId, this.residue, this.x, this.y, this.z);
            result.fiveP = this.fiveP;
            result.threeP = this.threeP;
            result.hasHelixUp = this.hasHelixUp;
            result.hasHelixDown = this.hasHelixDown;
            result.relId = this.relId;
            result.pairedWForce = this.pairedWForce;
            result.pairedH = this.pairedH;
            result.pairedS = this.pairedS;
            result.vx = this.vx;
            result.vy = this.vy;
            result.colorNum = this.colorNum;
            result.baseColor = this.baseColor;
            result.forceX = this.forceX;
            result.forceY = this.forceY;
            result.bonds = ribosketch.this.stringArrayClone(this.bonds);
            return result;
        }

        public boolean isPaired(Sphere2D other) {
            if (other == null) {
                return false;
            }
            return this.pairedWForce == other || this.pairedH == other || this.pairedS == other;
        }

        public boolean isPaired() {
            return this.pairedWForce != null || this.pairedH != null || this.pairedS != null;
        }

        public boolean isAdjacent(Sphere2D other) {
            if (other == null) {
                return false;
            }
            return this.fiveP == other || this.threeP == other;
        }

        public double distance(Sphere2D other) {
            double dx = other.x - this.x;
            double dy = other.y - this.y;
            return ribosketch.this.normFunction(dx, dy, 0.0);
        }

        public double distance(double otherX, double otherY) {
            double dx = otherX - this.x;
            double dy = otherY - this.y;
            return ribosketch.this.normFunction(dx, dy, 0.0);
        }

        public void rotateSphere(double angle, double rx, double ry) {
            double x2 = this.x - rx;
            double y2 = this.y - ry;
            double ca = Math.cos(angle);
            double sa = Math.sin(angle);
            double x2b = x2 * ca - y2 * sa;
            double y2b = x2 * sa + y2 * ca;
            this.x = x2b + rx;
            this.y = y2b + ry;
        }

        public void update() {
            double straightFactor;
            double ddy;
            double ddx;
            double py;
            double px;
            double angTerm;
            PVector p5;
            PVector p55;
            double len2;
            double dy2;
            double dx2;
            double len;
            double dy;
            double dx;
            if (ribosketch.this.ds.padding > 0.0) {
                if (this.x < ribosketch.this.ds.padding) {
                    this.forceX += ribosketch.this.ff.padWeight * (ribosketch.this.ds.padding - this.x);
                } else if (this.x > (double)ribosketch.this.width - ribosketch.this.ds.padding) {
                    this.forceX -= ribosketch.this.ff.padWeight * (this.x - ((double)ribosketch.this.width - ribosketch.this.ds.padding));
                }
                if (this.y < ribosketch.this.ds.padding) {
                    this.forceY += ribosketch.this.ff.padWeight * (ribosketch.this.ds.padding - this.y);
                } else if (this.y > (double)ribosketch.this.height - ribosketch.this.ds.padding) {
                    this.forceY -= ribosketch.this.ff.padWeight * (this.y - ((double)ribosketch.this.height - ribosketch.this.ds.padding));
                }
            }
            this.forceX -= ribosketch.this.ff.cmWeight * (double)(ribosketch.this.cmx - (float)ribosketch.this.width / 2.0f);
            this.forceY -= ribosketch.this.ff.cmWeight * (double)(ribosketch.this.cmy - (float)ribosketch.this.height / 2.0f);
            if (this.fiveP != null && this.fiveP.fiveP != null) {
                dx = this.fiveP.x - this.fiveP.fiveP.x;
                dy = this.fiveP.y - this.fiveP.fiveP.y;
                len = ribosketch.this.normFunction(dx, dy, 0.0);
                dx2 = this.x - this.fiveP.x;
                dy2 = this.y - this.fiveP.y;
                len2 = ribosketch.this.normFunction(dx2, dy2, 0.0);
                p55 = new PVector((float)(dx /= len), (float)(dy /= len), 0.0f);
                p5 = new PVector((float)(dx2 /= len2), (float)(dy2 /= len2), 0.0f);
                angTerm = ribosketch.this.angleBetweenFunct(p5, p55);
                px = this.fiveP.x + len2 * dx;
                py = this.fiveP.y + len2 * dy;
                ddx = px - this.x;
                ddy = py - this.y;
                straightFactor = ribosketch.this.ff.straightWeight * angTerm * angTerm;
                this.forceX += ddx * straightFactor;
                this.forceY += ddy * straightFactor;
            }
            if (this.threeP != null && this.threeP.threeP != null) {
                dx = this.threeP.x - this.threeP.threeP.x;
                dy = this.threeP.y - this.threeP.threeP.y;
                len = ribosketch.this.normFunction(dx, dy, 0.0);
                dx2 = this.x - this.threeP.x;
                dy2 = this.y - this.threeP.y;
                len2 = ribosketch.this.normFunction(dx2, dy2, 0.0);
                p55 = new PVector((float)(dx /= len), (float)(dy /= len), 0.0f);
                p5 = new PVector((float)(dx2 /= len2), (float)(dy2 /= len2), 0.0f);
                angTerm = ribosketch.this.angleBetweenFunct(p5, p55);
                px = this.threeP.x + len2 * dx;
                py = this.threeP.y + len2 * dy;
                ddx = px - this.x;
                ddy = py - this.y;
                straightFactor = ribosketch.this.ff.straightWeight * angTerm * angTerm;
                this.forceX += ddx * straightFactor;
                this.forceY += ddy * straightFactor;
            }
            double ax = this.forceX / ribosketch.this.ff.mass;
            this.vx = ribosketch.this.ff.damping * this.vx + ax;
            double ay = this.forceY / ribosketch.this.ff.mass;
            this.vy = ribosketch.this.ff.damping * this.vy + ay;
            double vel = ribosketch.this.normFunction(this.vx, this.vy, 0.0);
            if (vel > ribosketch.this.ff.velMax) {
                double velReduce = ribosketch.this.ff.velMax / vel;
                this.vx *= velReduce;
                this.vy *= velReduce;
            }
            this.x += this.vx;
            this.y += this.vy;
            this.forceX = 0.0;
            this.forceY = 0.0;
        }

        public void displayLines(boolean[] drawn) {
            ribosketch.this.drawer.Stroke(ribosketch.this.ds.bbCol);
            ribosketch.this.drawer.StrokeWeight(ribosketch.this.ds.bbWeight / ribosketch.this.ds.zoomFactor);
            if (this.threeP != null && !drawn[this.threeP.id]) {
                ribosketch.this.drawer.Line((float)this.x, (float)this.y, (float)this.threeP.x, (float)this.threeP.y);
            }
            if (this.fiveP != null && !drawn[this.fiveP.id]) {
                ribosketch.this.drawer.Line((float)this.x, (float)this.y, (float)this.fiveP.x, (float)this.fiveP.y);
            }
            if (this.pairedWForce != null && "cWW".equals(this.bonds[this.pairedWForce.id]) && !drawn[this.pairedWForce.id]) {
                ribosketch.this.drawer.Stroke(ribosketch.this.ds.bpCol);
                ribosketch.this.drawer.StrokeWeight(ribosketch.this.ds.bpWeight / ribosketch.this.ds.zoomFactor);
                ribosketch.this.drawer.Line((float)this.x, (float)this.y, (float)this.pairedWForce.x, (float)this.pairedWForce.y);
            }
        }

        public void displayBody(float displayDiam, float offsetX, float offsetY) {
            ribosketch.this.drawer.Fill(-5592406);
            if (ribosketch.this.ds.outlineMode) {
                ribosketch.this.drawer.Stroke(-16777216);
                ribosketch.this.drawer.StrokeWeight(ribosketch.sqrt((float)((float)(ribosketch.this.ff.radius * ribosketch.this.ds.radiusShowMul))) / 3.0f / ribosketch.this.ds.zoomFactor);
            } else {
                ribosketch.this.drawer.NoStroke();
            }
            if (ribosketch.this.ds.colorMode == 5) {
                int c = ribosketch.this.color(-5592406);
                int id = this.strandId % 9;
                switch (id) {
                    case 0: {
                        c = ribosketch.this.color(-4195841);
                        break;
                    }
                    case 1: {
                        c = ribosketch.this.color(-6734);
                        break;
                    }
                    case 2: {
                        c = ribosketch.this.color(-5046343);
                        break;
                    }
                    case 3: {
                        c = ribosketch.this.color(-13322);
                        break;
                    }
                    case 4: {
                        c = ribosketch.this.color(-104);
                        break;
                    }
                    case 5: {
                        c = ribosketch.this.color(-25960);
                        break;
                    }
                    case 6: {
                        c = ribosketch.this.color(-2454529);
                        break;
                    }
                    case 7: {
                        c = ribosketch.this.color(-1);
                        break;
                    }
                    case 8: {
                        c = ribosketch.this.color(-8472065);
                        break;
                    }
                    default: {
                        if (ribosketch.this.debugPrints) {
                            ribosketch.println((String)"Internal error in color pallete");
                        }
                        c = ribosketch.this.color(-1);
                    }
                }
                ribosketch.this.drawer.Fill(c);
            } else if (ribosketch.this.ds.colorMode == 1) {
                int c = ribosketch.this.color(-5592406);
                int id = this.strandId % 8;
                switch (id) {
                    case 0: {
                        c = ribosketch.this.color(-10112280);
                        break;
                    }
                    case 1: {
                        c = ribosketch.this.color(-351174);
                        break;
                    }
                    case 2: {
                        c = ribosketch.this.color(-10437272);
                        break;
                    }
                    case 3: {
                        c = ribosketch.this.color(-951120);
                        break;
                    }
                    case 4: {
                        c = ribosketch.this.color(-860604);
                        break;
                    }
                    case 5: {
                        c = ribosketch.this.color(-960428);
                        break;
                    }
                    case 6: {
                        c = ribosketch.this.color(-5081422);
                        break;
                    }
                    case 7: {
                        c = ribosketch.this.color(-4144960);
                        break;
                    }
                    default: {
                        if (ribosketch.this.debugPrints) {
                            ribosketch.println((String)"Internal error in color pallete");
                        }
                        c = ribosketch.this.color(-1);
                    }
                }
                ribosketch.this.drawer.Fill(c);
            } else if (ribosketch.this.ds.colorMode == 3) {
                String temp = this.residue.toUpperCase();
                if ("G".equals(temp)) {
                    ribosketch.this.drawer.Fill(-10164993);
                } else if ("A".equals(temp)) {
                    ribosketch.this.drawer.Fill(-35727);
                } else if ("U".equals(temp)) {
                    ribosketch.this.drawer.Fill(-10158222);
                } else if ("T".equals(temp)) {
                    ribosketch.this.drawer.Fill(-15204467);
                } else if ("C".equals(temp)) {
                    ribosketch.this.drawer.Fill(-2421);
                } else {
                    ribosketch.this.drawer.Fill(-1);
                }
            } else if (ribosketch.this.ds.colorMode == 7) {
                double frac = (double)ribosketch.this.ds.colorMax * (double)this.id / ((double)ribosketch.this.currentState.sim.lenTot + (double)((float)ribosketch.this.ds.colorMax / 8.0f));
                if (frac > (double)((float)ribosketch.this.ds.colorMax * 5.0f / 8.0f)) {
                    frac += (double)((float)ribosketch.this.ds.colorMax / 8.0f);
                }
                ribosketch.this.drawer.Fill(ribosketch.this.color((int)frac, ribosketch.this.ds.colorMax, ribosketch.this.ds.colorMax));
            } else if (ribosketch.this.ds.colorMode == 6) {
                int c = ribosketch.this.color(-5592406);
                int id = this.strandId % 9;
                switch (id) {
                    case 0: {
                        c = ribosketch.this.color(-16711681);
                        break;
                    }
                    case 1: {
                        c = ribosketch.this.color(-31744);
                        break;
                    }
                    case 2: {
                        c = ribosketch.this.color(-16711936);
                        break;
                    }
                    case 3: {
                        c = ribosketch.this.color(-130817);
                        break;
                    }
                    case 4: {
                        c = ribosketch.this.color(-2498);
                        break;
                    }
                    case 5: {
                        c = ribosketch.this.color(-65536);
                        break;
                    }
                    case 6: {
                        c = ribosketch.this.color(-16739585);
                        break;
                    }
                    case 7: {
                        c = ribosketch.this.color(-2883329);
                        break;
                    }
                    case 8: {
                        c = ribosketch.this.color(-1);
                        break;
                    }
                    default: {
                        if (ribosketch.this.debugPrints) {
                            ribosketch.println((String)"Internal error in color pallete");
                        }
                        c = ribosketch.this.color(-1);
                    }
                }
                ribosketch.this.drawer.Fill(c);
            } else if (ribosketch.this.ds.colorMode == 8) {
                int c = ribosketch.this.color(-2368549);
                ribosketch.this.drawer.Fill(c);
            } else if (ribosketch.this.ds.colorMode == 2) {
                ribosketch.this.drawer.Fill(-1);
                if (ribosketch.this.ds.outlineMode) {
                    ribosketch.this.drawer.Stroke(-16777216);
                } else {
                    ribosketch.this.drawer.NoStroke();
                }
                float saveWeight = ribosketch.this.drawer.strokeWidth;
                ribosketch.this.drawer.StrokeWeight(saveWeight / ribosketch.this.ds.zoomFactor);
            } else if (ribosketch.this.ds.colorMode == 4) {
                int c = -4195841;
                if (this.pairedWForce != null) {
                    c = -2498;
                }
                ribosketch.this.drawer.Fill(c);
            } else if (ribosketch.this.ds.colorMode == 10) {
                ribosketch.this.drawer.Fill(this.baseColor);
            } else if (ribosketch.this.ds.colorMode == 9) {
                int c = ribosketch.this.color(-5592406);
                if (this.residue.length() > 0) {
                    c = this.residue.toUpperCase().equals(this.residue) ? ribosketch.this.color(-31744) : ribosketch.this.color(-16711681);
                }
                ribosketch.this.drawer.Fill(c);
            }
            if (ribosketch.this.attachedIds.containsKey(this.id)) {
                displayDiam = (float)((double)displayDiam * ribosketch.this.ds.highlightMul);
                ribosketch.this.drawer.Stroke(ribosketch.this.ds.highlightCol);
            }
            ribosketch.this.drawer.Ellipse((float)this.x, (float)this.y, displayDiam, displayDiam);
            if (ribosketch.this.ds.textMode) {
                ribosketch.this.drawer.Fill(ribosketch.this.ds.textCol);
                ribosketch.this.drawer.Text(this.residue, (float)this.x + offsetX, (float)this.y + offsetY);
            }
        }
    }

    class SphereList
    extends ArrayList<Sphere2D> {
        ArrayList<Integer> displayOrder = new ArrayList();
        HashMap<Integer, Integer> relaxedIds = new HashMap();

        public SphereList() {
            this.displayOrder = new ArrayList();
        }

        public SphereList cloneFunction() {
            SphereList spheres = new SphereList();
            int i = 0;
            while (i < this.size()) {
                spheres.add(this.get(i).cloneFunction());
                ++i;
            }
            i = 0;
            while (i < spheres.size()) {
                if (spheres.get((int)i).fiveP != null) {
                    spheres.get((int)i).fiveP = spheres.get(spheres.get((int)i).fiveP.id);
                }
                if (spheres.get((int)i).threeP != null) {
                    spheres.get((int)i).threeP = spheres.get(spheres.get((int)i).threeP.id);
                }
                if (spheres.get((int)i).pairedWForce != null) {
                    spheres.get((int)i).pairedWForce = spheres.get(spheres.get((int)i).pairedWForce.id);
                }
                if (this.get((int)i).pairedH != null) {
                    this.get((int)i).pairedH = this.get(this.get((int)i).pairedH.id);
                }
                if (this.get((int)i).pairedS != null) {
                    this.get((int)i).pairedS = this.get(this.get((int)i).pairedS.id);
                }
                ++i;
            }
            spheres.relaxedIds = (HashMap)this.relaxedIds.clone();
            spheres.displayOrder = (ArrayList)this.displayOrder.clone();
            return spheres;
        }

        @Override
        public Sphere2D get(int id) {
            return (Sphere2D)super.get(id);
        }

        @Override
        public int size() {
            return super.size();
        }

        public void update() {
            double eCutoff = Math.sqrt(ribosketch.this.ff.backboneDist) * ribosketch.this.ff.eCutoffScale;
            if (this.size() > 1800) {
                eCutoff /= 2.0;
            }
            int i = 0;
            int l = this.size();
            while (i < l) {
                Sphere2D s1 = this.get(i);
                int j = i + 1;
                while (j < l) {
                    Sphere2D s2 = this.get(j);
                    double d = s1.distance(s2);
                    if (d < 1.0) {
                        d = 1.0;
                    }
                    double d2 = d * d;
                    double dx = s1.x - s2.x;
                    double dy = s1.y - s2.y;
                    double dx0 = dx / d;
                    double dy0 = dy / d;
                    double pushX = ribosketch.this.ff.backboneDist * dx0 / d2;
                    double pushY = ribosketch.this.ff.backboneDist * dy0 / d2;
                    if (d < eCutoff && s1.pairedWForce != s2 && !s1.isAdjacent(s2)) {
                        s1.forceX += ribosketch.this.ff.eWeight * pushX;
                        s1.forceY += ribosketch.this.ff.eWeight * pushY;
                        s2.forceX -= ribosketch.this.ff.eWeight * pushX;
                        s2.forceY -= ribosketch.this.ff.eWeight * pushY;
                    }
                    s1.forceX += ribosketch.this.ff.vdWeight * pushX;
                    s1.forceY += ribosketch.this.ff.vdWeight * pushY;
                    s2.forceX -= ribosketch.this.ff.vdWeight * pushX;
                    s2.forceY -= ribosketch.this.ff.vdWeight * pushY;
                    double viol = -1.0;
                    if (s1.pairedWForce == s2 && !this.relaxedIds.containsKey(s1.id) && !this.relaxedIds.containsKey(s2.id)) {
                        viol = d - ribosketch.this.ff.bpDist;
                    } else if (s1.isAdjacent(s2)) {
                        viol = d - ribosketch.this.ff.backboneDist;
                    }
                    if (viol > (double)0.1f) {
                        s1.forceX -= ribosketch.this.ff.stretchWeight * viol * dx0;
                        s1.forceY -= ribosketch.this.ff.stretchWeight * viol * dy0;
                        s2.forceX += ribosketch.this.ff.stretchWeight * viol * dx0;
                        s2.forceY += ribosketch.this.ff.stretchWeight * viol * dy0;
                    }
                    ++j;
                }
                ++i;
            }
            if (ribosketch.this.attachedIds.size() == 0 || ribosketch.this.simulateAllMode) {
                i = 0;
                while (i < this.size()) {
                    this.get(i).update();
                    ++i;
                }
            } else {
                Iterator<Integer> it = ribosketch.this.attachedIds.keySet().iterator();
                while (it.hasNext()) {
                    this.get(it.next()).update();
                }
            }
        }

        public void fixHelices() {
            SphereList spheres = this;
            int i = 0;
            while (i < spheres.size()) {
                Sphere2D res = spheres.get(i);
                if (res.pairedWForce != null && !res.hasHelixUp && res.hasHelixDown && res.id < res.pairedWForce.id) {
                    Sphere2D resNew;
                    Sphere2D resEnd = res;
                    int j = i + 1;
                    while (j < spheres.size()) {
                        resEnd = spheres.get(j);
                        if (!resEnd.hasHelixDown) break;
                        ++j;
                    }
                    int len = j - i + 1;
                    double stacks = len - 1;
                    double dx = resEnd.x - res.x;
                    double dy = resEnd.y - res.y;
                    double dx2 = resEnd.pairedWForce.x - res.pairedWForce.x;
                    double dy2 = resEnd.pairedWForce.y - res.pairedWForce.y;
                    double dxInterval = dx / stacks;
                    double dyInterval = dy / stacks;
                    double dx2Interval = dx2 / stacks;
                    double dy2Interval = dy2 / stacks;
                    double distanceSum = 0.0;
                    int count = 0;
                    int k = 0;
                    while (k < len) {
                        Sphere2D resNew2 = spheres.get(i + k);
                        if (!this.relaxedIds.containsKey(resNew2.id) && !this.relaxedIds.containsKey(resNew2.pairedWForce.id)) {
                            resNew2.x = res.x + (double)k * dxInterval;
                            resNew2.y = res.y + (double)k * dyInterval;
                            resNew2.pairedWForce.x = res.pairedWForce.x + (double)k * dx2Interval;
                            resNew2.pairedWForce.y = res.pairedWForce.y + (double)k * dy2Interval;
                            ++count;
                            distanceSum += resNew2.pairedWForce.distance(resNew2);
                        }
                        ++k;
                    }
                    double distanceAvg = 0.0;
                    if (count > 0) {
                        distanceAvg = distanceSum / (double)count;
                    }
                    if (distanceAvg < ribosketch.this.ff.bpDist) {
                        distanceAvg = ribosketch.this.ff.bpDist;
                    }
                    double dxMid = (dx + dx2) / 2.0;
                    double dyMid = (dy + dy2) / 2.0;
                    PVector midLine = new PVector((float)dxMid, (float)dyMid);
                    float angle = midLine.heading();
                    double xDifference = distanceAvg * (double)ribosketch.sin((float)angle) / 2.0;
                    double yDifference = -distanceAvg * (double)ribosketch.cos((float)angle) / 2.0;
                    double xStartMidpoint = (res.x + res.pairedWForce.x) / 2.0;
                    double yStartMidpoint = (res.y + res.pairedWForce.y) / 2.0;
                    double xMidInterval = dxMid / stacks;
                    double yMidInterval = dyMid / stacks;
                    double mul = 0.0;
                    int k2 = 0;
                    while (k2 < len) {
                        resNew = spheres.get(i + k2);
                        double sign = (double)midLine.x * (resNew.y - yStartMidpoint) - (double)midLine.y * (resNew.x - xStartMidpoint);
                        if (sign > 0.0) {
                            mul -= 1.0;
                        } else if (sign < 0.0) {
                            mul += 1.0;
                        }
                        ++k2;
                    }
                    mul = mul >= 0.0 ? 1.0 : -1.0;
                    k2 = 0;
                    while (k2 < len) {
                        resNew = spheres.get(i + k2);
                        if (!this.relaxedIds.containsKey(resNew.id) && !this.relaxedIds.containsKey(resNew.pairedWForce.id)) {
                            double xNew = xStartMidpoint + (double)k2 * xMidInterval;
                            double yNew = yStartMidpoint + (double)k2 * yMidInterval;
                            if (ribosketch.this.simulateAllMode || ribosketch.this.attachedIds.size() == 0 || ribosketch.this.attachedIds.containsKey(resNew.id)) {
                                resNew.x = xNew + xDifference * mul;
                                resNew.y = yNew + yDifference * mul;
                            }
                            if (ribosketch.this.simulateAllMode || ribosketch.this.attachedIds.size() == 0 || ribosketch.this.attachedIds.containsKey(resNew.pairedWForce.id)) {
                                resNew.pairedWForce.x = xNew - xDifference * mul;
                                resNew.pairedWForce.y = yNew - yDifference * mul;
                            }
                        }
                        ++k2;
                    }
                    if (ribosketch.this.rigidHairpins && !ribosketch.this.rigidLoops) {
                        res = resEnd;
                        while (res.threeP != null) {
                            res = res.threeP;
                            if (res.isPaired()) break;
                        }
                        if (resEnd.pairedWForce.id == res.id && resEnd.id != res.id) {
                            double sideL = res.distance(resEnd);
                            Sphere2D resStart = resEnd;
                            resEnd = res;
                            int n = resEnd.id - resStart.id + 1;
                            PVector v1 = new PVector((float)(resStart.x - resEnd.x), (float)(resStart.y - resEnd.y));
                            PVector v2 = new PVector((float)(resStart.x - resStart.fiveP.x), (float)(resStart.y - resStart.fiveP.y));
                            double angChange = 6.2831854820251465 / (double)n;
                            if (v1.y * v2.x > 0.0f) {
                                angChange *= -1.0;
                            }
                            float ang = v1.heading();
                            res = resStart;
                            double targetX = res.x;
                            double targetY = res.y;
                            int k3 = 0;
                            while (k3 < n - 2) {
                                ang = (float)((double)ang + angChange);
                                double xDiff = sideL * (double)ribosketch.cos((float)ang);
                                double yDiff = sideL * (double)ribosketch.sin((float)ang);
                                res = res.threeP;
                                res.forceX += ribosketch.this.ff.hairpinWeight * ((targetX += xDiff) - res.x);
                                res.forceY += ribosketch.this.ff.hairpinWeight * ((targetY += yDiff) - res.y);
                                ++k3;
                            }
                        }
                    }
                }
                ++i;
            }
        }

        public void fixLoops() {
            SphereList spheres = this;
            int i = 0;
            while (i < spheres.size()) {
                Sphere2D res = spheres.get(i);
                if (res.pairedWForce != null && res.pairedWForce.strandId == res.strandId && !res.hasHelixUp && res.hasHelixDown && res.id < res.pairedWForce.id) {
                    this.findLoop(res);
                    i = res.pairedWForce.id;
                }
                ++i;
            }
        }

        public void findLoop(Sphere2D helixStart) {
            SphereList spheres = this;
            Sphere2D loopStart = helixStart;
            int i = helixStart.id + 1;
            while (i < spheres.size()) {
                loopStart = spheres.get(i);
                if (!loopStart.hasHelixDown) break;
                ++i;
            }
            Sphere2D loopEnd = loopStart.pairedWForce;
            ArrayList<Sphere2D> loopResidues = new ArrayList<Sphere2D>();
            int endSearch = loopEnd.id;
            Sphere2D searchRes = loopStart;
            while (searchRes.id < endSearch - 1) {
                searchRes = searchRes.threeP;
                loopResidues.add(searchRes);
                if (searchRes.pairedWForce == null || searchRes.id >= searchRes.pairedWForce.id) continue;
                if (searchRes.pairedWForce.strandId != searchRes.strandId || searchRes.pairedWForce.id > endSearch) {
                    return;
                }
                if (!searchRes.hasHelixUp && searchRes.hasHelixDown) {
                    this.findLoop(searchRes);
                }
                searchRes = searchRes.pairedWForce;
                loopResidues.add(searchRes);
            }
            double dist = loopStart.distance(loopEnd);
            int n = loopResidues.size() + 2;
            double sideL = ribosketch.this.ff.backboneDist;
            PVector v1 = new PVector((float)(loopStart.x - loopEnd.x), (float)(loopStart.y - loopEnd.y));
            PVector v2 = new PVector((float)(loopStart.x - loopStart.fiveP.x), (float)(loopStart.y - loopStart.fiveP.y));
            double angChange = 6.2831854820251465 / (double)n;
            if (v1.y * v2.x > 0.0f) {
                angChange *= -1.0;
            }
            float ang = v1.heading();
            Sphere2D res = loopStart;
            double targetX = res.x;
            double targetY = res.y;
            int k = 0;
            while (k < n - 2) {
                ang = (float)((double)ang + angChange);
                double xDiff = sideL * (double)ribosketch.cos((float)ang);
                double yDiff = sideL * (double)ribosketch.sin((float)ang);
                targetX += xDiff;
                targetY += yDiff;
                if (((Sphere2D)loopResidues.get((int)k)).id < res.id) {
                    ribosketch.println((String)"\n****ERROR!!!!****\n");
                }
                res = (Sphere2D)loopResidues.get(k);
                res.forceX += ribosketch.this.ff.loopWeight * (targetX - res.x);
                res.forceY += ribosketch.this.ff.loopWeight * (targetY - res.y);
                if (res.hasHelixDown) {
                    float newAng = ang + (float)angChange;
                    newAng = angChange < 0.0 ? (newAng += 1.5707964f) : (newAng -= 1.5707964f);
                    Sphere2D outerHelixEnd = res.threeP;
                    while (outerHelixEnd.hasHelixDown) {
                        outerHelixEnd = outerHelixEnd.threeP;
                    }
                    int outerHelixLength = outerHelixEnd.id - res.id;
                    double helixDiffX = (double)outerHelixLength * sideL * (double)ribosketch.cos((float)newAng);
                    double helixDiffY = (double)outerHelixLength * sideL * (double)ribosketch.sin((float)newAng);
                    double outer1TargetX = targetX + helixDiffX;
                    double outer1TargetY = targetY + helixDiffY;
                    Sphere2D outerHelixEnd2 = outerHelixEnd.pairedWForce;
                    newAng = angChange < 0.0 ? (newAng -= 1.5707964f) : (newAng += 1.5707964f);
                    double outer2TargetX = outer1TargetX + dist * (double)ribosketch.cos((float)newAng);
                    double outer2TargetY = outer1TargetY + dist * (double)ribosketch.sin((float)newAng);
                    outerHelixEnd.forceX += ribosketch.this.ff.branchStraightenWeight * (outer1TargetX - outerHelixEnd.x);
                    outerHelixEnd.forceY += ribosketch.this.ff.branchStraightenWeight * (outer1TargetY - outerHelixEnd.y);
                    outerHelixEnd2.forceX += ribosketch.this.ff.branchStraightenWeight * (outer2TargetX - outerHelixEnd2.x);
                    outerHelixEnd2.forceY += ribosketch.this.ff.branchStraightenWeight * (outer2TargetY - outerHelixEnd2.y);
                }
                ++k;
            }
        }

        public void stopVelocities() {
            int i = 0;
            while (i < this.size()) {
                Sphere2D sphere = this.get(i);
                sphere.vx = 0.0;
                sphere.vy = 0.0;
                ++i;
            }
        }

        public double[] findClosest(double x, double y) {
            int closestId = 0;
            double dBest = this.get(0).distance(x, y);
            int i = 1;
            while (i < this.size()) {
                double d = this.get(i).distance(x, y);
                if (d < dBest) {
                    dBest = d;
                    closestId = i;
                }
                ++i;
            }
            double[] output = new double[]{closestId, dBest};
            return output;
        }

        public PVector computeCenterOfMass() {
            ribosketch.this.cmx = 0.0f;
            ribosketch.this.cmy = 0.0f;
            int i = 0;
            while (i < this.size()) {
                ribosketch.this.cmx = (float)((double)ribosketch.this.cmx + this.get((int)i).x);
                ribosketch.this.cmy = (float)((double)ribosketch.this.cmy + this.get((int)i).y);
                ++i;
            }
            ribosketch.this.cmx /= (float)this.size();
            ribosketch.this.cmy /= (float)this.size();
            return new PVector(ribosketch.this.cmx, ribosketch.this.cmy);
        }

        public void display() {
            boolean[] drawn = new boolean[this.displayOrder.size()];
            float displayDiameter = (float)(ribosketch.this.ff.radius * ribosketch.this.ds.radiusShowMul);
            float offsetX = ribosketch.this.ds.textOffsX * displayDiameter;
            float offsetY = ribosketch.this.ds.textOffsY * displayDiameter;
            ribosketch.this.drawer.TextSize(ribosketch.this.ds.textReduction * displayDiameter);
            ribosketch.this.textAlign(37);
            for (int id : this.displayOrder) {
                this.get(id).displayLines(drawn);
                this.get(id).displayBody(displayDiameter, offsetX, offsetY);
                drawn[id] = true;
            }
        }

        public void displayLabels() {
            float radius2 = (float)(ribosketch.this.ff.radius * ribosketch.this.ds.radiusShowMul);
            ribosketch.this.drawer.TextSize(ribosketch.constrain((float)(ribosketch.this.ds.textReduction * radius2), (float)6.0f, (float)65.0f));
            ribosketch.this.textAlign(3, 3);
            ribosketch.this.drawer.Stroke(-6579301);
            ribosketch.this.drawer.StrokeWeight(ribosketch.constrain((float)(ribosketch.this.sliders[0].value * ribosketch.this.ds.labelWeight), (float)0.7f, (float)ribosketch.this.ds.labelWeight));
            ribosketch.this.drawer.Fill(ribosketch.this.ds.textCol);
            if (!ribosketch.this.capturingScreen) {
                Iterator<Integer> it = this.relaxedIds.keySet().iterator();
                while (it.hasNext()) {
                    PVector pv = this.findPositionForPrint(it.next(), radius2, radius2);
                    if (pv == null) continue;
                    ribosketch.this.drawer.Text("R", pv.x, pv.y);
                }
            }
            ribosketch.this.drawer.Fill(ribosketch.this.ds.textCol);
            int[] strandStarts = ribosketch.this.currentState.sim.starts;
            int i = 0;
            while (i < strandStarts.length) {
                int start = strandStarts[i];
                int end = i < strandStarts.length - 1 ? strandStarts[i + 1] : this.size();
                PVector pv = this.findPositionForPrint(start, radius2 + 10.0f, radius2);
                if (pv != null) {
                    String textString = ribosketch.str((int)1);
                    float ntX = (float)this.get((int)start).x;
                    float ntY = (float)this.get((int)start).y;
                    float dx = pv.x - ntX;
                    float dy = pv.y - ntY;
                    float magn = ribosketch.sqrt((float)(dx * dx + dy * dy));
                    float normX = dx / magn;
                    float normY = dy / magn;
                    ribosketch.this.drawer.Fill(ribosketch.this.ds.textCol);
                    ribosketch.this.drawer.Line(pv.x - normX * 8.0f, pv.y - normY * 8.0f, ntX + normX * radius2 / 2.0f, ntY + normY * radius2 / 2.0f);
                    ribosketch.this.drawer.Text(textString, pv.x, pv.y);
                }
                int j = start + 9;
                while (j < end) {
                    pv = this.findPositionForPrint(j, radius2 + 10.0f, radius2);
                    if (pv != null) {
                        String textString = ribosketch.str((int)(j - start + 1));
                        float ntX = (float)this.get((int)j).x;
                        float ntY = (float)this.get((int)j).y;
                        float dx = pv.x - ntX;
                        float dy = pv.y - ntY;
                        float magn = ribosketch.sqrt((float)(dx * dx + dy * dy));
                        float normX = dx / magn;
                        float normY = dy / magn;
                        ribosketch.this.drawer.Fill(ribosketch.this.ds.textCol);
                        ribosketch.this.drawer.Line(pv.x - normX * 8.0f, pv.y - normY * 8.0f, ntX + normX * radius2 / 2.0f, ntY + normY * radius2 / 2.0f);
                        ribosketch.this.drawer.Text(textString, pv.x, pv.y);
                    }
                    j += 10;
                }
                ++i;
            }
        }

        public void displayInfo() {
            float radius2 = (float)(ribosketch.this.ff.radius * ribosketch.this.ds.radiusShowMul);
            ribosketch.this.drawer.TextSize(ribosketch.constrain((float)(ribosketch.this.ds.textReduction * radius2), (float)6.0f, (float)65.0f));
            ribosketch.this.textAlign(3, 3);
            ribosketch.this.drawer.Fill(ribosketch.this.ds.textCol);
            int[] strandStarts = ribosketch.this.currentState.sim.starts;
            int i = 0;
            while (i < strandStarts.length) {
                int start = strandStarts[i];
                int end = i < strandStarts.length - 1 ? strandStarts[i + 1] : this.size();
                int id = PApplet.parseInt((float)((start + end) / 2));
                PVector pv = this.findPositionForPrint(id, radius2 * 1.5f, radius2);
                if (pv != null) {
                    String textString = "Strand " + (this.get((int)id).strandId + 1);
                    ribosketch.this.drawer.Text(textString, pv.x, pv.y);
                }
                if (end - start >= 4) {
                    pv = this.findPositionForPrint(start + 1, radius2 * 1.5f, radius2);
                    if (pv != null) {
                        ribosketch.this.drawer.Text("5'", pv.x, pv.y);
                    }
                    if ((end - start) % 10 == 0) {
                        --end;
                    }
                    if ((pv = this.findPositionForPrint(end - 1, radius2 * 1.5f, radius2)) != null) {
                        ribosketch.this.drawer.Text("3'", pv.x, pv.y);
                    }
                }
                ++i;
            }
        }

        public PVector findPositionForPrint(int i0, double delta, double targetBuffer) {
            double x = this.get((int)i0).x;
            double y = this.get((int)i0).y;
            int ix = -1;
            while (ix <= 1) {
                int iy = 1;
                while (iy >= -1) {
                    if (ix != 0 || iy != 0) {
                        double dist = delta;
                        if (ix != 0 && iy != 0) {
                            dist *= (double)0.707f;
                        }
                        double x2 = x + (double)ix * dist;
                        double y2 = y + (double)iy * dist;
                        boolean violation = false;
                        int ii = 0;
                        while (ii < this.size()) {
                            if (ii != i0) {
                                Sphere2D sphere = this.get(ii);
                                double d = ribosketch.this.normFunction(x2 - sphere.x, y2 - sphere.y, 0.0);
                                if (d < targetBuffer) {
                                    violation = true;
                                    break;
                                }
                            }
                            ++ii;
                        }
                        if (!violation) {
                            return new PVector((float)x2, (float)y2);
                        }
                    }
                    --iy;
                }
                ++ix;
            }
            return null;
        }
    }

    class Strand {
        int id;
        ArrayList<Integer> strandIds = new ArrayList();
        int length;
        ArrayList<HelixEnd> helixEnds = new ArrayList();

        Strand(int id, int length) {
            this.id = id;
            this.strandIds.add(id);
            this.length = length;
        }

        public void addEnd(HelixEnd _end) {
            this.helixEnds.add(_end);
        }

        public void addId(int strandId) {
            this.strandIds.add(strandId);
        }
    }

    public class ZoomResetBox
    extends CheckBox {
        ZoomResetBox(String l, float xx, float yy, float ww, float hh, float labelSize) {
            super(l, xx, yy, ww, hh, labelSize);
        }

        @Override
        public void mouseReleased(float mx, float my) {
            if (!ribosketch.this.menuVisible) {
                return;
            }
            ribosketch.this.ds.resetZoom();
            ribosketch.this.zoomFactorSave = 1.0f;
            ribosketch.this.zoomTranslateXSave = 0.0f;
            ribosketch.this.zoomTranslateYSave = 0.0f;
        }

        @Override
        public void draw() {
            super.draw();
        }

        @Override
        public boolean isInside(float mx, float my) {
            return super.isInside(mx, my);
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }
}

